var __create = Object.create;
var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
var __markAsModule = (target) => __defProp(target, "__esModule", { value: true });
var __export = (target, all) => {
  __markAsModule(target);
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __reExport = (target, module2, desc) => {
  if (module2 && typeof module2 === "object" || typeof module2 === "function") {
    for (let key of __getOwnPropNames(module2))
      if (!__hasOwnProp.call(target, key) && key !== "default")
        __defProp(target, key, { get: () => module2[key], enumerable: !(desc = __getOwnPropDesc(module2, key)) || desc.enumerable });
  }
  return target;
};
var __toModule = (module2) => {
  return __reExport(__markAsModule(__defProp(module2 != null ? __create(__getProtoOf(module2)) : {}, "default", module2 && module2.__esModule && "default" in module2 ? { get: () => module2.default, enumerable: true } : { value: module2, enumerable: true })), module2);
};

// src/backend/orchestration/redrive-state-machine.lambda.ts
__export(exports, {
  handler: () => handler
});

// src/backend/shared/aws.lambda-shared.ts
var AWS = __toModule(require("aws-sdk"));
var _sqs;
var _sfn;
function sqs() {
  if (_sqs == null) {
    _sqs = new AWS.SQS();
  }
  return _sqs;
}
function stepFunctions() {
  if (_sfn == null) {
    _sfn = new AWS.StepFunctions();
  }
  return _sfn;
}

// src/backend/shared/env.lambda-shared.ts
var import_process = __toModule(require("process"));
function requireEnv(name) {
  const result = import_process.env[name];
  if (!result) {
    throw new Error(`No value specified for required environment variable: ${name}`);
  }
  return result;
}

// src/backend/orchestration/redrive-state-machine.lambda.ts
async function handler(event, context) {
  const stateMachineArn = requireEnv("STATE_MACHINE_ARN");
  const queueUrl = requireEnv("QUEUE_URL");
  console.log(`Event: ${JSON.stringify(event, null, 2)}`);
  const sfn = stepFunctions();
  for await (const message of messagesToRedrive(queueUrl)) {
    const input = JSON.parse(message.Body);
    console.log(`Redriving message ${JSON.stringify(input, null, 2)}`);
    const { executionArn } = await sfn.startExecution({
      stateMachineArn,
      input: JSON.stringify(__spreadProps(__spreadValues({}, input), {
        _error: void 0,
        _redrive: {
          lambdaRequestId: context.awsRequestId,
          lambdaLogGroupName: context.logGroupName,
          lambdaLogStreamName: context.logStreamName
        }
      }))
    }).promise();
    console.log(`Redrive execution ARN: ${executionArn}`);
    await sqs().deleteMessage({
      QueueUrl: queueUrl,
      ReceiptHandle: message.ReceiptHandle
    }).promise();
  }
}
async function* messagesToRedrive(queueUrl) {
  const sqs2 = sqs();
  let result;
  do {
    result = await sqs2.receiveMessage({
      QueueUrl: queueUrl,
      VisibilityTimeout: 900
    }).promise();
    if (result.Messages) {
      yield* result.Messages;
    }
  } while (result.Messages != null && result.Messages.length > 0);
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  handler
});
