/*
 * Decompiled with CFR 0.152.
 */
package org.util.graphviz;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;

public class GraphViz {
    private String IMAGE_FORMAT = "png";
    private static String TEMP_DIR = System.getProperty("java.io.tmpdir");
    private static final String DOT_PATH_PROPERTY_NAME = "sbml2dot.dot.path";
    private static String DOT = "/usr/bin/dot";
    private StringBuffer graph = new StringBuffer();

    public String getDotSource() {
        return this.graph.toString();
    }

    public void add(String line) {
        this.graph.append(line);
    }

    public void addln(String line) {
        this.graph.append(line + "\n");
    }

    public void addln() {
        this.graph.append('\n');
    }

    public byte[] getGraph(String dot_source) {
        return this.getGraph(dot_source, "");
    }

    public byte[] getGraph(String dot_source, String dotOptions) {
        byte[] img_stream = null;
        try {
            File dot = this.writeDotSourceToFile(dot_source);
            if (dot != null) {
                img_stream = this.getImgStream(dot, dotOptions);
                if (!dot.delete()) {
                    System.err.println("Warning: " + dot.getAbsolutePath() + " could not be deleted!");
                }
                return img_stream;
            }
            return null;
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public int writeGraphToFile(byte[] img, String file) {
        File to = new File(file);
        return this.writeGraphToFile(img, to);
    }

    public int writeGraphToFile(byte[] img, File to) {
        try {
            FileOutputStream fos = new FileOutputStream(to);
            fos.write(img);
            fos.close();
        }
        catch (IOException ioe) {
            return -1;
        }
        return 1;
    }

    private byte[] getImgStream(File dot, String dotAttr) {
        byte[] img_stream = null;
        if (!GraphViz.isDotAvailable()) {
            return null;
        }
        try {
            File img = File.createTempFile("graph_", "." + this.IMAGE_FORMAT, new File(TEMP_DIR));
            String imagePath = img.getAbsolutePath();
            Runtime rt = Runtime.getRuntime();
            String cmd = DOT + " -T" + this.IMAGE_FORMAT + " " + dotAttr + " " + dot.getAbsolutePath() + " -o" + imagePath;
            Process p = rt.exec(cmd);
            p.waitFor();
            FileInputStream in = new FileInputStream(img.getAbsolutePath());
            img_stream = new byte[in.available()];
            in.read(img_stream);
            if (in != null) {
                in.close();
            }
            if (!img.delete()) {
                System.out.println("Warning: " + img.getAbsolutePath() + " is not deleted!");
            }
        }
        catch (IOException ioe) {
            System.err.println("Error:    in I/O processing of tempfile in dir " + TEMP_DIR + "\n");
            System.err.println("       or in calling external command");
            ioe.printStackTrace();
        }
        catch (InterruptedException ie) {
            System.err.println("Error: the execution of the external program was interrupted");
            ie.printStackTrace();
        }
        return img_stream;
    }

    private File writeDotSourceToFile(String str) throws IOException {
        File temp;
        try {
            temp = File.createTempFile("graph_", ".dot.tmp", new File(TEMP_DIR));
            FileWriter fout = new FileWriter(temp);
            fout.write(str);
            fout.close();
        }
        catch (Exception e) {
            System.err.println("Error: I/O error while writing the dot source to temp file!");
            return null;
        }
        return temp;
    }

    public String startDigraph() {
        return "digraph G {";
    }

    public String endGraph() {
        return "}";
    }

    public String getImageFormat() {
        return this.IMAGE_FORMAT;
    }

    public void setImageFormat(String imageFormat) {
        this.IMAGE_FORMAT = imageFormat;
    }

    private static void updateDotPath() {
        if (System.getProperty(DOT_PATH_PROPERTY_NAME) != null) {
            DOT = System.getProperty(DOT_PATH_PROPERTY_NAME);
        }
    }

    public static boolean isDotAvailable() {
        GraphViz.updateDotPath();
        return new File(DOT).exists();
    }

    public static void setDotPath(String dotPath) {
        DOT = dotPath;
    }

    public static String getDotPath() {
        return DOT;
    }
}

