/*
 * Decompiled with CFR 0.152.
 */
package org.util.classlist;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.sbfc.converter.models.GeneralModel;
import org.util.classlist.ClassSearchUtils;

public class ModelSearcher {
    private static String modelSuperPackage = "org.sbfc.converter.models";

    public static String getModelSuperPackage() {
        return modelSuperPackage;
    }

    private static boolean isModel(String className) {
        try {
            Class<?> cls = Class.forName(className);
            Object clsInstance = cls.newInstance();
            if (clsInstance instanceof GeneralModel) {
                return true;
            }
        }
        catch (UnsatisfiedLinkError e) {
        }
        catch (ClassNotFoundException e) {
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (RuntimeException e) {
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public static ArrayList<String> getModelPackageList() {
        List<String> classes = ClassSearchUtils.searchClassPath(modelSuperPackage);
        ArrayList<String> classPackages = new ArrayList<String>();
        for (int i = 0; i < classes.size(); ++i) {
            String clsPackage;
            String cls = classes.get(i);
            if (!ModelSearcher.isModel(cls) || classPackages.contains(clsPackage = cls.substring(0, cls.lastIndexOf(".")))) continue;
            classPackages.add(clsPackage);
        }
        Collections.sort(classPackages);
        return classPackages;
    }

    public static ArrayList<String> getModelFullNameList() {
        List<String> classes = ClassSearchUtils.searchClassPath(modelSuperPackage);
        ArrayList<String> classPackages = new ArrayList<String>();
        for (int i = 0; i < classes.size(); ++i) {
            String cls = classes.get(i);
            if (!ModelSearcher.isModel(cls)) continue;
            classPackages.add(cls);
        }
        Collections.sort(classPackages);
        return classPackages;
    }

    public static ArrayList<String> getModelNameList() {
        List<String> classes = ClassSearchUtils.searchClassPath(modelSuperPackage);
        ArrayList<String> classNames = new ArrayList<String>();
        for (int i = 0; i < classes.size(); ++i) {
            String className;
            String cls = classes.get(i);
            if (!ModelSearcher.isModel(cls) || classNames.contains(className = cls.substring(cls.lastIndexOf(".") + 1))) continue;
            classNames.add(className);
        }
        Collections.sort(classNames);
        return classNames;
    }

    public static void main(String[] args) {
        ArrayList<String> modelNames = ModelSearcher.getModelNameList();
        for (int i = 0; i < modelNames.size(); ++i) {
            System.out.println(modelNames.get(i));
        }
    }
}

