/*
 * Decompiled with CFR 0.152.
 */
package org.util.classlist;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.sbfc.converter.GeneralConverter;
import org.util.classlist.ClassSearchUtils;

public class ConverterSearcher {
    private static String converterSuperPackage = "org.sbfc.converter";

    public static String getConverterSuperPackage() {
        return converterSuperPackage;
    }

    private static boolean isConverter(String className) {
        try {
            Class<?> cls = Class.forName(className);
            Object clsInstance = cls.newInstance();
            if (clsInstance instanceof GeneralConverter) {
                return true;
            }
        }
        catch (UnsatisfiedLinkError e) {
        }
        catch (ClassNotFoundException e) {
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (RuntimeException e) {
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public static ArrayList<String> getConverterPackageList() {
        List<String> classes = ClassSearchUtils.searchClassPath(converterSuperPackage);
        ArrayList<String> classPackages = new ArrayList<String>();
        for (int i = 0; i < classes.size(); ++i) {
            String clsPackage;
            String cls = classes.get(i);
            if (!ConverterSearcher.isConverter(cls) || classPackages.contains(clsPackage = cls.substring(0, cls.lastIndexOf(".")))) continue;
            classPackages.add(clsPackage);
        }
        Collections.sort(classPackages);
        return classPackages;
    }

    public static ArrayList<String> getConverterFullNameList() {
        List<String> classes = ClassSearchUtils.searchClassPath(converterSuperPackage);
        ArrayList<String> classPackages = new ArrayList<String>();
        for (int i = 0; i < classes.size(); ++i) {
            String cls = classes.get(i);
            if (!ConverterSearcher.isConverter(cls)) continue;
            classPackages.add(cls);
        }
        Collections.sort(classPackages);
        return classPackages;
    }

    public static ArrayList<String> getConverterNameList() {
        List<String> classes = ClassSearchUtils.searchClassPath(converterSuperPackage);
        ArrayList<String> classNames = new ArrayList<String>();
        for (int i = 0; i < classes.size(); ++i) {
            String className;
            String cls = classes.get(i);
            if (!ConverterSearcher.isConverter(cls) || classNames.contains(className = cls.substring(cls.lastIndexOf(".") + 1))) continue;
            classNames.add(className);
        }
        Collections.sort(classNames);
        return classNames;
    }

    public static void main(String[] args) {
        ArrayList<String> converterNames = ConverterSearcher.getConverterNameList();
        for (int i = 0; i < converterNames.size(); ++i) {
            System.out.println(converterNames.get(i));
        }
    }
}

