/*
 * Decompiled with CFR 0.152.
 */
package org.util.classlist;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Logger;

public class ClassSearchUtils {
    private static final Logger log = Logger.getAnonymousLogger();
    private ArrayList<String> listPackages;
    private String extension;
    private String prefix;

    public static List<String> searchClassPath(String prefix) {
        return ClassSearchUtils.searchClassPath(prefix, ".class");
    }

    public static List<String> searchClassPath(String prefix, String extension) {
        ClassSearchUtils factory = new ClassSearchUtils();
        factory.prefix = prefix;
        return factory.find(extension);
    }

    private List<String> find(String extension) {
        this.extension = extension;
        this.listPackages = new ArrayList();
        String classpath = System.getProperty("java.class.path");
        if (classpath == null) {
            classpath = System.getProperty("java.class.path");
        }
        StringTokenizer tokenizer = new StringTokenizer(classpath, File.pathSeparator);
        while (tokenizer.hasMoreTokens()) {
            String name;
            String token = tokenizer.nextToken();
            File dir = new File(token);
            if (dir.isDirectory()) {
                this.lookInDirectory("", dir);
            }
            if (!dir.isFile() || !(name = dir.getName().toLowerCase()).endsWith(".zip") && !name.endsWith(".jar")) continue;
            this.lookInArchive(dir);
        }
        return this.listPackages;
    }

    private void lookInDirectory(String name, File dir) {
        log.fine("Looking in directory [" + dir.getName() + "].");
        for (File file : dir.listFiles()) {
            String fileName = file.getName();
            if (file.isFile() && fileName.toLowerCase().endsWith(this.extension)) {
                if (this.extension.equalsIgnoreCase(".class")) {
                    fileName = fileName.substring(0, fileName.length() - 6);
                    if (!(name + fileName).startsWith(this.prefix)) continue;
                    log.fine("Found class: [" + name + fileName + "].");
                    this.listPackages.add(name + fileName);
                } else {
                    this.listPackages.add(name.replace('.', File.separatorChar) + fileName);
                }
            }
            if (!file.isDirectory()) continue;
            this.lookInDirectory(name + fileName + ".", file);
        }
    }

    private void lookInArchive(File archive) {
        log.fine("Looking in archive [" + archive.getName() + "] for extension [" + this.extension + "].");
        JarFile jarFile = null;
        Enumeration<JarEntry> entries = null;
        try {
            jarFile = new JarFile(archive);
            entries = jarFile.entries();
        }
        catch (IOException e) {
            log.warning("Non fatal error. Unable to read jar item.");
            return;
        }
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String entryName = entry.getName();
            if (!entryName.toLowerCase().endsWith(this.extension)) continue;
            if (this.extension.equalsIgnoreCase(".class")) {
                entryName = entryName.substring(0, entryName.length() - 6);
                if (!(entryName = entryName.replace('/', '.')).startsWith(this.prefix)) continue;
                log.fine("Found class: [" + entryName + "]. ");
                this.listPackages.add(entryName);
                continue;
            }
            this.listPackages.add(entryName);
        }
        try {
            if (jarFile != null) {
                jarFile.close();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
    }
}

