/*
 * Decompiled with CFR 0.152.
 */
package org.sbfc.converter.utils.sbgn;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.sbfc.converter.sbml2dot.ConstraintFileReader;
import org.sbml.jsbml.Annotation;
import org.sbml.jsbml.CVTerm;
import org.sbml.jsbml.SBO;
import org.sbml.jsbml.SBase;

public class SBGNUtils {
    private static Logger logger = Logger.getLogger(SBGNUtils.class);
    private String[] FORMATS = new String[2];
    private String conversionFormatOutput;
    private static Properties properties = SBGNUtils.readProperties();
    private static ArrayList<String> tree = SBGNUtils.buildTree();
    public static Hashtable<String, String> speciesAnnotationMap = new Hashtable();

    public SBGNUtils(String conversionFormatOutput) {
        this.FORMATS[0] = "dot";
        this.FORMATS[1] = "sbgnml";
        this.conversionFormatOutput = conversionFormatOutput;
    }

    public static String getSBGNClassThroughAnnotation(Annotation annotation) {
        String sbgnClass = null;
        if (annotation == null) {
            logger.warn((Object)"ShapeUtils : getSBGNClassThroughAnnotation : annotation string is null !");
            return sbgnClass;
        }
        if (annotation.getNumCVTerms() > 0) {
            for (CVTerm cvTerm : annotation.getListOfCVTerms()) {
                if (cvTerm.isBiologicalQualifier() && cvTerm.getBiologicalQualifierType().equals((Object)CVTerm.Qualifier.BQB_HAS_PART)) {
                    return "complex";
                }
                Integer i = 0;
                String biopaxPhysicalEntityType = null;
                String previousSBGNClass = null;
                boolean canCompare = false;
                for (String uri : cvTerm.getResources()) {
                    i = i + 1;
                    logger.debug((Object)("Number of uri : " + i.toString() + " " + uri));
                    if (uri.matches("^#.*")) continue;
                    if (speciesAnnotationMap.containsKey(uri)) {
                        logger.debug((Object)"entire uri recognized");
                        biopaxPhysicalEntityType = speciesAnnotationMap.get(uri);
                    } else {
                        int lastIndex = uri.lastIndexOf(":");
                        String firstPartUri = uri.substring(0, lastIndex);
                        logger.debug((Object)("firstPartUri : " + firstPartUri));
                        if (speciesAnnotationMap.containsKey(firstPartUri)) {
                            biopaxPhysicalEntityType = speciesAnnotationMap.get(firstPartUri);
                            logger.debug((Object)("parsed annotation recognized is " + biopaxPhysicalEntityType));
                        }
                    }
                    if (biopaxPhysicalEntityType == null || biopaxPhysicalEntityType.trim().length() == 0) {
                        logger.warn((Object)("Warning : cannot find a valid class for the uri '" + uri + "'."));
                        continue;
                    }
                    sbgnClass = SBGNUtils.biopaxTosbgnClass(biopaxPhysicalEntityType);
                    if (canCompare && sbgnClass != previousSBGNClass) {
                        logger.warn((Object)"Warning: annotations give different SBGN-ML class");
                    }
                    previousSBGNClass = sbgnClass;
                    canCompare = true;
                }
                sbgnClass = SBGNUtils.biopaxTosbgnClass(biopaxPhysicalEntityType);
            }
        }
        return sbgnClass;
    }

    public static String getSBGNClassThroughSboterm(SBase sBase) {
        if (sBase.isSetSBOTerm()) {
            int sboTermInt = sBase.getSBOTerm();
            String sboTerm = sBase.getSBOTermID();
            if (!SBO.checkTerm((String)sboTerm)) {
                logger.warn((Object)("Warning : Bad sboTerm : " + sboTerm));
            } else {
                String sboClass = properties.getProperty(sboTerm);
                if (sboClass == null) {
                    for (String parent : tree) {
                        int parentSboTerm = SBO.stringToInt((String)parent);
                        if (!SBO.isChildOf((int)sboTermInt, (int)parentSboTerm)) continue;
                        return properties.getProperty(parent);
                    }
                } else {
                    return sboClass;
                }
            }
        }
        return null;
    }

    public static Integer getSBOTermThroughSBGNClass(String SBGNClass) {
        for (String string : properties.values()) {
            String value = properties.getProperty(string);
            if (!value.equals(SBGNClass)) continue;
            return SBO.stringToInt((String)string);
        }
        return null;
    }

    public static Properties readProperties() {
        Properties properties = new Properties();
        try {
            properties.load(SBGNUtils.class.getResourceAsStream("sbo2sbgn.properties"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return properties;
    }

    public static String getSBGNClass(SBase sBase) {
        String sbgnClassBySboTerm = SBGNUtils.getSBGNClassThroughSboterm(sBase);
        logger.debug((Object)("for the reaction " + sBase.getSBOTermID() + " sbgnClassBySboTerm is = " + sbgnClassBySboTerm));
        String sbgnClassByAnnotation = SBGNUtils.getSBGNClassThroughAnnotation(sBase.getAnnotation());
        logger.debug((Object)("SBGN class by the annotation is = " + sbgnClassByAnnotation));
        if (sbgnClassBySboTerm != null) {
            if (sbgnClassByAnnotation != null && !sbgnClassBySboTerm.equals(sbgnClassByAnnotation)) {
                logger.warn((Object)("Warning: for MetaID: '" + sBase.getMetaId() + "', the shape found with sboTerm is '" + sbgnClassBySboTerm + "' instead of '" + sbgnClassByAnnotation + "' with annotations"));
            }
            return sbgnClassBySboTerm;
        }
        if (sbgnClassByAnnotation != null) {
            return sbgnClassByAnnotation;
        }
        return null;
    }

    public static String biopaxTosbgnClass(String biopaxType) {
        HashMap<String, String> link = new HashMap<String, String>(5);
        link.put("complex", "complex");
        link.put("protein", "macromolecule");
        link.put("rna", "macromolecule");
        link.put("dna", "macromolecule");
        link.put("smallMolecule", "simple chemical");
        String sbgnClass = (String)link.get(biopaxType);
        return sbgnClass;
    }

    private static ArrayList<String> buildTree() {
        InputStream is = SBGNUtils.class.getResourceAsStream("sbo2sbgn.properties");
        if (is == null) {
            System.out.println("The file 'sbo2sbgn.properties' was not found !!!");
            return new ArrayList<String>();
        }
        InputStreamReader isr = new InputStreamReader(is);
        BufferedReader in = new BufferedReader(isr);
        String line = "";
        ArrayList<String> tree = new ArrayList<String>(0);
        try {
            while ((line = in.readLine()) != null) {
                String correctSboTerm;
                String[] sboTab = line.split("=", 1);
                if (line.startsWith("#") || line.equals("") || sboTab.length != 2 || !SBO.checkTerm((String)(correctSboTerm = sboTab[0].replace("\\:", ":")))) continue;
                tree.add(correctSboTerm);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return tree;
    }

    public String getOutputFromClass(SBase sBase, String defaultSBGNClass) {
        String sbgnClass = SBGNUtils.getSBGNClass(sBase);
        if (sbgnClass == null) {
            sbgnClass = defaultSBGNClass;
            if (defaultSBGNClass == null) {
                logger.info((Object)("Shape for metaId: " + sBase.getMetaId() + " cannot be given."));
                return null;
            }
        }
        if (sBase.getClass().toString().equals("class org.sbml.jsbml.Reaction")) {
            String regex = "^consumption$|^production$";
            if (defaultSBGNClass.matches(regex) && !sbgnClass.matches(regex)) {
                sbgnClass = defaultSBGNClass;
            }
            if (defaultSBGNClass.matches(regex = "^modulation$|(^necessary |^)stimulation$|^catalysis$|^inhibition$") && !sbgnClass.matches(regex)) {
                sbgnClass = defaultSBGNClass;
            }
            if (defaultSBGNClass.matches(regex = "(^uncertain |^omitted |^)process$|^association$|^dissociation$|^phenotype$") && !sbgnClass.matches(regex)) {
                sbgnClass = defaultSBGNClass;
            }
        }
        if (this.conversionFormatOutput.equalsIgnoreCase("dot")) {
            HashMap<String, String> map = SBGNUtils.sbgn2DotMap();
            return map.get(sbgnClass);
        }
        if (this.conversionFormatOutput.equalsIgnoreCase("sbgnml")) {
            return sbgnClass;
        }
        System.out.println("Warning : format " + this.conversionFormatOutput + " does not exist.");
        return null;
    }

    private static HashMap<String, String> sbgn2DotMap() {
        String imagePath = "src/org/sbfc/converter/sbml2dot/dotImages/";
        HashMap<String, String> hm = new HashMap<String, String>();
        hm.put("macromolecule multimer", "\"rectangle\", style=rounded");
        hm.put("complex multimer", "\"octagon\"");
        hm.put("nucleic acid feature multimer", "\"ellipse\"");
        hm.put("simple chemical multimer", "\"circle\"");
        hm.put("complex", "\"octagon\"");
        hm.put("nucleic acid feature", "\"ellipse\"");
        hm.put("empty set", "plaintext, label=\"\u00d8\", fontsize=15,fontcolor=blue];");
        hm.put("simple chemical", "\"circle\"");
        hm.put("compartment", "\"rectangle\", style=rounded");
        hm.put("unspecified entity", "\"ellipse\"");
        hm.put("macromolecule", "\"rectangle\", style=rounded");
        hm.put("perturbation", "\"ellipse\"");
        hm.put("association", "\"circle\", style=filled, fillcolor=black");
        hm.put("dissociation", "\"doublecircle\", fixedsize=true, width=0.001, height=0.001]//");
        hm.put("submap", "\"rectangle\"");
        hm.put("omitted process", "\"square\", label=\"\\\\\\\\\" ");
        hm.put("uncertain process", "\"square\", label=\"?\"");
        hm.put("phenotype", "\"hexagon\"");
        hm.put("process", "\"square\"");
        hm.put("and", "\"circle\", label=\"AND\"");
        hm.put("or", "\"circle\", label=\"OR\"");
        hm.put("not", "\"circle\", label=\"NOT\"");
        hm.put("consumption", "\"none\"");
        hm.put("production", "\"normal\"");
        hm.put("necessary stimulation", "\"teeonormal\"");
        hm.put("catalysis", "\"odot\"");
        hm.put("stimulation", "\"onormal\"");
        hm.put("inhibition", "\"tee\"");
        hm.put("modulation", "\"odiamond\"");
        hm.put("logic arc", "\"none\"");
        return hm;
    }

    static {
        ConstraintFileReader.parseSBML2SBGNConfigFile(speciesAnnotationMap, new Hashtable<String, String>(), new Hashtable<String, String>(), new Hashtable<String, String>(), "classSBGN");
    }
}

