/*
 * Decompiled with CFR 0.152.
 */
package org.sbfc.converter.sbml2xpp;

import java.util.HashMap;

public class XPPID {
    private static HashMap<String, XPPID> xppIdMap = new HashMap();
    private static HashMap<String, Integer> xppIdReduceMap = new HashMap();
    private static HashMap<String, XPPID> sbmlIdMap = new HashMap();
    private String sbmlId;
    private String xppId;
    private String xppIdUpercase;

    public XPPID(String sbmlId) {
        this.sbmlId = sbmlId;
        this.xppId = sbmlId;
        if (this.xppId.equalsIgnoreCase("time")) {
            this.xppId = "t";
        } else if (this.xppId.equalsIgnoreCase("floor")) {
            this.xppId = "flr";
        } else if (this.xppId.equalsIgnoreCase("t")) {
            this.xppId = sbmlId + "_renamed";
        } else if (this.xppId.equalsIgnoreCase("pi")) {
            this.xppId = sbmlId + "_ren";
        }
        this.xppIdUpercase = sbmlId.toUpperCase();
    }

    public XPPID(String sbmlId, String sbmlReactionId) {
        this.sbmlId = sbmlId + "_" + sbmlReactionId;
        this.xppId = sbmlId;
        this.xppIdUpercase = this.xppId.toUpperCase();
    }

    public void checkXPPId() {
        if (this.xppId.length() > 9) {
            this.xppId = this.xppId.substring(0, 9);
            this.xppIdUpercase = this.xppId.toUpperCase();
        }
        boolean isUnique = false;
        Integer idNb = xppIdReduceMap.get(this.xppIdUpercase);
        int i = 1;
        if (idNb != null) {
            i = idNb;
        }
        while (!isUnique) {
            XPPID conflictingId = xppIdMap.get(this.xppIdUpercase);
            if (conflictingId == null) {
                isUnique = true;
                break;
            }
            this.reduceId(i);
            ++i;
        }
        this.xppIdUpercase = this.xppId.toUpperCase();
        xppIdMap.put(this.xppIdUpercase, this);
        xppIdReduceMap.put(this.xppIdUpercase, i);
        sbmlIdMap.put(this.sbmlId, this);
    }

    private void reduceId(int i) {
        if (i < 10) {
            if (this.xppId.length() > 7) {
                this.xppId = this.xppId.substring(0, 7);
            }
            this.xppId = this.xppId + "_" + i;
        } else if (i < 100) {
            if (this.xppId.length() > 6) {
                this.xppId = this.xppId.substring(0, 6);
            }
            this.xppId = this.xppId + "_" + i;
        } else {
            if (this.xppId.length() > 4) {
                this.xppId = this.xppId.substring(0, 4);
            }
            this.xppId = this.xppId + "_" + i;
        }
        this.xppIdUpercase = this.xppId.toUpperCase();
    }

    public boolean equals(Object obj) {
        if (obj instanceof XPPID) {
            return ((XPPID)obj).getXppId().equalsIgnoreCase(this.xppId);
        }
        if (obj instanceof String) {
            return ((String)obj).equalsIgnoreCase(this.xppId);
        }
        return false;
    }

    public int hashCode() {
        return this.xppIdUpercase.hashCode();
    }

    public String toString() {
        return this.xppId;
    }

    public String getSbmlId() {
        return this.sbmlId;
    }

    public String getXppId() {
        return this.xppId;
    }

    public String getXppIdUpercase() {
        return this.xppIdUpercase;
    }

    public static String getSBMLId(String xppId) {
        XPPID id = xppIdMap.get(xppId.toUpperCase());
        if (id == null) {
            return null;
        }
        return id.getSbmlId();
    }

    public static String getXPPId(String sbmlId) {
        XPPID id = sbmlIdMap.get(sbmlId);
        if (id == null) {
            return null;
        }
        return id.getXppId();
    }

    static {
        sbmlIdMap.put("time", new XPPID("time"));
        sbmlIdMap.put("Time", new XPPID("time"));
        sbmlIdMap.put("floor", new XPPID("floor"));
    }
}

