/*
 * Decompiled with CFR 0.152.
 */
package org.sbfc.converter.sbml2sbml;

import java.util.ArrayList;
import java.util.Calendar;
import org.identifiers.registry.RegistryLocalProvider;
import org.sbml.libsbml.CVTerm;
import org.sbml.libsbml.Event;
import org.sbml.libsbml.KineticLaw;
import org.sbml.libsbml.ListOf;
import org.sbml.libsbml.Model;
import org.sbml.libsbml.Reaction;
import org.sbml.libsbml.SBMLDocument;
import org.sbml.libsbml.SBMLReader;
import org.sbml.libsbml.SBMLWriter;
import org.sbml.libsbml.SBase;
import org.sbml.libsbml.UnitDefinition;

public class IdentifiersUtilLibSBML {
    private static String urnPrefix = "urn:miriam";
    private static String urlPrefix = "http://identifiers.org";
    private static RegistryLocalProvider link = new RegistryLocalProvider();
    private static boolean isLibSBMLAvailable = false;

    private static void listOfAnnotationsUpdate(ListOf listOf, String annotationPrefix) {
        if (listOf == null) {
            return;
        }
        IdentifiersUtilLibSBML.sBaseAnnotationsUpdate((SBase)listOf, annotationPrefix);
        long n = listOf.size();
        int i = 0;
        while ((long)i < n) {
            SBase sbase = listOf.get((long)i);
            IdentifiersUtilLibSBML.sBaseAnnotationsUpdate(sbase, annotationPrefix);
            ++i;
        }
    }

    private static void sBaseAnnotationsUpdate(SBase sbase, String annotationPrefix) {
        block12: {
            if (sbase.getNumCVTerms() <= 0L) break block12;
            boolean urn2url = false;
            boolean url2urn = false;
            boolean update = false;
            if (annotationPrefix == null) {
                update = true;
            } else if (annotationPrefix.equals(urlPrefix)) {
                url2urn = true;
            } else if (annotationPrefix.equals(urnPrefix)) {
                urn2url = true;
            }
            long n = sbase.getNumCVTerms();
            int i = 0;
            while ((long)i < n) {
                CVTerm cvTerm = sbase.getCVTerm((long)i);
                ArrayList<String> updatedUris = new ArrayList<String>();
                boolean updated = false;
                long nbURIs = cvTerm.getNumResources();
                int j = 0;
                while ((long)j < nbURIs) {
                    block16: {
                        String newURI;
                        String annotationString;
                        block15: {
                            block13: {
                                block14: {
                                    newURI = annotationString = cvTerm.getResourceURI((long)j);
                                    if (!url2urn && !urn2url || annotationString.startsWith(annotationPrefix)) break block13;
                                    if (!url2urn) break block14;
                                    newURI = link.convertURN(annotationString);
                                    break block15;
                                }
                                if (!urn2url) break block15;
                                break block16;
                            }
                            if (update) {
                                newURI = link.getMiriamURI(annotationString);
                            }
                        }
                        if (newURI == null) {
                            System.out.println("Error : the uri '" + annotationString + "' is not recognized by miriamws !!");
                            newURI = annotationString;
                        } else if (!newURI.equals(annotationString)) {
                            updated = true;
                        }
                        updatedUris.add(newURI);
                    }
                    ++j;
                }
                if (updated) {
                    // empty if block
                }
                ++i;
            }
        }
    }

    public static SBMLDocument urnToUrl(SBMLDocument doc) {
        return IdentifiersUtilLibSBML.documentAnnotationsUpdate(doc, urlPrefix);
    }

    public static SBMLDocument urlToUrn(SBMLDocument doc) {
        return IdentifiersUtilLibSBML.documentAnnotationsUpdate(doc, urnPrefix);
    }

    public static SBMLDocument updateAnnotations(SBMLDocument doc) {
        return IdentifiersUtilLibSBML.documentAnnotationsUpdate(doc, null);
    }

    private static SBMLDocument documentAnnotationsUpdate(SBMLDocument doc, String annotationPrefix) {
        IdentifiersUtilLibSBML.sBaseAnnotationsUpdate((SBase)doc, annotationPrefix);
        Model model = doc.getModel();
        IdentifiersUtilLibSBML.sBaseAnnotationsUpdate((SBase)model, annotationPrefix);
        IdentifiersUtilLibSBML.listOfAnnotationsUpdate((ListOf)model.getListOfFunctionDefinitions(), annotationPrefix);
        IdentifiersUtilLibSBML.listOfAnnotationsUpdate((ListOf)model.getListOfUnitDefinitions(), annotationPrefix);
        long n = model.getListOfUnitDefinitions().size();
        int i = 0;
        while ((long)i < n) {
            UnitDefinition unitDefinition = model.getUnitDefinition((long)i);
            IdentifiersUtilLibSBML.listOfAnnotationsUpdate((ListOf)unitDefinition.getListOfUnits(), annotationPrefix);
            ++i;
        }
        IdentifiersUtilLibSBML.listOfAnnotationsUpdate((ListOf)model.getListOfSpeciesTypes(), annotationPrefix);
        IdentifiersUtilLibSBML.listOfAnnotationsUpdate((ListOf)model.getListOfCompartmentTypes(), annotationPrefix);
        IdentifiersUtilLibSBML.listOfAnnotationsUpdate((ListOf)model.getListOfSpecies(), annotationPrefix);
        IdentifiersUtilLibSBML.listOfAnnotationsUpdate((ListOf)model.getListOfCompartments(), annotationPrefix);
        IdentifiersUtilLibSBML.listOfAnnotationsUpdate((ListOf)model.getListOfParameters(), annotationPrefix);
        IdentifiersUtilLibSBML.listOfAnnotationsUpdate((ListOf)model.getListOfInitialAssignments(), annotationPrefix);
        IdentifiersUtilLibSBML.listOfAnnotationsUpdate((ListOf)model.getListOfRules(), annotationPrefix);
        IdentifiersUtilLibSBML.listOfAnnotationsUpdate((ListOf)model.getListOfConstraints(), annotationPrefix);
        IdentifiersUtilLibSBML.listOfAnnotationsUpdate((ListOf)model.getListOfReactions(), annotationPrefix);
        n = model.getListOfReactions().size();
        i = 0;
        while ((long)i < n) {
            Reaction reaction = model.getReaction((long)i);
            IdentifiersUtilLibSBML.listOfAnnotationsUpdate((ListOf)reaction.getListOfModifiers(), annotationPrefix);
            IdentifiersUtilLibSBML.listOfAnnotationsUpdate((ListOf)reaction.getListOfProducts(), annotationPrefix);
            IdentifiersUtilLibSBML.listOfAnnotationsUpdate((ListOf)reaction.getListOfReactants(), annotationPrefix);
            if (reaction.isSetKineticLaw()) {
                KineticLaw kineticLaw = reaction.getKineticLaw();
                IdentifiersUtilLibSBML.sBaseAnnotationsUpdate((SBase)kineticLaw, annotationPrefix);
                IdentifiersUtilLibSBML.listOfAnnotationsUpdate((ListOf)kineticLaw.getListOfLocalParameters(), annotationPrefix);
            }
            ++i;
        }
        IdentifiersUtilLibSBML.listOfAnnotationsUpdate((ListOf)model.getListOfEvents(), annotationPrefix);
        n = model.getListOfEvents().size();
        i = 0;
        while ((long)i < n) {
            Event event = model.getEvent((long)i);
            IdentifiersUtilLibSBML.listOfAnnotationsUpdate((ListOf)event.getListOfEventAssignments(), annotationPrefix);
            ++i;
        }
        return doc;
    }

    public static void main(String[] args) {
        if (!isLibSBMLAvailable) {
            System.out.println("LibSBML does not seems to be correctly configured !!");
            System.exit(2);
        }
        if (args.length < 2) {
            System.out.println("Usage : java org.sbml.jsbml.xml.stax.SBMLWriter [-m|-i|-u] sbmlFileName [suffix]");
            System.out.println("\n\t\tThe order of the options is important.");
            System.out.println("\n\t\t-m will update the given sbml file to use miriam urn-uris");
            System.out.println("\n\t\t-i will update the given sbml file to use miriam url-uris (identifiers.org urls)");
            System.out.println("\n\t\t-u will update the given sbml file to the correct and up-to-date miriam urn-uris");
            System.exit(1);
        }
        long init = Calendar.getInstance().getTimeInMillis();
        System.out.println(Calendar.getInstance().getTime());
        String annoPrefixOption = args[0];
        String annotationPrefix = urlPrefix;
        String fileName = args[1];
        String fileNameSuffix = "-identifiers.org";
        if (annoPrefixOption.equals("-m")) {
            fileNameSuffix = "-miriam-urn";
            annotationPrefix = urnPrefix;
        } else if (annoPrefixOption.equals("-u")) {
            fileNameSuffix = "-updated-annotations";
            annotationPrefix = null;
        }
        if (args.length >= 3) {
            fileNameSuffix = args[3];
        }
        String jsbmlWriteFileName = fileName.replaceFirst(".xml", fileNameSuffix + ".xml");
        System.out.printf("Reading %s and writing %s\n", fileName, jsbmlWriteFileName);
        long afterRead = 0L;
        long afterAnnoUpdate = 0L;
        SBMLDocument testDocument = new SBMLReader().readSBMLFromFile(fileName);
        System.out.printf("Reading done\n", new Object[0]);
        System.out.println(Calendar.getInstance().getTime());
        afterRead = Calendar.getInstance().getTimeInMillis();
        IdentifiersUtilLibSBML.documentAnnotationsUpdate(testDocument, annotationPrefix);
        afterAnnoUpdate = Calendar.getInstance().getTimeInMillis();
        System.out.printf("Starting writing\n", new Object[0]);
        new SBMLWriter().writeSBMLToFile(testDocument, jsbmlWriteFileName);
        System.out.println(Calendar.getInstance().getTime());
        long end = Calendar.getInstance().getTimeInMillis();
        long nbSecondes = (end - init) / 1000L;
        long nbSecondesRead = (afterRead - init) / 1000L;
        long nbSecondesAnnoUpdate = (afterAnnoUpdate - afterRead) / 1000L;
        long nbSecondesWrite = (end - afterAnnoUpdate) / 1000L;
        if (nbSecondes > 120L) {
            System.out.println("It took " + nbSecondes / 60L + " minutes.");
        } else {
            System.out.println("It took " + nbSecondes + " secondes.");
        }
        System.out.println("Reading : " + nbSecondesRead + " secondes.");
        System.out.println("Writing : " + nbSecondesWrite + " secondes, AnnoUpdate : " + nbSecondesAnnoUpdate + " secondes.");
    }

    public static String anyStringAnnotationsUpdate(String anyString) {
        return anyString;
    }

    static {
        try {
            System.loadLibrary("sbmlj");
            Class.forName("org.sbml.libsbml.libsbml");
            isLibSBMLAvailable = true;
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (UnsatisfiedLinkError e) {
            throw new RuntimeException("You need to install libsbml before being able to use the IdentifiersUtilLibSBML class.", e);
        }
        catch (ClassNotFoundException e) {
            System.out.println("ClassNotFoundException exception catched : Could not load libsbml class file.");
        }
        catch (RuntimeException e) {
            System.out.println("Could not load libsbml.\n Control that the libsbmlj.jar that you are using is synchronized with your current libSBML installation.");
        }
    }
}

