/*
 * Decompiled with CFR 0.152.
 */
package org.sbfc.converter.sbml2octave;

import java.util.HashMap;

public class OctaveID {
    private static HashMap<String, OctaveID> octaveIdMap = new HashMap();
    private static HashMap<String, OctaveID> sbmlIdMap = new HashMap();
    private String sbmlId;
    private String octaveId;

    public OctaveID(String sbmlId) {
        this.sbmlId = sbmlId;
        this.octaveId = sbmlId;
    }

    public OctaveID(String sbmlId, String octaveId, Boolean diff) {
        this.sbmlId = sbmlId;
        this.octaveId = octaveId;
    }

    public OctaveID(String sbmlId, String sbmlReactionId) {
        this.sbmlId = sbmlId + "_" + sbmlReactionId;
        this.octaveId = sbmlId;
    }

    public void checkOctaveId() {
        octaveIdMap.put(this.octaveId, this);
        sbmlIdMap.put(this.sbmlId, this);
    }

    public boolean equals(Object obj) {
        if (obj instanceof OctaveID) {
            return ((OctaveID)obj).getOctaveId().equalsIgnoreCase(this.octaveId);
        }
        if (obj instanceof String) {
            return ((String)obj).equalsIgnoreCase(this.octaveId);
        }
        return false;
    }

    public int hashCode() {
        return this.octaveId.hashCode();
    }

    public String toString() {
        return this.octaveId;
    }

    public String getSbmlId() {
        return this.sbmlId;
    }

    public String getOctaveId() {
        return this.octaveId;
    }

    public static String getSBMLId(String octaveId) {
        OctaveID id = octaveIdMap.get(octaveId);
        if (id == null) {
            return null;
        }
        return id.getSbmlId();
    }

    public static String getOctaveId(String sbmlId) {
        OctaveID id = sbmlIdMap.get(sbmlId);
        if (id == null) {
            return null;
        }
        return id.getOctaveId();
    }

    static {
        sbmlIdMap.put("time", new OctaveID("time"));
        sbmlIdMap.put("Time", new OctaveID("time"));
        sbmlIdMap.put("floor", new OctaveID("floor"));
    }
}

