/*
 * Decompiled with CFR 0.152.
 */
package org.sbfc.converter.sbml2graphml;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import javax.xml.stream.XMLStreamException;
import org.sbml.jsbml.ListOf;
import org.sbml.jsbml.Model;
import org.sbml.jsbml.ModifierSpeciesReference;
import org.sbml.jsbml.Reaction;
import org.sbml.jsbml.SBMLDocument;
import org.sbml.jsbml.SBMLReader;
import org.sbml.jsbml.SimpleSpeciesReference;
import org.sbml.jsbml.Species;
import org.sbml.jsbml.SpeciesReference;

public class SBML2GRAPHML {
    private String sbmlFileName;

    public SBML2GRAPHML(String input) {
        this.sbmlFileName = input;
    }

    public SBMLDocument getSBMLDocument() {
        SBMLDocument document = null;
        SBMLReader reader = new SBMLReader();
        try {
            document = reader.readSBML(this.sbmlFileName);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
        return document;
    }

    public String closeGraphMLTag() {
        return "</graphml>\n";
    }

    public String closeGraphTag() {
        return "</graph>\n";
    }

    public static String openGraphMLTag() {
        return "<graphml>\n";
    }

    public static String openGraphTag(String edgeDefault) {
        if (edgeDefault == null || !edgeDefault.matches("directed|undirected")) {
            edgeDefault = "directed";
        }
        return "<graph edgedefault=\"" + edgeDefault + "\">\n";
    }

    public String writeDescTags(String comment) {
        if (comment.equals("") || comment == null) {
            comment = "no description available";
        }
        return "<desc>" + comment + "</desc>\n";
    }

    public String writeEdgeTag(Reaction reaction, SimpleSpeciesReference ssr, String type) {
        String source = ssr.getSpecies();
        String target = reaction.getId();
        if (type.matches("product")) {
            source = target;
            target = ssr.getSpecies();
        }
        return "<edge source=\"" + source + "\" target=\"" + target + "\"/>\n";
    }

    public void writeGraphML(SBMLDocument sbmlDoc, String outputFile) {
        String graph = "";
        graph = graph + SBML2GRAPHML.openGraphMLTag();
        Model model = sbmlDoc.getModel();
        String comment = model.getName();
        try {
            comment = model.getName() + " " + model.getNotesString();
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
        graph = graph + this.writeIndents(1) + this.writeDescTags(comment);
        graph = graph + this.writeIndents(1) + SBML2GRAPHML.openGraphTag("directed");
        ListOf los = model.getListOfSpecies();
        for (Species sp : los) {
            graph = graph + this.writeIndents(2) + this.writeDescTags(sp.getName());
            graph = graph + this.writeIndents(2) + this.writeNodeTag(sp.getId());
        }
        String edges = "";
        ListOf lor = model.getListOfReactions();
        for (Reaction reac : lor) {
            graph = graph + this.writeIndents(2) + this.writeDescTags(reac.getName());
            graph = graph + this.writeIndents(2) + this.writeNodeTag(reac.getId());
            edges = edges + this.writeIndents(2) + this.writeDescTags(reac.getName());
            ListOf lore = reac.getListOfReactants();
            if (lore.size() > 0) {
                for (SpeciesReference spRef : lore) {
                    edges = edges + this.writeIndents(2) + this.writeEdgeTag(reac, (SimpleSpeciesReference)spRef, "reactant");
                }
            }
            if ((lore = reac.getListOfProducts()).size() > 0) {
                for (SpeciesReference spRef : lore) {
                    edges = edges + this.writeIndents(2) + this.writeEdgeTag(reac, (SimpleSpeciesReference)spRef, "product");
                }
            }
            ListOf lomoref = reac.getListOfModifiers();
            if (lore.size() <= 0) continue;
            for (ModifierSpeciesReference moRef : lomoref) {
                edges = edges + this.writeIndents(2) + this.writeEdgeTag(reac, (SimpleSpeciesReference)moRef, "modifier");
            }
        }
        graph = graph + edges;
        graph = graph + this.writeIndents(1) + this.closeGraphTag();
        graph = graph + this.closeGraphMLTag();
        try {
            BufferedWriter buff = new BufferedWriter(new FileWriter(outputFile));
            buff.write(graph);
            buff.close();
        }
        catch (IOException ioe) {
            System.out.println("Error in writeGraphML...");
            ioe.printStackTrace();
        }
    }

    public String writeIndents(int number) {
        String indentPattern = " ";
        String indent = "";
        for (int i = 0; i < number; ++i) {
            indent = indent + indentPattern;
        }
        return indent;
    }

    public String writeNodeTag(String idAttr) {
        return "<node id=\"" + idAttr + "\"/>\n";
    }

    public String getName() {
        return "SBML2GRAPHML";
    }

    public String getDescription() {
        return "It converts a model format from SBML to Graph ML";
    }

    public String getHtmlDescription() {
        return "It converts a model format from SBML to Graph ML";
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("Bad usage: path of a SBML file as unique argument");
            return;
        }
        String sbmlFileName = args[0];
        SBML2GRAPHML sbml = new SBML2GRAPHML(sbmlFileName);
        SBMLDocument sbmlDocument = sbml.getSBMLDocument();
        if (sbmlDocument == null) {
            System.exit(1);
        }
        String outputFilePath = sbmlFileName.replaceAll("[_A-Za-z0-9-]+.xml$", "");
        String outputFile = outputFilePath + "graphML_" + sbmlFileName.replaceAll("^.*/", "");
        sbml.writeGraphML(sbmlDocument, outputFile);
        System.out.println("Writing done");
    }
}

