/*
 * Decompiled with CFR 0.152.
 */
package org.sbfc.converter.sbml2dot;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Hashtable;
import javax.xml.stream.XMLStreamException;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;
import org.sbfc.converter.GeneralConverter;
import org.sbfc.converter.exceptions.ConversionException;
import org.sbfc.converter.exceptions.ReadModelException;
import org.sbfc.converter.models.DotModel;
import org.sbfc.converter.models.GeneralModel;
import org.sbfc.converter.models.SBMLModel;
import org.sbfc.converter.sbml2dot.ConstraintFileReader;
import org.sbfc.converter.sbml2dot.Context;
import org.sbfc.converter.sbml2dot.MiriamAnnotation;
import org.sbfc.converter.utils.sbgn.SBGNUtils;
import org.sbml.jsbml.ExplicitRule;
import org.sbml.jsbml.ListOf;
import org.sbml.jsbml.Model;
import org.sbml.jsbml.ModifierSpeciesReference;
import org.sbml.jsbml.Reaction;
import org.sbml.jsbml.Rule;
import org.sbml.jsbml.SBMLDocument;
import org.sbml.jsbml.SBMLException;
import org.sbml.jsbml.SBMLReader;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.SimpleSpeciesReference;
import org.sbml.jsbml.Species;
import org.sbml.jsbml.SpeciesReference;
import org.util.graphviz.GraphViz;

public class SBML2Dot
extends GeneralConverter {
    private static Logger logger = Logger.getLogger(SBML2Dot.class);
    public static int MAX_EDGE_ALLOWED = 4;
    public static int MAX_REACTION_ALLOWED = 3000;
    public static SBGNUtils converter = new SBGNUtils("dot");
    public static Hashtable<String, String> speciesAnnotationMap = new Hashtable();
    public boolean cloning = false;
    public String fileNameSuffix = "";
    private String sbmlFileName;
    private HashMap<Species, Integer> speciesCardinalityMap = new HashMap();
    Model sbmlModel;

    public SBML2Dot(String sbmlFileName) {
        this.sbmlFileName = sbmlFileName;
        this.cloning = false;
        this.fileNameSuffix = "_auto";
    }

    public SBML2Dot() {
        this(null);
    }

    private void addCardinality(ListOf<? extends SimpleSpeciesReference> listOf) {
        for (SimpleSpeciesReference speciesRef : listOf) {
            Species species = speciesRef.getSpeciesInstance();
            Integer cardinality = this.speciesCardinalityMap.get(species);
            if (cardinality == null) {
                cardinality = 1;
            } else {
                Integer n = cardinality;
                Integer n2 = cardinality = Integer.valueOf(cardinality + 1);
            }
            this.speciesCardinalityMap.put(species, cardinality);
        }
    }

    private String createCloneSpecies(PrintWriter out, String reactionId, Species species, String suffix, String shape) {
        String clonedSpeciesNodeId = reactionId + "_" + species.getId() + "_" + suffix;
        out.println("    " + clonedSpeciesNodeId + " [label=\"" + this.getDisplayName(species) + "\", shape=" + shape + ";");
        return clonedSpeciesNodeId;
    }

    private String createEmptySetNode(PrintWriter out, String reactionId) {
        String emptySetNodeId = reactionId + "_empty";
        out.println("    " + emptySetNodeId + " [shape=plaintext, label=\"\u00d8\", fontsize=15,fontcolor=blue];");
        return emptySetNodeId;
    }

    private String createIntermediateReactionNode(PrintWriter out, Reaction reaction, String suffix) {
        String intermediateReactionNodeId = reaction.getId() + "_intermediate_" + suffix;
        out.println("      " + intermediateReactionNodeId + " [label=\"\", shape=point,width=0.001,height=0.001];");
        if (suffix.equals("r")) {
            out.println("      \"" + intermediateReactionNodeId + "\" -> \"" + reaction.getId() + "\"[arrowhead=none];\n");
        } else if (suffix.equals("p")) {
            out.println("      \"" + reaction.getId() + "\" -> \"" + intermediateReactionNodeId + "\"[arrowhead=none];\n");
        } else {
            logger.info((Object)"Bad suffix format, available: \"r\" or \"p\"");
        }
        return intermediateReactionNodeId;
    }

    public void dotExport(SBMLDocument sbmlDocument, PrintWriter out) throws SBMLException {
        String shape;
        try {
            this.sbmlModel = sbmlDocument.getModel();
        }
        catch (Exception e) {
            throw new SBMLException("SBML2Dot: Input file is not a regular SBML file.");
        }
        String modelName = this.sbmlModel.getName();
        ListOf listOfSpecies = this.sbmlModel.getListOfSpecies();
        ListOf reactions = this.sbmlModel.getListOfReactions();
        if (this.cloning) {
            for (Reaction reaction : reactions) {
                this.addCardinality((ListOf<? extends SimpleSpeciesReference>)reaction.getListOfReactants());
                this.addCardinality((ListOf<? extends SimpleSpeciesReference>)reaction.getListOfProducts());
                this.addCardinality((ListOf<? extends SimpleSpeciesReference>)reaction.getListOfModifiers());
            }
        }
        if (modelName == null || modelName.trim().length() == 0) {
            modelName = this.sbmlModel.getId();
        }
        out.println("// " + modelName + "\n");
        SBML2Dot.println("// " + modelName + "\n");
        out.println("digraph G {\n");
        out.println("  node [fontsize=10];\n");
        out.println("  graph [rank=same];\n");
        out.println("  graph [rankdir=LR];\n");
        if (listOfSpecies.size() == 0 || reactions.size() == 0) {
            out.println(" noSpecies[fontsize=14,label=\"There are no species or no reactions in this model so no graph can be automatically generated.\", shape=\"plaintext\"] }");
            out.close();
            return;
        }
        SBML2Dot.println("SBML2Dot : dotExport : nb Reactions = " + reactions.size());
        if (reactions.size() >= MAX_REACTION_ALLOWED) {
            out.println(" toMuchReaction[fontsize=14,label=\"There are too many species or reactions in this model so no graph are automatically generated.\", shape=\"plaintext\"] }");
            out.close();
            return;
        }
        out.println("  // Species\n");
        for (Species species : listOfSpecies) {
            if (this.speciesCardinalityMap.get(species) == null) {
                this.speciesCardinalityMap.put(species, 0);
            }
            out.println(this.printSpeciesComment(species));
            if (species.getId().equalsIgnoreCase("emptyset") || this.speciesCardinalityMap.get(species) > MAX_EDGE_ALLOWED) {
                out.println("\n");
                continue;
            }
            String displayName = species.getName();
            if (displayName == null || displayName.trim().length() == 0) {
                displayName = species.getId();
            } else if (displayName.equalsIgnoreCase("emptyset") || displayName.equalsIgnoreCase("empty set")) {
                out.println("\n");
                continue;
            }
            shape = converter.getOutputFromClass((SBase)species, "unspecified entity");
            if (species.getSBOTerm() == 291) {
                out.println("    \"" + species.getId() + "\" [ shape= " + shape + "];\n");
                continue;
            }
            out.println("    \"" + species.getId() + "\" [label=\"" + displayName + "\", shape= " + shape + "];\n");
        }
        for (Reaction reaction : reactions) {
            String speciesShape;
            String speciesNodeId;
            Species species;
            String emptySetNodeId;
            String reactionId = reaction.getId();
            shape = converter.getOutputFromClass((SBase)reaction, "process");
            out.println("    " + reactionId + " [label=\"\", shape=" + shape + ", fixedsize=true, width=0.2, height=0.2];\n");
            ListOf products = reaction.getListOfProducts();
            ListOf reactants = reaction.getListOfReactants();
            ListOf modifiers = reaction.getListOfModifiers();
            if (reactants.size() == 0) {
                emptySetNodeId = this.createEmptySetNode(out, reactionId);
                out.println("      \"" + emptySetNodeId + "\" -> \"" + reactionId + "\" [arrowhead=none];\n");
            }
            if (products.size() == 0) {
                emptySetNodeId = this.createEmptySetNode(out, reactionId);
                out.println("      \"" + reactionId + "\" -> \"" + emptySetNodeId + "\";\n");
            }
            String reactionNodeId = reactionId;
            if (reactants.size() >= 1) {
                reactionNodeId = this.createIntermediateReactionNode(out, reaction, "r");
            }
            for (SpeciesReference reactant : reactants) {
                species = reactant.getSpeciesInstance();
                speciesNodeId = species.getId();
                speciesShape = converter.getOutputFromClass((SBase)species, "unspecified entity");
                if (species.getId().equalsIgnoreCase("emptyset")) {
                    speciesNodeId = this.createEmptySetNode(out, reactionId);
                } else if (this.speciesCardinalityMap.get(species) > MAX_EDGE_ALLOWED) {
                    speciesNodeId = this.createCloneSpecies(out, reactionId, species, "r", speciesShape);
                }
                if (reaction.isReversible()) {
                    out.println("      \"" + speciesNodeId + "\" -> \"" + reactionNodeId + "\"[arrowhead=none, arrowtail=normal,arrowsize=1.0];\n");
                    continue;
                }
                out.println("      \"" + speciesNodeId + "\" -> \"" + reactionNodeId + "\"[arrowhead=none];\n");
            }
            reactionNodeId = reactionId;
            if (products.size() >= 1) {
                reactionNodeId = this.createIntermediateReactionNode(out, reaction, "p");
            }
            for (SpeciesReference product : products) {
                species = product.getSpeciesInstance();
                speciesNodeId = species.getId();
                speciesShape = converter.getOutputFromClass((SBase)species, "unspecified entity");
                if (speciesShape == null) {
                    speciesShape = "ellipse";
                }
                if (speciesShape.equalsIgnoreCase("emptyset")) {
                    speciesNodeId = this.createEmptySetNode(out, reactionId);
                } else if (this.speciesCardinalityMap.get(species) > MAX_EDGE_ALLOWED) {
                    speciesNodeId = this.createCloneSpecies(out, reactionId, species, "p", speciesShape);
                }
                out.println("      \"" + reactionNodeId + "\" -> \"" + speciesNodeId + "\";\n");
            }
            reactionNodeId = reactionId;
            for (ModifierSpeciesReference modifier : modifiers) {
                species = modifier.getSpeciesInstance();
                speciesNodeId = species.getId();
                String arrowHead = converter.getOutputFromClass((SBase)modifier, "modulation");
                if (this.speciesCardinalityMap.get(species) > MAX_EDGE_ALLOWED) {
                    String speciesShape2 = converter.getOutputFromClass((SBase)species, "unspecified entity");
                    speciesNodeId = this.createCloneSpecies(out, reactionId, species, "m", speciesShape2);
                }
                out.println("      \"" + speciesNodeId + "\" -> \"" + reactionNodeId + "\"[arrowhead=" + arrowHead + "];\n");
            }
        }
        out.println("\n}\n");
        out.close();
        SBML2Dot.println("SBML2Dot : dotExport : Export done");
    }

    private String getDisplayName(Species species) {
        String displayName = species.getName();
        if (displayName == null || displayName.trim().length() == 0) {
            displayName = species.getId();
        }
        return displayName;
    }

    public SBMLDocument getSBMLDocument() {
        SBMLDocument document = null;
        SBMLReader reader = new SBMLReader();
        try {
            document = reader.readSBML(this.sbmlFileName);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
        long errors = 0L;
        if (errors != 0L) {
            SBML2Dot.println("SBML2Dot : getSBMLDocument : checkConsistency : model not valid:\n--" + errors + " error(s)");
            document = null;
        } else {
            SBML2Dot.println("SBML2Dot : getSBMLDocument : SBML File = " + this.sbmlFileName);
            SBML2Dot.println("SBML2Dot : getSBMLDocument : SBML Level " + document.getLevel() + " Version " + document.getVersion() + " to XPP\n");
            Model sbmlModel = document.getModel();
            SBML2Dot.println("SBML2Dot : getSBMLDocument : Model: " + sbmlModel.getId() + ", " + sbmlModel.getName() + "\n");
        }
        return document;
    }

    private boolean hasRule(String id) {
        for (Rule rule : this.sbmlModel.getListOfRules()) {
            ExplicitRule explicitRule;
            if (!(rule instanceof ExplicitRule) || !id.equals((explicitRule = (ExplicitRule)rule).getVariable())) continue;
            return true;
        }
        return false;
    }

    MiriamAnnotation parseMiriamAnnotation(String annotation) {
        String uri = null;
        String id = null;
        int indexOfDash = annotation.indexOf("#");
        int indexOfColon = annotation.lastIndexOf(":");
        if (indexOfDash != -1) {
            String[] annotationParts = annotation.split("#");
            uri = annotationParts[0];
            id = annotationParts[1];
        } else if (indexOfColon != -1) {
            uri = annotation.substring(0, indexOfColon);
            try {
                id = URLDecoder.decode(annotation.substring(indexOfColon + 1), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        if (uri != null && id != null) {
            String officialURN = ConstraintFileReader.officialURIs.get(uri);
            if (officialURN == null) {
                officialURN = uri;
            }
            return new MiriamAnnotation(id, officialURN);
        }
        return null;
    }

    static void println(String msg) {
        logger.info((Object)msg);
    }

    static void println(boolean msg) {
        logger.info((Object)msg);
    }

    static void println(int msg) {
        logger.info((Object)msg);
    }

    static void println(double msg) {
        logger.info((Object)msg);
    }

    private String printSpeciesComment(Species species) {
        StringBuilder commentStr = new StringBuilder();
        String id = species.getId();
        String name = species.getName();
        if (name == null || name.trim().length() == 0) {
            name = id;
        }
        commentStr.append("    // Species: ");
        commentStr.append("  id = " + id);
        commentStr.append(", name = " + name);
        if (species.isConstant()) {
            commentStr.append(", constant");
        } else if (species.isBoundaryCondition()) {
            commentStr.append(", involved in a rule ");
        } else if (!species.isBoundaryCondition()) {
            if (this.hasRule(id)) {
                commentStr.append(", involved in a rule ");
            } else {
                commentStr.append(", affected by kineticLaw");
            }
        }
        if (this.speciesCardinalityMap.get(species) != null && this.speciesCardinalityMap.get(species) > MAX_EDGE_ALLOWED) {
            commentStr.append(", will be cloned in the graph.");
        }
        return commentStr.toString();
    }

    public static void main(String[] args) {
        BasicConfigurator.configure();
        if (args.length < 1 || args.length > 2) {
            SBML2Dot.println("  usage: java org.sbfc.converter.dot.sbml2dot <SBML filename> [<image format>]");
            SBML2Dot.println("The filename has to be an absolute path.");
            return;
        }
        String fileName = args[0];
        SBML2Dot sbml2dot = new SBML2Dot(fileName);
        Context.loadProperties();
        sbml2dot.cloning = Context.getPropertyAsBoolean("cloning");
        sbml2dot.fileNameSuffix = Context.getProperty("suffix");
        GraphViz.setDotPath("/usr/local/bin/wrongdot");
        SBMLDocument sbmlDocument = sbml2dot.getSBMLDocument();
        if (sbmlDocument == null) {
            logger.debug((Object)"sbmlDocument == null");
            System.exit(1);
        }
        StringWriter stringWriter = new StringWriter();
        sbml2dot.dotExport(sbmlDocument, new PrintWriter(stringWriter));
        GraphViz graphViz = new GraphViz();
        String dotFileStr = stringWriter.toString();
        logger.debug((Object)dotFileStr);
        String dotFileName = fileName.replaceFirst(".xml", ".dot");
        try {
            FileWriter dotFile = new FileWriter(dotFileName);
            dotFile.write(dotFileStr);
            dotFile.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        graphViz.setImageFormat("dot");
        byte[] dotWithLayoutBytes = graphViz.getGraph(dotFileStr);
        if (dotWithLayoutBytes != null) {
            String dotWithLayout = new String(dotWithLayoutBytes);
            System.out.println("SBML2Dot : conversion with layout done : " + Calendar.getInstance().getTimeInMillis());
            String exports = "svg png";
            if (args.length > 1) {
                exports = args[1];
            }
            if (exports != null && exports.trim().length() > 0) {
                String[] exportArr = exports.split(" ");
                int lastIndexDot = fileName.lastIndexOf(".");
                String exportFileSuffix = fileName.substring(0, lastIndexDot);
                System.out.println("SBML2Dot : FILE name suffix = " + exportFileSuffix);
                logger.debug((Object)("Dot export file name suffix = " + exportFileSuffix));
                for (String export : exportArr) {
                    String imgFileName = exportFileSuffix + "." + export.trim();
                    System.out.println("image file name: " + imgFileName);
                    graphViz.setImageFormat(export);
                    byte[] imgBytes = graphViz.getGraph(dotWithLayout, "-n2");
                    graphViz.writeGraphToFile(imgBytes, imgFileName);
                    System.out.println("SBML2Dot : conversion without layout done : " + Calendar.getInstance().getTimeInMillis());
                }
            }
        }
    }

    @Override
    public GeneralModel convert(GeneralModel model) throws ConversionException, ReadModelException {
        if (!(model instanceof SBMLModel)) {
            throw new ReadModelException("SBML2Dot: Input file is not a regular SBML file.");
        }
        this.inputModel = model;
        SBMLDocument sbmlDocument = ((SBMLModel)model).getSBMLDocument();
        StringWriter dotStringWriter = new StringWriter();
        try {
            this.dotExport(sbmlDocument, new PrintWriter(dotStringWriter));
        }
        catch (SBMLException e) {
            throw new ConversionException(e.getMessage());
        }
        String dotFileStr = dotStringWriter.toString();
        try {
            File tmpDotFile = File.createTempFile("sbml2dot_", "dot");
            FileWriter dotFile = new FileWriter(tmpDotFile);
            dotFile.write(dotFileStr);
            dotFile.close();
        }
        catch (Exception e) {
            throw new ConversionException(e);
        }
        boolean dotAvailable = GraphViz.isDotAvailable();
        String dotWithLayout = dotFileStr;
        if (dotAvailable) {
            GraphViz graphViz = new GraphViz();
            graphViz.setImageFormat("dot");
            byte[] dotWithLayoutBytes = graphViz.getGraph(dotFileStr);
            dotWithLayout = new String(dotWithLayoutBytes);
            System.out.println("SBML2Dot : convert : dot with layout = \n" + dotWithLayout);
            String exports = (String)this.options.get("export");
            if (exports != null && exports.trim().length() > 0) {
                String[] exportArr = exports.split(" ");
                String fileName = ((SBMLModel)model).getModelFileName();
                if (fileName == null) {
                    logger.debug((Object)"No fileName available to save the export files!");
                    return new DotModel(dotWithLayout);
                }
                int lastIndexDot = fileName.lastIndexOf(".");
                String exportFileSuffix = fileName.substring(0, lastIndexDot);
                logger.debug((Object)("Dot export file name suffix = " + exportFileSuffix));
                for (String export : exportArr) {
                    String imgFileName = exportFileSuffix + "." + export.trim();
                    logger.info((Object)("image file name: " + imgFileName));
                    graphViz.setImageFormat(export);
                    byte[] imgBytes = graphViz.getGraph(dotWithLayout, "-n2");
                    graphViz.writeGraphToFile(imgBytes, imgFileName);
                }
            }
        } else {
            System.out.println("The Graphviz 'dot' program does not seems to be setup properly, saving the dot file without layout information!");
            dotWithLayout = "// The Graphviz 'dot' program does not seems to be setup properly, this dot file does not contain layout information\n// If you want to have layout and being able to export the graph as png or other, you need to install Graphviz from http://www.graphviz.org/.\n// If 'dot' is not installed on the default location ('/usr/bin/dot'), you can specified the path with the java option '-Dsbml2dot.dot.path=/usr/local/bin/dot'\n\n" + dotWithLayout;
        }
        return new DotModel(dotWithLayout);
    }

    @Override
    public String getResultExtension() {
        return ".dot";
    }

    @Override
    public String getName() {
        return "SBML2Dot";
    }

    @Override
    public String getDescription() {
        return "It converts a model format from SBML to Dot";
    }

    @Override
    public String getHtmlDescription() {
        return "It converts a model format from SBML to Dot";
    }

    static {
        ConstraintFileReader.parseSBML2SBGNConfigFile(speciesAnnotationMap, new Hashtable<String, String>(), new Hashtable<String, String>(), new Hashtable<String, String>(), "classSBGN");
    }
}

