/*
 * Decompiled with CFR 0.152.
 */
package org.sbfc.converter.sbml2biopax;

import java.util.Set;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXFactory;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level2.ControlType;
import org.biopax.paxtools.model.level2.Level2Element;
import org.biopax.paxtools.model.level2.SpontaneousType;
import org.biopax.paxtools.model.level2.XReferrable;
import org.biopax.paxtools.model.level2.bioSource;
import org.biopax.paxtools.model.level2.complex;
import org.biopax.paxtools.model.level2.control;
import org.biopax.paxtools.model.level2.conversion;
import org.biopax.paxtools.model.level2.dataSource;
import org.biopax.paxtools.model.level2.openControlledVocabulary;
import org.biopax.paxtools.model.level2.pathway;
import org.biopax.paxtools.model.level2.pathwayComponent;
import org.biopax.paxtools.model.level2.physicalEntity;
import org.biopax.paxtools.model.level2.physicalEntityParticipant;
import org.biopax.paxtools.model.level2.process;
import org.biopax.paxtools.model.level2.xref;
import org.biopax.paxtools.model.level3.ConversionDirectionType;
import org.sbfc.converter.sbml2biopax.SBML2BioPAX;

public class SBML2BioPAX_l2
extends SBML2BioPAX {
    public SBML2BioPAX_l2() {
        this.biopaxLevel = 2;
        this.PATHWAY_CLASS_NAME = "pathway";
        this.BIO_SOURCE = "bioSource";
        this.CONTROL = "control";
        this.BIOCHEMICAL_REACTION = "biochemicalReaction";
        this.COMPLEX_DIS_ASSEMBLY = "complexDisAssembly";
        this.COMPLEX_ASSEMBLY = "complexAssembly";
        this.TRANSPORT = "transport";
        this.PUBLICATION_XREF_CLASS_NAME = "publicationXref";
        this.UNIFICATION_XREF_CLASS_NAME = "unificationXref";
        this.PROVENANCE_CLASS_NAME = "dataSource";
        this.CELLULAR_LOCATION_VOCABULARY = "openControlledVocabulary";
        this.PHYSICAL_ENTITY_PARTICIPANT = "physicalEntityParticipant";
        this.INTERACTION = "interaction";
        this.CATALYSIS = "catalysis";
    }

    @Override
    protected void addComment(BioPAXElement biopaxElement, String commentString) {
        if (biopaxElement instanceof Level2Element) {
            ((Level2Element)biopaxElement).addCOMMENT(commentString);
        }
    }

    @Override
    protected void setXrefId(BioPAXElement xref2, String annotationIdentifier) {
        if (xref2 instanceof xref) {
            ((xref)xref2).setID(annotationIdentifier);
        }
    }

    @Override
    protected void setXrefDb(BioPAXElement xref2, String annotationDBname) {
        if (xref2 instanceof xref) {
            ((xref)xref2).setDB(annotationDBname);
        }
    }

    @Override
    protected void addPathwayComponent(BioPAXElement pathway2, BioPAXElement bioReaction) {
        if (pathway2 instanceof pathway && bioReaction instanceof process) {
            ((pathway)pathway2).addPATHWAY_COMPONENTS((pathwayComponent)((process)bioReaction));
        }
    }

    @Override
    protected void setOrganismToPathway(BioPAXElement pathway2, BioPAXElement biosource) {
        if (pathway2 instanceof pathway && biosource instanceof bioSource) {
            ((pathway)pathway2).setORGANISM((bioSource)biosource);
        }
    }

    @Override
    protected void addXref(BioPAXElement biopaxElement, BioPAXElement xref2) {
        if (biopaxElement instanceof XReferrable && xref2 instanceof xref) {
            ((XReferrable)biopaxElement).addXREF((xref)xref2);
        }
    }

    @Override
    protected void addDataSource(BioPAXElement pathway2, BioPAXElement datasource) {
        if (pathway2 instanceof pathway && datasource instanceof dataSource) {
            ((pathway)pathway2).addDATA_SOURCE((dataSource)datasource);
        }
    }

    @Override
    protected void setDisplayName(BioPAXElement named, String displayName) {
    }

    @Override
    protected void addName(BioPAXElement named, String name) {
        if (named instanceof dataSource) {
            ((dataSource)named).addNAME(name);
        }
    }

    @Override
    protected void addTerm(BioPAXElement vocab, String term) {
        if (vocab instanceof openControlledVocabulary) {
            ((openControlledVocabulary)vocab).addTERM(term);
        }
    }

    @Override
    protected boolean isComplex(Model bioPaxModel, String species) {
        return bioPaxModel.getByID(species) instanceof complex;
    }

    @Override
    protected void setConversionDirection(BioPAXElement bioReaction, ConversionDirectionType direction) {
        if (bioReaction instanceof conversion) {
            if (direction.equals((Object)ConversionDirectionType.LEFT_TO_RIGHT)) {
                ((conversion)bioReaction).setSPONTANEOUS(SpontaneousType.L_R);
            } else if (direction.equals((Object)ConversionDirectionType.RIGHT_TO_LEFT)) {
                ((conversion)bioReaction).setSPONTANEOUS(SpontaneousType.R_L);
            }
        }
    }

    @Override
    protected void setSpontaneous(BioPAXElement bioReaction, boolean spontaneous) {
    }

    @Override
    protected BioPAXElement setStoichiometry(BioPAXElement bioReaction, BioPAXElement physicalEntityParticipant2, double stoichiometry, String stochiometryId, BioPAXFactory elementFactory) {
        if (bioReaction instanceof conversion && physicalEntityParticipant2 instanceof physicalEntityParticipant) {
            ((physicalEntityParticipant)physicalEntityParticipant2).setSTOICHIOMETRIC_COEFFICIENT(stoichiometry);
        } else {
            SBML2BioPAX_l2.println("setStoichiometry problem !! " + physicalEntityParticipant2 + "; " + bioReaction);
        }
        return null;
    }

    @Override
    protected void addMemberPhysicalEntity(BioPAXElement physicalEntityParticipant2, BioPAXElement physicalEntity2) {
        if (physicalEntityParticipant2 instanceof physicalEntityParticipant && physicalEntity2 instanceof physicalEntity) {
            ((physicalEntityParticipant)physicalEntityParticipant2).setPHYSICAL_ENTITY((physicalEntity)physicalEntity2);
        } else {
            SBML2BioPAX_l2.println("addMemberPhysicalEntity problem !! " + physicalEntityParticipant2 + "; " + physicalEntity2);
        }
    }

    @Override
    protected void setCellularLocation(BioPAXElement physicalEntityParticipant2, BioPAXElement cellularLocation) {
        if (physicalEntityParticipant2 instanceof physicalEntityParticipant && cellularLocation instanceof openControlledVocabulary) {
            ((physicalEntityParticipant)physicalEntityParticipant2).setCELLULAR_LOCATION((openControlledVocabulary)cellularLocation);
        } else {
            SBML2BioPAX_l2.println("setCellularLocation problem !! " + physicalEntityParticipant2 + "; " + cellularLocation);
        }
    }

    @Override
    protected void addRight(BioPAXElement bioReaction, BioPAXElement physicalEntityParticipant2) {
        if (bioReaction instanceof conversion && physicalEntityParticipant2 instanceof physicalEntityParticipant) {
            ((conversion)bioReaction).addRIGHT((physicalEntityParticipant)physicalEntityParticipant2);
        }
    }

    @Override
    protected void addLeft(BioPAXElement bioReaction, BioPAXElement physicalEntityParticipant2) {
        if (bioReaction instanceof conversion && physicalEntityParticipant2 instanceof physicalEntityParticipant) {
            ((conversion)bioReaction).addLEFT((physicalEntityParticipant)physicalEntityParticipant2);
        }
    }

    @Override
    protected void addControl(Set<? extends BioPAXElement> setOfcontrol, BioPAXElement reacControl) {
        if (reacControl instanceof control) {
            setOfcontrol.add((BioPAXElement)((control)reacControl));
        }
    }

    @Override
    protected Set<? extends BioPAXElement> getListOfControl(BioPAXElement bioReaction) {
        if (bioReaction instanceof conversion) {
            return ((conversion)bioReaction).isCONTROLLEDOf();
        }
        SBML2BioPAX_l2.println("getListOfControl problem !! " + bioReaction);
        return null;
    }

    protected void setControlType(BioPAXElement reacControl, String controlType) {
        if (reacControl instanceof control) {
            ControlType bioPaxcontrolType = controlType.equals(this.CONTROL) ? ControlType.INHIBITION : ControlType.ACTIVATION;
            ((control)reacControl).setCONTROL_TYPE(bioPaxcontrolType);
        }
    }

    @Override
    protected void addControlled(BioPAXElement reacControl, BioPAXElement bioReaction) {
        if (reacControl instanceof control && bioReaction instanceof process) {
            ((control)reacControl).addCONTROLLED((process)bioReaction);
        }
    }

    @Override
    protected void addController(BioPAXElement reacControl, BioPAXElement physicalEntityParticipant2) {
        if (reacControl instanceof control && physicalEntityParticipant2 instanceof physicalEntity) {
            ((control)reacControl).addCONTROLLER((physicalEntityParticipant)physicalEntityParticipant2);
        }
    }

    @Override
    public String getName() {
        return "SBML2BioPAX_l2";
    }

    @Override
    public String getDescription() {
        return "It converts a model format from SBML to BioPAX L2";
    }

    @Override
    public String getHtmlDescription() {
        return "It converts a model format from SBML to BioPAX L2";
    }
}

