/*
 * Decompiled with CFR 0.152.
 */
package org.sbfc.converter.sbml2apm;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.sbml.jsbml.ASTNode;
import org.sbml.jsbml.SBMLException;
import org.sbml.jsbml.util.compilers.ASTNodeCompiler;
import org.sbml.jsbml.util.compilers.ASTNodeValue;
import org.sbml.jsbml.util.compilers.FormulaCompiler;

public class APMFormulaCompilerNoPiecewise
extends FormulaCompiler {
    private LinkedHashMap<String, String> piecewiseMap = new LinkedHashMap();
    private String andReplacement = " & ";
    private String orReplacement = " | ";

    public ASTNodeValue piecewise(List<ASTNode> nodes) throws SBMLException {
        int i;
        int indexLambda = nodes.indexOf("lambda");
        String piecewiseStr = "";
        String piecewiseEquation = "";
        int nbChildren = nodes.size();
        int nbIfThen = nbChildren / 2;
        boolean otherwise = nbChildren % 2 == 1;
        int id = this.piecewiseMap.size() + 1;
        String piecewiseId = "piecew" + id;
        piecewiseStr = piecewiseStr + "\t!Piecewise Function for this variable:" + piecewiseId + "=";
        for (i = 0; i < nbIfThen; ++i) {
            int index = i * 2;
            if (i > 0) {
                piecewiseStr = piecewiseStr + "(";
            }
            piecewiseStr = piecewiseStr + " if (" + nodes.get(index + 1).compile((ASTNodeCompiler)this).toString() + ") then (" + nodes.get(index).compile((ASTNodeCompiler)this).toString() + ") else ";
        }
        if (otherwise) {
            piecewiseStr = piecewiseStr + "" + nodes.get(nbChildren - 1).compile((ASTNodeCompiler)this).toString() + "";
            piecewiseEquation = piecewiseEquation + "" + nodes.get(nbChildren - 1).compile((ASTNodeCompiler)this).toString() + "";
        }
        if (nbIfThen > 1) {
            for (i = 1; i < nbIfThen; ++i) {
                piecewiseStr = piecewiseStr + ")";
            }
        }
        if (indexLambda != -1) {
            piecewiseStr = piecewiseStr.replaceAll("lambda", "");
        }
        if (this.andReplacement != null) {
            piecewiseStr = piecewiseStr.replaceAll(" and ", this.andReplacement);
        }
        if (this.orReplacement != null) {
            piecewiseStr = piecewiseStr.replaceAll(" or ", this.orReplacement);
        }
        this.piecewiseMap.put(piecewiseId, piecewiseStr);
        return new ASTNodeValue("" + piecewiseEquation + " ", (ASTNodeCompiler)this);
    }

    public HashMap<String, String> getPiecewiseMap() {
        return this.piecewiseMap;
    }

    public String getAndReplacement() {
        return this.andReplacement;
    }

    public void setAndReplacement(String andReplacement) {
        this.andReplacement = andReplacement;
    }

    public String getOrReplacement() {
        return this.orReplacement;
    }

    public void setOrReplacement(String orReplacement) {
        this.orReplacement = orReplacement;
    }
}

