/*
 * Decompiled with CFR 0.152.
 */
package org.sbfc.converter.models;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import org.sbfc.converter.exceptions.ReadModelException;
import org.sbfc.converter.exceptions.WriteModelException;
import org.sbfc.converter.models.GeneralModel;

public abstract class StringModel
implements GeneralModel {
    private String model;
    private String fileName;

    @Override
    public void modelToFile(String fileName) throws WriteModelException {
        try {
            FileOutputStream file = new FileOutputStream(fileName);
            PrintStream printFile = new PrintStream(file);
            printFile.println(this.model);
            file.close();
        }
        catch (FileNotFoundException e) {
            throw new WriteModelException(e);
        }
        catch (IOException e) {
            throw new WriteModelException(e);
        }
    }

    @Override
    public String modelToString() throws WriteModelException {
        return this.model;
    }

    public String getModel() {
        return this.model;
    }

    public String getModelFileName() {
        return this.fileName;
    }

    @Override
    public void setModelFromFile(String fileName) throws ReadModelException {
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(fileName));
            String result = "";
            while ((line = in.readLine()) != null) {
                result = result + line + "\n";
            }
            in.close();
            this.model = result;
            this.fileName = fileName;
        }
        catch (IOException e) {
            throw new ReadModelException(e);
        }
    }

    @Override
    public void setModelFromString(String modelString) throws ReadModelException {
        this.model = modelString;
        this.fileName = null;
    }
}

