/*
 * Decompiled with CFR 0.152.
 */
package org.sbfc.converter.models;

import java.io.File;
import javax.xml.bind.JAXBException;
import org.sbfc.converter.exceptions.ReadModelException;
import org.sbfc.converter.exceptions.WriteModelException;
import org.sbfc.converter.models.GeneralModel;
import org.sbfc.converter.models.SBMLModel;
import org.sbfc.converter.sbml2sbgnml.SBML2SBGNML;
import org.sbgn.SbgnUtil;
import org.sbgn.bindings.Sbgn;
import org.sbml.jsbml.SBMLDocument;

public class SBGNModel
implements GeneralModel {
    private Sbgn sbgnModel;
    private String fileName;

    public SBGNModel() {
    }

    public SBGNModel(Sbgn model) {
        this.sbgnModel = model;
    }

    @Override
    public void modelToFile(String fileName) throws WriteModelException {
        File f = new File(fileName);
        try {
            SbgnUtil.writeToFile(this.sbgnModel, f);
        }
        catch (JAXBException e) {
            throw new WriteModelException(e);
        }
        catch (Exception e) {
            throw new WriteModelException(e);
        }
    }

    @Override
    public String modelToString() throws WriteModelException {
        return null;
    }

    @Override
    public void setModelFromFile(String fileName) throws ReadModelException {
        this.sbgnModel = this.modelFromFile(fileName);
    }

    @Override
    public void setModelFromString(String modelString) throws ReadModelException {
        this.sbgnModel = this.modelFromString(modelString);
    }

    private Sbgn modelFromString(String modelString) throws ReadModelException {
        SBMLModel model = new SBMLModel();
        SBMLDocument sbmlDoc = model.modelFromString(modelString);
        SBML2SBGNML converter = new SBML2SBGNML();
        Sbgn sbgnModel = converter.convertSBGNML(sbmlDoc);
        return sbgnModel;
    }

    private Sbgn modelFromFile(String fileName2) throws ReadModelException {
        SBMLModel model = new SBMLModel();
        SBMLDocument sbmlDoc = model.modelFromFile(fileName2);
        SBML2SBGNML converter = new SBML2SBGNML();
        Sbgn sbgnModel = converter.convertSBGNML(sbmlDoc);
        return sbgnModel;
    }

    @Override
    public String[] getExtensions() {
        return new String[]{".xml", ".sbgn", ".sbgnml"};
    }

    @Override
    public boolean isCorrectType(File f) {
        return true;
    }

    @Override
    public String getURI() {
        return "application/sbgn";
    }
}

