/*
 * Decompiled with CFR 0.152.
 */
package org.sbfc.converter.models;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.biopax.paxtools.io.SimpleIOHandler;
import org.biopax.paxtools.model.Model;
import org.sbfc.converter.exceptions.ReadModelException;
import org.sbfc.converter.exceptions.WriteModelException;
import org.sbfc.converter.models.GeneralModel;

public class BioPAXModel
implements GeneralModel {
    private Model model;

    public BioPAXModel() {
    }

    public BioPAXModel(Model model) {
        this.model = model;
    }

    public Model getModel() {
        return this.model;
    }

    @Override
    public void setModelFromFile(String fileName) throws ReadModelException {
        this.model = this.modelFromFile(fileName);
    }

    @Override
    public void setModelFromString(String modelString) throws ReadModelException {
        this.model = this.modelFromString(modelString);
    }

    @Override
    public void modelToFile(String fileName) throws WriteModelException {
        SimpleIOHandler export = new SimpleIOHandler(this.getModel().getLevel());
        try {
            export.convertToOWL(this.model, (OutputStream)new FileOutputStream(fileName));
        }
        catch (FileNotFoundException e) {
            throw new WriteModelException(e);
        }
        catch (RuntimeException e) {
            throw new WriteModelException(e);
        }
    }

    public Model modelFromFile(String fileName) throws ReadModelException {
        SimpleIOHandler handler = new SimpleIOHandler();
        try {
            return handler.convertFromOWL((InputStream)new FileInputStream(new File(fileName)));
        }
        catch (FileNotFoundException e) {
            throw new ReadModelException(e);
        }
    }

    public Model modelFromString(String modelString) throws ReadModelException {
        SimpleIOHandler handler = new SimpleIOHandler();
        try {
            return handler.convertFromOWL((InputStream)new ByteArrayInputStream(modelString.getBytes("UTF-8")));
        }
        catch (UnsupportedEncodingException e) {
            throw new ReadModelException(e);
        }
    }

    @Override
    public String modelToString() {
        String resModel = null;
        SimpleIOHandler export = new SimpleIOHandler(this.getModel().getLevel());
        try {
            File tempFile = File.createTempFile("BioPaxConvert", "temp");
            FileOutputStream out = new FileOutputStream(tempFile);
            export.convertToOWL(this.model, (OutputStream)out);
            resModel = BioPAXModel.readFileAsString(tempFile.getName());
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return resModel;
    }

    private static String readFileAsString(String filePath) throws IOException {
        byte[] buffer = new byte[(int)new File(filePath).length()];
        FileInputStream f = new FileInputStream(filePath);
        f.read(buffer);
        return new String(buffer);
    }

    @Override
    public String[] getExtensions() {
        return new String[]{".owl"};
    }

    @Override
    public boolean isCorrectType(File f) {
        return true;
    }

    @Override
    public String getURI() {
        return "http://identifiers.org/combine.specifications/biopax";
    }
}

