/*
 * Decompiled with CFR 0.152.
 */
package org.sbfc.converter;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.ListDataListener;
import javax.swing.filechooser.FileFilter;
import org.sbfc.converter.Converter;
import org.sbfc.converter.GeneralConverter;
import org.sbfc.converter.gui.AboutDialog;
import org.sbfc.converter.gui.StatusPanel;

public class ConverterGUI
extends JFrame {
    JFileChooser inputFileChooser = new JFileChooser();
    JTextField inputFileTextField = new JTextField();
    JButton inputFileButton;
    JFileChooser outputFileChooser = new JFileChooser();
    JTextField outputFileTextField = new JTextField(40);
    JButton launchButton;
    public static final String APPLICATION_NAME = "Systems Biology Format Converter";
    public static final String APPLICATION_SHORTNAME = "SBFC";
    public static final String VERSION = "1.3.7";
    public static final String WEBSITE = "http://sbfc.sf.net/";
    private ConverterGUI application = this;
    private StatusPanel statusPanel;

    public ConverterGUI() {
        super(APPLICATION_NAME);
        this.init();
    }

    private void init() {
        this.setDefaultCloseOperation(3);
        Container jpanel = this.getContentPane();
        jpanel.setLayout(new GridBagLayout());
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        JMenu filesMenu = new JMenu("Files");
        menuBar.add(filesMenu);
        JMenuItem exitMenuItem = new JMenuItem(new AbstractAction("Exit"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConverterGUI.this.setVisible(false);
                System.exit(0);
            }
        });
        filesMenu.add(exitMenuItem);
        JMenuItem aboutMenuItem = new JMenuItem(new AbstractAction("About"){

            @Override
            public void actionPerformed(ActionEvent e) {
                new AboutDialog(ConverterGUI.this.application);
            }
        });
        menuBar.add(aboutMenuItem);
        this.inputFileChooser.setCurrentDirectory(new File(System.getProperty("user.home")));
        this.inputFileChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getName().toLowerCase().endsWith(".xml") || f.isDirectory();
            }

            @Override
            public String getDescription() {
                return "XML files";
            }
        });
        int rowNumber = 0;
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridx = 0;
        c.gridy = rowNumber++;
        c.ipadx = 10;
        c.ipady = 0;
        c.anchor = 17;
        jpanel.add((Component)new JLabel("Select input file"), c);
        c.gridx = 1;
        c.ipadx = 300;
        c.weightx = 0.5;
        c.fill = 2;
        jpanel.add((Component)this.inputFileTextField, c);
        AbstractAction inputAction = new AbstractAction("..."){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int r = ConverterGUI.this.inputFileChooser.showOpenDialog(new JFrame());
                if (r == 0) {
                    String name = ConverterGUI.this.inputFileChooser.getSelectedFile().getName();
                    ConverterGUI.this.inputFileTextField.setText(ConverterGUI.this.inputFileChooser.getSelectedFile().getAbsolutePath());
                }
            }
        };
        c.fill = 0;
        c.weightx = 0.0;
        c.gridx = 2;
        c.ipadx = 0;
        this.inputFileButton = new JButton(inputAction);
        this.inputFileButton.setToolTipText("Open a file chooser dialog to select the input file");
        jpanel.add((Component)this.inputFileButton, c);
        c.gridx = 0;
        c.gridy = rowNumber;
        c.ipadx = 10;
        c.ipady = 0;
        jpanel.add((Component)new JLabel("Select the converter to use"), c);
        final ArrayList<String> converterClassNames = new ArrayList<String>();
        final ArrayList<GeneralConverter> converterInstances = new ArrayList<GeneralConverter>();
        ArrayList<String> converterDisplayNames = new ArrayList<String>();
        for (String converterClass : Converter.converterFullNames) {
            String converterClassSimpleName = converterClass.substring(converterClass.lastIndexOf(".") + 1);
            if (converterClass.contains("example") || converterClass.contains("GPML")) continue;
            try {
                GeneralConverter instance = (GeneralConverter)Class.forName(converterClass).newInstance();
                converterInstances.add(instance);
                converterClassNames.add(converterClassSimpleName);
                this.addDisplayName(converterDisplayNames, converterClassSimpleName);
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (ClassNotFoundException e) {
            }
            catch (UnsatisfiedLinkError e) {
            }
            catch (Throwable e) {}
        }
        if (converterClassNames.contains("SBML2SBML")) {
            int sbml2sbmlIndex = converterClassNames.indexOf("SBML2SBML");
            converterClassNames.remove(sbml2sbmlIndex);
            GeneralConverter sbml2sbmlConverter = (GeneralConverter)converterInstances.remove(sbml2sbmlIndex);
            converterClassNames.add("SBML2SBML_L3V1");
            converterInstances.add(sbml2sbmlConverter);
            converterClassNames.add("SBML2SBML_L2V4");
            converterInstances.add(sbml2sbmlConverter);
            converterClassNames.add("SBML2SBML_L2V3");
            converterInstances.add(sbml2sbmlConverter);
            converterClassNames.add("SBML2SBML_L2V1");
            converterInstances.add(sbml2sbmlConverter);
            converterClassNames.add("SBML2SBML_L1V2");
            converterInstances.add(sbml2sbmlConverter);
        }
        c.gridx = 1;
        c.ipadx = 0;
        final JList<String> jList = new JList<String>();
        jList.setSelectionMode(0);
        jList.setModel(new ListModel<String>(){

            @Override
            public void removeListDataListener(ListDataListener l) {
            }

            @Override
            public int getSize() {
                return converterClassNames.size();
            }

            @Override
            public String getElementAt(int index) {
                return (String)converterClassNames.get(index);
            }

            @Override
            public void addListDataListener(ListDataListener l) {
            }
        });
        jpanel.add(jList, c);
        ++rowNumber;
        c.gridx = 0;
        c.gridy = rowNumber++;
        jpanel.add((Component)new JLabel("Select output file"), c);
        c.gridx = 1;
        c.ipadx = 300;
        c.weightx = 0.5;
        c.fill = 2;
        jpanel.add((Component)this.outputFileTextField, c);
        AbstractAction outputAction = new AbstractAction("..."){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int r = ConverterGUI.this.outputFileChooser.showOpenDialog(new JFrame());
                if (r == 0) {
                    String name = ConverterGUI.this.outputFileChooser.getSelectedFile().getName();
                    ConverterGUI.this.outputFileTextField.setText(ConverterGUI.this.outputFileChooser.getSelectedFile().getAbsolutePath());
                }
            }
        };
        c.fill = 0;
        c.gridx = 2;
        c.ipadx = 0;
        c.weightx = 0.0;
        JButton outputFileButton = new JButton(outputAction);
        outputFileButton.setToolTipText("Open a file chooser dialog to select the output file");
        jpanel.add((Component)outputFileButton, c);
        c.gridx = 0;
        c.gridy = rowNumber++;
        jpanel.add((Component)new JLabel("Open output file"), c);
        c.gridx = 1;
        final JCheckBox openOutputCheckBox = new JCheckBox();
        openOutputCheckBox.setSelected(true);
        openOutputCheckBox.setToolTipText("If this checkbox is selected, the content of the ouput file will be displayed in a new window if the conversion is successful.");
        jpanel.add((Component)openOutputCheckBox, c);
        c.gridx = 1;
        c.gridy = rowNumber++;
        c.insets = new Insets(10, 10, 10, 10);
        c.anchor = 10;
        AbstractAction launchAction = new AbstractAction("Convert"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String inputFileName = ConverterGUI.this.inputFileTextField.getText();
                if (inputFileName == null || inputFileName.trim().length() == 0 || !new File(inputFileName).exists()) {
                    JOptionPane.showMessageDialog(null, "Please, select an input file first.");
                    return;
                }
                System.out.println("Input file name = '" + inputFileName + "'");
                int converterIndex = jList.getSelectedIndex();
                if (converterIndex == -1) {
                    JOptionPane.showMessageDialog(null, "Please, select a converter.");
                    return;
                }
                String inputModelType = "SBMLModel";
                if (((String)converterClassNames.get(converterIndex)).startsWith("BioPAX")) {
                    inputModelType = "BioPAXModel";
                }
                GeneralConverter converter = (GeneralConverter)converterInstances.get(converterIndex);
                String outputFileName = Converter.convertFromFile(inputModelType, (String)converterClassNames.get(converterIndex), inputFileName, ConverterGUI.this.outputFileTextField.getText());
                if (outputFileName != null && openOutputCheckBox.isSelected()) {
                    System.out.println("\nOutput file: " + outputFileName);
                    ConverterGUI.this.displayFileinNewWindow(outputFileName);
                    ConverterGUI.this.statusPanel.setText("Conversion succesful and result saved on file : " + outputFileName);
                } else if (outputFileName != null) {
                    ConverterGUI.this.statusPanel.setText("Conversion succesfull and result saved on file : " + outputFileName);
                    JOptionPane.showMessageDialog(null, "Conversion succesful and result saved on file: \n" + outputFileName);
                } else {
                    int pos = inputFileName.lastIndexOf(".");
                    String errorFileName = inputFileName.substring(0, pos) + ".errorLog";
                    outputFileName = inputFileName.substring(0, pos) + converter.getResultExtension();
                    ConverterGUI.this.statusPanel.setText("Conversion FAILED!");
                    ConverterGUI.this.displayFileinNewWindow(outputFileName);
                    JOptionPane.showMessageDialog(null, "Conversion failed ! Check the sbfc-gui.log or \n" + errorFileName + " files for errors if the output file does not contain the error.");
                }
            }
        };
        this.launchButton = new JButton(launchAction);
        jpanel.add((Component)this.launchButton, c);
        c.gridx = 0;
        c.gridy = rowNumber;
        c.gridwidth = 3;
        c.ipadx = 10;
        c.anchor = 17;
        c.fill = 2;
        this.statusPanel = new StatusPanel();
        this.statusPanel.setText("Status bar");
        jpanel.add((Component)this.statusPanel, c);
    }

    static String readFile(String path, Charset encoding) throws IOException {
        byte[] encoded = Files.readAllBytes(Paths.get(path, new String[0]));
        return new String(encoded, encoding);
    }

    private void displayFileinNewWindow(String outputFileName) {
        if (outputFileName == null || !new File(outputFileName).exists()) {
            System.out.println("Output file '" + outputFileName + "' does not seem to exist !");
            return;
        }
        try {
            System.out.println("Trying to read '" + outputFileName + "'.");
            String outputFileContent = ConverterGUI.readFile(outputFileName, Charset.forName("UTF-8"));
            JFrame outputFileJFrame = new JFrame("Conversion result saved on file : " + outputFileName);
            JTextArea outputFileTA = new JTextArea(outputFileContent);
            outputFileTA.setEditable(false);
            outputFileJFrame.add(new JScrollPane(outputFileTA));
            outputFileJFrame.setMinimumSize(new Dimension(800, 600));
            outputFileJFrame.setVisible(true);
        }
        catch (IOException e) {
            System.out.println("There was a problem opening the ouput file: '" + e.getMessage() + "'");
        }
    }

    private void addDisplayName(ArrayList<String> converterDisplayNames, String converterClassSimpleName) {
    }

    public static void main(String[] args) {
        try {
            System.setOut(new PrintStream(new File("sbfc-gui.log")));
        }
        catch (FileNotFoundException e) {
            // empty catch block
        }
        ConverterGUI gui = new ConverterGUI();
        gui.setMinimumSize(new Dimension(600, 300));
        gui.setResizable(true);
        gui.pack();
        gui.setVisible(true);
    }

    public static ConverterGUI getConverterGuiInstance() {
        final ConverterGUI gui = new ConverterGUI();
        gui.setDefaultCloseOperation(1);
        JPanel panel = (JPanel)((JLayeredPane)((JRootPane)gui.getComponent(0)).getComponent(1)).getComponent(0);
        JMenu filesMenu = (JMenu)((JMenuBar)panel.getComponent(0)).getComponent(0);
        filesMenu.remove(0);
        JMenuItem closeMenuItem = new JMenuItem(new AbstractAction("Close"){

            @Override
            public void actionPerformed(ActionEvent e) {
                gui.setVisible(false);
            }
        });
        filesMenu.add(closeMenuItem);
        gui.setMinimumSize(new Dimension(600, 300));
        gui.setResizable(false);
        gui.pack();
        return gui;
    }
}

