/*
 * Decompiled with CFR 0.152.
 */
package org.sbfc.converter;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.sbfc.converter.ConverterData;
import org.sbfc.converter.GeneralConverter;
import org.sbfc.converter.models.GeneralModel;
import org.util.classlist.ConverterSearcher;

public class Converter {
    static final Logger logger = Logger.getLogger(Converter.class);
    public static ArrayList<String> converterFullNames = ConverterSearcher.getConverterFullNameList();
    public static String converterPackage = ConverterSearcher.getConverterSuperPackage();

    private static ConverterData getPackageClassPath(String converterType, Map<String, String> converterOptions) {
        boolean found = false;
        String levelAndVersion = null;
        if (converterType.contains("SBML2SBML") && converterType.length() > 10) {
            levelAndVersion = converterType.substring(10);
            converterType = "SBML2SBML";
        }
        for (int i = 0; i < converterFullNames.size() && !found; ++i) {
            String converterFullName = converterFullNames.get(i);
            if (!converterFullName.contains(converterType)) continue;
            converterPackage = converterFullName.substring(0, converterFullName.lastIndexOf("."));
            if (converterType.contains("Dot")) {
                converterOptions.put("export", "png svg");
            } else if (levelAndVersion != null && levelAndVersion.trim().length() > 0) {
                System.out.println("Level and version = " + levelAndVersion);
                if (levelAndVersion.equals("L3V1")) {
                    converterOptions.put("sbml.target.level", "3");
                    converterOptions.put("sbml.target.version", "1");
                } else if (levelAndVersion.equals("L2V4")) {
                    converterOptions.put("sbml.target.level", "2");
                    converterOptions.put("sbml.target.version", "4");
                } else if (levelAndVersion.equals("L2V1")) {
                    converterOptions.put("sbml.target.level", "2");
                    converterOptions.put("sbml.target.version", "1");
                } else if (levelAndVersion.equals("L1V2")) {
                    converterOptions.put("sbml.target.level", "1");
                    converterOptions.put("sbml.target.version", "2");
                }
            }
            found = true;
        }
        logger.debug((Object)("getPackageClassPath - converter type: " + converterType));
        logger.debug((Object)("getPackageClassPath - convert package: " + converterPackage));
        return new ConverterData(converterType, converterPackage);
    }

    public static String convertFromFile(String inputModelType, String converterType, String inputFileName) {
        return Converter.convertFromFile(inputModelType, converterType, inputFileName, null);
    }

    public static String convertFromFile(String inputModelType, String converterType, String inputFileName, String outputFileName) {
        FileOutputStream fconv;
        int pos;
        HashMap<String, String> converterOptions = new HashMap<String, String>();
        converterOptions.put("save.result", "yes");
        ConverterData data = Converter.getPackageClassPath(converterType, converterOptions);
        converterType = data.getConverterType();
        converterPackage = data.getConverterPackage();
        GeneralConverter converter = null;
        try {
            converter = (GeneralConverter)Class.forName(converterPackage + "." + converterType).newInstance();
            converter.setOptions(converterOptions);
        }
        catch (Exception e1) {
            pos = inputFileName.lastIndexOf(".");
            try {
                fconv = new FileOutputStream(inputFileName.substring(0, pos) + ".errorLog");
                PrintStream convprint = new PrintStream(fconv);
                convprint.println("######################################################\nThe converter " + converterType + " you asked for can not be found...\n");
                e1.printStackTrace(convprint);
                logger.info((Object)("The converter " + converterType + " you asked for can not be found...\n"));
                e1.printStackTrace();
                fconv.close();
                System.exit(1);
            }
            catch (FileNotFoundException e2) {
                e2.printStackTrace();
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        }
        try {
            String modelPackage = "org.sbfc.converter.models";
            GeneralModel inputModel = (GeneralModel)Class.forName(modelPackage + "." + inputModelType).newInstance();
            inputModel.setModelFromFile(inputFileName);
            GeneralModel result = converter.convert(inputModel);
            if (((String)converterOptions.get("save.result")).equals("yes")) {
                if (outputFileName == null || outputFileName.trim().length() == 0) {
                    int pos2 = inputFileName.lastIndexOf(".");
                    outputFileName = inputFileName.substring(0, pos2) + converter.getResultExtension();
                }
                result.modelToFile(outputFileName);
                return outputFileName;
            }
        }
        catch (Exception e) {
            pos = inputFileName.lastIndexOf(".");
            try {
                String extension = ".err";
                if (converter != null) {
                    extension = converter.getResultExtension();
                }
                fconv = new FileOutputStream(inputFileName.substring(0, pos) + extension);
                PrintStream convprint = new PrintStream(fconv);
                convprint.println("######################################################\n#Something went wrong during the conversion !\n#Try to validate your input file before converting it\n\n");
                e.printStackTrace(convprint);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"#Something went wrong during the conversion !\n");
                    e.printStackTrace();
                }
                fconv.close();
            }
            catch (FileNotFoundException e1) {
                e1.printStackTrace();
            }
            catch (IOException e1) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static String convertFromString(String inputModelType, String converterType, String modelInputString) {
        String retModel = null;
        try {
            HashMap<String, String> converterOptions = new HashMap<String, String>();
            converterOptions.put("save.result", "yes");
            ConverterData data = Converter.getPackageClassPath(converterType, converterOptions);
            converterType = data.getConverterType();
            converterPackage = data.getConverterPackage();
            GeneralConverter converter = (GeneralConverter)Class.forName(converterPackage + "." + converterType).newInstance();
            String modelPackage = "org.sbfc.converter.models";
            GeneralModel inputModel = (GeneralModel)Class.forName(modelPackage + "." + inputModelType).newInstance();
            inputModel.setModelFromString(modelInputString);
            GeneralModel result = converter.convert(inputModel);
            retModel = result.modelToString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retModel;
    }

    public static void main(String[] args) {
        if (args.length < 3) {
            System.out.println("Wrong number of arguments :\nUsage: Converter.java [InputModelClass] [ConverterClass] [ModelFile]");
        } else {
            Converter.convertFromFile(args[0], args[1], args[2]);
            System.exit(0);
        }
    }
}

