/*
 * Decompiled with CFR 0.152.
 */
package org.processing;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.sbgn.SbgnUtil;
import org.sbgn.bindings.Arc;
import org.sbgn.bindings.Bbox;
import org.sbgn.bindings.Glyph;
import org.sbgn.bindings.Label;
import org.sbgn.bindings.Port;
import org.sbgn.bindings.SBGNBase;
import org.sbgn.bindings.Sbgn;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SBGNML2Processing {
    private static final HashMap<String, String> mapping = SBGNML2Processing.buildMappingForProcessing();
    private String sbgnmlFileName = "";
    private String processingFileName = "graphData.pde";
    private Sbgn sbgnObj = new Sbgn();
    private static ArrayList<String> graphData = new ArrayList();
    private static int WINDOW_WIDTH = 0;
    private static int WINDOW_HEIGHT = 0;
    private static int WINDOW_YBORDER = 1000;
    private static int WINDOW_XBORDER = 1000;
    private static List<String> treeData = new ArrayList<String>();

    private void readSbgnmlFile(File fileInput) {
        try {
            this.sbgnObj = SbgnUtil.readFromFile(fileInput);
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        graphData.add("/*\n  PROCESSINGJS.COM HEADER ANIMATION\n  MIT License - Hyper-Metrix.com/F1LT3R\n  Native Processing compatible\n */ \n\n");
        graphData.add("// Defining and limiting the number of nodes\n");
        List<Glyph> listOfGlyphs = this.sbgnObj.getMap().getGlyph();
        List<Arc> listOfArcs = this.sbgnObj.getMap().getArc();
        graphData.add("Shape[] SHAPES = {\n");
        int glyphCounter = SBGNML2Processing.printListOfGlyphs(listOfGlyphs, 0);
        int counter = 0;
        for (Arc a : listOfArcs) {
            Label labelSource;
            treeData.add(a.getClazz());
            String textSource = "";
            String textTarget = "";
            String idOfArc = "";
            if (a.getSource().getClass() == Glyph.class && a.getTarget().getClass() == Glyph.class) {
                labelSource = ((Glyph)a.getSource()).getLabel();
                Label labelTarget = ((Glyph)a.getTarget()).getLabel();
                textSource = labelSource != null ? labelSource.getText() : ((Glyph)a.getSource()).getId();
                textTarget = labelTarget != null ? labelTarget.getText() : ((Glyph)a.getTarget()).getId();
                treeData.add(textSource + "->" + textTarget);
                idOfArc = ((Glyph)a.getSource()).getId() + "_" + ((Glyph)a.getTarget()).getId();
            } else if (a.getSource().getClass() == Port.class && a.getTarget().getClass() == Glyph.class) {
                Label labelTarget = ((Glyph)a.getTarget()).getLabel();
                textTarget = labelTarget != null ? labelTarget.getText() : ((Glyph)a.getTarget()).getId();
                treeData.add(((Port)a.getSource()).getId() + "->" + textTarget);
                idOfArc = ((Port)a.getSource()).getId() + "_" + ((Glyph)a.getTarget()).getId();
            } else if (a.getSource().getClass() == Glyph.class && a.getTarget().getClass() == Port.class) {
                labelSource = ((Glyph)a.getSource()).getLabel();
                textSource = labelSource != null ? labelSource.getText() : ((Glyph)a.getSource()).getId();
                treeData.add(textSource + "->" + ((Port)a.getTarget()).getId());
                idOfArc = ((Glyph)a.getSource()).getId() + "_" + ((Port)a.getTarget()).getId();
            } else {
                System.out.println("Error: Source and target are together related to Port objects");
                System.exit(1);
            }
            if (a.getSource().getClass() == Glyph.class && a.getTarget().getClass() == Glyph.class) {
                treeData.add(((Glyph)a.getSource()).getId() + "_" + ((Glyph)a.getTarget()).getId());
            } else if (a.getSource().getClass() == Port.class && a.getTarget().getClass() == Glyph.class) {
                treeData.add(((Port)a.getSource()).getId() + "_" + ((Glyph)a.getTarget()).getId());
            } else if (a.getSource().getClass() == Glyph.class && a.getTarget().getClass() == Port.class) {
                treeData.add(((Glyph)a.getSource()).getId() + "_" + ((Port)a.getTarget()).getId());
            } else {
                System.out.println("Error: Source and target are together related to Port objects");
                System.exit(1);
            }
            String glyph = "new " + mapping.get(a.getClazz());
            glyph = glyph + "\"" + idOfArc + "\",";
            glyph = glyph + a.getStart().getX() + "," + a.getStart().getY() + ",";
            SBGNML2Processing.adaptWindowSize(a.getStart().getX(), a.getStart().getY());
            SBGNML2Processing.getWindowScaleFrame(a.getStart().getX(), a.getStart().getY());
            glyph = glyph + a.getEnd().getX() + "," + a.getEnd().getY();
            SBGNML2Processing.adaptWindowSize(a.getEnd().getX(), a.getEnd().getY());
            SBGNML2Processing.getWindowScaleFrame(a.getEnd().getX(), a.getEnd().getY());
            if (a.getNext() != null) {
                glyph = glyph + ", new float[] {";
                int numberCounter = 0;
                for (Arc.Next n : a.getNext()) {
                    glyph = glyph + n.getX() + "," + n.getY();
                    SBGNML2Processing.adaptWindowSize(n.getX(), n.getY());
                    SBGNML2Processing.getWindowScaleFrame(n.getX(), n.getY());
                    if (++numberCounter == a.getNext().size()) continue;
                    glyph = glyph + ",";
                }
                glyph = glyph + "}";
            }
            glyph = glyph + "),";
            if (counter % 2 == 0) {
                glyph = glyph + "\n";
            }
            graphData.add(glyph);
        }
        String last = graphData.get(graphData.size() - 1);
        graphData.remove(graphData.size() - 1);
        graphData.add(last.replaceAll(",$", ""));
        graphData.add("};\n\n");
        int count = glyphCounter + listOfArcs.size();
        graphData.add("static int COUNT = " + count + ";\n\n");
        int ww = WINDOW_WIDTH + WINDOW_XBORDER;
        int wh = WINDOW_HEIGHT + WINDOW_YBORDER;
        System.out.println("ww = " + ww + " wh = " + wh);
        graphData.add("static int WINDOW_WIDTH = " + ww + ";\n" + "static int WINDOW_HEIGHT = " + wh + ";");
    }

    private static int printListOfGlyphs(List<Glyph> log, int counter) {
        for (Glyph g : log) {
            treeData.add(g.getClazz());
            if (g.getLabel() != null) {
                treeData.add(g.getLabel().getText());
            } else {
                treeData.add(g.getId());
            }
            treeData.add(g.getId());
            ++counter;
            System.out.println("glyph name = " + g.getClazz());
            if (mapping.get(g.getClazz()) == null) {
                System.out.println("SBGN class \"" + g.getClazz() + "\" has not found any equivalent in the mapping function.");
                System.exit(1);
            }
            String glyph = "new " + mapping.get(g.getClazz());
            if (SBGNML2Processing.canBeCloned(g.getClazz()).booleanValue()) {
                glyph = g.getClone() != null ? glyph + "1" : glyph + "0";
                glyph = glyph + ",";
            }
            if (g.getId() != null) {
                glyph = glyph + "\"" + g.getId() + "\",";
            } else {
                System.out.println("An SBGN-ML glyph has no id!");
                System.exit(1);
            }
            if (SBGNML2Processing.canBeLabeled(g.getClazz()).booleanValue()) {
                Label lab = g.getLabel();
                if (lab != null) {
                    System.out.println("glyph " + g.getClazz() + " has label = " + g.getLabel().getText());
                    String label = "new String[] {";
                    String[] labelPieces = lab.getText().split("\n");
                    for (int i = 0; i < labelPieces.length; ++i) {
                        label = i + 1 == labelPieces.length ? label + "\"" + labelPieces[i] + "\"" : label + "\"" + labelPieces[i] + "\\n\",";
                    }
                    glyph = glyph + label + "},";
                    if (g.getClazz().equals("compartment")) {
                        Bbox b = lab.getBbox();
                        if (b == null) {
                            System.out.println("Error: Label has no specific bounding box.");
                            System.exit(1);
                        }
                        SBGNML2Processing.adaptWindowSize(b.getX() + b.getW(), b.getY() + b.getH());
                        SBGNML2Processing.getWindowScaleFrame(b.getX(), b.getY());
                        glyph = glyph + b.getX() + "," + b.getY() + "," + b.getW() + "," + b.getH() + ",";
                    }
                } else if (g.getClazz().equals("state variable")) {
                    if (g.getState() != null) {
                        glyph = g.getState().getVariable() != null ? glyph + "new String[] {\"" + g.getState().getValue() + "@" + g.getState().getVariable() + "\"}," : glyph + "new String[] {\"" + g.getState().getValue() + "\"},";
                    } else {
                        System.out.println("state value cannot be null");
                        glyph = glyph + "new String[] {\"\"},";
                    }
                } else {
                    glyph = glyph + "new String[] {\"\"},";
                }
            }
            Bbox b = g.getBbox();
            glyph = glyph + b.getX() + "," + b.getY() + "," + b.getW() + "," + b.getH();
            SBGNML2Processing.adaptWindowSize(b.getX() + b.getW(), b.getY() + b.getH());
            SBGNML2Processing.getWindowScaleFrame(b.getX(), b.getY());
            if (g.getClazz().equals("tag") || g.getClazz().equals("terminal")) {
                String or = g.getOrientation();
                glyph = or.equals("right") ? glyph + ",0" : glyph + ",1";
            } else if (g.getClazz().matches("process|association|dissociation|and|or|not")) {
                String first = "";
                String second = "";
                for (Port p : g.getPort()) {
                    if (p.getId().matches(g.getId() + ".1")) {
                        first = first + "," + p.getX() + "," + p.getY();
                        continue;
                    }
                    second = second + "," + p.getX() + "," + p.getY();
                }
                glyph = glyph + first + second;
            }
            glyph = glyph + ",";
            glyph = g.getExtension() != null ? glyph + SBGNML2Processing.readExtension(g.getExtension()) : glyph + "new String[] {\"\"}";
            glyph = glyph + "),\n";
            System.out.println("    " + glyph);
            graphData.add(glyph);
            if (g.getGlyph().isEmpty()) continue;
            counter = SBGNML2Processing.printListOfGlyphs(g.getGlyph(), counter);
        }
        return counter;
    }

    private static String readExtension(SBGNBase.Extension ext) {
        String extensionString = "";
        System.out.println("size = " + ext.getAny().size());
        String math = "";
        String anno = "";
        for (Element e : ext.getAny()) {
            System.out.println("element = " + e.getTagName());
            System.out.println("test name attr = " + e.getNodeName());
            if (!e.getTagName().equals("math:math") && !e.getTagName().equals("annotation")) continue;
            DOMSource domSource = new DOMSource();
            domSource.setNode(e);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            TransformerFactory tf = TransformerFactory.newInstance();
            try {
                Transformer transformer = tf.newTransformer();
                try {
                    transformer.transform(domSource, result);
                }
                catch (TransformerException e1) {
                    e1.printStackTrace();
                }
            }
            catch (TransformerConfigurationException e1) {
                e1.printStackTrace();
            }
            String stringResult = writer.toString();
            if (e.getTagName().equals("math:math")) {
                math = stringResult;
                continue;
            }
            if (!e.getTagName().equals("annotation")) continue;
            anno = anno + "new String[] {";
            int countNonNull = 0;
            for (int index = 0; index < e.getChildNodes().getLength(); ++index) {
                Node child = e.getChildNodes().item(index);
                if (child.getLocalName() == null) continue;
                if (countNonNull != 0 && index != e.getChildNodes().getLength() - 1 && child.getLocalName() != null) {
                    anno = anno + ",";
                }
                anno = anno + "\"" + child.getLocalName() + "\",";
                anno = anno + "\"" + child.getChildNodes().item(0).getAttributes().item(0).getNodeValue() + "\"";
                ++countNonNull;
            }
            anno = anno + "}";
        }
        if (!math.equals("")) {
            extensionString = "\"" + math + "\"" + ",";
        }
        if (!anno.equals("")) {
            extensionString = anno;
        }
        if (!extensionString.equals("")) {
            extensionString.replaceAll(",$", "");
        }
        return extensionString;
    }

    private static HashMap<String, String> buildMappingForProcessing() {
        HashMap<String, String> mapping = new HashMap<String, String>();
        mapping.put("unspecified entity", "UnspecifiedEntity(");
        mapping.put("simple chemical", "SimpleChemical(0,");
        mapping.put("macromolecule", "Rectangle(4,0,0,");
        mapping.put("nucleic acid feature", "Rectangle(2,0,0,");
        mapping.put("perturbation", "PerturbingAgent(");
        mapping.put("source and sink", "Sink(");
        mapping.put("complex", "Rectangle(5,0,0,");
        mapping.put("macromolecule multimer", "Rectangle(4,1,0,");
        mapping.put("complex multimer", "Rectangle(5,1,0,");
        mapping.put("nucleic acid feature multimer", "Rectangle(2,1,0,");
        mapping.put("simple chemical multimer", "SimpleChemical(1,");
        mapping.put("process", "SquareNode(0,");
        mapping.put("omitted process", "SquareNode(1,");
        mapping.put("uncertain process", "SquareNode(2,");
        mapping.put("association", "CircularNode(0,");
        mapping.put("dissociation", "CircularNode(1,");
        mapping.put("phenotype", "Phenotype(");
        mapping.put("tag", "Tag(1,");
        mapping.put("submap", "Rectangle(0,0,0,0,");
        mapping.put("terminal", "Tag(0,");
        mapping.put("consumption", "ArcShape(0,");
        mapping.put("production", "ArcShape(1,");
        mapping.put("modulation", "ArcShape(2,");
        mapping.put("stimulation", "ArcShape(3,");
        mapping.put("catalysis", "ArcShape(4,");
        mapping.put("inhibition", "ArcShape(5,");
        mapping.put("necessary stimulation", "ArcShape(6,");
        mapping.put("logic arc", "ArcShape(7,");
        mapping.put("equivalence arc", "ArcShape(7,");
        mapping.put("and", "LogicalOperator(\"AND\",");
        mapping.put("or", "LogicalOperator(\"OR\",");
        mapping.put("not", "LogicalOperator(\"NOT\",");
        mapping.put("compartment", "Compartment(");
        mapping.put("unit of information", "UnitOfInfo(");
        mapping.put("state variable", "StateVariable(");
        return mapping;
    }

    private static Boolean canBeCloned(String glyphClass) {
        if (glyphClass.matches("unspecified entity||simple chemical$||macromolecule$||nucleic acid feature$||perturbation||complex$||macromolecule multimer||complex multimer||nucleic acid feature multimer||simple chemical multimer")) {
            return true;
        }
        return false;
    }

    private static Boolean canBeLabeled(String glyphClass) {
        if (glyphClass.matches("unspecified entity||simple chemical$||macromolecule$||nucleic acid feature$||perturbation||complex$||macromolecule multimer||complex multimer||nucleic acid feature multimer||simple chemical multimer||tag||terminal||submap||phenotype||unit of information||state variable||compartment")) {
            return true;
        }
        return false;
    }

    private static Boolean canCarryUnitOrStateGlyph(String glyphClass) {
        if (glyphClass.matches("unspecified entity||simple chemical$||macromolecule$||nucleic acid feature$||perturbation||complex$||macromolecule multimer||complex multimer||nucleic acid feature multimer||simple chemical multimer||compartment")) {
            return true;
        }
        return false;
    }

    private static void adaptWindowSize(float x, float y) {
        int xInt = (int)x;
        int yInt = (int)y;
        WINDOW_WIDTH = Math.max(WINDOW_WIDTH, xInt);
        WINDOW_HEIGHT = Math.max(WINDOW_HEIGHT, yInt);
    }

    private static void getWindowScaleFrame(float x, float y) {
        int xInt = (int)x;
        int yInt = (int)y;
        WINDOW_XBORDER = Math.min(WINDOW_XBORDER, xInt);
        WINDOW_YBORDER = Math.min(WINDOW_YBORDER, yInt);
    }

    private void writeSBGNBrowsingTree() throws ParserConfigurationException {
        ArrayList<String> classes = new ArrayList<String>();
        for (int i = 0; i < treeData.size(); i += 3) {
            classes.add(treeData.get(i));
        }
        Collections.sort(classes);
        ArrayList<String> treeData2 = new ArrayList<String>();
        for (int i = 0; i < classes.size(); ++i) {
            String firstString = (String)classes.get(i);
            int index = treeData.indexOf(firstString);
            treeData2.add(firstString);
            treeData.remove(index);
            treeData2.add(treeData.remove(index));
            treeData2.add(treeData.remove(index));
        }
        treeData = treeData2;
        treeData2 = new ArrayList();
        String firstClass = treeData.get(0);
        ArrayList<String> listOfNamesWithSameClass = new ArrayList<String>();
        listOfNamesWithSameClass.add(treeData.get(1));
        for (int i = 3; i < treeData.size() - 3; i += 3) {
            String secondClass = treeData.get(i);
            if (firstClass.equals(secondClass)) {
                listOfNamesWithSameClass.add(treeData.get(i + 1));
            } else {
                Collections.sort(listOfNamesWithSameClass);
                for (int i2 = 0; i2 < listOfNamesWithSameClass.size(); ++i2) {
                    treeData2.add(firstClass);
                    treeData2.add((String)listOfNamesWithSameClass.get(i2));
                    int indexOfName = treeData.indexOf(listOfNamesWithSameClass.get(i2)) + 1;
                    treeData2.add(treeData.get(indexOfName));
                    treeData.set(indexOfName - 1, "");
                    treeData.set(indexOfName, "");
                    treeData.set(indexOfName + 1, "");
                }
                listOfNamesWithSameClass = new ArrayList();
                listOfNamesWithSameClass.add(treeData.get(i + 1));
            }
            firstClass = secondClass;
        }
        treeData = treeData2;
        String fileName = "sbgnTree.xml";
        String filePath = "/automount/nas17b_vol-vol_homes-homes/jalowcki/Desktop/processing-1.2.3/test_javascript_zoom/treeImgs/";
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder constructeur = factory.newDocumentBuilder();
        Document document = constructeur.newDocument();
        Element tree = document.createElement("tree");
        tree.setAttribute("id", "0");
        document.appendChild(tree);
        if (treeData.size() % 3 != 0) {
            System.out.println("Error in writeSBGNBrowsingTree");
            System.exit(1);
        }
        ArrayList<String> branchClasses = new ArrayList<String>();
        for (int i = 0; i < treeData.size(); ++i) {
            Element parent = document.createElement("item");
            if (!branchClasses.contains(treeData.get(i))) {
                branchClasses.add(treeData.get(i));
                parent.setAttribute("text", treeData.get(i));
                parent.setAttribute("id", treeData.get(i));
                parent.setAttribute("im0", "book_titel.gif");
                parent.setAttribute("im1", "book_titel.gif");
                parent.setAttribute("im2", "book_titel.gif");
                tree.appendChild(parent);
            } else {
                for (int index = 0; index < tree.getChildNodes().getLength(); ++index) {
                    Node node = tree.getChildNodes().item(index);
                    for (int index2 = 0; index2 < node.getAttributes().getLength(); ++index2) {
                        if (!node.getAttributes().getNamedItem("id").getNodeValue().equals(treeData.get(i))) continue;
                        parent = (Element)node;
                    }
                }
            }
            Element child = document.createElement("item");
            child.setAttribute("text", treeData.get(++i));
            child.setAttribute("id", treeData.get(++i));
            child.setAttribute("im0", "book_titel.gif");
            child.setAttribute("im1", "book_titel.gif");
            child.setAttribute("im2", "book_titel.gif");
            parent.appendChild(child);
        }
        try {
            DOMSource source = new DOMSource(document);
            File file = new File(filePath + fileName);
            StreamResult result = new StreamResult(file);
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.transform(source, result);
        }
        catch (TransformerConfigurationException e) {
        }
        catch (TransformerException e) {
            // empty catch block
        }
    }

    private void writeProcessingData() {
        String dataString = "";
        for (String s : graphData) {
            dataString = dataString + s;
        }
        String filePath = this.sbgnmlFileName.replaceAll("[_A-Za-z0-9-]+.xml$", "");
        try {
            FileWriter writer = new FileWriter(filePath + this.processingFileName);
            writer.write(dataString);
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        if (args.length < 1 || args.length > 2) {
            System.out.println("usage: java org.processing.SBGNML2Processing <SBGNML filename>");
            return;
        }
        SBGNML2Processing s2p = new SBGNML2Processing();
        s2p.sbgnmlFileName = args[0];
        File f = new File(s2p.sbgnmlFileName);
        s2p.readSbgnmlFile(f);
        s2p.writeProcessingData();
        try {
            System.out.println("browsing the tree");
            s2p.writeSBGNBrowsingTree();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        String outputFilePath = s2p.sbgnmlFileName.replaceAll("[_A-Za-z0-9-]+.xml$", "");
        System.out.println("Writing sucessful. Output file at " + outputFilePath + s2p.processingFileName);
    }
}

