/*
 * Decompiled with CFR 0.152.
 */
package fr.curie.cd2sbgnml.xmlcdwrappers;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sbml._2001.ns.celldesigner.CompartmentAlias;
import org.sbml._2001.ns.celldesigner.ComplexSpeciesAlias;
import org.sbml._2001.ns.celldesigner.DoubleLine;
import org.sbml._2001.ns.celldesigner.Line;
import org.sbml._2001.ns.celldesigner.Modification;
import org.sbml._2001.ns.celldesigner.Paint;
import org.sbml._2001.ns.celldesigner.ProductLink;
import org.sbml._2001.ns.celldesigner.ReactantLink;
import org.sbml._2001.ns.celldesigner.SpeciesAlias;

public class StyleInfo {
    private static final String DEFAULT_BG_COLOR = "00ffffff";
    private static final String DEFAULT_LINE_COLOR = "ff000000";
    private static final float DEFAULT_FONT_SIZE = 12.0f;
    private static final float DEFAULT_LINE_WIDTH = 1.0f;
    private float lineWidth;
    private String bgColor;
    private float fontSize;
    private String lineColor;
    private String refId;
    private String id;

    public StyleInfo(String refId) {
        this.bgColor = DEFAULT_BG_COLOR;
        this.fontSize = 12.0f;
        this.lineColor = DEFAULT_LINE_COLOR;
        this.lineWidth = 1.0f;
        this.refId = refId;
        this.id = this.generateStyleId();
    }

    public StyleInfo(StyleInfo previousInfo, String refId) {
        this.bgColor = previousInfo.getBgColor();
        this.fontSize = previousInfo.getFontSize();
        this.lineColor = previousInfo.getLineColor();
        this.lineWidth = previousInfo.getLineWidth();
        this.refId = refId;
        this.id = this.generateStyleId();
    }

    public StyleInfo(CompartmentAlias compAlias, String refId) {
        this.bgColor = DEFAULT_BG_COLOR;
        this.fontSize = 12.0f;
        this.refId = refId;
        Paint paint = compAlias.getPaint();
        DoubleLine doubleLine = compAlias.getDoubleLine();
        this.lineWidth = doubleLine.getThickness().floatValue() + doubleLine.getOuterWidth().floatValue() / 2.0f + doubleLine.getInnerWidth().floatValue() / 2.0f;
        this.lineColor = paint.getColor().toLowerCase();
        this.id = this.generateStyleId();
    }

    public StyleInfo(ComplexSpeciesAlias complexAlias, String refId) {
        this.refId = refId;
        this.fontSize = complexAlias.getFont().getSize().intValue();
        this.lineColor = DEFAULT_LINE_COLOR;
        this.lineWidth = complexAlias.getUsualView().getSingleLine().getWidth().floatValue();
        this.bgColor = complexAlias.getUsualView().getPaint().getColor().toLowerCase();
        this.id = this.generateStyleId();
    }

    public StyleInfo(SpeciesAlias speciesAlias, String refId) {
        this.refId = refId;
        this.fontSize = speciesAlias.getFont().getSize().intValue();
        this.lineColor = DEFAULT_LINE_COLOR;
        this.lineWidth = speciesAlias.getUsualView().getSingleLine().getWidth().floatValue();
        this.bgColor = speciesAlias.getUsualView().getPaint().getColor().toLowerCase();
        this.id = this.generateStyleId();
    }

    public StyleInfo(float width, String color, String refId) {
        this.refId = refId;
        this.lineWidth = width;
        this.lineColor = color;
        this.bgColor = DEFAULT_BG_COLOR;
        this.fontSize = 12.0f;
        this.id = this.generateStyleId();
    }

    public StyleInfo(Modification modif, String refId) {
        this.refId = refId;
        Line line = modif.getLine();
        this.lineWidth = line.getWidth().floatValue();
        this.lineColor = line.getColor().toLowerCase();
        this.bgColor = DEFAULT_BG_COLOR;
        this.fontSize = 12.0f;
        this.id = this.generateStyleId();
    }

    public StyleInfo(ReactantLink reactantLink, String refId) {
        this.refId = refId;
        this.lineWidth = reactantLink.getLine().getWidth().floatValue();
        this.lineColor = reactantLink.getLine().getColor().toLowerCase();
        this.bgColor = DEFAULT_BG_COLOR;
        this.fontSize = 12.0f;
        this.id = this.generateStyleId();
    }

    public StyleInfo(ProductLink productLink, String refId) {
        this.refId = refId;
        this.lineWidth = productLink.getLine().getWidth().floatValue();
        this.lineColor = productLink.getLine().getColor().toLowerCase();
        this.bgColor = DEFAULT_BG_COLOR;
        this.fontSize = 12.0f;
        this.id = this.generateStyleId();
    }

    private String generateStyleId() {
        return "style_" + this.lineWidth + this.bgColor + this.fontSize + this.lineColor;
    }

    public static Map<String, String> getMapOfColorDefinitions(List<StyleInfo> styleInfoList) {
        HashMap<String, String> result = new HashMap<String, String>();
        int i = 1;
        for (StyleInfo sinfo : styleInfoList) {
            if (!result.containsKey(sinfo.getBgColor())) {
                result.put(sinfo.getBgColor(), "color_" + i);
                ++i;
            }
            if (result.containsKey(sinfo.getLineColor())) continue;
            result.put(sinfo.getLineColor(), "color_" + i);
            ++i;
        }
        return result;
    }

    public float getLineWidth() {
        return this.lineWidth;
    }

    public String getBgColor() {
        return this.bgColor;
    }

    public float getFontSize() {
        return this.fontSize;
    }

    public String getLineColor() {
        return this.lineColor;
    }

    public String getRefId() {
        return this.refId;
    }

    public String getId() {
        return this.id;
    }

    public String toString() {
        return "BgColor: " + this.bgColor + " lineColor: " + this.lineColor + " lineWidth: " + this.lineWidth + " fontSize: " + this.fontSize;
    }

    public void setLineWidth(float lineWidth) {
        this.lineWidth = lineWidth;
    }

    public void setBgColor(String bgColor) {
        this.bgColor = bgColor;
    }

    public void setFontSize(float fontSize) {
        this.fontSize = fontSize;
    }

    public void setLineColor(String lineColor) {
        this.lineColor = lineColor;
    }
}

