/*
 * Decompiled with CFR 0.152.
 */
package fr.curie.cd2sbgnml.xmlcdwrappers;

import fr.curie.cd2sbgnml.xmlcdwrappers.AliasWrapper;
import fr.curie.cd2sbgnml.xmlcdwrappers.IAnnotationsFeature;
import fr.curie.cd2sbgnml.xmlcdwrappers.INotesFeature;
import fr.curie.cd2sbgnml.xmlcdwrappers.ModelWrapper;
import fr.curie.cd2sbgnml.xmlcdwrappers.ResidueWrapper;
import fr.curie.cd2sbgnml.xmlcdwrappers.Utils;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.sbgn.bindings.Glyph;
import org.sbml._2001.ns.celldesigner.AntisenseRNA;
import org.sbml._2001.ns.celldesigner.Catalyzed;
import org.sbml._2001.ns.celldesigner.ComplexSpeciesAlias;
import org.sbml._2001.ns.celldesigner.Gene;
import org.sbml._2001.ns.celldesigner.ListOfCatalyzedReactions;
import org.sbml._2001.ns.celldesigner.ListOfModifications;
import org.sbml._2001.ns.celldesigner.ListOfRegions;
import org.sbml._2001.ns.celldesigner.ModificationResidue;
import org.sbml._2001.ns.celldesigner.Notes;
import org.sbml._2001.ns.celldesigner.Protein;
import org.sbml._2001.ns.celldesigner.RNA;
import org.sbml._2001.ns.celldesigner.Region;
import org.sbml._2001.ns.celldesigner.Species;
import org.sbml._2001.ns.celldesigner.SpeciesAlias;
import org.sbml._2001.ns.celldesigner.SpeciesAnnotationType;
import org.sbml._2001.ns.celldesigner.SpeciesIdentity;
import org.sbml._2001.ns.celldesigner.State;
import org.sbml.sbml.level2.version4.SBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SpeciesWrapper
implements INotesFeature,
IAnnotationsFeature {
    private final Logger logger = LoggerFactory.getLogger(SpeciesWrapper.class);
    private boolean isIncludedSpecies;
    private boolean isComplex;
    private String id;
    private String name;
    private String compartment;
    private String complex;
    private String cdClass;
    private int multimer;
    private String structuralState;
    private ReferenceType type;
    private String referenceId;
    private Element notes;
    private Element annotations;
    private Element referenceNotes;
    private List<String> catalyzedReactions;
    private List<AliasWrapper> aliases;
    private List<ResidueWrapper> residues;

    public SpeciesWrapper(String id, String name, ReferenceType type, String referenceId) {
        this.id = id;
        this.name = name;
        this.type = type;
        this.referenceId = referenceId;
        this.aliases = new ArrayList<AliasWrapper>();
        this.residues = new ArrayList<ResidueWrapper>();
        this.catalyzedReactions = new ArrayList<String>();
    }

    public SpeciesWrapper(org.sbml.sbml.level2.version4.Species species, ModelWrapper modelW) {
        this.isIncludedSpecies = false;
        this.cdClass = species.getAnnotation().getExtension().getSpeciesIdentity().getClazz();
        this.id = species.getId();
        this.name = species.getName();
        this.compartment = species.getCompartment();
        this.complex = null;
        this.notes = Utils.getNotes(species.getNotes());
        this.annotations = Utils.getRDFAnnotations(species.getAnnotation().getAny());
        this.catalyzedReactions = new ArrayList<String>();
        this.commonConstructor(species.getAnnotation().getExtension().getSpeciesIdentity(), modelW);
    }

    public SpeciesWrapper(Species species, ModelWrapper modelW) {
        this.isIncludedSpecies = true;
        this.cdClass = species.getAnnotation().getSpeciesIdentity().getClazz();
        this.id = species.getId();
        this.name = species.getName();
        this.complex = species.getAnnotation().getComplexSpecies();
        this.compartment = null;
        this.notes = Utils.getNotes(species.getNotes());
        this.commonConstructor(species.getAnnotation().getSpeciesIdentity(), modelW);
    }

    public SpeciesWrapper(Glyph sbgnGlyph) {
        this(sbgnGlyph, null);
    }

    public SpeciesWrapper(Glyph sbgnGlyph, Glyph parentGlyph) {
        this.id = "s" + sbgnGlyph.getId();
        this.name = sbgnGlyph.getLabel() != null ? sbgnGlyph.getLabel().getText() : this.id;
        this.compartment = sbgnGlyph.getCompartmentRef() != null ? ((Glyph)sbgnGlyph.getCompartmentRef()).getId() : "default";
        if (parentGlyph != null) {
            this.isIncludedSpecies = true;
            this.complex = "cs" + parentGlyph.getId();
        } else {
            this.isIncludedSpecies = false;
            this.complex = null;
        }
    }

    private void commonConstructor(SpeciesIdentity identity, ModelWrapper modelW) {
        this.multimer = 1;
        this.residues = new ArrayList<ResidueWrapper>();
        this.aliases = new ArrayList<AliasWrapper>();
        this.isComplex = this.cdClass.equals("COMPLEX");
        if (this.isComplex) {
            if (modelW.getComplexSpeciesAliasFor(this.id) != null) {
                this.logger.debug("Species has " + modelW.getComplexSpeciesAliasFor(this.id).size() + " complexSpeciesAliases");
                for (ComplexSpeciesAlias complexAlias : modelW.getComplexSpeciesAliasFor(this.id)) {
                    if (complexAlias == null) continue;
                    this.logger.debug("Parse complex alias: " + complexAlias.getId());
                    this.aliases.add(new AliasWrapper(complexAlias, this));
                }
            } else {
                this.logger.warn("Complex species: " + this.id + " should have complex aliases");
            }
        }
        if (modelW.getSpeciesAliasFor(this.id) != null) {
            if (this.isComplex) {
                this.logger.warn("Complex species: " + this.id + " shouldn't have non-complex aliases");
            }
            this.logger.debug("Species has " + modelW.getSpeciesAliasFor(this.id).size() + " speciesAliases");
            for (SpeciesAlias alias : modelW.getSpeciesAliasFor(this.id)) {
                if (alias == null) continue;
                this.logger.debug("Parse alias: " + alias.getId());
                this.aliases.add(new AliasWrapper(alias, this));
            }
        }
        HashMap<Object, Object> mapOfReferenceModif = new HashMap();
        if (identity.getProteinReference() != null) {
            String protId = identity.getProteinReference();
            Protein prot = modelW.getProtein(protId);
            if (prot.getListOfModificationResidues() != null) {
                List<ModificationResidue> listOfReferenceModif = prot.getListOfModificationResidues().getModificationResidue();
                mapOfReferenceModif = new HashMap();
                for (ModificationResidue modificationResidue : listOfReferenceModif) {
                    this.logger.debug("Residue found for " + prot.getId() + " resid " + modificationResidue.getId() + " angle " + modificationResidue.getAngle());
                    ResidueWrapper residueWrapper = new ResidueWrapper(modificationResidue.getId());
                    residueWrapper.angle = modificationResidue.getAngle().floatValue();
                    if (modificationResidue.getName() != null) {
                        residueWrapper.name = modificationResidue.getName();
                    }
                    mapOfReferenceModif.put(residueWrapper.id, residueWrapper);
                }
                this.logger.debug(mapOfReferenceModif.size() + " res for protein " + protId);
            }
            this.type = SpeciesWrapper.getTypeFromString(prot.getType());
            this.referenceNotes = Utils.getNotes(prot.getNotes());
        } else if (identity.getRnaReference() != null) {
            String rnaId = identity.getRnaReference();
            RNA rna = modelW.getRNA(rnaId);
            this.type = SpeciesWrapper.getTypeFromString(rna.getType());
            if (rna.getListOfRegions() != null) {
                mapOfReferenceModif = this.mapOfRegion(rna.getListOfRegions());
            }
            this.referenceNotes = Utils.getNotes(rna.getNotes());
        } else if (identity.getAntisensernaReference() != null) {
            String asrnaId = identity.getAntisensernaReference();
            AntisenseRNA asrna = modelW.getAntisenseRNA(asrnaId);
            this.type = SpeciesWrapper.getTypeFromString(asrna.getType());
            if (asrna.getListOfRegions() != null) {
                mapOfReferenceModif = this.mapOfRegion(asrna.getListOfRegions());
            }
            this.referenceNotes = Utils.getNotes(asrna.getNotes());
        } else if (identity.getGeneReference() != null) {
            String geneId = identity.getGeneReference();
            Gene gene = modelW.getGene(geneId);
            this.type = SpeciesWrapper.getTypeFromString(gene.getType());
            if (gene.getListOfRegions() != null) {
                mapOfReferenceModif = this.mapOfRegion(gene.getListOfRegions());
                this.logger.debug("GENE MODIF COUNT: " + mapOfReferenceModif.size() + " " + gene.getListOfRegions().getRegion().size());
            }
            this.referenceNotes = Utils.getNotes(gene.getNotes());
        }
        if (identity.getState() != null) {
            State state = identity.getState();
            if (state.getHomodimer() != null) {
                this.multimer = state.getHomodimer().intValue();
            }
            if (state.getListOfStructuralStates() != null) {
                this.structuralState = state.getListOfStructuralStates().getStructuralState().getStructuralState();
            }
            if (state.getListOfModifications() != null) {
                List<ListOfModifications.Modification> listOfModif = state.getListOfModifications().getModification();
                for (ListOfModifications.Modification modification : listOfModif) {
                    this.logger.debug("adding state: " + modification.getState() + " for res " + modification.getResidue());
                    String residueId = modification.getResidue();
                    ResidueWrapper residueWrapper = (ResidueWrapper)mapOfReferenceModif.get(residueId);
                    if (residueWrapper != null) {
                        residueWrapper.state = modification.getState();
                        continue;
                    }
                    this.logger.error("Residue " + residueId + " doesn't exist in referenced protein.");
                }
            }
        }
        this.residues.addAll(mapOfReferenceModif.values());
        this.logger.debug("final residue size for species " + this.getId() + " : " + this.residues.size());
    }

    private HashMap<String, ResidueWrapper> mapOfRegion(NodeList listOfNode) {
        HashMap<String, ResidueWrapper> mapOfReferenceModif = new HashMap<String, ResidueWrapper>();
        for (int i = 0; i < listOfNode.getLength(); ++i) {
            Node n = listOfNode.item(i);
            if (!n.getNodeName().equals("celldesigner_listOfRegions")) continue;
            Node listOfRegions = n;
            for (int j = 0; j < listOfRegions.getChildNodes().getLength(); ++j) {
                Node n2 = listOfRegions.getChildNodes().item(j);
                if (!n2.getNodeName().equals("celldesigner_region")) continue;
                String type = n2.getAttributes().getNamedItem("type").getNodeValue();
                String id = n2.getAttributes().getNamedItem("id").getNodeValue();
                String pos = n2.getAttributes().getNamedItem("pos").getNodeValue();
                if (!type.equals("Modification Site")) continue;
                ResidueWrapper residueWrapper = new ResidueWrapper(id);
                residueWrapper.relativePos = Float.parseFloat(pos);
                residueWrapper.useAngle = false;
                if (n2.getAttributes().getNamedItem("name") != null) {
                    residueWrapper.name = n2.getAttributes().getNamedItem("name").getNodeValue();
                }
                mapOfReferenceModif.put(residueWrapper.id, residueWrapper);
            }
        }
        return mapOfReferenceModif;
    }

    private HashMap<String, ResidueWrapper> mapOfRegion(ListOfRegions listOfRegions) {
        HashMap<String, ResidueWrapper> mapOfReferenceModif = new HashMap<String, ResidueWrapper>();
        for (Region region : listOfRegions.getRegion()) {
            String type = region.getType();
            String id = region.getId();
            float pos = region.getPos().floatValue();
            if (!type.equals("Modification Site")) continue;
            ResidueWrapper residueWrapper = new ResidueWrapper(id);
            residueWrapper.relativePos = pos;
            residueWrapper.useAngle = false;
            if (region.getName() != null) {
                residueWrapper.name = region.getName();
            }
            mapOfReferenceModif.put(residueWrapper.id, residueWrapper);
        }
        return mapOfReferenceModif;
    }

    public org.sbml.sbml.level2.version4.Species getCDNormalSpecies() {
        org.sbml.sbml.level2.version4.Species species = new org.sbml.sbml.level2.version4.Species();
        species.setId(this.getId());
        species.setMetaid(this.getId());
        species.setName(this.getName().isEmpty() ? this.getId() : this.getName());
        species.setCompartment(this.getCompartment());
        species.setInitialAmount(0.0);
        SpeciesAnnotationType speciesAnnot = new SpeciesAnnotationType();
        species.setAnnotation(speciesAnnot);
        SpeciesAnnotationType.Extension ext = new SpeciesAnnotationType.Extension();
        speciesAnnot.setExtension(ext);
        ext.setPositionToCompartment("inside");
        ext.setSpeciesIdentity(this.getIdentity());
        if (this.getCatalyzedReactions().size() > 0) {
            ListOfCatalyzedReactions listOfCatalyzedReactions = new ListOfCatalyzedReactions();
            ext.setListOfCatalyzedReactions(listOfCatalyzedReactions);
            for (String reactionId : this.getCatalyzedReactions()) {
                Catalyzed catalyzed = new Catalyzed();
                catalyzed.setReaction(reactionId);
                listOfCatalyzedReactions.getCatalyzed().add(catalyzed);
            }
        }
        if (this.getNotes() != null) {
            SBase.Notes notes = new SBase.Notes();
            species.setNotes(notes);
            notes.getAny().add(this.getNotes());
        }
        if (this.getAnnotations() != null) {
            speciesAnnot.getAny().add(this.getAnnotations());
        }
        return species;
    }

    public Species getCDIncludedSpecies() {
        Species species = new Species();
        species.setId(this.getId());
        species.setName(this.getName().isEmpty() ? this.getId() : this.getName());
        Species.Annotation speciesAnnot = new Species.Annotation();
        species.setAnnotation(speciesAnnot);
        speciesAnnot.setComplexSpecies(this.getComplex());
        speciesAnnot.setSpeciesIdentity(this.getIdentity());
        if (this.getNotes() != null) {
            Notes notes = new Notes();
            species.setNotes(notes);
            notes.getAny().add(this.getNotes());
        }
        if (this.getAnnotations() != null) {
            this.logger.error("Species: " + this.getId() + " with name " + this.getName() + " is an included species and has rdf annotations. These annotations will be lost, due to CellDesigner not allowing them foranything included inside a complex.");
        }
        return species;
    }

    private SpeciesIdentity getIdentity() {
        SpeciesIdentity ident = new SpeciesIdentity();
        ident.setClazz(this.getCdClass());
        if (this.getType() == null) {
            ident.setName(this.getName().isEmpty() ? this.getId() : this.getName());
        } else {
            switch (this.getType()) {
                case GENERIC: 
                case RECEPTOR: 
                case TRUNCATED: 
                case ION_CHANNEL: {
                    ident.setProteinReference(this.getReferenceId());
                    break;
                }
                case RNA: {
                    ident.setRnaReference(this.getReferenceId());
                    break;
                }
                case GENE: {
                    ident.setGeneReference(this.getReferenceId());
                    break;
                }
                case ANTISENSE_RNA: {
                    ident.setAntisensernaReference(this.getReferenceId());
                }
            }
        }
        if (this.getMultimer() > 0 || this.getResidues().size() > 0) {
            State state = new State();
            ident.setState(state);
            if (this.getMultimer() > 0) {
                state.setHomodimer(BigInteger.valueOf(this.getMultimer()));
            }
            if (this.getResidues().size() > 0) {
                ListOfModifications listOfModifications = new ListOfModifications();
                boolean atLeast1ResiduePresent = false;
                for (ResidueWrapper resW : this.getResidues()) {
                    if (resW.state == null || resW.state.isEmpty()) continue;
                    ListOfModifications.Modification modification = new ListOfModifications.Modification();
                    modification.setResidue(resW.id);
                    modification.setState(resW.state);
                    listOfModifications.getModification().add(modification);
                    atLeast1ResiduePresent = true;
                }
                if (atLeast1ResiduePresent) {
                    state.setListOfModifications(listOfModifications);
                }
            }
        }
        return ident;
    }

    public boolean isIncludedSpecies() {
        return this.isIncludedSpecies;
    }

    public boolean isComplex() {
        return this.isComplex;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getCompartment() {
        return this.compartment;
    }

    public String getComplex() {
        return this.complex;
    }

    public String getCdClass() {
        return this.cdClass;
    }

    public List<AliasWrapper> getAliases() {
        return this.aliases;
    }

    public int getMultimer() {
        return this.multimer;
    }

    public String getStructuralState() {
        return this.structuralState;
    }

    public List<ResidueWrapper> getResidues() {
        return this.residues;
    }

    public static ReferenceType getTypeFromString(String t) {
        switch (t) {
            case "GENERIC": {
                return ReferenceType.GENERIC;
            }
            case "ION_CHANNEL": {
                return ReferenceType.ION_CHANNEL;
            }
            case "RECEPTOR": {
                return ReferenceType.RECEPTOR;
            }
            case "TRUNCATED": {
                return ReferenceType.TRUNCATED;
            }
            case "GENE": {
                return ReferenceType.GENE;
            }
            case "RNA": {
                return ReferenceType.RNA;
            }
            case "ANTISENSE_RNA": {
                return ReferenceType.ANTISENSE_RNA;
            }
        }
        throw new IllegalArgumentException("Value: " + t + " is not a valid type. Should be one of" + Arrays.toString((Object[])ReferenceType.values()));
    }

    public ReferenceType getType() {
        return this.type;
    }

    @Override
    public Element getNotes() {
        return this.notes;
    }

    public Element getReferenceNotes() {
        return this.referenceNotes;
    }

    @Override
    public Element getAnnotations() {
        return this.annotations;
    }

    public void setIncludedSpecies(boolean includedSpecies) {
        this.isIncludedSpecies = includedSpecies;
    }

    public void setComplex(boolean complex2) {
        this.isComplex = complex2;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setCompartment(String compartment) {
        this.compartment = compartment;
    }

    public void setComplex(String complex2) {
        this.complex = complex2;
    }

    public void setCdClass(String cdClass) {
        this.cdClass = cdClass;
    }

    public void setMultimer(int multimer) {
        this.multimer = multimer;
    }

    public void setStructuralState(String structuralState) {
        this.structuralState = structuralState;
    }

    public void setType(ReferenceType type) {
        this.type = type;
    }

    @Override
    public void setNotes(Element notes) {
        this.notes = notes;
    }

    public void setReferenceNotes(Element referenceNotes) {
        this.referenceNotes = referenceNotes;
    }

    @Override
    public void setAnnotations(Element annotations) {
        this.annotations = annotations;
    }

    public void setAliases(List<AliasWrapper> aliases) {
        this.aliases = aliases;
    }

    public void setResidues(List<ResidueWrapper> residues) {
        this.residues = residues;
    }

    public List<String> getCatalyzedReactions() {
        return this.catalyzedReactions;
    }

    public void setCatalyzedReactions(List<String> catalyzedReactions) {
        this.catalyzedReactions = catalyzedReactions;
    }

    public String getReferenceId() {
        return this.referenceId;
    }

    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    public static enum ReferenceType {
        GENERIC,
        ION_CHANNEL,
        RECEPTOR,
        TRUNCATED,
        GENE,
        RNA,
        ANTISENSE_RNA;

    }
}

