/*
 * Decompiled with CFR 0.152.
 */
package fr.curie.cd2sbgnml.xmlcdwrappers;

import fr.curie.cd2sbgnml.xmlcdwrappers.IAnnotationsFeature;
import fr.curie.cd2sbgnml.xmlcdwrappers.INotesFeature;
import fr.curie.cd2sbgnml.xmlcdwrappers.LineWrapper;
import fr.curie.cd2sbgnml.xmlcdwrappers.LogicGateWrapper;
import fr.curie.cd2sbgnml.xmlcdwrappers.ModelWrapper;
import fr.curie.cd2sbgnml.xmlcdwrappers.ModificationLinkType;
import fr.curie.cd2sbgnml.xmlcdwrappers.ReactantWrapper;
import fr.curie.cd2sbgnml.xmlcdwrappers.ReactionType;
import fr.curie.cd2sbgnml.xmlcdwrappers.Utils;
import java.awt.geom.Point2D;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.sbml._2001.ns.celldesigner.BaseProduct;
import org.sbml._2001.ns.celldesigner.BaseProducts;
import org.sbml._2001.ns.celldesigner.BaseReactant;
import org.sbml._2001.ns.celldesigner.BaseReactants;
import org.sbml._2001.ns.celldesigner.ConnectScheme;
import org.sbml._2001.ns.celldesigner.ListOfGateMember;
import org.sbml._2001.ns.celldesigner.ListOfModification;
import org.sbml._2001.ns.celldesigner.ListOfProductLinks;
import org.sbml._2001.ns.celldesigner.ListOfReactantLinks;
import org.sbml._2001.ns.celldesigner.Modification;
import org.sbml._2001.ns.celldesigner.ProductLink;
import org.sbml._2001.ns.celldesigner.ReactantLink;
import org.sbml._2001.ns.celldesigner.ReactionAnnotationType;
import org.sbml._2001.ns.celldesigner.SpeciesReferenceAnnotationType;
import org.sbml.sbml.level2.version4.ListOfModifierSpeciesReferences;
import org.sbml.sbml.level2.version4.ListOfSpeciesReferences;
import org.sbml.sbml.level2.version4.ModifierSpeciesReference;
import org.sbml.sbml.level2.version4.Reaction;
import org.sbml.sbml.level2.version4.SBase;
import org.sbml.sbml.level2.version4.SpeciesReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class ReactionWrapper
implements INotesFeature,
IAnnotationsFeature {
    private static final Logger logger = LoggerFactory.getLogger(ReactionWrapper.class);
    private String id;
    private List<ReactantWrapper> baseReactants;
    private List<ReactantWrapper> baseProducts;
    private List<ReactantWrapper> additionalReactants;
    private List<ReactantWrapper> additionalProducts;
    private List<ReactantWrapper> modifiers;
    private List<LogicGateWrapper> logicGates;
    private int processSegmentIndex;
    private ReactionType reactionType;
    private boolean hasProcess;
    private boolean isReversible;
    private LineWrapper lineWrapper;
    private Element notes;
    private Element annotations;

    public ReactionWrapper(String id, ReactionType type, List<ReactantWrapper> baseReactants, List<ReactantWrapper> baseProducts) {
        this.id = id;
        this.reactionType = type;
        this.baseReactants = baseReactants;
        this.baseProducts = baseProducts;
        this.additionalProducts = new ArrayList<ReactantWrapper>();
        this.additionalReactants = new ArrayList<ReactantWrapper>();
        this.modifiers = new ArrayList<ReactantWrapper>();
        this.logicGates = new ArrayList<LogicGateWrapper>();
    }

    public ReactionWrapper(Reaction reaction, ModelWrapper modelW) {
        this.id = reaction.getId();
        this.baseReactants = new ArrayList<ReactantWrapper>();
        this.baseProducts = new ArrayList<ReactantWrapper>();
        this.additionalReactants = new ArrayList<ReactantWrapper>();
        this.additionalProducts = new ArrayList<ReactantWrapper>();
        this.modifiers = new ArrayList<ReactantWrapper>();
        this.logicGates = new ArrayList<LogicGateWrapper>();
        this.processSegmentIndex = ReactionWrapper.getProcessSegment(reaction);
        this.reactionType = ReactionType.valueOf(reaction.getAnnotation().getExtension().getReactionType());
        this.hasProcess = ReactionWrapper.hasProcess(reaction);
        this.isReversible = reaction.isReversible();
        this.lineWrapper = new LineWrapper(reaction.getAnnotation().getExtension().getConnectScheme(), reaction.getAnnotation().getExtension().getEditPoints(), reaction.getAnnotation().getExtension().getLine());
        this.notes = Utils.getNotes(reaction.getNotes());
        this.annotations = Utils.getRDFAnnotations(reaction.getAnnotation().getAny());
        AbstractMap.SimpleEntry<List<ReactantWrapper>, List<LogicGateWrapper>> wrapperListTuple = ReactantWrapper.fromReaction(reaction, modelW);
        List<ReactantWrapper> reactantWrapperList = wrapperListTuple.getKey();
        List<LogicGateWrapper> logicGateWrapperList = wrapperListTuple.getValue();
        this.logicGates.addAll(logicGateWrapperList);
        for (ReactantWrapper reactW : reactantWrapperList) {
            switch (reactW.getReactantType()) {
                case BASE_REACTANT: {
                    this.baseReactants.add(reactW);
                    break;
                }
                case BASE_PRODUCT: {
                    this.baseProducts.add(reactW);
                    break;
                }
                case ADDITIONAL_REACTANT: {
                    this.additionalReactants.add(reactW);
                    break;
                }
                case ADDITIONAL_PRODUCT: {
                    this.additionalProducts.add(reactW);
                    break;
                }
                case MODIFICATION: {
                    this.modifiers.add(reactW);
                }
            }
        }
    }

    public boolean isBranchTypeLeft() {
        if (this.baseReactants.size() > 1 && this.baseProducts.size() > 1) {
            throw new RuntimeException("Multiple branches on both sides of reaction: " + this.getId() + " unforeseen case.");
        }
        return this.baseReactants.size() > 1 && this.baseProducts.size() == 1;
    }

    public boolean isBranchTypeRight() {
        if (this.baseReactants.size() > 1 && this.baseProducts.size() > 1) {
            throw new RuntimeException("Multiple branches on both sides of reaction: " + this.getId() + " unforeseen case.");
        }
        return this.baseReactants.size() == 1 && this.baseProducts.size() > 1;
    }

    public boolean isBranchType() {
        return this.isBranchTypeLeft() || this.isBranchTypeRight();
    }

    public static int getProcessSegment(Reaction reaction) {
        ConnectScheme connectScheme = reaction.getAnnotation().getExtension().getConnectScheme();
        if (connectScheme == null) {
            logger.warn("ConnectScheme element missing for reaction: " + reaction.getId());
            return 0;
        }
        if (connectScheme.getRectangleIndex() != null) {
            return Integer.parseInt(connectScheme.getRectangleIndex());
        }
        if (reaction.getAnnotation().getExtension().getEditPoints() != null && reaction.getAnnotation().getExtension().getEditPoints().getTShapeIndex() != null) {
            return reaction.getAnnotation().getExtension().getEditPoints().getTShapeIndex().shortValue();
        }
        return 0;
    }

    public static boolean hasProcess(Reaction reaction) {
        ConnectScheme connectScheme = reaction.getAnnotation().getExtension().getConnectScheme();
        if (connectScheme == null) {
            return true;
        }
        if (connectScheme.getRectangleIndex() != null) {
            return true;
        }
        return reaction.getAnnotation().getExtension().getEditPoints() != null && reaction.getAnnotation().getExtension().getEditPoints().getTShapeIndex() != null;
    }

    public static List<Point2D.Float> parseEditPointsString(String editPointString) {
        ArrayList<Point2D.Float> editPoints = new ArrayList<Point2D.Float>();
        Arrays.stream(editPointString.split(" ")).forEach(e -> {
            String[] tmp = e.split(",");
            editPoints.add(new Point2D.Float(Float.parseFloat(tmp[0]), Float.parseFloat(tmp[1])));
        });
        return editPoints;
    }

    public static List<Point2D.Float> parseEditPointsString(List<String> editPointString) {
        ArrayList<Point2D.Float> editPoints = new ArrayList<Point2D.Float>();
        editPointString.stream().forEach(e -> {
            String[] tmp = e.split(",");
            editPoints.add(new Point2D.Float(Float.parseFloat(tmp[0]), Float.parseFloat(tmp[1])));
        });
        return editPoints;
    }

    public static List<Point2D.Float> getBaseEditPoints(Reaction reaction) {
        if (reaction.getAnnotation().getExtension().getEditPoints() == null) {
            return new ArrayList<Point2D.Float>();
        }
        List<String> editPointString = reaction.getAnnotation().getExtension().getEditPoints().getValue();
        return ReactionWrapper.parseEditPointsString(editPointString);
    }

    public List<Point2D.Float> getEditPointsForBranch(int b) {
        List<Point2D.Float> editPoints = this.getLineWrapper().getEditPoints();
        int num0 = this.getLineWrapper().getNum0();
        int num1 = this.getLineWrapper().getNum1();
        int num2 = this.getLineWrapper().getNum2();
        ArrayList<Point2D.Float> finalEditPoints = new ArrayList<Point2D.Float>();
        switch (b) {
            case 0: {
                for (int i = 0; i < num0; ++i) {
                    finalEditPoints.add(editPoints.get(i));
                }
                break;
            }
            case 1: {
                for (int i = num0; i < num0 + num1; ++i) {
                    finalEditPoints.add(editPoints.get(i));
                }
                break;
            }
            case 2: {
                for (int i = num0 + num1; i < num0 + num1 + num2; ++i) {
                    finalEditPoints.add(editPoints.get(i));
                }
                break;
            }
            default: {
                throw new RuntimeException("Value: " + b + " not allowed for branch index. Authorized values: 0, 1, 2.");
            }
        }
        return finalEditPoints;
    }

    public static List<Point2D.Float> getEditPointsForModifier(Reaction reaction, int index) {
        Modification modif = reaction.getAnnotation().getExtension().getListOfModification().getModification().get(index);
        if (modif.getEditPoints() == null) {
            return new ArrayList<Point2D.Float>();
        }
        if (modif.getEditPoints() != null) {
            List<String> editPointString = modif.getEditPoints();
            return ReactionWrapper.parseEditPointsString(editPointString);
        }
        return new ArrayList<Point2D.Float>();
    }

    public List<Point2D.Float> getEditPointsForModifier() {
        if (this.getLineWrapper().getEditPoints().size() == 0) {
            return new ArrayList<Point2D.Float>();
        }
        if (this.getLineWrapper().getEditPoints().size() > 0) {
            return this.getLineWrapper().getEditPoints();
        }
        return new ArrayList<Point2D.Float>();
    }

    public static List<Point2D.Float> getEditPointsForAdditionalReactant(Reaction reaction, int index) {
        ReactantLink reactLink = reaction.getAnnotation().getExtension().getListOfReactantLinks().getReactantLink().get(index);
        if (reactLink.getEditPoints() != null) {
            return ReactionWrapper.parseEditPointsString(reactLink.getEditPoints().getValue());
        }
        return new ArrayList<Point2D.Float>();
    }

    public static List<Point2D.Float> getEditPointsForAdditionalProduct(Reaction reaction, int index) {
        ProductLink reactLink = reaction.getAnnotation().getExtension().getListOfProductLinks().getProductLink().get(index);
        if (reactLink.getEditPoints() != null) {
            return ReactionWrapper.parseEditPointsString(reactLink.getEditPoints().getValue());
        }
        return new ArrayList<Point2D.Float>();
    }

    public Reaction getCDReaction() {
        boolean isBranchType;
        Reaction reaction = new Reaction();
        reaction.setId(this.getId());
        reaction.setMetaid(this.getId());
        reaction.setReversible(this.isReversible());
        ListOfSpeciesReferences listOfReactants = new ListOfSpeciesReferences();
        reaction.setListOfReactants(listOfReactants);
        ListOfSpeciesReferences listOfProducts = new ListOfSpeciesReferences();
        reaction.setListOfProducts(listOfProducts);
        ReactionAnnotationType annotation = new ReactionAnnotationType();
        reaction.setAnnotation(annotation);
        ReactionAnnotationType.Extension ext = new ReactionAnnotationType.Extension();
        annotation.setExtension(ext);
        ext.setReactionType(this.getReactionType().toString());
        ext.setConnectScheme(this.getLineWrapper().getCDConnectScheme());
        ext.setLine(this.getLineWrapper().getCDLine());
        boolean bl = isBranchType = this.getReactionType() == ReactionType.HETERODIMER_ASSOCIATION || this.getReactionType() == ReactionType.DISSOCIATION;
        if (this.getLineWrapper().getEditPoints().size() > 0) {
            ext.setEditPoints(this.getLineWrapper().getCDEditPoints(isBranchType));
        }
        int metaCounter = 1;
        BaseReactants baseReactants = new BaseReactants();
        ext.setBaseReactants(baseReactants);
        for (ReactantWrapper reactantWrapper : this.getBaseReactants()) {
            BaseReactant baseReactant = (BaseReactant)reactantWrapper.getCDElement();
            baseReactants.getBaseReactant().add(baseReactant);
            listOfReactants.getSpeciesReference().add(this.getSpeciesReference(reactantWrapper, metaCounter));
            ++metaCounter;
        }
        BaseProducts baseProducts = new BaseProducts();
        ext.setBaseProducts(baseProducts);
        for (ReactantWrapper reactantWrapper : this.getBaseProducts()) {
            BaseProduct baseProduct = (BaseProduct)reactantWrapper.getCDElement();
            baseProducts.getBaseProduct().add(baseProduct);
            listOfProducts.getSpeciesReference().add(this.getSpeciesReference(reactantWrapper, metaCounter));
            ++metaCounter;
        }
        if (this.getAdditionalReactants().size() > 0) {
            ListOfReactantLinks listOfReactantLinks = new ListOfReactantLinks();
            for (ReactantWrapper w : this.getAdditionalReactants()) {
                listOfReactantLinks.getReactantLink().add((ReactantLink)w.getCDElement());
                listOfReactants.getSpeciesReference().add(this.getSpeciesReference(w, metaCounter));
                ++metaCounter;
            }
            ext.setListOfReactantLinks(listOfReactantLinks);
        }
        if (this.getAdditionalProducts().size() > 0) {
            ListOfProductLinks listOfProductLinks = new ListOfProductLinks();
            for (ReactantWrapper w : this.getAdditionalProducts()) {
                listOfProductLinks.getProductLink().add((ProductLink)w.getCDElement());
                listOfProducts.getSpeciesReference().add(this.getSpeciesReference(w, metaCounter));
                ++metaCounter;
            }
            ext.setListOfProductLinks(listOfProductLinks);
        }
        if (this.getReactionType().equals("BOOLEAN_LOGIC_GATE")) {
            ListOfGateMember listOfGateMember = new ListOfGateMember();
            listOfGateMember.getGateMember().add(((LogicGateWrapper)this.getModifiers().get(0)).getCDElement());
            for (ReactantWrapper reactantWrapper : this.getBaseReactants()) {
                listOfGateMember.getGateMember().add(reactantWrapper.getAsModification());
            }
            ext.setListOfGateMember(listOfGateMember);
        } else if (this.getModifiers().size() > 0) {
            ListOfModifierSpeciesReferences listOfModifierSpeciesReferences = new ListOfModifierSpeciesReferences();
            reaction.setListOfModifiers(listOfModifierSpeciesReferences);
            ListOfModification listOfModification = new ListOfModification();
            logger.debug("Number of modifiers to serialize: " + this.getModifiers().size());
            for (ReactantWrapper w : this.getModifiers()) {
                listOfModification.getModification().add((Modification)w.getCDElement());
                logger.debug("modif type: " + (Object)((Object)w.getModificationLinkType()) + " " + w.getAliasW() + " " + this.getId() + " " + this.getModifiers().size() + " " + (w instanceof LogicGateWrapper));
                if (w.getAliasW() != null) {
                    logger.debug("isincluded ? " + w.getAliasW().getSpeciesW().isIncludedSpecies());
                }
                if (w.getModificationLinkType() == ModificationLinkType.BOOLEAN_LOGIC_GATE_UNKNOWN || w.getModificationLinkType() == ModificationLinkType.BOOLEAN_LOGIC_GATE_AND || w.getModificationLinkType() == ModificationLinkType.BOOLEAN_LOGIC_GATE_OR || w.getModificationLinkType() == ModificationLinkType.BOOLEAN_LOGIC_GATE_NOT) continue;
                listOfModifierSpeciesReferences.getModifierSpeciesReference().add(this.getModifierSpeciesReference(w, metaCounter));
                ++metaCounter;
            }
            ext.setListOfModification(listOfModification);
        }
        if (this.getNotes() != null) {
            SBase.Notes notes = new SBase.Notes();
            reaction.setNotes(notes);
            notes.getAny().add(this.getNotes());
        }
        if (this.getAnnotations() != null) {
            annotation.getAny().add(this.getAnnotations());
        }
        return reaction;
    }

    private SpeciesReference getSpeciesReference(ReactantWrapper w, int metaCount) {
        String speciesId;
        String aliasId;
        if (w.getAliasW().getSpeciesW().isIncludedSpecies()) {
            aliasId = w.getAliasW().getTopLevelParent().getId();
            speciesId = w.getAliasW().getTopLevelParent().getSpeciesId();
        } else {
            aliasId = w.getAliasW().getId();
            speciesId = w.getAliasW().getSpeciesW().getId();
        }
        SpeciesReference speciesReference = new SpeciesReference();
        speciesReference.setSpecies(speciesId);
        speciesReference.setMetaid(this.getId() + "_meta" + metaCount + "_" + speciesId);
        SpeciesReferenceAnnotationType speciesRefAnnotation = new SpeciesReferenceAnnotationType();
        speciesReference.setAnnotation(speciesRefAnnotation);
        SpeciesReferenceAnnotationType.Extension speciesRefExt = new SpeciesReferenceAnnotationType.Extension();
        speciesRefAnnotation.setExtension(speciesRefExt);
        speciesRefExt.setAlias(aliasId);
        return speciesReference;
    }

    private ModifierSpeciesReference getModifierSpeciesReference(ReactantWrapper w, int metaCount) {
        String speciesId;
        String aliasId;
        if (w.getAliasW().getSpeciesW().isIncludedSpecies()) {
            aliasId = w.getAliasW().getTopLevelParent().getId();
            speciesId = w.getAliasW().getTopLevelParent().getSpeciesId();
        } else {
            aliasId = w.getAliasW().getId();
            speciesId = w.getAliasW().getSpeciesW().getId();
        }
        ModifierSpeciesReference speciesReference = new ModifierSpeciesReference();
        speciesReference.setSpecies(speciesId);
        speciesReference.setMetaid(this.getId() + "_meta" + metaCount + "_" + speciesId);
        SpeciesReferenceAnnotationType speciesRefAnnotation = new SpeciesReferenceAnnotationType();
        speciesReference.setAnnotation(speciesRefAnnotation);
        SpeciesReferenceAnnotationType.Extension speciesRefExt = new SpeciesReferenceAnnotationType.Extension();
        speciesRefAnnotation.setExtension(speciesRefExt);
        speciesRefExt.setAlias(aliasId);
        return speciesReference;
    }

    public boolean hasProcess() {
        return this.hasProcess;
    }

    public List<ReactantWrapper> getReactantList() {
        ArrayList<ReactantWrapper> reactList = new ArrayList<ReactantWrapper>();
        reactList.addAll(this.getBaseReactants());
        reactList.addAll(this.getBaseProducts());
        reactList.addAll(this.getAdditionalReactants());
        reactList.addAll(this.getAdditionalProducts());
        reactList.addAll(this.getModifiers());
        return reactList;
    }

    public String getId() {
        return this.id;
    }

    public List<ReactantWrapper> getBaseReactants() {
        return this.baseReactants;
    }

    public List<ReactantWrapper> getBaseProducts() {
        return this.baseProducts;
    }

    public List<ReactantWrapper> getAdditionalReactants() {
        return this.additionalReactants;
    }

    public List<ReactantWrapper> getAdditionalProducts() {
        return this.additionalProducts;
    }

    public List<ReactantWrapper> getModifiers() {
        return this.modifiers;
    }

    public int getProcessSegmentIndex() {
        return this.processSegmentIndex;
    }

    public ReactionType getReactionType() {
        return this.reactionType;
    }

    public List<LogicGateWrapper> getLogicGates() {
        return this.logicGates;
    }

    public boolean isReversible() {
        return this.isReversible;
    }

    public LineWrapper getLineWrapper() {
        return this.lineWrapper;
    }

    public void setLineWrapper(LineWrapper lineWrapper) {
        this.lineWrapper = lineWrapper;
    }

    @Override
    public Element getNotes() {
        return this.notes;
    }

    @Override
    public Element getAnnotations() {
        return this.annotations;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setProcessSegmentIndex(int processSegmentIndex) {
        this.processSegmentIndex = processSegmentIndex;
    }

    public void setReactionType(ReactionType reactionType) {
        this.reactionType = reactionType;
    }

    public void setHasProcess(boolean hasProcess) {
        this.hasProcess = hasProcess;
    }

    public void setReversible(boolean reversible) {
        this.isReversible = reversible;
    }

    @Override
    public void setNotes(Element notes) {
        this.notes = notes;
    }

    @Override
    public void setAnnotations(Element annotations) {
        this.annotations = annotations;
    }
}

