/*
 * Decompiled with CFR 0.152.
 */
package fr.curie.cd2sbgnml.xmlcdwrappers;

import fr.curie.cd2sbgnml.xmlcdwrappers.AliasWrapper;
import fr.curie.cd2sbgnml.xmlcdwrappers.ReactantWrapper;
import fr.curie.cd2sbgnml.xmlcdwrappers.ReactionWrapper;
import fr.curie.cd2sbgnml.xmlcdwrappers.SpeciesWrapper;
import fr.curie.cd2sbgnml.xmlcdwrappers.TextWrapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.sbml._2001.ns.celldesigner.AntisenseRNA;
import org.sbml._2001.ns.celldesigner.CompartmentAlias;
import org.sbml._2001.ns.celldesigner.ComplexSpeciesAlias;
import org.sbml._2001.ns.celldesigner.Gene;
import org.sbml._2001.ns.celldesigner.Layer;
import org.sbml._2001.ns.celldesigner.LayerSpeciesAlias;
import org.sbml._2001.ns.celldesigner.ListOfComplexSpeciesAliases;
import org.sbml._2001.ns.celldesigner.Protein;
import org.sbml._2001.ns.celldesigner.RNA;
import org.sbml._2001.ns.celldesigner.Species;
import org.sbml._2001.ns.celldesigner.SpeciesAlias;
import org.sbml.sbml.level2.version4.Compartment;
import org.sbml.sbml.level2.version4.Model;
import org.sbml.sbml.level2.version4.Reaction;
import org.sbml.sbml.level2.version4.Sbml;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelWrapper {
    private final Logger logger = LoggerFactory.getLogger(ModelWrapper.class);
    private Model model;
    private List<org.sbml.sbml.level2.version4.Species> listOfSpecies;
    private List<Compartment> listOfCompartments;
    private List<Species> listOfIncludedSpecies;
    private List<CompartmentAlias> listOfCompartmentAliases;
    private List<SpeciesAlias> listOfSpeciesAliases;
    private List<ListOfComplexSpeciesAliases.ComplexSpeciesAlias> listOfComplexSpeciesAliases;
    private List<Reaction> listOfReactions;
    private List<Protein> listOfProtein;
    private List<RNA> listOfRna;
    private List<AntisenseRNA> listOfAntisenseRna;
    private List<Gene> listOfGene;
    private List<Layer> listOfLayers;
    private HashMap<String, org.sbml.sbml.level2.version4.Species> mapOfSpecies;
    private HashMap<String, Species> mapOfIncludedSpecies;
    private HashMap<String, Protein> mapOfProtein;
    private HashMap<String, RNA> mapOfRna;
    private HashMap<String, AntisenseRNA> mapOfAntisenseRna;
    private HashMap<String, Gene> mapOfGene;
    private HashMap<String, List<CompartmentAlias>> compartment2aliasMap;
    private HashMap<String, List<SpeciesAlias>> species2aliasMap;
    private HashMap<String, List<ComplexSpeciesAlias>> complexSpecies2aliasMap;
    private List<SpeciesWrapper> listOfSpeciesWrapper;
    private List<AliasWrapper> listofAliasWrapper;
    private List<TextWrapper> listofTextWrapper;
    private HashMap<String, SpeciesWrapper> mapOfSpeciesWrapper;
    private HashMap<String, AliasWrapper> mapOfAliasWrapper;
    private HashMap<String, List<AliasWrapper>> complexSpeciesAlias2speciesAliasWrapper;
    private List<ReactionWrapper> listOfReactionWrapper;
    private HashMap<String, ReactionWrapper> mapOfReactionWrapper;
    private HashMap<String, List<ReactantWrapper>> alias2reactantWrapper;

    public static ModelWrapper create(Sbml sbmlDoc) {
        ModelWrapper modelW = new ModelWrapper();
        modelW.model = sbmlDoc.getModel();
        modelW.addBasicLists();
        modelW.addBasicMaps();
        modelW.addWrapperListsAndMaps();
        modelW.addComplexNestingIndex();
        modelW.addReactionStructures();
        return modelW;
    }

    private void addBasicLists() {
        this.listOfSpecies = this.model.getListOfSpecies().getSpecies();
        this.listOfCompartments = this.model.getListOfCompartments().getCompartment();
        this.listOfCompartmentAliases = this.model.getAnnotation().getExtension().getListOfCompartmentAliases().getCompartmentAlias();
        this.listOfSpeciesAliases = this.model.getAnnotation().getExtension().getListOfSpeciesAliases().getSpeciesAlias();
        this.listOfComplexSpeciesAliases = this.model.getAnnotation().getExtension().getListOfComplexSpeciesAliases().getComplexSpeciesAlias();
        this.listOfIncludedSpecies = this.model.getAnnotation().getExtension().getListOfIncludedSpecies() != null ? this.model.getAnnotation().getExtension().getListOfIncludedSpecies().getSpecies() : new ArrayList<Species>();
        if (this.model.getListOfReactions() == null || this.model.getListOfReactions().getReaction().size() == 0) {
            this.logger.warn("No reaction found.");
            this.listOfReactions = new ArrayList<Reaction>();
        } else {
            this.listOfReactions = this.model.getListOfReactions().getReaction();
        }
        this.listOfProtein = this.model.getAnnotation().getExtension().getListOfProteins().getProtein();
        this.listOfRna = this.model.getAnnotation().getExtension().getListOfRNAs().getRNA();
        this.listOfAntisenseRna = this.model.getAnnotation().getExtension().getListOfAntisenseRNAs().getAntisenseRNA();
        this.listOfGene = this.model.getAnnotation().getExtension().getListOfGenes().getGene();
        this.listOfLayers = this.model.getAnnotation().getExtension().getListOfLayers().getLayer();
        this.listofTextWrapper = new ArrayList<TextWrapper>();
        for (Layer layer : this.listOfLayers) {
            if (layer.getListOfTexts() == null) continue;
            for (LayerSpeciesAlias text : layer.getListOfTexts().getLayerSpeciesAlias()) {
                this.listofTextWrapper.add(new TextWrapper(text, layer.isVisible()));
            }
        }
    }

    private void addBasicMaps() {
        this.mapOfSpecies = new HashMap();
        for (org.sbml.sbml.level2.version4.Species species : this.listOfSpecies) {
            this.mapOfSpecies.put(species.getId(), species);
        }
        this.mapOfIncludedSpecies = new HashMap();
        for (Species species : this.listOfIncludedSpecies) {
            this.mapOfIncludedSpecies.put(species.getId(), species);
        }
        this.mapOfProtein = new HashMap();
        for (Protein protein : this.listOfProtein) {
            this.mapOfProtein.put(protein.getId(), protein);
        }
        this.mapOfRna = new HashMap();
        for (RNA rNA : this.listOfRna) {
            this.mapOfRna.put(rNA.getId(), rNA);
        }
        this.mapOfAntisenseRna = new HashMap();
        for (AntisenseRNA antisenseRNA : this.listOfAntisenseRna) {
            this.mapOfAntisenseRna.put(antisenseRNA.getId(), antisenseRNA);
        }
        this.mapOfGene = new HashMap();
        for (Gene gene : this.listOfGene) {
            this.mapOfGene.put(gene.getId(), gene);
        }
        this.compartment2aliasMap = new HashMap();
        for (CompartmentAlias compartmentAlias : this.listOfCompartmentAliases) {
            if (!this.compartment2aliasMap.containsKey(compartmentAlias.getCompartment())) {
                this.compartment2aliasMap.put(compartmentAlias.getCompartment(), new ArrayList());
            }
            this.compartment2aliasMap.get(compartmentAlias.getCompartment()).add(compartmentAlias);
        }
        this.species2aliasMap = new HashMap();
        for (SpeciesAlias speciesAlias : this.listOfSpeciesAliases) {
            if (!this.species2aliasMap.containsKey(speciesAlias.getSpecies())) {
                this.species2aliasMap.put(speciesAlias.getSpecies(), new ArrayList());
            }
            this.species2aliasMap.get(speciesAlias.getSpecies()).add(speciesAlias);
        }
        this.complexSpecies2aliasMap = new HashMap();
        for (ComplexSpeciesAlias complexSpeciesAlias : this.listOfComplexSpeciesAliases) {
            if (!this.complexSpecies2aliasMap.containsKey(complexSpeciesAlias.getSpecies())) {
                this.complexSpecies2aliasMap.put(complexSpeciesAlias.getSpecies(), new ArrayList());
            }
            this.complexSpecies2aliasMap.get(complexSpeciesAlias.getSpecies()).add(complexSpeciesAlias);
        }
    }

    private void addWrapperListsAndMaps() {
        SpeciesWrapper speciesW;
        this.listOfSpeciesWrapper = new ArrayList<SpeciesWrapper>();
        this.listofAliasWrapper = new ArrayList<AliasWrapper>();
        this.mapOfSpeciesWrapper = new HashMap();
        this.mapOfAliasWrapper = new HashMap();
        this.logger.info("Wrapping " + this.listOfSpecies.size() + " species");
        for (org.sbml.sbml.level2.version4.Species species : this.listOfSpecies) {
            this.logger.debug("Parse species: " + species.getId());
            speciesW = new SpeciesWrapper(species, this);
            this.listOfSpeciesWrapper.add(speciesW);
            this.mapOfSpeciesWrapper.put(speciesW.getId(), speciesW);
            for (AliasWrapper aliasW : speciesW.getAliases()) {
                this.listofAliasWrapper.add(aliasW);
                this.mapOfAliasWrapper.put(aliasW.getId(), aliasW);
            }
        }
        this.logger.info(this.listofAliasWrapper.size() + " alias wrapper added");
        this.logger.info("Wrapping " + this.listOfIncludedSpecies.size() + " included species");
        for (Species species : this.listOfIncludedSpecies) {
            this.logger.debug("Parse included species: " + species.getId());
            speciesW = new SpeciesWrapper(species, this);
            this.listOfSpeciesWrapper.add(speciesW);
            this.mapOfSpeciesWrapper.put(speciesW.getId(), speciesW);
            for (AliasWrapper aliasW : speciesW.getAliases()) {
                this.listofAliasWrapper.add(aliasW);
                this.mapOfAliasWrapper.put(aliasW.getId(), aliasW);
            }
        }
        this.logger.info(this.listOfSpeciesWrapper.size() + " species wrapper total");
        this.logger.info(this.listofAliasWrapper.size() + " alias wrapper total");
    }

    private void addComplexNestingIndex() {
        AliasWrapper aliasW;
        this.complexSpeciesAlias2speciesAliasWrapper = new HashMap();
        for (ComplexSpeciesAlias complexSpeciesAlias : this.listOfComplexSpeciesAliases) {
            aliasW = this.getAliasWrapperFor(complexSpeciesAlias.getId());
            if (aliasW.getComplexAlias() == null) continue;
            if (!this.complexSpeciesAlias2speciesAliasWrapper.containsKey(aliasW.getComplexAlias())) {
                this.complexSpeciesAlias2speciesAliasWrapper.put(aliasW.getComplexAlias(), new ArrayList());
            }
            this.complexSpeciesAlias2speciesAliasWrapper.get(aliasW.getComplexAlias()).add(aliasW);
        }
        for (SpeciesAlias speciesAlias : this.listOfSpeciesAliases) {
            aliasW = this.getAliasWrapperFor(speciesAlias.getId());
            if (aliasW.getComplexAlias() == null) continue;
            if (!this.complexSpeciesAlias2speciesAliasWrapper.containsKey(aliasW.getComplexAlias())) {
                this.complexSpeciesAlias2speciesAliasWrapper.put(aliasW.getComplexAlias(), new ArrayList());
            }
            this.complexSpeciesAlias2speciesAliasWrapper.get(aliasW.getComplexAlias()).add(aliasW);
        }
    }

    private void addReactionStructures() {
        this.listOfReactionWrapper = new ArrayList<ReactionWrapper>();
        this.mapOfReactionWrapper = new HashMap();
        this.alias2reactantWrapper = new HashMap();
        for (Reaction reaction : this.listOfReactions) {
            this.logger.info("Parse reaction " + reaction.getId());
            ReactionWrapper reactionW = new ReactionWrapper(reaction, this);
            this.listOfReactionWrapper.add(reactionW);
            this.mapOfReactionWrapper.put(reactionW.getId(), reactionW);
            for (ReactantWrapper reactantW : reactionW.getReactantList()) {
                if (!this.alias2reactantWrapper.containsKey(reactantW.getAliasW().getId())) {
                    this.alias2reactantWrapper.put(reactantW.getAliasW().getId(), new ArrayList());
                }
                this.alias2reactantWrapper.get(reactantW.getAliasW().getId()).add(reactantW);
            }
        }
    }

    public Model getModel() {
        return this.model;
    }

    public List<org.sbml.sbml.level2.version4.Species> getListOfSpecies() {
        return this.listOfSpecies;
    }

    public org.sbml.sbml.level2.version4.Species getSpecies(String id) {
        return this.mapOfSpecies.get(id);
    }

    public List<Compartment> getListOfCompartments() {
        return this.listOfCompartments;
    }

    public List<Species> getListOfIncludedSpecies() {
        return this.listOfIncludedSpecies;
    }

    public Species getIncludedSpecies(String id) {
        return this.mapOfIncludedSpecies.get(id);
    }

    public List<CompartmentAlias> getListOfCompartmentAliases() {
        return this.listOfCompartmentAliases;
    }

    public List<SpeciesAlias> getListOfSpeciesAliases() {
        return this.listOfSpeciesAliases;
    }

    public List<ListOfComplexSpeciesAliases.ComplexSpeciesAlias> getListOfComplexSpeciesAliases() {
        return this.listOfComplexSpeciesAliases;
    }

    public List<Reaction> getListOfReactions() {
        return this.listOfReactions;
    }

    public List<Protein> getListOfProtein() {
        return this.listOfProtein;
    }

    public List<RNA> getListOfRna() {
        return this.listOfRna;
    }

    public List<AntisenseRNA> getListOfAntisenseRna() {
        return this.listOfAntisenseRna;
    }

    public List<Gene> getListOfGene() {
        return this.listOfGene;
    }

    public Protein getProtein(String id) {
        return this.mapOfProtein.get(id);
    }

    public RNA getRNA(String id) {
        return this.mapOfRna.get(id);
    }

    public AntisenseRNA getAntisenseRNA(String id) {
        return this.mapOfAntisenseRna.get(id);
    }

    public Gene getGene(String id) {
        return this.mapOfGene.get(id);
    }

    public List<CompartmentAlias> getCompartmentAliasFor(String compartmentId) {
        return this.compartment2aliasMap.get(compartmentId);
    }

    public List<SpeciesAlias> getSpeciesAliasFor(String speciesId) {
        return this.species2aliasMap.get(speciesId);
    }

    public List<ComplexSpeciesAlias> getComplexSpeciesAliasFor(String speciesId) {
        return this.complexSpecies2aliasMap.get(speciesId);
    }

    public List<AliasWrapper> getIncludedAliasWrapperFor(String complexAliasId) {
        return this.complexSpeciesAlias2speciesAliasWrapper.get(complexAliasId);
    }

    public AliasWrapper getAliasWrapperFor(String aliasId) {
        return this.mapOfAliasWrapper.get(aliasId);
    }

    public SpeciesWrapper getSpeciesWrapperFor(String speciesId) {
        return this.mapOfSpeciesWrapper.get(speciesId);
    }

    public List<SpeciesWrapper> getListOfSpeciesWrapper() {
        return this.listOfSpeciesWrapper;
    }

    public List<AliasWrapper> getListofAliasWrapper() {
        return this.listofAliasWrapper;
    }

    public List<ReactionWrapper> getListOfReactionWrapper() {
        return this.listOfReactionWrapper;
    }

    public ReactionWrapper getReactionWrapperFor(String reactionId) {
        return this.mapOfReactionWrapper.get(reactionId);
    }

    public List<ReactantWrapper> getReactionWrappersForAlias(String aliasId) {
        return this.alias2reactantWrapper.get(aliasId);
    }

    public List<Layer> getListOfLayers() {
        return this.listOfLayers;
    }

    public List<TextWrapper> getListofTextWrapper() {
        return this.listofTextWrapper;
    }
}

