/*
 * Decompiled with CFR 0.152.
 */
package fr.curie.cd2sbgnml.xmlcdwrappers;

import java.awt.geom.Point2D;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.sbml._2001.ns.celldesigner.ConnectScheme;
import org.sbml._2001.ns.celldesigner.EditPoints;
import org.sbml._2001.ns.celldesigner.Line;
import org.sbml._2001.ns.celldesigner.LineDirection;
import org.sbml._2001.ns.celldesigner.LineType2;
import org.sbml._2001.ns.celldesigner.ListOfLineDirection;

public class LineWrapper {
    private float lineWidth;
    private String lineColor;
    private String lineType;
    private List<Point2D.Float> editPoints;
    private int num0;
    private int num1;
    private int num2;
    private int tShapeIndex;
    private String connectPolicy = "direct";
    private String rectangleIndex = "0";
    private List<LineDirection> lineDirectionList;

    public LineWrapper(ConnectScheme connectScheme, EditPoints editPoints, Line line) {
        this(connectScheme, line.getWidth().floatValue(), line.getColor(), null);
        this.setEditPoints(editPoints);
    }

    public LineWrapper(ConnectScheme connectScheme, EditPoints editPoints, LineType2 line) {
        this(connectScheme, line.getWidth().floatValue(), line.getColor(), line.getType());
        this.setEditPoints(editPoints);
    }

    public LineWrapper(ConnectScheme connectScheme, List<String> editPoints, Line line) {
        this(connectScheme, line.getWidth().floatValue(), line.getColor(), null);
        ArrayList<Point2D.Float> pointList = new ArrayList<Point2D.Float>();
        if (editPoints != null) {
            for (String pointString : editPoints) {
                String[] tmp = pointString.split(",");
                float x = Float.parseFloat(tmp[0]);
                float y = Float.parseFloat(tmp[1]);
                pointList.add(new Point2D.Float(x, y));
            }
        }
        this.editPoints = pointList;
    }

    public LineWrapper(ConnectScheme connectScheme, List<String> editPoints, LineType2 line) {
        this(connectScheme, line.getWidth().floatValue(), line.getColor(), line.getType());
        ArrayList<Point2D.Float> pointList = new ArrayList<Point2D.Float>();
        if (editPoints != null) {
            for (String pointString : editPoints) {
                String[] tmp = pointString.split(",");
                float x = Float.parseFloat(tmp[0]);
                float y = Float.parseFloat(tmp[1]);
                pointList.add(new Point2D.Float(x, y));
            }
        }
        this.editPoints = pointList;
    }

    private LineWrapper(ConnectScheme connectScheme, float width, String color, String type) {
        this.lineWidth = width;
        this.lineColor = color;
        this.lineType = type;
        this.lineDirectionList = new ArrayList<LineDirection>();
        LineDirection defaultLine = new LineDirection();
        defaultLine.setIndex((short)0);
        defaultLine.setValue("unknown");
        this.lineDirectionList.add(defaultLine);
        if (connectScheme != null) {
            this.connectPolicy = connectScheme.getConnectPolicy();
            this.rectangleIndex = connectScheme.getRectangleIndex();
            if (null != connectScheme.getListOfLineDirection()) {
                this.lineDirectionList = connectScheme.getListOfLineDirection().getLineDirection();
            }
        }
    }

    private void setEditPoints(EditPoints editPoints) {
        if (editPoints != null) {
            if (editPoints.getNum0() != null) {
                this.num0 = editPoints.getNum0().shortValue();
            }
            if (editPoints.getNum1() != null) {
                this.num1 = editPoints.getNum1().shortValue();
            }
            if (editPoints.getNum2() != null) {
                this.num2 = editPoints.getNum2().shortValue();
            }
            if (editPoints.getTShapeIndex() != null) {
                this.tShapeIndex = editPoints.getTShapeIndex().shortValue();
            }
            if (editPoints.getValue() != null) {
                ArrayList<Point2D.Float> pointList = new ArrayList<Point2D.Float>();
                for (String pointString : editPoints.getValue()) {
                    String[] tmp = pointString.split(",");
                    float x = Float.parseFloat(tmp[0]);
                    float y = Float.parseFloat(tmp[1]);
                    pointList.add(new Point2D.Float(x, y));
                }
                this.editPoints = pointList;
            }
        }
    }

    public ConnectScheme getCDConnectScheme() {
        ConnectScheme connectScheme = new ConnectScheme();
        ListOfLineDirection listOfLineDirection = new ListOfLineDirection();
        for (LineDirection ld : this.getLineDirectionList()) {
            listOfLineDirection.getLineDirection().add(ld);
        }
        connectScheme.setListOfLineDirection(listOfLineDirection);
        connectScheme.setRectangleIndex(this.getRectangleIndex());
        connectScheme.setConnectPolicy(this.getConnectPolicy());
        return connectScheme;
    }

    public Line getCDLine() {
        Line line = new Line();
        line.setColor(this.getLineColor());
        line.setWidth(BigDecimal.valueOf(this.getLineWidth()));
        return line;
    }

    public LineType2 getCDLineType2() {
        LineType2 line = new LineType2();
        line.setColor(this.getLineColor());
        line.setWidth(BigDecimal.valueOf(this.getLineWidth()));
        line.setType(this.getLineType());
        return line;
    }

    public EditPoints getCDEditPoints(boolean isBranchType) {
        EditPoints editPoints = new EditPoints();
        if (isBranchType) {
            editPoints.setNum0((short)this.getNum0());
            editPoints.setNum1((short)this.getNum1());
            editPoints.setNum2((short)this.getNum2());
            editPoints.setTShapeIndex((short)this.gettShapeIndex());
        }
        for (Point2D.Float p : this.getEditPoints()) {
            editPoints.getValue().add(p.getX() + "," + p.getY());
        }
        return editPoints;
    }

    public List<String> editPointsAsStringList() {
        ArrayList<String> editPointString = new ArrayList<String>();
        for (Point2D.Float p : this.getEditPoints()) {
            editPointString.add(p.getX() + "," + p.getY());
        }
        return editPointString;
    }

    public float getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(float lineWidth) {
        this.lineWidth = lineWidth;
    }

    public String getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(String lineColor) {
        this.lineColor = lineColor;
    }

    public String getLineType() {
        return this.lineType;
    }

    public void setLineType(String lineType) {
        this.lineType = lineType;
    }

    public List<Point2D.Float> getEditPoints() {
        if (this.editPoints == null) {
            return new ArrayList<Point2D.Float>();
        }
        return this.editPoints;
    }

    public void setEditPoints(List<Point2D.Float> editPoints) {
        this.editPoints = editPoints;
    }

    public int getNum0() {
        return this.num0;
    }

    public void setNum0(int num0) {
        this.num0 = num0;
    }

    public int getNum1() {
        return this.num1;
    }

    public void setNum1(int num1) {
        this.num1 = num1;
    }

    public int getNum2() {
        return this.num2;
    }

    public void setNum2(int num2) {
        this.num2 = num2;
    }

    public int gettShapeIndex() {
        return this.tShapeIndex;
    }

    public void settShapeIndex(int tShapeIndex) {
        this.tShapeIndex = tShapeIndex;
    }

    public String getConnectPolicy() {
        return this.connectPolicy;
    }

    public void setConnectPolicy(String connectPolicy) {
        this.connectPolicy = connectPolicy;
    }

    public String getRectangleIndex() {
        return this.rectangleIndex;
    }

    public void setRectangleIndex(String rectangleIndex) {
        this.rectangleIndex = rectangleIndex;
    }

    public List<LineDirection> getLineDirectionList() {
        return this.lineDirectionList;
    }

    public void setLineDirectionList(List<LineDirection> lineDirectionList) {
        this.lineDirectionList = lineDirectionList;
    }
}

