/*
 * Decompiled with CFR 0.152.
 */
package fr.curie.cd2sbgnml.model;

import fr.curie.cd2sbgnml.graphics.GeometryUtils;
import fr.curie.cd2sbgnml.graphics.Glyph;
import fr.curie.cd2sbgnml.model.GenericReactionElement;
import fr.curie.cd2sbgnml.xmlcdwrappers.StyleInfo;
import java.awt.geom.Point2D;

public class ReactionNodeModel
extends GenericReactionElement {
    private float portDistanceRatio;
    private StyleInfo styleInfo;
    private float size;
    private Point2D.Float portIn;
    private Point2D.Float portOut;
    private Orientation orientation;

    public ReactionNodeModel(Glyph glyph, String id, float size, float portDistanceRatio, StyleInfo styleInfo) {
        super(glyph, id);
        this.styleInfo = styleInfo;
        this.size = size;
        this.portDistanceRatio = portDistanceRatio;
    }

    public void setPorts(Point2D pIn, Point2D pOut) {
        float slope = GeometryUtils.lineSlope(pIn, pOut);
        if (slope > -1.0f && slope < 1.0f) {
            this.orientation = Orientation.HORIZONTAL;
            Point2D.Float p1 = new Point2D.Float((float)(this.getGlyph().getCenter().getX() - (double)(this.getSize() / 2.0f) - (double)(this.getSize() * this.getPortDistanceRatio())), (float)this.getGlyph().getCenter().getY());
            Point2D.Float p2 = new Point2D.Float((float)(this.getGlyph().getCenter().getX() + (double)(this.getSize() / 2.0f) + (double)(this.getSize() * this.getPortDistanceRatio())), (float)this.getGlyph().getCenter().getY());
            if (pIn.getX() < pOut.getX()) {
                this.portIn = p1;
                this.portOut = p2;
            } else {
                this.portIn = p2;
                this.portOut = p1;
            }
        } else {
            this.orientation = Orientation.VERTICAL;
            Point2D.Float p1 = new Point2D.Float((float)this.getGlyph().getCenter().getX(), (float)(this.getGlyph().getCenter().getY() - (double)(this.getSize() / 2.0f) - (double)(this.getSize() * this.getPortDistanceRatio())));
            Point2D.Float p2 = new Point2D.Float((float)this.getGlyph().getCenter().getX(), (float)(this.getGlyph().getCenter().getY() + (double)(this.getSize() / 2.0f) + (double)(this.getSize() * this.getPortDistanceRatio())));
            if (pIn.getY() < pOut.getY()) {
                this.portIn = p1;
                this.portOut = p2;
            } else {
                this.portIn = p2;
                this.portOut = p1;
            }
        }
    }

    public StyleInfo getStyleInfo() {
        return this.styleInfo;
    }

    public float getSize() {
        return this.size;
    }

    public Point2D.Float getPortIn() {
        return this.portIn;
    }

    public Point2D.Float getPortOut() {
        return this.portOut;
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    public float getPortDistanceRatio() {
        return this.portDistanceRatio;
    }

    public static enum Orientation {
        HORIZONTAL,
        VERTICAL;

    }
}

