/*
 * Decompiled with CFR 0.152.
 */
package fr.curie.cd2sbgnml.model;

import fr.curie.cd2sbgnml.graphics.CdShape;
import fr.curie.cd2sbgnml.graphics.Glyph;
import fr.curie.cd2sbgnml.graphics.SbgnShape;
import fr.curie.cd2sbgnml.model.ReactionNodeModel;
import fr.curie.cd2sbgnml.xmlcdwrappers.LogicGateWrapper;
import fr.curie.cd2sbgnml.xmlcdwrappers.StyleInfo;
import java.awt.geom.Point2D;
import org.sbgn.GlyphClazz;

public class LogicGate
extends ReactionNodeModel {
    private static final float LOGICGATE_SIZE = 20.0f;
    private static final float PORT_DISTANCE_RATIO = 0.5f;
    private LogicGateWrapper.LogicGateType type;

    public LogicGate(Glyph glyph, String id, LogicGateWrapper.LogicGateType type, StyleInfo styleInfo) {
        super(glyph, id, 20.0f, 0.5f, styleInfo);
        this.type = type;
    }

    public LogicGate(Point2D.Float centerCoords, String id, LogicGateWrapper.LogicGateType type, StyleInfo styleInfo) {
        super(new Glyph(centerCoords, 20.0f, 20.0f, CdShape.CIRCLE, SbgnShape.CIRCLE), id, 20.0f, 0.5f, styleInfo);
        this.type = type;
    }

    public static String getSbgnClass(LogicGateWrapper.LogicGateType logicType) {
        switch (logicType) {
            case OR: {
                return "or";
            }
            case AND: {
                return "and";
            }
            case NOT: {
                return "not";
            }
        }
        throw new IllegalArgumentException("Could not infer SBGN class from logic type: " + (Object)((Object)logicType));
    }

    public static LogicGateWrapper.LogicGateType getLogicGateType(GlyphClazz clazz) {
        switch (clazz) {
            case OR: {
                return LogicGateWrapper.LogicGateType.OR;
            }
            case AND: {
                return LogicGateWrapper.LogicGateType.AND;
            }
            case NOT: {
                return LogicGateWrapper.LogicGateType.NOT;
            }
        }
        throw new IllegalArgumentException("Could not infer logic gate type from SBGN class: " + (Object)((Object)clazz));
    }

    public LogicGateWrapper.LogicGateType getType() {
        return this.type;
    }
}

