/*
 * Decompiled with CFR 0.152.
 */
package fr.curie.cd2sbgnml.graphics;

import fr.curie.cd2sbgnml.graphics.AnchorPoint;
import fr.curie.cd2sbgnml.graphics.CdShape;
import fr.curie.cd2sbgnml.graphics.Glyph;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeometryUtils {
    private static final Logger logger = LoggerFactory.getLogger(GeometryUtils.class);

    public static AffineTransform getTransformsToGlobalCoords(Point2D origin, Point2D px) {
        AffineTransform initTransform = GeometryUtils.getTransformsToLocalCoords(origin, px);
        AffineTransform reverse = null;
        try {
            reverse = initTransform.createInverse();
        }
        catch (NoninvertibleTransformException e) {
            logger.error("Matrix transform error, results may be incorrect: " + e.getMessage());
            e.printStackTrace();
        }
        return reverse;
    }

    public static AffineTransform getTransformsToLocalCoords(Point2D origin, Point2D px) {
        Point2D.Double originCopy = new Point2D.Double(origin.getX(), origin.getY());
        Point2D.Double pxCopy = new Point2D.Double(px.getX(), px.getY());
        AffineTransform t1_5 = new AffineTransform();
        t1_5.translate(-((Point2D)originCopy).getX(), -((Point2D)originCopy).getY());
        t1_5.transform(pxCopy, pxCopy);
        double angle = GeometryUtils.angle(new Point2D.Float(1.0f, 0.0f), pxCopy);
        AffineTransform t2 = new AffineTransform();
        t2.rotate(-angle);
        t2.transform(pxCopy, pxCopy);
        AffineTransform t3 = new AffineTransform();
        t3.scale(1.0 / ((Point2D)pxCopy).getX(), 1.0 / ((Point2D)pxCopy).getX());
        t3.transform(pxCopy, pxCopy);
        AffineTransform finalTransform = new AffineTransform();
        finalTransform.concatenate(t3);
        finalTransform.concatenate(t2);
        finalTransform.concatenate(t1_5);
        return finalTransform;
    }

    public static AffineTransform getTransformsToLocalCoords(Point2D origin, Point2D px, Point2D py) {
        Point2D.Double originCopy = new Point2D.Double(origin.getX(), origin.getY());
        Point2D.Double pxCopy = new Point2D.Double(px.getX(), px.getY());
        Point2D.Double pyCopy = new Point2D.Double(py.getX(), py.getY());
        AffineTransform t1 = new AffineTransform();
        t1.translate(-((Point2D)originCopy).getX(), -((Point2D)originCopy).getY());
        t1.transform(pxCopy, pxCopy);
        t1.transform(pyCopy, pyCopy);
        double angle = GeometryUtils.angle(new Point2D.Float(1.0f, 0.0f), pxCopy);
        AffineTransform t2 = new AffineTransform();
        t2.rotate(-angle);
        t2.transform(pxCopy, pxCopy);
        t2.transform(pyCopy, pyCopy);
        double shearFactor = ((Point2D)pyCopy).getX() / ((Point2D)pyCopy).getY();
        AffineTransform t3 = new AffineTransform();
        t3.shear(-shearFactor, 0.0);
        t3.transform(pxCopy, pxCopy);
        t3.transform(pyCopy, pyCopy);
        AffineTransform t4 = new AffineTransform();
        t4.scale(1.0 / ((Point2D)pxCopy).getX(), 1.0 / ((Point2D)pyCopy).getY());
        t4.transform(pxCopy, pxCopy);
        t4.transform(pyCopy, pyCopy);
        AffineTransform finalTransform = new AffineTransform();
        finalTransform.concatenate(t4);
        finalTransform.concatenate(t3);
        finalTransform.concatenate(t2);
        finalTransform.concatenate(t1);
        return finalTransform;
    }

    public static AffineTransform getTransformsToGlobalCoords(Point2D origin, Point2D px, Point2D py) {
        AffineTransform initTransform = GeometryUtils.getTransformsToLocalCoords(origin, px, py);
        AffineTransform reverse = null;
        try {
            reverse = initTransform.createInverse();
        }
        catch (NoninvertibleTransformException e) {
            logger.error("Matrix transform error, results may be incorrect: " + e.getMessage());
            e.printStackTrace();
        }
        return reverse;
    }

    public static double angle(Point2D v1, Point2D v2) {
        return Math.atan2(v1.getX() * v2.getY() - v1.getY() * v2.getX(), v1.getX() * v2.getX() + v1.getY() * v2.getY());
    }

    public static double angle(Point2D p) {
        return GeometryUtils.angle(p, new Point2D.Float(1.0f, 0.0f));
    }

    public static float perimeterAnchorPointToAngle(AnchorPoint anchorPoint) {
        switch (anchorPoint) {
            case N: {
                return 90.0f;
            }
            case NNE: {
                return 67.5f;
            }
            case NE: {
                return 45.0f;
            }
            case ENE: {
                return 22.5f;
            }
            case E: {
                return 0.0f;
            }
            case ESE: {
                return -22.5f;
            }
            case SE: {
                return -45.0f;
            }
            case SSE: {
                return -67.5f;
            }
            case S: {
                return -90.0f;
            }
            case SSW: {
                return -112.5f;
            }
            case SW: {
                return -135.0f;
            }
            case WSW: {
                return -157.5f;
            }
            case W: {
                return 180.0f;
            }
            case WNW: {
                return 157.5f;
            }
            case NW: {
                return 135.0f;
            }
            case NNW: {
                return 112.5f;
            }
            case CENTER: {
                throw new RuntimeException("Cannot infer angle from link starting at center");
            }
        }
        throw new RuntimeException("Unexpected error, should not be able to reach this point.");
    }

    public static Point2D.Float getRelativeRectangleAnchorPosition(AnchorPoint anchorPoint, float width, float height) {
        Point2D.Float pl = new Point2D.Float();
        switch (anchorPoint) {
            case E: {
                pl.x = 0.5f * width;
                pl.y = 0.0f;
                break;
            }
            case ENE: {
                pl.x = 0.5f * width;
                pl.y = 0.25f * height;
                break;
            }
            case NE: {
                pl.x = 0.5f * width;
                pl.y = 0.5f * height;
                break;
            }
            case ESE: {
                pl.x = 0.5f * width;
                pl.y = -0.25f * height;
                break;
            }
            case SE: {
                pl.x = 0.5f * width;
                pl.y = -0.5f * height;
                break;
            }
            case W: {
                pl.x = -0.5f * width;
                pl.y = 0.0f;
                break;
            }
            case WNW: {
                pl.x = -0.5f * width;
                pl.y = 0.25f * height;
                break;
            }
            case NW: {
                pl.x = -0.5f * width;
                pl.y = 0.5f * height;
                break;
            }
            case WSW: {
                pl.x = -0.5f * width;
                pl.y = -0.25f * height;
                break;
            }
            case SW: {
                pl.x = -0.5f * width;
                pl.y = -0.5f * height;
                break;
            }
            case N: {
                pl.x = 0.0f;
                pl.y = 0.5f * height;
                break;
            }
            case NNW: {
                pl.x = -0.25f * width;
                pl.y = 0.5f * height;
                break;
            }
            case NNE: {
                pl.x = 0.25f * width;
                pl.y = 0.5f * height;
                break;
            }
            case S: {
                pl.x = 0.0f;
                pl.y = -0.5f * height;
                break;
            }
            case SSW: {
                pl.x = -0.25f * width;
                pl.y = -0.5f * height;
                break;
            }
            case SSE: {
                pl.x = 0.25f * width;
                pl.y = -0.5f * height;
            }
        }
        return new Point2D.Float((float)pl.getX(), (float)(-pl.getY()));
    }

    public static Point2D.Float getRelativePhenotypeAnchorPosition(AnchorPoint anchorPoint, float width, float height) {
        float halfW = 0.5f * width;
        float halfH = 0.5f * height;
        float quartH = 0.25f * height;
        Point2D.Float pl = new Point2D.Float();
        switch (anchorPoint) {
            case E: {
                pl.x = halfW;
                pl.y = 0.0f;
                break;
            }
            case ENE: {
                pl.x = halfW - quartH;
                pl.y = quartH;
                break;
            }
            case NE: {
                pl.x = halfW - halfH;
                pl.y = halfH;
                break;
            }
            case ESE: {
                pl.x = halfW - quartH;
                pl.y = -quartH;
                break;
            }
            case SE: {
                pl.x = halfW - halfH;
                pl.y = -halfH;
                break;
            }
            case W: {
                pl.x = -halfW;
                pl.y = 0.0f;
                break;
            }
            case WNW: {
                pl.x = quartH - halfW;
                pl.y = quartH;
                break;
            }
            case NW: {
                pl.x = halfH - halfW;
                pl.y = halfH;
                break;
            }
            case WSW: {
                pl.x = quartH - halfW;
                pl.y = -quartH;
                break;
            }
            case SW: {
                pl.x = halfH - halfW;
                pl.y = -halfH;
                break;
            }
            case N: {
                pl.x = 0.0f;
                pl.y = halfH;
                break;
            }
            case NNW: {
                pl.x = 0.5f * (halfH - halfW);
                pl.y = halfH;
                break;
            }
            case NNE: {
                pl.x = 0.5f * (halfW - halfH);
                pl.y = halfH;
                break;
            }
            case S: {
                pl.x = 0.0f;
                pl.y = -halfH;
                break;
            }
            case SSW: {
                pl.x = 0.5f * (halfH - halfW);
                pl.y = -halfH;
                break;
            }
            case SSE: {
                pl.x = 0.5f * (halfW - halfH);
                pl.y = -halfH;
            }
        }
        return new Point2D.Float((float)pl.getX(), (float)(-pl.getY()));
    }

    public static Point2D.Float getRelativeRightParallelogramAnchorPosition(AnchorPoint anchorPoint, float width, float height) {
        float halfW = 0.5f * width;
        float halfH = 0.5f * height;
        float quartH = 0.25f * height;
        Point2D.Float pl = new Point2D.Float();
        switch (anchorPoint) {
            case E: {
                pl.x = halfW - halfH;
                pl.y = 0.0f;
                break;
            }
            case ENE: {
                pl.x = halfW - quartH;
                pl.y = quartH;
                break;
            }
            case NE: {
                pl.x = halfW;
                pl.y = halfH;
                break;
            }
            case ESE: {
                pl.x = halfW - height + quartH;
                pl.y = -quartH;
                break;
            }
            case SE: {
                pl.x = halfW - height;
                pl.y = -halfH;
                break;
            }
            case W: {
                pl.x = halfH - halfW;
                pl.y = 0.0f;
                break;
            }
            case WNW: {
                pl.x = height - halfW - quartH;
                pl.y = quartH;
                break;
            }
            case NW: {
                pl.x = height - halfW;
                pl.y = halfH;
                break;
            }
            case WSW: {
                pl.x = quartH - halfW;
                pl.y = -quartH;
                break;
            }
            case SW: {
                pl.x = -halfW;
                pl.y = -halfH;
                break;
            }
            case N: {
                pl.x = -halfW + height + 0.5f * (width - height);
                pl.y = halfH;
                break;
            }
            case NNW: {
                pl.x = -halfW + height + 0.25f * (width - height);
                pl.y = halfH;
                break;
            }
            case NNE: {
                pl.x = halfW - 0.25f * (width - height);
                pl.y = halfH;
                break;
            }
            case S: {
                pl.x = halfW - height - 0.5f * (width - height);
                pl.y = -halfH;
                break;
            }
            case SSW: {
                pl.x = -halfW + 0.25f * (width - height);
                pl.y = -halfH;
                break;
            }
            case SSE: {
                pl.x = halfW - height - 0.25f * (width - height);
                pl.y = -halfH;
            }
        }
        return new Point2D.Float((float)pl.getX(), (float)(-pl.getY()));
    }

    public static Point2D.Float getRelativeLeftParallelogramAnchorPosition(AnchorPoint anchorPoint, float width, float height) {
        float halfW = 0.5f * width;
        float halfH = 0.5f * height;
        float quartH = 0.25f * height;
        Point2D.Float pl = new Point2D.Float();
        switch (anchorPoint) {
            case E: {
                pl.x = halfW - halfH;
                pl.y = 0.0f;
                break;
            }
            case ENE: {
                pl.x = halfW - height + quartH;
                pl.y = quartH;
                break;
            }
            case NE: {
                pl.x = halfW - height;
                pl.y = halfH;
                break;
            }
            case ESE: {
                pl.x = halfW - quartH;
                pl.y = -quartH;
                break;
            }
            case SE: {
                pl.x = halfW;
                pl.y = -halfH;
                break;
            }
            case W: {
                pl.x = halfH - halfW;
                pl.y = 0.0f;
                break;
            }
            case WNW: {
                pl.x = -halfW + quartH;
                pl.y = quartH;
                break;
            }
            case NW: {
                pl.x = -halfW;
                pl.y = halfH;
                break;
            }
            case WSW: {
                pl.x = height - halfW - quartH;
                pl.y = -quartH;
                break;
            }
            case SW: {
                pl.x = -halfW + height;
                pl.y = -halfH;
                break;
            }
            case N: {
                pl.x = -halfW + 0.5f * (width - height);
                pl.y = halfH;
                break;
            }
            case NNW: {
                pl.x = 0.25f * (-width - height);
                pl.y = halfH;
                break;
            }
            case NNE: {
                pl.x = -halfW + 0.75f * (width - height);
                pl.y = halfH;
                break;
            }
            case S: {
                pl.x = halfW - 0.5f * (width - height);
                pl.y = -halfH;
                break;
            }
            case SSW: {
                pl.x = halfW - 0.75f * (width - height);
                pl.y = -halfH;
                break;
            }
            case SSE: {
                pl.x = 0.25f * (width + height);
                pl.y = -halfH;
            }
        }
        return new Point2D.Float((float)pl.getX(), (float)(-pl.getY()));
    }

    public static Point2D.Float getRelativeReceptorAnchorPosition(AnchorPoint anchorPoint, float width, float height) {
        float halfW = 0.5f * width;
        float quartW = 0.25f * width;
        float halfH = 0.5f * height;
        float fifthH = 0.2f * height;
        float tenthH = 0.1f * height;
        Point2D.Float pl = new Point2D.Float();
        switch (anchorPoint) {
            case E: {
                pl.x = halfW;
                pl.y = tenthH;
                break;
            }
            case ENE: {
                pl.x = halfW;
                pl.y = halfH - fifthH;
                break;
            }
            case NE: {
                pl.x = halfW;
                pl.y = halfH;
                break;
            }
            case ESE: {
                pl.x = halfW;
                pl.y = -tenthH;
                break;
            }
            case SE: {
                pl.x = halfW;
                pl.y = -halfH + fifthH;
                break;
            }
            case W: {
                pl.x = -halfW;
                pl.y = tenthH;
                break;
            }
            case WNW: {
                pl.x = -halfW;
                pl.y = halfH - fifthH;
                break;
            }
            case NW: {
                pl.x = -halfW;
                pl.y = halfH;
                break;
            }
            case WSW: {
                pl.x = -halfW;
                pl.y = -tenthH;
                break;
            }
            case SW: {
                pl.x = -halfW;
                pl.y = -halfH + fifthH;
                break;
            }
            case N: {
                pl.x = 0.0f;
                pl.y = halfH - fifthH;
                break;
            }
            case NNW: {
                pl.x = -quartW;
                pl.y = halfH - tenthH;
                break;
            }
            case NNE: {
                pl.x = quartW;
                pl.y = halfH - tenthH;
                break;
            }
            case S: {
                pl.x = 0.0f;
                pl.y = -halfH;
                break;
            }
            case SSW: {
                pl.x = -quartW;
                pl.y = -halfH + tenthH;
                break;
            }
            case SSE: {
                pl.x = quartW;
                pl.y = -halfH + tenthH;
            }
        }
        return new Point2D.Float((float)pl.getX(), (float)(-pl.getY()));
    }

    public static Point2D.Float ellipsePerimeterPointFromAngle(float bboxWidth, float bboxHeight, float deg) {
        double theta = (double)deg * Math.PI / 180.0;
        return new Point2D.Float((float)((double)(bboxWidth / 2.0f) * Math.cos(theta)), (float)((double)(-(bboxHeight / 2.0f)) * Math.sin(theta)));
    }

    public static List<Point2D.Float> getLineRectangleIntersection(Line2D.Float line, Rectangle2D.Float rect) {
        Point2D.Float p1 = new Point2D.Float((float)(rect.getX() - rect.getWidth() / 2.0), (float)(rect.getY() - rect.getHeight() / 2.0));
        Point2D.Float p2 = new Point2D.Float((float)(rect.getX() + rect.getWidth() / 2.0), (float)(rect.getY() - rect.getHeight() / 2.0));
        Point2D.Float p3 = new Point2D.Float((float)(rect.getX() + rect.getWidth() / 2.0), (float)(rect.getY() + rect.getHeight() / 2.0));
        Point2D.Float p4 = new Point2D.Float((float)(rect.getX() - rect.getWidth() / 2.0), (float)(rect.getY() + rect.getHeight() / 2.0));
        Line2D.Float l1 = new Line2D.Float(p1, p2);
        Line2D.Float l2 = new Line2D.Float(p2, p3);
        Line2D.Float l3 = new Line2D.Float(p3, p4);
        Line2D.Float l4 = new Line2D.Float(p4, p1);
        logger.trace(rect + " -- " + line);
        Point2D.Float i1 = GeometryUtils.getLineLineIntersection(line, l1);
        Point2D.Float i2 = GeometryUtils.getLineLineIntersection(line, l2);
        Point2D.Float i3 = GeometryUtils.getLineLineIntersection(line, l3);
        Point2D.Float i4 = GeometryUtils.getLineLineIntersection(line, l4);
        ArrayList<Point2D.Float> result = new ArrayList<Point2D.Float>();
        if (i1 != null && GeometryUtils.isDefinedAndFinite(i1.getX()) && GeometryUtils.isDefinedAndFinite(i1.getY())) {
            result.add(i1);
        }
        if (i2 != null && GeometryUtils.isDefinedAndFinite(i2.getX()) && GeometryUtils.isDefinedAndFinite(i2.getY())) {
            result.add(i2);
        }
        if (i3 != null && GeometryUtils.isDefinedAndFinite(i3.getX()) && GeometryUtils.isDefinedAndFinite(i3.getY())) {
            result.add(i3);
        }
        if (i4 != null && GeometryUtils.isDefinedAndFinite(i4.getX()) && GeometryUtils.isDefinedAndFinite(i4.getY())) {
            result.add(i4);
        }
        return result;
    }

    public static boolean isDefinedAndFinite(double n) {
        return Double.isFinite(n) && !Double.isNaN(n);
    }

    public static Point2D.Float getLineLineIntersection(Line2D.Float line1, Line2D.Float line2) {
        double x1 = line1.x1;
        double y1 = line1.y1;
        double x2 = line1.x2;
        double y2 = line1.y2;
        double x3 = line2.x1;
        double y3 = line2.y1;
        double x4 = line2.x2;
        double y4 = line2.y2;
        double x = ((x2 - x1) * (x3 * y4 - x4 * y3) - (x4 - x3) * (x1 * y2 - x2 * y1)) / ((x1 - x2) * (y3 - y4) - (y1 - y2) * (x3 - x4));
        double y = ((y3 - y4) * (x1 * y2 - x2 * y1) - (y1 - y2) * (x3 * y4 - x4 * y3)) / ((x1 - x2) * (y3 - y4) - (y1 - y2) * (x3 - x4));
        if (line1.intersectsLine(line2)) {
            return new Point2D.Float((float)x, (float)y);
        }
        return null;
    }

    public static Point2D.Float getClosest(List<Point2D.Float> pointList, Point2D.Float ref) {
        if (pointList.size() == 0) {
            throw new IllegalArgumentException("Point list should not be empty.");
        }
        double minDist = pointList.get(0).distance(ref);
        Point2D.Float closest = pointList.get(0);
        for (int i = 1; i < pointList.size(); ++i) {
            if (!(pointList.get(i).distance(ref) < minDist)) continue;
            closest = pointList.get(i);
        }
        return closest;
    }

    public static List<Point2D.Float> convertPoints(List<Point2D.Float> points, AffineTransform transform) {
        ArrayList<Point2D.Float> convertedPoints = new ArrayList<Point2D.Float>();
        for (Point2D point2D : points) {
            Point2D.Double p = new Point2D.Double(point2D.getX(), point2D.getY());
            transform.transform(p, p);
            convertedPoints.add(new Point2D.Float((float)((Point2D)p).getX(), (float)((Point2D)p).getY()));
        }
        return convertedPoints;
    }

    public static Point2D.Float getMiddle(Point2D.Float p1, Point2D.Float p2) {
        return new Point2D.Float(p1.x + (p2.x - p1.x) / 2.0f, p1.y + (p2.y - p1.y) / 2.0f);
    }

    public static Point2D.Float getMiddleOfPolylineSegment(List<Point2D.Float> points, int segment) {
        if (points.size() < 2) {
            throw new IllegalArgumentException("Polyline needs to have at least 2 points, " + points.size() + " points provided.");
        }
        if (segment < 0 || segment > points.size() - 1) {
            throw new IllegalArgumentException("segment has to be between 0 and polyline segment count, " + segment + " was provided.");
        }
        Point2D.Float p1 = points.get(segment);
        Point2D.Float p2 = points.get(segment + 1);
        logger.trace("middle of " + p1 + " " + p2 + " -> " + GeometryUtils.getMiddle(p1, p2));
        return GeometryUtils.getMiddle(p1, p2);
    }

    public static AbstractMap.SimpleEntry<List<Point2D.Float>, List<Point2D.Float>> splitPolylineAtSegment(List<Point2D.Float> points, int segment) {
        if (points.size() < 2) {
            throw new IllegalArgumentException("Polyline needs to have at least 2 points, " + points.size() + " points provided.");
        }
        if (segment < 0 || segment > points.size() - 1) {
            throw new IllegalArgumentException("segment has to be between 0 and polyline segment count, " + segment + " was provided.");
        }
        ArrayList<Point2D.Float> subLinkPoints1 = new ArrayList<Point2D.Float>();
        ArrayList subLinkPoints2 = new ArrayList();
        ArrayList<Point2D.Float> currentSubLink = subLinkPoints1;
        for (int i = 0; i < points.size() - 1; ++i) {
            Point2D.Float currentStartPoint = points.get(i);
            Point2D.Float currenEndPoint = points.get(i + 1);
            currentSubLink.add(currentStartPoint);
            if (i == segment) {
                Point2D.Float middle = GeometryUtils.getMiddle(currentStartPoint, currenEndPoint);
                currentSubLink.add(middle);
                currentSubLink = subLinkPoints2;
                currentSubLink.add(middle);
            }
            if (i != points.size() - 2) continue;
            currentSubLink.add(currenEndPoint);
        }
        return new AbstractMap.SimpleEntry<List<Point2D.Float>, List<Point2D.Float>>(subLinkPoints1, subLinkPoints2);
    }

    public static Point2D.Float normalizePoint(Point2D.Float p1, Point2D.Float p2, Glyph glyph, AnchorPoint anchorPoint) {
        if (glyph.getCdShape() == CdShape.LEFT_PARALLELOGRAM || glyph.getCdShape() == CdShape.RIGHT_PARALLELOGRAM || glyph.getCdShape() == CdShape.RECEPTOR || anchorPoint == AnchorPoint.CENTER) {
            Rectangle2D.Float rect = new Rectangle2D.Float((float)glyph.getCenter().getX(), (float)glyph.getCenter().getY(), glyph.getWidth(), glyph.getHeight());
            Line2D.Float segment = new Line2D.Float(p1, p2);
            logger.trace("Intersect segement: " + segment.getP1() + " " + segment.getP2() + " with rectangle " + rect);
            List<Point2D.Float> intersections2 = GeometryUtils.getLineRectangleIntersection(segment, rect);
            if (intersections2.isEmpty()) {
                return p1;
            }
            Point2D.Float normalizedStart = GeometryUtils.getClosest(intersections2, p2);
            return normalizedStart;
        }
        return p1;
    }

    public static List<Point2D.Float> getNormalizedEndPoints(List<Point2D.Float> points, Glyph startGlyph, Glyph endGlyph, AnchorPoint startAnchor, AnchorPoint endAnchor) {
        logger.trace("NORMALIZE points: " + points);
        Point2D.Float cdSpaceStart = points.get(0);
        Point2D.Float cdSpaceEnd = points.get(points.size() - 1);
        ArrayList<Point2D.Float> result = new ArrayList<Point2D.Float>();
        Point2D.Float normalized1 = GeometryUtils.normalizePoint(cdSpaceStart, points.get(1), startGlyph, startAnchor);
        result.add(normalized1);
        for (int i = 1; i < points.size() - 1; ++i) {
            result.add(points.get(i));
        }
        Point2D.Float normalized2 = GeometryUtils.normalizePoint(cdSpaceEnd, points.get(points.size() - 2), endGlyph, endAnchor);
        result.add(normalized2);
        logger.trace("NORMALIZE RESULT: " + result);
        return result;
    }

    public static Point2D.Float interpolationByRatio(Point2D.Float p1, Point2D.Float p2, float ratio) {
        if (p1.distance(p2) == 0.0) {
            logger.warn("Interpolation by ratio for a 0-length segment (2 same points given): " + p1 + " " + p2);
            return new Point2D.Float((float)p1.getX(), (float)p1.getY());
        }
        float len = (float)p1.distance(p2);
        float x = ratio * p2.x + (1.0f - ratio) * p1.x;
        float y = ratio * p2.y + (1.0f - ratio) * p1.y;
        return new Point2D.Float(x, y);
    }

    public static Point2D.Float interpolationByDistance(Point2D.Float p1, Point2D.Float p2, float d) {
        if (p1.distance(p2) == 0.0) {
            logger.warn("Interpolation by distance for a 0-length segment (2 same points given): " + p1 + " " + p2);
            return new Point2D.Float((float)p1.getX(), (float)p1.getY());
        }
        float len = (float)p1.distance(p2);
        float ratio = d / len;
        float x = ratio * p2.x + (1.0f - ratio) * p1.x;
        float y = ratio * p2.y + (1.0f - ratio) * p1.y;
        return new Point2D.Float(x, y);
    }

    public static Rectangle2D.Float getCompartmentBbox(String cdClass, float x, float y, float thickness, float mapW, float mapH) {
        float resH;
        float resW;
        float resY;
        float resX;
        switch (cdClass) {
            case "SQUARE_CLOSEUP_NORTHWEST": {
                resX = x;
                resY = y;
                resW = mapW - x;
                resH = mapH - y;
                break;
            }
            case "SQUARE_CLOSEUP_NORTHEAST": {
                resX = 0.0f;
                resY = y;
                resW = x;
                resH = mapH - y;
                break;
            }
            case "SQUARE_CLOSEUP_SOUTHWEST": {
                resX = x;
                resY = 0.0f;
                resW = mapW - x;
                resH = y;
                break;
            }
            case "SQUARE_CLOSEUP_SOUTHEAST": {
                resX = 0.0f;
                resY = 0.0f;
                resW = x;
                resH = y;
                break;
            }
            case "SQUARE_CLOSEUP_NORTH": {
                resX = 0.0f;
                resY = y;
                resW = mapW;
                resH = thickness;
                break;
            }
            case "SQUARE_CLOSEUP_EAST": {
                resX = x - thickness;
                resY = 0.0f;
                resW = thickness;
                resH = mapH;
                break;
            }
            case "SQUARE_CLOSEUP_WEST": {
                resX = x;
                resY = 0.0f;
                resW = thickness;
                resH = mapH;
                break;
            }
            case "SQUARE_CLOSEUP_SOUTH": {
                resX = 0.0f;
                resY = y - thickness;
                resW = mapW;
                resH = thickness;
                break;
            }
            default: {
                throw new IllegalArgumentException("Compartment bbox can be inferred only for the special CLOSEUP classes. Invalid class provided: " + cdClass);
            }
        }
        return new Rectangle2D.Float(resX, resY, resW, resH);
    }

    public static float getLengthForString(String s) {
        if (s.trim().isEmpty()) {
            return 0.0f;
        }
        return s.length() * 5 + 5;
    }

    public static Rectangle2D.Float getAuxUnitBboxFromAngle(Rectangle2D.Float parentBbox, String s, float angle) {
        Point2D.Float unitCenter = GeometryUtils.getPositionFromAngle(parentBbox, angle);
        return GeometryUtils.getAuxUnitBboxFromPoint(parentBbox, s, unitCenter);
    }

    public static Rectangle2D.Float getAuxUnitBboxFromRelativeTopRatio(Rectangle2D.Float parentBbox, String s, float ratio) {
        Point2D.Float unitCenter = GeometryUtils.getTopPositionFromRatio(parentBbox, ratio);
        return GeometryUtils.getAuxUnitBboxFromPoint(parentBbox, s, unitCenter);
    }

    public static Rectangle2D.Float getAuxUnitBboxFromPoint(Rectangle2D.Float parentBbox, String s, Point2D unitCenter) {
        float unitWidth = GeometryUtils.getLengthForString(s);
        float unitHeight = 10.0f;
        unitWidth = unitWidth > parentBbox.width ? parentBbox.width : unitWidth;
        unitWidth = unitWidth < unitHeight ? unitHeight : unitWidth;
        Rectangle2D.Float res = new Rectangle2D.Float((float)(unitCenter.getX() + parentBbox.getX() + parentBbox.getWidth() / 2.0 - (double)(unitWidth / 2.0f)), (float)(unitCenter.getY() + parentBbox.getY() + parentBbox.getHeight() / 2.0 - (double)(unitHeight / 2.0f)), unitWidth, unitHeight);
        return res;
    }

    public static Point2D.Float getRelativePositionOfAuxUnit(Rectangle2D parent, Rectangle2D auxUnit) {
        Point2D.Float parentMiddle = new Point2D.Float((float)parent.getCenterX(), (float)parent.getCenterY());
        Point2D.Float unitMiddle = new Point2D.Float((float)(auxUnit.getCenterX() - parentMiddle.getX()), (float)(auxUnit.getCenterY() - parentMiddle.getY()));
        return unitMiddle;
    }

    public static double getTopRatioOfAuxUnit(Rectangle2D parent, Rectangle2D auxUnit) {
        Point2D.Float unitRelativeCenter = GeometryUtils.getRelativePositionOfAuxUnit(parent, auxUnit);
        return unitRelativeCenter.getX() / parent.getWidth() + 0.5;
    }

    public static double normalizeAngle(double angle) {
        double theta;
        double twoPI = Math.PI * 2;
        for (theta = angle; theta <= -Math.PI; theta += twoPI) {
        }
        while (theta > Math.PI) {
            theta -= twoPI;
        }
        return theta;
    }

    public static Point2D.Float rectanglePerimeterPointFromAngle(Rectangle2D.Float rect, double deg) {
        double theta;
        double twoPI = Math.PI * 2;
        for (theta = deg * Math.PI / 180.0; theta < -Math.PI; theta += twoPI) {
        }
        while (theta > Math.PI) {
            theta -= twoPI;
        }
        double rectAtan = Math.atan2(rect.height, rect.width);
        double tanTheta = Math.tan(theta);
        int region = theta > -rectAtan && theta <= rectAtan ? 1 : (theta > rectAtan && theta <= Math.PI - rectAtan ? 2 : (theta > Math.PI - rectAtan || theta <= -(Math.PI - rectAtan) ? 3 : 4));
        Point2D.Float edgePoint = new Point2D.Float(rect.width / 2.0f, rect.height / 2.0f);
        int xFactor = 1;
        int yFactor = 1;
        switch (region) {
            case 1: {
                yFactor = -1;
                break;
            }
            case 2: {
                yFactor = -1;
                break;
            }
            case 3: {
                xFactor = -1;
                break;
            }
            case 4: {
                xFactor = -1;
            }
        }
        if (region == 1 || region == 3) {
            edgePoint.x = (float)((double)edgePoint.x + (double)xFactor * ((double)rect.width / 2.0));
            edgePoint.y = (float)((double)edgePoint.y + (double)yFactor * ((double)rect.width / 2.0) * tanTheta);
        } else {
            edgePoint.x = (float)((double)edgePoint.x + (double)xFactor * ((double)rect.height / (2.0 * tanTheta)));
            edgePoint.y = (float)((double)edgePoint.y + (double)yFactor * ((double)rect.height / 2.0));
        }
        return edgePoint;
    }

    public static Point2D.Float getPositionFromAngle(Rectangle2D.Float rect, float deg) {
        float fictionalSquareSize = 10.0f;
        Point2D.Float localCoordFromTopLeft = GeometryUtils.rectanglePerimeterPointFromAngle(new Rectangle2D.Float(0.0f, 0.0f, fictionalSquareSize, fictionalSquareSize), deg);
        Point2D.Float localCoordFromCenter = new Point2D.Float((float)(localCoordFromTopLeft.getX() - (double)(fictionalSquareSize / 2.0f)), (float)(localCoordFromTopLeft.getY() - (double)(fictionalSquareSize / 2.0f)));
        double xRatio = localCoordFromCenter.getX() / (double)fictionalSquareSize;
        double yRatio = localCoordFromCenter.getY() / (double)fictionalSquareSize;
        double resultX = (double)rect.width * xRatio;
        double resultY = (double)rect.height * yRatio;
        return new Point2D.Float((float)resultX, (float)resultY);
    }

    public static double getAngleOfAuxUnit(Rectangle2D parent, Rectangle2D auxUnit) {
        double yratio;
        float fictionalSquareSize;
        Point2D.Float unitRelativeCenter = GeometryUtils.getRelativePositionOfAuxUnit(parent, auxUnit);
        double xratio = unitRelativeCenter.getX() / parent.getWidth();
        Point2D.Float unitOnSquare = new Point2D.Float((float)(xratio * (double)(fictionalSquareSize = 10.0f)), (float)((yratio = unitRelativeCenter.getY() / parent.getHeight()) * (double)fictionalSquareSize));
        double signedAngle = GeometryUtils.angle(unitOnSquare);
        if (signedAngle < 0.0) {
            signedAngle += Math.PI * 2;
        }
        return signedAngle;
    }

    public static Point2D.Float getTopPositionFromRatio(Rectangle2D.Float rect, float ratio) {
        float resultX = rect.width * ratio - rect.width / 2.0f;
        float resultY = -rect.height / 2.0f;
        return new Point2D.Float(resultX, resultY);
    }

    public static float unsignedRadianToSignedDegree(float radian) {
        float unsignedDegree = (float)((double)radian / Math.PI * 180.0);
        if (unsignedDegree > 180.0f) {
            unsignedDegree -= 360.0f;
        }
        return unsignedDegree;
    }

    public static float unsignedRadianToUnsignedDegree(float radian) {
        return (float)((double)radian / Math.PI * 180.0);
    }

    public static float lineSlope(Point2D p1, Point2D p2) {
        return (float)((p1.getY() - p2.getY()) / (p1.getX() - p2.getX()));
    }

    public static Point2D.Float getRelativeAnchorCoordinate(CdShape shape, float width, float height, AnchorPoint anchorPoint) {
        Point2D.Float relativeAnchorPoint;
        if (anchorPoint != AnchorPoint.CENTER) {
            float angle = GeometryUtils.perimeterAnchorPointToAngle(anchorPoint);
            switch (shape) {
                case ELLIPSE: 
                case CIRCLE: {
                    relativeAnchorPoint = GeometryUtils.ellipsePerimeterPointFromAngle(width, height, angle);
                    break;
                }
                case PHENOTYPE: {
                    relativeAnchorPoint = GeometryUtils.getRelativePhenotypeAnchorPosition(anchorPoint, width, height);
                    break;
                }
                case LEFT_PARALLELOGRAM: {
                    relativeAnchorPoint = GeometryUtils.getRelativeLeftParallelogramAnchorPosition(anchorPoint, width, height);
                    break;
                }
                case RIGHT_PARALLELOGRAM: {
                    relativeAnchorPoint = GeometryUtils.getRelativeRightParallelogramAnchorPosition(anchorPoint, width, height);
                    break;
                }
                case RECEPTOR: {
                    relativeAnchorPoint = GeometryUtils.getRelativeReceptorAnchorPosition(anchorPoint, width, height);
                    break;
                }
                default: {
                    relativeAnchorPoint = GeometryUtils.getRelativeRectangleAnchorPosition(anchorPoint, width, height);
                    break;
                }
            }
        } else {
            relativeAnchorPoint = new Point2D.Float(0.0f, 0.0f);
        }
        return relativeAnchorPoint;
    }

    public static Point2D.Float getAbsoluteAnchorPoint(CdShape shape, Rectangle2D.Float bbox, AnchorPoint anchorPoint) {
        Point2D.Float relativePoint = GeometryUtils.getRelativeAnchorCoordinate(shape, (float)bbox.getWidth(), (float)bbox.getHeight(), anchorPoint);
        return new Point2D.Float((float)(relativePoint.getX() + bbox.getX() + bbox.getWidth() / 2.0), (float)(relativePoint.getY() + bbox.getY() + bbox.getHeight() / 2.0));
    }

    public static AnchorPoint getNearestAnchorPoint(Point2D.Float p, Rectangle2D.Float bbox, CdShape shape) {
        AnchorPoint result = AnchorPoint.CENTER;
        Point2D.Float relativeP = new Point2D.Float((float)(p.getX() - bbox.getX() - bbox.getWidth() / 2.0), (float)(p.getY() - bbox.getY() - bbox.getHeight() / 2.0));
        logger.trace("Nearest anchro point: " + p + " " + relativeP + " " + bbox + " " + (Object)((Object)shape));
        double minDist = Double.MAX_VALUE;
        for (AnchorPoint a : AnchorPoint.values()) {
            Point2D.Float currentRelativeAnchor = GeometryUtils.getRelativeAnchorCoordinate(shape, (float)bbox.getWidth(), (float)bbox.getHeight(), a);
            double dist = relativeP.distance(currentRelativeAnchor);
            if (!(dist < minDist)) continue;
            minDist = dist;
            result = a;
        }
        return result;
    }
}

