/*
 * Decompiled with CFR 0.152.
 */
package fr.curie.cd2sbgnml;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import fr.curie.cd2sbgnml.CellDesignerSBFCModel;
import fr.curie.cd2sbgnml.SBGNML2CD;
import fr.curie.cd2sbgnml.SBGNSBFCModel;
import java.io.File;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.util.ValidationEventCollector;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.sbfc.converter.exceptions.ConversionException;
import org.sbfc.converter.exceptions.ReadModelException;
import org.sbfc.converter.exceptions.WriteModelException;
import org.sbml.sbml.level2.version4.Sbml;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class Sbgnml2CdScript {
    @Parameter(names={"-i", "--input"}, required=true)
    private String inputFileName;
    @Parameter(names={"-o", "--output"}, required=true)
    private String outputFileName;

    public static void main(String[] args) {
        Logger logger = LoggerFactory.getLogger(Sbgnml2CdScript.class);
        Sbgnml2CdScript app = new Sbgnml2CdScript();
        JCommander.newBuilder().addObject(app).build().parse(args);
        Sbgnml2CdScript.convert(app.inputFileName, app.outputFileName);
    }

    public static void convert(String inputFileName, String outputFileName) {
        SBGNML2CD toCDConverter = new SBGNML2CD();
        long start = System.currentTimeMillis();
        SBGNSBFCModel sbgnModel = new SBGNSBFCModel();
        try {
            sbgnModel.setModelFromFile(inputFileName);
        }
        catch (ReadModelException e) {
            e.printStackTrace();
        }
        try {
            CellDesignerSBFCModel cellDesignerSBFCModel = (CellDesignerSBFCModel)toCDConverter.convert(sbgnModel);
            cellDesignerSBFCModel.modelToFile(outputFileName);
        }
        catch (ConversionException | ReadModelException | WriteModelException e) {
            e.printStackTrace();
        }
        long elapsedTimeMillis = System.currentTimeMillis() - start;
        System.out.println((float)elapsedTimeMillis / 1000.0f + " seconds");
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            Schema schema = sf.newSchema(Sbgnml2CdScript.class.getResource("/schema/CellDesigner.xsd"));
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{Sbml.class});
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            unmarshaller.setSchema(schema);
            unmarshaller.setEventHandler((ValidationEventHandler)new ValidationEventCollector());
            unmarshaller.unmarshal(new File(outputFileName));
        }
        catch (JAXBException | SAXException e) {
            e.printStackTrace();
        }
    }
}

