/*
 * Decompiled with CFR 0.152.
 */
package fr.curie.cd2sbgnml;

import fr.curie.cd2sbgnml.CellDesignerSBFCModel;
import fr.curie.cd2sbgnml.SBGNSBFCModel;
import fr.curie.cd2sbgnml.SBGNUtils;
import fr.curie.cd2sbgnml.graphics.AnchorPoint;
import fr.curie.cd2sbgnml.graphics.CdShape;
import fr.curie.cd2sbgnml.graphics.GeometryUtils;
import fr.curie.cd2sbgnml.graphics.Link;
import fr.curie.cd2sbgnml.model.LinkModel;
import fr.curie.cd2sbgnml.model.LogicGate;
import fr.curie.cd2sbgnml.model.Process;
import fr.curie.cd2sbgnml.model.ReactantModel;
import fr.curie.cd2sbgnml.xmlcdwrappers.AliasInfoWrapper;
import fr.curie.cd2sbgnml.xmlcdwrappers.AliasWrapper;
import fr.curie.cd2sbgnml.xmlcdwrappers.CompartmentWrapper;
import fr.curie.cd2sbgnml.xmlcdwrappers.IAnnotationsFeature;
import fr.curie.cd2sbgnml.xmlcdwrappers.INotesFeature;
import fr.curie.cd2sbgnml.xmlcdwrappers.LineWrapper;
import fr.curie.cd2sbgnml.xmlcdwrappers.LogicGateWrapper;
import fr.curie.cd2sbgnml.xmlcdwrappers.ModificationLinkType;
import fr.curie.cd2sbgnml.xmlcdwrappers.ReactantWrapper;
import fr.curie.cd2sbgnml.xmlcdwrappers.ReactionType;
import fr.curie.cd2sbgnml.xmlcdwrappers.ReactionWrapper;
import fr.curie.cd2sbgnml.xmlcdwrappers.ResidueWrapper;
import fr.curie.cd2sbgnml.xmlcdwrappers.SpeciesWrapper;
import fr.curie.cd2sbgnml.xmlcdwrappers.StyleInfo;
import fr.curie.cd2sbgnml.xmlcdwrappers.Utils;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.sbfc.converter.GeneralConverter;
import org.sbfc.converter.exceptions.ConversionException;
import org.sbfc.converter.exceptions.ReadModelException;
import org.sbfc.converter.models.GeneralModel;
import org.sbgn.ArcClazz;
import org.sbgn.GlyphClazz;
import org.sbgn.bindings.Arc;
import org.sbgn.bindings.Glyph;
import org.sbgn.bindings.Map;
import org.sbgn.bindings.Port;
import org.sbgn.bindings.SBGNBase;
import org.sbgn.bindings.Sbgn;
import org.sbml._2001.ns.celldesigner.AntisenseRNA;
import org.sbml._2001.ns.celldesigner.ConnectScheme;
import org.sbml._2001.ns.celldesigner.Gene;
import org.sbml._2001.ns.celldesigner.Line;
import org.sbml._2001.ns.celldesigner.LineDirection;
import org.sbml._2001.ns.celldesigner.LineType2;
import org.sbml._2001.ns.celldesigner.ListOfAntisenseRNAs;
import org.sbml._2001.ns.celldesigner.ListOfBlockDiagrams;
import org.sbml._2001.ns.celldesigner.ListOfCompartmentAliases;
import org.sbml._2001.ns.celldesigner.ListOfComplexSpeciesAliases;
import org.sbml._2001.ns.celldesigner.ListOfGenes;
import org.sbml._2001.ns.celldesigner.ListOfGroups;
import org.sbml._2001.ns.celldesigner.ListOfIncludedSpecies;
import org.sbml._2001.ns.celldesigner.ListOfLineDirection;
import org.sbml._2001.ns.celldesigner.ListOfModificationResidues;
import org.sbml._2001.ns.celldesigner.ListOfProteins;
import org.sbml._2001.ns.celldesigner.ListOfRNAs;
import org.sbml._2001.ns.celldesigner.ListOfRegions;
import org.sbml._2001.ns.celldesigner.ListOfSpeciesAliases;
import org.sbml._2001.ns.celldesigner.ModelAnnotationType;
import org.sbml._2001.ns.celldesigner.ModelDisplay;
import org.sbml._2001.ns.celldesigner.ModificationResidue;
import org.sbml._2001.ns.celldesigner.Protein;
import org.sbml._2001.ns.celldesigner.RNA;
import org.sbml._2001.ns.celldesigner.Species;
import org.sbml._2001.ns.celldesigner.SpeciesAlias;
import org.sbml.sbml.level2.version4.Compartment;
import org.sbml.sbml.level2.version4.Model;
import org.sbml.sbml.level2.version4.ModifierSpeciesReference;
import org.sbml.sbml.level2.version4.OriginalModel;
import org.sbml.sbml.level2.version4.SBase;
import org.sbml.sbml.level2.version4.Sbml;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class SBGNML2CD
extends GeneralConverter {
    final Logger logger = LoggerFactory.getLogger(SBGNML2CD.class);
    Rectangle2D mapBounds;
    Sbml sbml;
    boolean mapHasStyle;
    java.util.Map<String, StyleInfo> styleMap;
    java.util.Map<String, AliasWrapper> aliasWrapperMap;
    java.util.Map<String, SpeciesWrapper> speciesWrapperMap;
    java.util.Map<String, Protein> protMap;
    java.util.Map<String, RNA> rnaMap;
    java.util.Map<String, Gene> geneMap;
    java.util.Map<String, AntisenseRNA> asrnaMap;
    java.util.Map<String, List<Arc>> processToArcs;
    List<Arc> orphanArcs;
    HashSet<Glyph> orphanLogicGates;
    java.util.Map<String, Glyph> arcToSource;
    java.util.Map<String, Glyph> arcToTarget;
    java.util.Map<String, Glyph> idToGlyph;
    java.util.Map<String, Glyph> portToGlyph;
    java.util.Map<String, List<Arc>> glyphToArc;

    public Sbml toCD(Sbgn sbgn) {
        String clazz;
        sbgn = SBGNUtils.sanitizeIds(sbgn);
        Map sbgnMap = sbgn.getMap();
        this.sbml = this.initFile(sbgnMap);
        this.buildMaps(sbgnMap);
        if (sbgnMap.getNotes() != null && sbgnMap.getNotes().getAny().size() > 0) {
            Element notesE = sbgnMap.getNotes().getAny().get(0);
            SBase.Notes notes = new SBase.Notes();
            notes.getAny().add(notesE);
            this.sbml.getModel().setNotes(notes);
        }
        if (sbgnMap.getExtension() != null) {
            for (Element e : sbgnMap.getExtension().getAny()) {
                if (!e.getTagName().equals("annotation")) continue;
                Element rdf = SBGNUtils.sanitizeRdfURNs((Element)e.getElementsByTagName("rdf:RDF").item(0));
                this.sbml.getModel().getAnnotation().getAny().add(rdf);
            }
        }
        for (Glyph glyph : sbgnMap.getGlyph()) {
            clazz = glyph.getClazz();
            switch (GlyphClazz.fromClazz(clazz)) {
                case COMPARTMENT: {
                    this.processCompartment(glyph);
                    break;
                }
                case MACROMOLECULE: 
                case MACROMOLECULE_MULTIMER: 
                case NUCLEIC_ACID_FEATURE: 
                case NUCLEIC_ACID_FEATURE_MULTIMER: 
                case SIMPLE_CHEMICAL: 
                case SIMPLE_CHEMICAL_MULTIMER: 
                case UNSPECIFIED_ENTITY: 
                case PHENOTYPE: 
                case SOURCE_AND_SINK: 
                case PERTURBING_AGENT: 
                case SUBMAP: {
                    this.processSpecies(glyph, false, false, null, null);
                    break;
                }
                case COMPLEX: 
                case COMPLEX_MULTIMER: {
                    this.processSpecies(glyph, false, true, null, null);
                }
            }
        }
        for (Glyph glyph : sbgnMap.getGlyph()) {
            clazz = glyph.getClazz();
            switch (GlyphClazz.fromClazz(clazz)) {
                case PROCESS: 
                case OMITTED_PROCESS: 
                case UNCERTAIN_PROCESS: 
                case ASSOCIATION: 
                case DISSOCIATION: {
                    this.processReaction(glyph);
                }
            }
        }
        for (Arc orphanArc : this.orphanArcs) {
            this.processOrphanArc(orphanArc);
        }
        for (Glyph orphanLogic : this.orphanLogicGates) {
            this.processLogicReaction(orphanLogic);
        }
        this.processEnd();
        return this.sbml;
    }

    private void processEnd() {
        for (SpeciesWrapper speciesWrapper : this.speciesWrapperMap.values()) {
            if (speciesWrapper.isIncludedSpecies()) {
                ListOfIncludedSpecies listOfIncludedSpecies = this.sbml.getModel().getAnnotation().getExtension().getListOfIncludedSpecies();
                if (listOfIncludedSpecies == null) {
                    listOfIncludedSpecies = new ListOfIncludedSpecies();
                    this.sbml.getModel().getAnnotation().getExtension().setListOfIncludedSpecies(listOfIncludedSpecies);
                }
                Species species = speciesWrapper.getCDIncludedSpecies();
                listOfIncludedSpecies.getSpecies().add(species);
                continue;
            }
            org.sbml.sbml.level2.version4.Species species = speciesWrapper.getCDNormalSpecies();
            this.sbml.getModel().getListOfSpecies().getSpecies().add(species);
        }
        for (Protein protein : this.protMap.values()) {
            this.sbml.getModel().getAnnotation().getExtension().getListOfProteins().getProtein().add(protein);
        }
        for (Gene gene : this.geneMap.values()) {
            this.sbml.getModel().getAnnotation().getExtension().getListOfGenes().getGene().add(gene);
        }
        for (RNA rNA : this.rnaMap.values()) {
            this.sbml.getModel().getAnnotation().getExtension().getListOfRNAs().getRNA().add(rNA);
        }
        for (AntisenseRNA antisenseRNA : this.asrnaMap.values()) {
            this.sbml.getModel().getAnnotation().getExtension().getListOfAntisenseRNAs().getAntisenseRNA().add(antisenseRNA);
        }
    }

    private void processLogicReaction(Glyph logicGlyph) {
        List<Arc> connectedArcs = this.glyphToArc.get(logicGlyph.getId());
        Point2D.Float logicCoords = new Point2D.Float(logicGlyph.getBbox().getX() + logicGlyph.getBbox().getW() / 2.0f, logicGlyph.getBbox().getY() + logicGlyph.getBbox().getH() / 2.0f);
        ReactionType reactionCDClass = ReactionType.BOOLEAN_LOGIC_GATE;
        List<List<Arc>> tmp = SBGNUtils.getBLGReactantTypes(connectedArcs);
        List<Arc> reactants = tmp.get(0);
        Arc productArc = tmp.get(1).get(0);
        ArrayList<ReactantWrapper> baseReactantsW = new ArrayList<ReactantWrapper>();
        ArrayList<Glyph> baseReactantGlyphs = new ArrayList<Glyph>();
        ArrayList<Arc> baseReactantArcs = new ArrayList<Arc>();
        ArrayList<String> aliases = new ArrayList<String>();
        ArrayList<String> speciesModifiers = new ArrayList<String>();
        for (Arc arc : reactants) {
            Glyph g = this.arcToSource.get(arc.getId());
            AliasWrapper aliasW = this.aliasWrapperMap.get(g.getId() + "_alias1");
            ReactantWrapper baseWrapper = new ReactantWrapper(aliasW, ReactantWrapper.ReactantType.BASE_REACTANT);
            baseWrapper.setModificationLinkType(ModificationLinkType.valueOf(LinkModel.getCdClass(ArcClazz.fromClazz(productArc.getClazz()))));
            baseReactantsW.add(baseWrapper);
            baseReactantGlyphs.add(g);
            baseReactantArcs.add(arc);
            aliases.add(aliasW.getId());
            speciesModifiers.add(aliasW.getSpeciesId());
        }
        Glyph baseProductGlyph = this.arcToTarget.get(productArc.getId());
        AliasWrapper aliasW = this.aliasWrapperMap.get(baseProductGlyph.getId() + "_alias1");
        ReactantWrapper baseProductW = new ReactantWrapper(aliasW, ReactantWrapper.ReactantType.BASE_PRODUCT);
        baseProductW.setModificationLinkType(ModificationLinkType.valueOf(LinkModel.getCdClass(ArcClazz.fromClazz(productArc.getClazz()))));
        ReactionWrapper reactionW = new ReactionWrapper(logicGlyph.getId().replaceAll("-", "_"), reactionCDClass, baseReactantsW, Collections.singletonList(baseProductW));
        AbstractMap.SimpleEntry<Link, Link> tmpProductLink = this.baseLinkProcessingStep1(baseProductW, baseProductGlyph, productArc, logicCoords, false, new ReactionFeatures(false, true, false));
        List<Point2D.Float> localEditPointsProduct = tmpProductLink.getKey().getEditPoints();
        Point2D.Float finalEndPoint = tmpProductLink.getKey().getEnd();
        Link productLink = tmpProductLink.getValue();
        Point2D.Float logicPoint = new Point2D.Float((float)(logicCoords.getX() - this.mapBounds.getX()), (float)(logicCoords.getY() - this.mapBounds.getY()));
        LineWrapper productLineWrapper = this.buildLineWrapper(productArc.getId(), localEditPointsProduct, logicPoint);
        LogicGateWrapper logicW = new LogicGateWrapper(baseProductW, LogicGate.getLogicGateType(GlyphClazz.fromClazz(logicGlyph.getClazz())), speciesModifiers, aliases, baseProductW.getModificationLinkType());
        logicW.setLineWrapper(productLineWrapper);
        logicW.setTargetLineIndex("-1,0");
        reactionW.getModifiers().add(logicW);
        int i = 0;
        for (ReactantWrapper reactantWrapper : baseReactantsW) {
            List<Point2D.Float> localEditPoints0 = this.baseLinkProcessingStep1(reactantWrapper, (Glyph)baseReactantGlyphs.get(i), (Arc)baseReactantArcs.get(i), logicCoords, true, new ReactionFeatures(false, true, false, true)).getKey().getEditPoints();
            reactantWrapper.setTargetLineIndex("-1,0");
            ArrayList<String> editPointStringList = new ArrayList<String>();
            for (Point2D.Float p : localEditPoints0) {
                editPointStringList.add(p.getX() + "," + p.getY());
            }
            LineWrapper lineWrapper = this.buildLineWrapper(((Arc)baseReactantArcs.get(i)).getId(), localEditPoints0, null);
            reactantWrapper.setLineWrapper(lineWrapper);
            ++i;
        }
        ArrayList<String> baseReactionEditPointString = new ArrayList<String>();
        for (Point2D.Float p : logicW.getLineWrapper().getEditPoints()) {
            baseReactionEditPointString.add(p.getX() + "," + p.getY());
        }
        Line line = new Line();
        line.setWidth(BigDecimal.valueOf(1L));
        line.setColor("ff000000");
        LineWrapper baseLineWrapper = new LineWrapper(null, baseReactionEditPointString, line);
        reactionW.setLineWrapper(baseLineWrapper);
        this.sbml.getModel().getListOfReactions().getReaction().add(reactionW.getCDReaction());
    }

    private void processReaction(Glyph processGlyph) {
        LineWrapper lineWrapper;
        List<Point2D.Float> localEditPoints;
        List<Object> editPointsOnly;
        Glyph additionalGlyph;
        ReactantWrapper additionalW;
        Arc additionalArc;
        LineWrapper lineWrapper2;
        LinkedHashMap<String, List<Point2D.Float>> arcsId2Editpoints;
        Line2D.Float processLine;
        AbstractMap.SimpleEntry<Point2D.Float, Point2D.Float> tmpResult;
        ReactionFeatures reactionFeatures;
        ReactantWrapper additionalWrapper;
        ReactantWrapper baseWrapper;
        AliasWrapper aliasW;
        Glyph g;
        List<Arc> connectedArcs = this.processToArcs.get(processGlyph.getId());
        Point2D.Float processCoords = new Point2D.Float(processGlyph.getBbox().getX(), processGlyph.getBbox().getY());
        boolean isReversible = SBGNUtils.isReactionReversible(connectedArcs);
        ReactionType reactionCDClass = ReactionType.STATE_TRANSITION;
        List<List<Arc>> tmp = SBGNUtils.getReactantTypes(connectedArcs, isReversible);
        List<Arc> reactants = tmp.get(0);
        List<Arc> products = tmp.get(1);
        List<Arc> modifiers = tmp.get(2);
        if (SBGNUtils.isReactionAssociation(processGlyph, reactants, products)) {
            reactionCDClass = ReactionType.HETERODIMER_ASSOCIATION;
        } else if (SBGNUtils.isReactionDissociation(processGlyph, reactants, products)) {
            reactionCDClass = ReactionType.DISSOCIATION;
        } else {
            switch (GlyphClazz.fromClazz(processGlyph.getClazz())) {
                case OMITTED_PROCESS: {
                    reactionCDClass = ReactionType.KNOWN_TRANSITION_OMITTED;
                    break;
                }
                case UNCERTAIN_PROCESS: {
                    reactionCDClass = ReactionType.UNKNOWN_TRANSITION;
                }
            }
        }
        ArrayList<ReactantWrapper> baseReactantsW = new ArrayList<ReactantWrapper>();
        ArrayList<Glyph> baseReactantGlyphs = new ArrayList<Glyph>();
        ArrayList<Arc> baseReactantArcs = new ArrayList<Arc>();
        ArrayList<ReactantWrapper> additionallReactantsW = new ArrayList<ReactantWrapper>();
        ArrayList<Glyph> additionalReactantGlyphs = new ArrayList<Glyph>();
        ArrayList<Arc> additionalReactantArcs = new ArrayList<Arc>();
        ArrayList<ReactantWrapper> baseProductsW = new ArrayList<ReactantWrapper>();
        ArrayList<Glyph> baseProductGlyphs = new ArrayList<Glyph>();
        ArrayList<Arc> baseProductArcs = new ArrayList<Arc>();
        ArrayList<ReactantWrapper> additionalProductsW = new ArrayList<ReactantWrapper>();
        ArrayList<Glyph> additionalProductGlyphs = new ArrayList<Glyph>();
        ArrayList<Arc> additionalProductArcs = new ArrayList<Arc>();
        ArrayList<ReactantWrapper> modificationsW = new ArrayList<ReactantWrapper>();
        ArrayList<Glyph> modificationsGlyphs = new ArrayList<Glyph>();
        ArrayList<Arc> modificationsArcs = new ArrayList<Arc>();
        int i = 0;
        for (Arc arc : reactants) {
            g = isReversible ? this.arcToTarget.get(arc.getId()) : this.arcToSource.get(arc.getId());
            aliasW = this.aliasWrapperMap.get(g.getId() + "_alias1");
            if (reactionCDClass == ReactionType.HETERODIMER_ASSOCIATION && i == 1 || i == 0) {
                baseWrapper = new ReactantWrapper(aliasW, ReactantWrapper.ReactantType.BASE_REACTANT);
                baseReactantsW.add(baseWrapper);
                baseReactantGlyphs.add(g);
                baseReactantArcs.add(arc);
            } else {
                additionalWrapper = new ReactantWrapper(aliasW, ReactantWrapper.ReactantType.ADDITIONAL_REACTANT);
                additionallReactantsW.add(additionalWrapper);
                additionalReactantGlyphs.add(g);
                additionalReactantArcs.add(arc);
            }
            ++i;
        }
        i = 0;
        for (Arc arc : products) {
            g = this.arcToTarget.get(arc.getId());
            aliasW = this.aliasWrapperMap.get(g.getId() + "_alias1");
            if (i == 0 || reactionCDClass == ReactionType.DISSOCIATION && i == 1) {
                baseWrapper = new ReactantWrapper(aliasW, ReactantWrapper.ReactantType.BASE_PRODUCT);
                baseProductsW.add(baseWrapper);
                baseProductGlyphs.add(g);
                baseProductArcs.add(arc);
            } else {
                additionalWrapper = new ReactantWrapper(aliasW, ReactantWrapper.ReactantType.ADDITIONAL_PRODUCT);
                additionalProductsW.add(additionalWrapper);
                additionalProductGlyphs.add(g);
                additionalProductArcs.add(arc);
            }
            ++i;
        }
        i = 0;
        for (Arc arc : modifiers) {
            g = this.arcToSource.get(arc.getId());
            aliasW = this.aliasWrapperMap.get(g.getId() + "_alias1");
            ReactantWrapper modifWrapper = new ReactantWrapper(aliasW, ReactantWrapper.ReactantType.MODIFICATION);
            modifWrapper.setModificationLinkType(ModificationLinkType.valueOf(LinkModel.getCdClass(ArcClazz.fromClazz(arc.getClazz()))));
            modificationsW.add(modifWrapper);
            modificationsGlyphs.add(g);
            modificationsArcs.add(arc);
            ++i;
        }
        ReactionWrapper reactionW = new ReactionWrapper(processGlyph.getId().replaceAll("-", "_"), reactionCDClass, baseReactantsW, baseProductsW);
        reactionW.setReversible(isReversible);
        if (reactionCDClass == ReactionType.HETERODIMER_ASSOCIATION) {
            reactionFeatures = new ReactionFeatures(isReversible, true, true);
            ReactantWrapper baseReactantW0 = (ReactantWrapper)baseReactantsW.get(0);
            ReactantWrapper baseReactantW1 = (ReactantWrapper)baseReactantsW.get(1);
            ReactantWrapper baseProductW = (ReactantWrapper)baseProductsW.get(0);
            tmpResult = this.getAssocDissocPoints(Arrays.asList(baseReactantW0, baseReactantW1, baseProductW), processGlyph, processCoords, (Arc)baseProductArcs.get(0), true);
            Point2D.Float absAssocPoint = tmpResult.getKey();
            Point2D.Float localAssocPoint = tmpResult.getValue();
            List<Point2D.Float> localEditPoints0 = this.baseLinkProcessingStep1(baseReactantW0, (Glyph)baseReactantGlyphs.get(0), (Arc)baseReactantArcs.get(0), absAssocPoint, true, reactionFeatures).getKey().getEditPoints();
            List<Point2D.Float> localEditPoints1 = this.baseLinkProcessingStep1(baseReactantW1, (Glyph)baseReactantGlyphs.get(1), (Arc)baseReactantArcs.get(1), absAssocPoint, true, reactionFeatures).getKey().getEditPoints();
            AbstractMap.SimpleEntry<Link, Link> tmpResultPoints = this.baseLinkProcessingStep1(baseProductW, (Glyph)baseProductGlyphs.get(0), (Arc)baseProductArcs.get(0), absAssocPoint, false, reactionFeatures);
            List<Point2D.Float> localEditPoints2 = tmpResultPoints.getKey().getEditPoints();
            Point2D.Float finalEndPoint = tmpResultPoints.getKey().getEnd();
            Link productLink = tmpResultPoints.getValue();
            processLine = this.getProcessLine(productLink, absAssocPoint, reactionFeatures);
            arcsId2Editpoints = new LinkedHashMap<String, List<Point2D.Float>>();
            arcsId2Editpoints.put(((Arc)baseReactantArcs.get(0)).getId(), localEditPoints0);
            arcsId2Editpoints.put(((Arc)baseReactantArcs.get(1)).getId(), localEditPoints1);
            arcsId2Editpoints.put(((Arc)baseProductArcs.get(0)).getId(), localEditPoints2);
            lineWrapper2 = this.buildLineWrapperWithProcess(arcsId2Editpoints, processGlyph.getId(), localAssocPoint);
            reactionW.setLineWrapper(lineWrapper2);
        } else if (reactionCDClass == ReactionType.DISSOCIATION) {
            reactionFeatures = new ReactionFeatures(isReversible, true, false);
            ReactantWrapper baseReactantW = (ReactantWrapper)baseReactantsW.get(0);
            ReactantWrapper baseProductW1 = (ReactantWrapper)baseProductsW.get(0);
            ReactantWrapper baseProductW2 = (ReactantWrapper)baseProductsW.get(1);
            tmpResult = this.getAssocDissocPoints(Arrays.asList(baseReactantW, baseProductW1, baseProductW2), processGlyph, processCoords, (Arc)baseReactantArcs.get(0), false);
            Point2D.Float absDissocPoint = tmpResult.getKey();
            Point2D.Float localDissocPoint = tmpResult.getValue();
            AbstractMap.SimpleEntry<Link, Link> tmpResultPoints = this.baseLinkProcessingStep1(baseReactantW, (Glyph)baseReactantGlyphs.get(0), (Arc)baseReactantArcs.get(0), absDissocPoint, true, reactionFeatures);
            List<Point2D.Float> localEditPoints0 = tmpResultPoints.getKey().getEditPoints();
            Point2D.Float finalStartPoint = tmpResultPoints.getKey().getStart();
            Link reactantLink = tmpResultPoints.getValue();
            List<Point2D.Float> localEditPoints1 = this.baseLinkProcessingStep1(baseProductW1, (Glyph)baseProductGlyphs.get(0), (Arc)baseProductArcs.get(0), absDissocPoint, false, reactionFeatures).getKey().getEditPoints();
            List<Point2D.Float> localEditPoints2 = this.baseLinkProcessingStep1(baseProductW2, (Glyph)baseProductGlyphs.get(1), (Arc)baseProductArcs.get(1), absDissocPoint, false, reactionFeatures).getKey().getEditPoints();
            processLine = this.getProcessLine(reactantLink, absDissocPoint, reactionFeatures);
            arcsId2Editpoints = new LinkedHashMap();
            arcsId2Editpoints.put(((Arc)baseReactantArcs.get(0)).getId(), localEditPoints0);
            arcsId2Editpoints.put(((Arc)baseProductArcs.get(0)).getId(), localEditPoints1);
            arcsId2Editpoints.put(((Arc)baseProductArcs.get(1)).getId(), localEditPoints2);
            lineWrapper2 = this.buildLineWrapperWithProcess(arcsId2Editpoints, processGlyph.getId(), localDissocPoint);
            reactionW.setLineWrapper(lineWrapper2);
        } else {
            ReactantWrapper baseReactantW = (ReactantWrapper)baseReactantsW.get(0);
            Glyph baseReactantGlyph = (Glyph)baseReactantGlyphs.get(0);
            ReactantWrapper baseProductW = (ReactantWrapper)baseProductsW.get(0);
            Glyph baseProductGlyph = (Glyph)baseProductGlyphs.get(0);
            List<Point2D.Float> reactantPoints = SBGNUtils.getPoints((Arc)baseReactantArcs.get(0));
            if (isReversible) {
                Collections.reverse(reactantPoints);
            }
            List<Point2D.Float> productPoints = SBGNUtils.getPoints((Arc)baseProductArcs.get(0));
            ArrayList<Point2D.Float> completeLinkPoints = new ArrayList<Point2D.Float>(reactantPoints);
            completeLinkPoints.addAll(productPoints);
            List editPointsOnly2 = completeLinkPoints.size() > 2 ? completeLinkPoints.subList(1, completeLinkPoints.size() - 1) : new ArrayList();
            Point2D.Float startPoint = (Point2D.Float)completeLinkPoints.get(0);
            Point2D.Float endPoint = (Point2D.Float)completeLinkPoints.get(completeLinkPoints.size() - 1);
            AnchorPoint startAnchor = SBGNML2CD.inferAnchorPoint(startPoint, baseReactantW, SBGNUtils.getRectangleFromGlyph((Glyph)baseReactantGlyphs.get(0)));
            baseReactantW.setAnchorPoint(startAnchor);
            AnchorPoint endAnchor = SBGNML2CD.inferAnchorPoint(endPoint, baseProductW, SBGNUtils.getRectangleFromGlyph((Glyph)baseProductGlyphs.get(0)));
            baseProductW.setAnchorPoint(endAnchor);
            Point2D.Float finalStartPoint = SBGNML2CD.getFinalpoint(baseReactantW.getAnchorPoint(), baseReactantW, SBGNUtils.getRectangleFromGlyph(baseReactantGlyph));
            Point2D.Float finalEndPoint = SBGNML2CD.getFinalpoint(baseProductW.getAnchorPoint(), baseProductW, SBGNUtils.getRectangleFromGlyph(baseProductGlyph));
            List<Point2D.Float> localEditPoints2 = GeometryUtils.convertPoints(editPointsOnly2, GeometryUtils.getTransformsToLocalCoords(finalStartPoint, finalEndPoint));
            processLine = editPointsOnly2.size() > 0 ? new Line2D.Float((Point2D)completeLinkPoints.get(reactantPoints.size() - 1), (Point2D)completeLinkPoints.get(reactantPoints.size())) : new Line2D.Float(finalStartPoint, finalEndPoint);
            int processSegmentIndex = reactantPoints.size() - 1;
            LinkedHashMap<String, List<Point2D.Float>> arcsId2Editpoints2 = new LinkedHashMap<String, List<Point2D.Float>>();
            arcsId2Editpoints2.put(((Arc)baseReactantArcs.get(0)).getId(), localEditPoints2.subList(0, processSegmentIndex));
            arcsId2Editpoints2.put(((Arc)baseProductArcs.get(0)).getId(), localEditPoints2.subList(processSegmentIndex, localEditPoints2.size()));
            LineWrapper lineWrapper3 = this.buildLineWrapperWithProcess(arcsId2Editpoints2, processGlyph.getId(), null);
            reactionW.setLineWrapper(lineWrapper3);
        }
        Process pr = new Process(GeometryUtils.getMiddle((Point2D.Float)processLine.getP1(), (Point2D.Float)processLine.getP2()), processGlyph.getId(), processLine, new StyleInfo(processGlyph.getId()));
        for (i = 0; i < additionalReactantArcs.size(); ++i) {
            additionalArc = (Arc)additionalReactantArcs.get(i);
            additionalW = (ReactantWrapper)additionallReactantsW.get(i);
            additionalGlyph = (Glyph)additionalReactantGlyphs.get(i);
            additionalW.setTargetLineIndex("-1,0");
            List<Point2D.Float> additionalReactPoints = SBGNUtils.getPoints(additionalArc);
            if (processGlyph.getPort().size() > 0) {
                additionalReactPoints.add(new Point2D.Float(processGlyph.getBbox().getX(), processGlyph.getBbox().getY()));
            }
            if (isReversible) {
                Collections.reverse(additionalReactPoints);
            }
            editPointsOnly = additionalReactPoints.size() > 2 ? additionalReactPoints.subList(1, additionalReactPoints.size() - 1) : new ArrayList();
            Point2D.Float startPoint = additionalReactPoints.get(0);
            AnchorPoint startAnchor = SBGNML2CD.inferAnchorPoint(startPoint, additionalW, SBGNUtils.getRectangleFromGlyph(additionalGlyph));
            additionalW.setAnchorPoint(startAnchor);
            Point2D.Float finalStartPoint = SBGNML2CD.getFinalpoint(additionalW.getAnchorPoint(), additionalW, SBGNUtils.getRectangleFromGlyph(additionalGlyph));
            Point2D.Float anchor0 = pr.getAbsoluteAnchorCoords(0);
            localEditPoints = GeometryUtils.convertPoints(editPointsOnly, GeometryUtils.getTransformsToLocalCoords(finalStartPoint, anchor0));
            lineWrapper = this.buildLineWrapper(additionalArc.getId(), localEditPoints, null);
            additionalW.setLineWrapper(lineWrapper);
            reactionW.getAdditionalReactants().add(additionalW);
        }
        for (i = 0; i < additionalProductArcs.size(); ++i) {
            additionalArc = (Arc)additionalProductArcs.get(i);
            additionalW = (ReactantWrapper)additionalProductsW.get(i);
            additionalGlyph = (Glyph)additionalProductGlyphs.get(i);
            additionalW.setTargetLineIndex("-1,1");
            ArrayList<Point2D.Float> additionalProdPoints = new ArrayList<Point2D.Float>();
            if (processGlyph.getPort().size() > 0) {
                additionalProdPoints.add(new Point2D.Float(processGlyph.getBbox().getX(), processGlyph.getBbox().getY()));
            }
            additionalProdPoints.addAll(SBGNUtils.getPoints(additionalArc));
            editPointsOnly = additionalProdPoints.size() > 2 ? additionalProdPoints.subList(1, additionalProdPoints.size() - 1) : new ArrayList();
            Point2D.Float endPoint = (Point2D.Float)additionalProdPoints.get(additionalProdPoints.size() - 1);
            AnchorPoint endAnchor = SBGNML2CD.inferAnchorPoint(endPoint, additionalW, SBGNUtils.getRectangleFromGlyph(additionalGlyph));
            additionalW.setAnchorPoint(endAnchor);
            Point2D.Float finalEndPoint = SBGNML2CD.getFinalpoint(additionalW.getAnchorPoint(), additionalW, SBGNUtils.getRectangleFromGlyph(additionalGlyph));
            Point2D.Float anchor1 = pr.getAbsoluteAnchorCoords(1);
            localEditPoints = GeometryUtils.convertPoints(editPointsOnly, GeometryUtils.getTransformsToLocalCoords(anchor1, finalEndPoint));
            lineWrapper = this.buildLineWrapper(additionalArc.getId(), localEditPoints, null);
            additionalW.setLineWrapper(lineWrapper);
            reactionW.getAdditionalProducts().add(additionalW);
        }
        for (i = 0; i < modificationsArcs.size(); ++i) {
            Arc modificationArc = (Arc)modificationsArcs.get(i);
            ReactantWrapper modificationW = (ReactantWrapper)modificationsW.get(i);
            Glyph modificationGlyph = (Glyph)modificationsGlyphs.get(i);
            if (SBGNUtils.isLogicGate(modificationGlyph)) {
                List<Arc> arcsConnectedToLogic = this.glyphToArc.get(modificationGlyph.getId());
                ArrayList<ReactantWrapper> connectedReactantsW = new ArrayList<ReactantWrapper>();
                ArrayList<String> logicModifiers = new ArrayList<String>();
                ArrayList<String> logicAliases = new ArrayList<String>();
                for (Arc logicArc : arcsConnectedToLogic) {
                    Glyph sourceGlyhp = this.arcToSource.get(logicArc.getId());
                    if (SBGNUtils.isLogicGate(sourceGlyhp)) continue;
                    AliasWrapper aliasW2 = this.aliasWrapperMap.get(sourceGlyhp.getId() + "_alias1");
                    ReactantWrapper modifWrapper = new ReactantWrapper(aliasW2, ReactantWrapper.ReactantType.MODIFICATION);
                    modifWrapper.setModificationLinkType(ModificationLinkType.valueOf(LinkModel.getCdClass(ArcClazz.fromClazz(modificationArc.getClazz()))));
                    ReactantWrapper processedLogicModifW = this.processModifierToLogic(logicArc, sourceGlyhp, modifWrapper, modificationGlyph);
                    connectedReactantsW.add(processedLogicModifW);
                    logicModifiers.add(processedLogicModifW.getAliasW().getSpeciesW().getId());
                    logicAliases.add(processedLogicModifW.getAliasW().getId());
                }
                ReactantWrapper processedlogicW = this.processLogicGate(modificationArc, modificationGlyph, modificationW, pr);
                LogicGateWrapper finalLogicW = new LogicGateWrapper(processedlogicW, LogicGateWrapper.LogicGateType.valueOf(modificationGlyph.getClazz().toUpperCase()), logicModifiers, logicAliases, processedlogicW.getModificationLinkType());
                this.orphanLogicGates.remove(modificationGlyph);
                finalLogicW.setAnchorPoint(AnchorPoint.CENTER);
                reactionW.getModifiers().add(finalLogicW);
                for (ReactantWrapper connectedToLogic : connectedReactantsW) {
                    reactionW.getModifiers().add(connectedToLogic);
                }
            } else {
                ReactantWrapper processedModifW = this.processModifier(modificationArc, modificationGlyph, modificationW, pr);
                reactionW.getModifiers().add(processedModifW);
            }
            for (ModifierSpeciesReference speciesReference : reactionW.getCDReaction().getListOfModifiers().getModifierSpeciesReference()) {
                String speciesId = speciesReference.getSpecies();
                SpeciesWrapper speciesW = this.speciesWrapperMap.get(speciesId);
                speciesW.getCatalyzedReactions().add(reactionW.getId());
            }
        }
        this.setNotes(reactionW, processGlyph);
        this.setAnnotations(reactionW, processGlyph);
        this.sbml.getModel().getListOfReactions().getReaction().add(reactionW.getCDReaction());
    }

    private void processOrphanArc(Arc orphanArc) {
        Glyph targetGlyph = this.arcToTarget.get(orphanArc.getId());
        Glyph sourceGlyph = this.arcToSource.get(orphanArc.getId());
        AliasWrapper sourceAliasW = this.aliasWrapperMap.get(sourceGlyph.getId() + "_alias1");
        AliasWrapper targetAliasW = this.aliasWrapperMap.get(targetGlyph.getId() + "_alias1");
        if (sourceAliasW == null || targetAliasW == null) {
            this.logger.warn("Discarding arc because its source or target could not be translated");
            return;
        }
        ReactantWrapper sourceWrapper = new ReactantWrapper(sourceAliasW, ReactantWrapper.ReactantType.BASE_REACTANT);
        ReactantWrapper targetWrapper = new ReactantWrapper(targetAliasW, ReactantWrapper.ReactantType.BASE_PRODUCT);
        List<Point2D.Float> arcPoints = SBGNUtils.getPoints(orphanArc);
        List<Object> editPointsOnly = arcPoints.size() > 2 ? arcPoints.subList(1, arcPoints.size() - 1) : new ArrayList();
        Point2D.Float startPoint = arcPoints.get(0);
        Point2D.Float endPoint = arcPoints.get(arcPoints.size() - 1);
        AnchorPoint startAnchor = SBGNML2CD.inferAnchorPoint(startPoint, sourceWrapper, SBGNUtils.getRectangleFromGlyph(sourceGlyph));
        sourceWrapper.setAnchorPoint(startAnchor);
        AnchorPoint endAnchor = SBGNML2CD.inferAnchorPoint(endPoint, targetWrapper, SBGNUtils.getRectangleFromGlyph(targetGlyph));
        targetWrapper.setAnchorPoint(endAnchor);
        Point2D.Float finalStartPoint = SBGNML2CD.getFinalpoint(sourceWrapper.getAnchorPoint(), sourceWrapper, SBGNUtils.getRectangleFromGlyph(sourceGlyph));
        Point2D.Float finalEndPoint = SBGNML2CD.getFinalpoint(targetWrapper.getAnchorPoint(), targetWrapper, SBGNUtils.getRectangleFromGlyph(targetGlyph));
        List<Point2D.Float> localEditPoints = GeometryUtils.convertPoints(editPointsOnly, GeometryUtils.getTransformsToLocalCoords(finalStartPoint, finalEndPoint));
        LineWrapper lineWrapper = this.buildLineWrapper(orphanArc.getId(), localEditPoints, null);
        ReactionWrapper reactionW = new ReactionWrapper(orphanArc.getId(), ReactionType.valueOf(LinkModel.getReducedCdClass(ArcClazz.fromClazz(orphanArc.getClazz()))), Collections.singletonList(sourceWrapper), Collections.singletonList(targetWrapper));
        reactionW.setLineWrapper(lineWrapper);
        reactionW.setHasProcess(false);
        this.sbml.getModel().getListOfReactions().getReaction().add(reactionW.getCDReaction());
    }

    private ReactantWrapper processModifierToLogic(Arc modificationArc, Glyph modificationGlyph, ReactantWrapper modificationW, Glyph logicGateGlyph) {
        List<Point2D.Float> modificationPoints = SBGNUtils.getPoints(modificationArc);
        if (logicGateGlyph.getPort().size() > 0) {
            modificationPoints.add(new Point2D.Float(logicGateGlyph.getBbox().getX() + logicGateGlyph.getBbox().getW() / 2.0f, logicGateGlyph.getBbox().getY() + logicGateGlyph.getBbox().getH() / 2.0f));
        }
        List<Object> editPointsOnly = modificationPoints.size() > 2 ? modificationPoints.subList(1, modificationPoints.size() - 1) : new ArrayList();
        Point2D.Float startPoint = modificationPoints.get(0);
        Point2D.Float endPoint = modificationPoints.get(modificationPoints.size() - 1);
        if (!SBGNUtils.isLogicGate(modificationGlyph)) {
            AnchorPoint startAnchor = SBGNML2CD.inferAnchorPoint(startPoint, modificationW, SBGNUtils.getRectangleFromGlyph(modificationGlyph));
            modificationW.setAnchorPoint(startAnchor);
        }
        Point2D.Float finalEndPoint = endPoint;
        modificationW.setTargetLineIndex("-1,0");
        Point2D.Float finalStartPoint = SBGNML2CD.getFinalpoint(modificationW.getAnchorPoint(), modificationW, SBGNUtils.getRectangleFromGlyph(modificationGlyph));
        List<Point2D.Float> localEditPoints = GeometryUtils.convertPoints(editPointsOnly, GeometryUtils.getTransformsToLocalCoords(finalStartPoint, finalEndPoint));
        LineWrapper lineWrapper = this.buildLineWrapper(modificationArc.getId(), localEditPoints, null);
        modificationW.setLineWrapper(lineWrapper);
        return modificationW;
    }

    private ReactantWrapper processLogicGate(Arc modificationArc, Glyph modificationGlyph, ReactantWrapper modificationW, Process pr) {
        ArrayList<Point2D.Float> modificationPoints = new ArrayList<Point2D.Float>();
        if (modificationGlyph.getPort().size() > 0) {
            modificationPoints.add(new Point2D.Float(modificationGlyph.getBbox().getX() + modificationGlyph.getBbox().getW() / 2.0f, modificationGlyph.getBbox().getY() + modificationGlyph.getBbox().getH() / 2.0f));
        }
        modificationPoints.addAll(SBGNUtils.getPoints(modificationArc));
        List editPointsOnly = modificationPoints.size() > 2 ? modificationPoints.subList(1, modificationPoints.size() - 1) : new ArrayList();
        Point2D.Float startPoint = (Point2D.Float)modificationPoints.get(0);
        Point2D.Float endPoint = (Point2D.Float)modificationPoints.get(modificationPoints.size() - 1);
        int processAnchor = SBGNML2CD.inferProcessAnchorPoint(endPoint, pr);
        modificationW.setTargetLineIndex("-1," + processAnchor);
        Point2D.Float finalEndPoint = pr.getAbsoluteAnchorCoords(processAnchor);
        Point2D.Float finalStartPoint = startPoint;
        List<Point2D.Float> localEditPoints = GeometryUtils.convertPoints(editPointsOnly, GeometryUtils.getTransformsToLocalCoords(finalStartPoint, finalEndPoint));
        Point2D.Float logicPoint = new Point2D.Float((float)(finalStartPoint.getX() - this.mapBounds.getX()), (float)(finalStartPoint.getY() - this.mapBounds.getY()));
        LineWrapper lineWrapper = this.buildLineWrapper(modificationArc.getId(), localEditPoints, logicPoint);
        modificationW.setLineWrapper(lineWrapper);
        return modificationW;
    }

    private ReactantWrapper processModifier(Arc modificationArc, Glyph modificationGlyph, ReactantWrapper modificationW, Object prOrLogic) {
        LineWrapper lineWrapper;
        List<Point2D.Float> modificationPoints = SBGNUtils.getPoints(modificationArc);
        List<Object> editPointsOnly = modificationPoints.size() > 2 ? modificationPoints.subList(1, modificationPoints.size() - 1) : new ArrayList();
        Point2D.Float startPoint = modificationPoints.get(0);
        Point2D.Float endPoint = modificationPoints.get(modificationPoints.size() - 1);
        if (!SBGNUtils.isLogicGate(modificationGlyph)) {
            AnchorPoint startAnchor = SBGNML2CD.inferAnchorPoint(startPoint, modificationW, SBGNUtils.getRectangleFromGlyph(modificationGlyph));
            modificationW.setAnchorPoint(startAnchor);
        }
        Point2D.Float finalEndPoint = null;
        if (prOrLogic instanceof Process) {
            Process pr = (Process)prOrLogic;
            int processAnchor = SBGNML2CD.inferProcessAnchorPoint(endPoint, pr);
            modificationW.setTargetLineIndex("-1," + processAnchor);
            finalEndPoint = pr.getAbsoluteAnchorCoords(processAnchor);
        } else if (prOrLogic instanceof Point2D) {
            finalEndPoint = (Point2D.Float)prOrLogic;
            modificationW.setTargetLineIndex("-1,0");
        }
        Point2D.Float finalStartPoint = null;
        finalStartPoint = SBGNUtils.isLogicGate(modificationGlyph) ? new Point2D.Float((float)((double)modificationGlyph.getBbox().getX() - this.mapBounds.getX() + (double)(modificationGlyph.getBbox().getW() / 2.0f)), (float)((double)modificationGlyph.getBbox().getY() - this.mapBounds.getY() + (double)(modificationGlyph.getBbox().getH() / 2.0f))) : SBGNML2CD.getFinalpoint(modificationW.getAnchorPoint(), modificationW, SBGNUtils.getRectangleFromGlyph(modificationGlyph));
        List<Point2D.Float> localEditPoints = GeometryUtils.convertPoints(editPointsOnly, GeometryUtils.getTransformsToLocalCoords(finalStartPoint, finalEndPoint));
        if (SBGNUtils.isLogicGate(modificationGlyph)) {
            Point2D.Float logicPoint = new Point2D.Float((float)finalStartPoint.getX(), (float)finalStartPoint.getY());
            lineWrapper = this.buildLineWrapper(modificationArc.getId(), localEditPoints, logicPoint);
        } else {
            lineWrapper = this.buildLineWrapper(modificationArc.getId(), localEditPoints, null);
        }
        modificationW.setLineWrapper(lineWrapper);
        return modificationW;
    }

    private ConnectScheme getSimpleConnectScheme(int segmentCount, int processSegmentIndex) {
        ConnectScheme connectScheme = new ConnectScheme();
        connectScheme.setConnectPolicy("direct");
        if (processSegmentIndex != -1) {
            connectScheme.setRectangleIndex(String.valueOf(processSegmentIndex));
        }
        ListOfLineDirection listOfLineDirection = new ListOfLineDirection();
        connectScheme.setListOfLineDirection(listOfLineDirection);
        for (int i = 0; i < segmentCount; ++i) {
            LineDirection lineDirection = new LineDirection();
            lineDirection.setIndex((short)i);
            lineDirection.setValue("unknown");
            listOfLineDirection.getLineDirection().add(lineDirection);
        }
        return connectScheme;
    }

    private ConnectScheme getBranchConnectScheme(List<Integer> segmentCountlist) {
        ConnectScheme connectScheme = new ConnectScheme();
        connectScheme.setConnectPolicy("direct");
        ListOfLineDirection listOfLineDirection = new ListOfLineDirection();
        connectScheme.setListOfLineDirection(listOfLineDirection);
        for (int i = 0; i < segmentCountlist.size(); ++i) {
            for (int j = 0; j < segmentCountlist.get(i); ++j) {
                LineDirection lineDirection = new LineDirection();
                lineDirection.setArm((short)i);
                lineDirection.setIndex((short)j);
                lineDirection.setValue("unknown");
                listOfLineDirection.getLineDirection().add(lineDirection);
            }
        }
        return connectScheme;
    }

    /*
     * WARNING - void declaration
     */
    private void processSpecies(Glyph glyph, boolean isIncluded, boolean isComplex, String parentSpeciesId, String parentAliasId) {
        int n;
        AliasWrapper aliasW;
        SpeciesWrapper speciesW;
        String label = glyph.getLabel() == null ? "" : glyph.getLabel().getText();
        label = Utils.UTF8charsToCD(label);
        List unitOfInfoList = glyph.getGlyph().stream().filter(g -> GlyphClazz.fromClazz(g.getClazz()) == GlyphClazz.UNIT_OF_INFORMATION).collect(Collectors.toList());
        SpeciesWrapper.ReferenceType subType = null;
        boolean ionFlag = false;
        boolean drugFlag = false;
        if (!isComplex) {
            switch (GlyphClazz.fromClazz(glyph.getClazz())) {
                case MACROMOLECULE: 
                case MACROMOLECULE_MULTIMER: {
                    subType = SpeciesWrapper.ReferenceType.GENERIC;
                    Optional<Glyph> g2 = SBGNUtils.getUnitOfInfo(glyph, "receptor");
                    if (g2.isPresent()) {
                        subType = SpeciesWrapper.ReferenceType.RECEPTOR;
                        unitOfInfoList.remove(g2.get());
                    }
                    if ((g2 = SBGNUtils.getUnitOfInfo(glyph, "ion channel")).isPresent()) {
                        subType = SpeciesWrapper.ReferenceType.ION_CHANNEL;
                        unitOfInfoList.remove(g2.get());
                    }
                    if (!(g2 = SBGNUtils.getUnitOfInfo(glyph, "truncated")).isPresent()) break;
                    subType = SpeciesWrapper.ReferenceType.TRUNCATED;
                    unitOfInfoList.remove(g2.get());
                    break;
                }
                case NUCLEIC_ACID_FEATURE: 
                case NUCLEIC_ACID_FEATURE_MULTIMER: {
                    subType = SpeciesWrapper.ReferenceType.GENE;
                    Optional<Glyph> g2 = SBGNUtils.getUnitOfInfo(glyph, "rna");
                    if (g2.isPresent()) {
                        subType = SpeciesWrapper.ReferenceType.RNA;
                        unitOfInfoList.remove(g2.get());
                    }
                    if (!(g2 = SBGNUtils.getUnitOfInfo(glyph, "asrna")).isPresent()) break;
                    subType = SpeciesWrapper.ReferenceType.ANTISENSE_RNA;
                    unitOfInfoList.remove(g2.get());
                    break;
                }
                case SIMPLE_CHEMICAL: 
                case SIMPLE_CHEMICAL_MULTIMER: {
                    Optional<Glyph> g2 = SBGNUtils.getUnitOfInfo(glyph, "ion");
                    if (g2.isPresent()) {
                        ionFlag = true;
                        unitOfInfoList.remove(g2.get());
                    }
                    if (!(g2 = SBGNUtils.getUnitOfInfo(glyph, "drug")).isPresent()) break;
                    drugFlag = true;
                    unitOfInfoList.remove(g2.get());
                }
            }
        }
        ArrayList<ResidueWrapper> residueList = new ArrayList<ResidueWrapper>();
        int i = 0;
        for (Glyph stateVar : SBGNUtils.getStateVariables(glyph)) {
            double angle = GeometryUtils.getAngleOfAuxUnit(SBGNUtils.getRectangleFromGlyph(glyph), SBGNUtils.getRectangleFromGlyph(stateVar));
            double topRatio = GeometryUtils.getTopRatioOfAuxUnit(SBGNUtils.getRectangleFromGlyph(glyph), SBGNUtils.getRectangleFromGlyph(stateVar));
            String string = stateVar.getState().getVariable();
            String string2 = stateVar.getState().getValue();
            ResidueWrapper residueWrapper = new ResidueWrapper("rs" + i);
            residueWrapper.name = string;
            residueWrapper.state = ResidueWrapper.getLongState(string2);
            residueWrapper.angle = (float)angle;
            residueWrapper.relativePos = (float)topRatio;
            residueList.add(residueWrapper);
            ++i;
        }
        HashSet<String> recognizedInfo = new HashSet<String>(Arrays.asList("pc:T", "pc:V", "pc:pH", "mt:ion", "mt:rad", "mt:rna", "mt:dna", "mt:prot", "mt:psac", "ct:gene", "ct:tss", "ct:coding", "ct:grr", "ct:mRNA"));
        ArrayList<AliasInfoWrapper> infoWrapperList = new ArrayList<AliasInfoWrapper>();
        for (Glyph infoUnit : unitOfInfoList) {
            void var21_58;
            void var20_42;
            double angle = -GeometryUtils.getAngleOfAuxUnit(SBGNUtils.getRectangleFromGlyph(glyph), SBGNUtils.getRectangleFromGlyph(infoUnit));
            String string = infoUnit.getLabel().getText();
            if (recognizedInfo.contains(string) || string.startsWith("N:")) {
                String[] tmp = string.split(":");
                String string3 = tmp[0];
                String string4 = tmp[1];
            } else {
                String string5 = "free input";
                String string6 = string;
            }
            AliasInfoWrapper infoWrapper = new AliasInfoWrapper((float)angle, (String)var20_42, (String)var21_58);
            infoWrapperList.add(infoWrapper);
        }
        String referenceId = glyph.getId();
        if (subType != null) {
            switch (subType) {
                case GENERIC: 
                case RECEPTOR: 
                case ION_CHANNEL: 
                case TRUNCATED: {
                    Protein prot = new Protein();
                    prot.setType(subType.toString());
                    referenceId = "prot_" + glyph.getId();
                    prot.setId(referenceId);
                    prot.setName(label);
                    if (residueList.size() > 0) {
                        ListOfModificationResidues listOfModificationResidues = new ListOfModificationResidues();
                        prot.setListOfModificationResidues(listOfModificationResidues);
                        for (ResidueWrapper residueWrapper : residueList) {
                            ModificationResidue modificationResidue = new ModificationResidue();
                            listOfModificationResidues.getModificationResidue().add(modificationResidue);
                            modificationResidue.setSide("none");
                            modificationResidue.setAngle(BigDecimal.valueOf(residueWrapper.angle));
                            modificationResidue.setId(residueWrapper.id);
                            if (residueWrapper.name == null || residueWrapper.name.isEmpty()) continue;
                            modificationResidue.setName(residueWrapper.name);
                        }
                    }
                    this.protMap.put(referenceId, prot);
                    break;
                }
                case GENE: {
                    Gene gene = new Gene();
                    referenceId = "gene_" + glyph.getId();
                    gene.setId(referenceId);
                    gene.setName(label);
                    gene.setType("GENE");
                    if (residueList.size() > 0) {
                        ListOfRegions listOfRegions = new ListOfRegions();
                        gene.setListOfRegions(listOfRegions);
                        for (ResidueWrapper residueWrapper : residueList) {
                            ListOfRegions.Region region = new ListOfRegions.Region();
                            listOfRegions.getRegion().add(region);
                            region.setId(residueWrapper.id);
                            region.setActive(false);
                            region.setSize(BigDecimal.valueOf(0L));
                            region.setType("Modification Site");
                            region.setPos(BigDecimal.valueOf(residueWrapper.relativePos));
                            if (residueWrapper.name == null || residueWrapper.name.isEmpty()) continue;
                            region.setName(residueWrapper.name);
                        }
                    }
                    this.geneMap.put(referenceId, gene);
                    break;
                }
                case RNA: {
                    RNA rna = new RNA();
                    referenceId = "rna_" + glyph.getId();
                    rna.setId(referenceId);
                    rna.setName(label);
                    rna.setType("RNA");
                    if (residueList.size() > 0) {
                        ListOfRegions listOfRegions = new ListOfRegions();
                        rna.setListOfRegions(listOfRegions);
                        for (ResidueWrapper residueWrapper : residueList) {
                            ListOfRegions.Region region = new ListOfRegions.Region();
                            listOfRegions.getRegion().add(region);
                            region.setId(residueWrapper.id);
                            region.setSize(BigDecimal.valueOf(0L));
                            region.setType("Modification Site");
                            region.setPos(BigDecimal.valueOf(residueWrapper.relativePos));
                            if (residueWrapper.name == null || residueWrapper.name.isEmpty()) continue;
                            region.setName(residueWrapper.name);
                        }
                    }
                    this.rnaMap.put(referenceId, rna);
                    break;
                }
                case ANTISENSE_RNA: {
                    AntisenseRNA antisenseRNA = new AntisenseRNA();
                    referenceId = "asrna_" + glyph.getId();
                    antisenseRNA.setId(referenceId);
                    antisenseRNA.setName(label);
                    antisenseRNA.setType("ANTISENSE_RNA");
                    if (residueList.size() > 0) {
                        ListOfRegions listOfRegions = new ListOfRegions();
                        antisenseRNA.setListOfRegions(listOfRegions);
                        for (ResidueWrapper resW : residueList) {
                            ListOfRegions.Region region = new ListOfRegions.Region();
                            listOfRegions.getRegion().add(region);
                            region.setId(resW.id);
                            region.setSize(BigDecimal.valueOf(0L));
                            region.setType("Modification Site");
                            region.setPos(BigDecimal.valueOf(resW.relativePos));
                            if (resW.name == null || resW.name.isEmpty()) continue;
                            region.setName(resW.name);
                        }
                    }
                    this.asrnaMap.put(referenceId, antisenseRNA);
                }
            }
        }
        String aliasId = glyph.getId() + "_alias1";
        if (isComplex) {
            speciesW = new SpeciesWrapper(glyph.getId(), label, null, referenceId);
            aliasW = new AliasWrapper(aliasId, AliasWrapper.AliasType.COMPLEX, speciesW);
        } else {
            speciesW = new SpeciesWrapper(glyph.getId(), label, subType, referenceId);
            aliasW = new AliasWrapper(aliasId, AliasWrapper.AliasType.SPECIES, speciesW);
        }
        speciesW.getAliases().add(aliasW);
        if (isIncluded) {
            void var19_33;
            AliasWrapper aliasWrapper = this.aliasWrapperMap.get(parentAliasId);
            while (var19_33.getTopLevelParent() != null) {
                AliasWrapper aliasWrapper2 = var19_33.getTopLevelParent();
            }
            aliasW.setTopLevelParent((AliasWrapper)var19_33);
        }
        if (ionFlag) {
            speciesW.setCdClass("ION");
        } else if (drugFlag) {
            speciesW.setCdClass("DRUG");
        } else {
            try {
                speciesW.setCdClass(ReactantModel.getCdClass(glyph.getClazz(), subType));
            }
            catch (Exception exception) {
                this.logger.error(exception.getMessage() + " Glyph will be skipped and will not appear in translation.");
                return;
            }
        }
        if (glyph.getCompartmentRef() != null) {
            speciesW.setCompartment(((Glyph)glyph.getCompartmentRef()).getId());
        } else {
            speciesW.setCompartment("default");
        }
        if (glyph.getClazz().endsWith("multimer")) {
            speciesW.setMultimer(2);
        }
        if ((n = SBGNUtils.getMultimerFromInfo(glyph)) > 0) {
            speciesW.setMultimer(n);
        }
        for (ResidueWrapper residueWrapper : residueList) {
            speciesW.getResidues().add(residueWrapper);
        }
        this.setNotes(speciesW, glyph);
        this.setAnnotations(speciesW, glyph);
        if (isIncluded) {
            speciesW.setComplex(parentSpeciesId);
            speciesW.setIncludedSpecies(true);
        }
        this.speciesWrapperMap.put(speciesW.getId(), speciesW);
        if (glyph.getCompartmentRef() != null) {
            aliasW.setCompartmentAlias(((Glyph)glyph.getCompartmentRef()).getId() + "_alias1");
        }
        Rectangle2D.Float float_ = new Rectangle2D.Float();
        float_.setRect(glyph.getBbox().getX() - (float)this.mapBounds.getX(), glyph.getBbox().getY() - (float)this.mapBounds.getY(), glyph.getBbox().getW(), glyph.getBbox().getH());
        aliasW.setBounds(float_);
        if (this.mapHasStyle) {
            aliasW.setStyleInfo(this.styleMap.get(glyph.getId()));
        } else {
            aliasW.setStyleInfo(new StyleInfo(aliasW.getId()));
        }
        if (isIncluded) {
            aliasW.setComplexAlias(parentAliasId);
        }
        if (infoWrapperList.size() > 0) {
            aliasW.setInfo((AliasInfoWrapper)infoWrapperList.get(0));
            if (infoWrapperList.size() > 1) {
                int n2 = 1;
                while (i < unitOfInfoList.size()) {
                    Glyph discardedUnit = (Glyph)unitOfInfoList.get(n2);
                    this.logger.error("Unit of information with id: " + discardedUnit.getId() + " and content: " + discardedUnit.getLabel().getText() + " on glyph with id: " + glyph.getId() + " cannot betranslated and will be lost.");
                    ++i;
                }
            }
        }
        if (isComplex) {
            ListOfComplexSpeciesAliases.ComplexSpeciesAlias complexSpeciesAlias = aliasW.getCDComplexSpeciesAlias();
            this.sbml.getModel().getAnnotation().getExtension().getListOfComplexSpeciesAliases().getComplexSpeciesAlias().add(complexSpeciesAlias);
        } else {
            SpeciesAlias speciesAlias = aliasW.getCDSpeciesAlias();
            this.sbml.getModel().getAnnotation().getExtension().getListOfSpeciesAliases().getSpeciesAlias().add(speciesAlias);
        }
        this.aliasWrapperMap.put(aliasW.getId(), aliasW);
        for (Glyph subglyph : glyph.getGlyph()) {
            if (subglyph.getClazz().equals("unit of information") || subglyph.getClazz().equals("state variable") || subglyph.getClazz().equals("entity")) continue;
            GlyphClazz subClazz = GlyphClazz.fromClazz(subglyph.getClazz());
            boolean isSubGlyphComplex = false;
            if (subClazz == GlyphClazz.COMPLEX || subClazz == GlyphClazz.COMPLEX_MULTIMER) {
                isSubGlyphComplex = true;
            }
            this.processSpecies(subglyph, true, isSubGlyphComplex, glyph.getId(), aliasId);
        }
    }

    private void processCompartment(Glyph glyph) {
        String label = glyph.getLabel() == null ? "" : glyph.getLabel().getText();
        CompartmentWrapper compM = new CompartmentWrapper(glyph.getId(), label, new Rectangle2D.Float(glyph.getBbox().getX() - (float)this.mapBounds.getX(), glyph.getBbox().getY() - (float)this.mapBounds.getY(), glyph.getBbox().getW(), glyph.getBbox().getH()));
        if (glyph.getCompartmentRef() != null) {
            compM.setOutside(((Glyph)glyph.getCompartmentRef()).getId());
        }
        if (this.mapHasStyle) {
            compM.setStyleInfo(this.styleMap.get(glyph.getId()));
        }
        if (glyph.getLabel() != null && glyph.getLabel().getBbox() != null) {
            Point2D.Float namePoint = new Point2D.Float(glyph.getLabel().getBbox().getX(), glyph.getLabel().getBbox().getY());
            compM.setNamePoint(namePoint);
        }
        this.setNotes(compM, glyph);
        this.setAnnotations(compM, glyph);
        this.sbml.getModel().getListOfCompartments().getCompartment().add(compM.getCDCompartment());
        this.sbml.getModel().getAnnotation().getExtension().getListOfCompartmentAliases().getCompartmentAlias().add(compM.getCDCompartmentAlias());
    }

    private Sbml initFile(Map map) {
        Sbml sbml = new Sbml();
        sbml.setLevel(BigInteger.valueOf(2L));
        sbml.setVersion(BigInteger.valueOf(4L));
        Model model = new Model();
        sbml.setModel(model);
        model.setId("untitled");
        model.setMetaid("untitled");
        ModelAnnotationType annotation = new ModelAnnotationType();
        model.setAnnotation(annotation);
        ModelAnnotationType.Extension ext = new ModelAnnotationType.Extension();
        ext.setModelVersion(BigDecimal.valueOf(4.0));
        this.mapBounds = SBGNUtils.getMapBounds(map);
        ModelDisplay modelDisplay = new ModelDisplay();
        modelDisplay.setSizeX((short)this.mapBounds.getWidth());
        modelDisplay.setSizeY((short)this.mapBounds.getHeight());
        ext.setModelDisplay(modelDisplay);
        ext.setListOfSpeciesAliases(new ListOfSpeciesAliases());
        ext.setListOfAntisenseRNAs(new ListOfAntisenseRNAs());
        ext.setListOfBlockDiagrams(new ListOfBlockDiagrams());
        ext.setListOfCompartmentAliases(new ListOfCompartmentAliases());
        ext.setListOfComplexSpeciesAliases(new ListOfComplexSpeciesAliases());
        ext.setListOfGenes(new ListOfGenes());
        ext.setListOfGroups(new ListOfGroups());
        ext.setListOfProteins(new ListOfProteins());
        ext.setListOfRNAs(new ListOfRNAs());
        annotation.setExtension(ext);
        OriginalModel.ListOfCompartments listOfCompartments = new OriginalModel.ListOfCompartments();
        model.setListOfCompartments(listOfCompartments);
        Compartment defaultCompartment = new Compartment();
        listOfCompartments.getCompartment().add(defaultCompartment);
        defaultCompartment.setId("default");
        defaultCompartment.setMetaid("default");
        defaultCompartment.setSize(1.0);
        defaultCompartment.setUnits("volume");
        OriginalModel.ListOfSpecies listOfSpecies = new OriginalModel.ListOfSpecies();
        model.setListOfSpecies(listOfSpecies);
        OriginalModel.ListOfReactions listOfReactions = new OriginalModel.ListOfReactions();
        model.setListOfReactions(listOfReactions);
        return sbml;
    }

    private void buildMaps(Map map) {
        this.idToGlyph = new HashMap<String, Glyph>();
        this.arcToSource = new HashMap<String, Glyph>();
        this.arcToTarget = new HashMap<String, Glyph>();
        this.processToArcs = new HashMap<String, List<Arc>>();
        this.portToGlyph = new HashMap<String, Glyph>();
        this.aliasWrapperMap = new HashMap<String, AliasWrapper>();
        this.speciesWrapperMap = new HashMap<String, SpeciesWrapper>();
        this.glyphToArc = new HashMap<String, List<Arc>>();
        this.orphanArcs = new ArrayList<Arc>();
        this.orphanLogicGates = new HashSet();
        this.protMap = new HashMap<String, Protein>();
        this.rnaMap = new HashMap<String, RNA>();
        this.geneMap = new HashMap<String, Gene>();
        this.asrnaMap = new HashMap<String, AntisenseRNA>();
        this.styleMap = new HashMap<String, StyleInfo>();
        this.mapHasStyle = false;
        if (map.getExtension() != null) {
            for (Element e : map.getExtension().getAny()) {
                if (!e.getTagName().equals("renderInformation")) continue;
                this.styleMap = SBGNUtils.mapStyleinfo(e);
                this.mapHasStyle = true;
            }
        }
        HashMap<String, Glyph> terminalId2Submap = new HashMap<String, Glyph>();
        for (Glyph g : map.getGlyph()) {
            GlyphClazz clazz = GlyphClazz.fromClazz(g.getClazz());
            this.idToGlyph.put(g.getId(), g);
            for (Port p : g.getPort()) {
                this.portToGlyph.put(p.getId(), g);
            }
            if (clazz == GlyphClazz.PROCESS || clazz == GlyphClazz.UNCERTAIN_PROCESS || clazz == GlyphClazz.OMITTED_PROCESS || clazz == GlyphClazz.ASSOCIATION || clazz == GlyphClazz.DISSOCIATION) {
                this.processToArcs.put(g.getId(), new ArrayList());
            }
            if (clazz == GlyphClazz.AND || clazz == GlyphClazz.OR || clazz == GlyphClazz.NOT) {
                this.orphanLogicGates.add(g);
            }
            if (clazz == GlyphClazz.SUBMAP) {
                for (Glyph subGlyph : g.getGlyph()) {
                    if (GlyphClazz.fromClazz(subGlyph.getClazz()) != GlyphClazz.TERMINAL) continue;
                    terminalId2Submap.put(subGlyph.getId(), g);
                }
            }
            this.glyphToArc.put(g.getId(), new ArrayList());
        }
        for (Arc arc : map.getArc()) {
            Glyph targetGlyph;
            Glyph sourceGlyph;
            Port p;
            boolean isConnectedToProcess = false;
            if (arc.getSource() instanceof Port) {
                p = (Port)arc.getSource();
                sourceGlyph = this.portToGlyph.get(p.getId());
            } else if (arc.getSource() instanceof Glyph && ((Glyph)arc.getSource()).getClazz().equals("terminal")) {
                this.logger.warn("The arc: " + arc.getId() + " has a source terminal (id: " + ((Glyph)arc.getSource()).getId() + "). But Arcs should always have terminals as target.");
                sourceGlyph = (Glyph)terminalId2Submap.get(((Glyph)arc.getSource()).getId());
            } else {
                sourceGlyph = (Glyph)arc.getSource();
            }
            this.arcToSource.put(arc.getId(), sourceGlyph);
            if (arc.getTarget() instanceof Port) {
                p = (Port)arc.getTarget();
                targetGlyph = this.portToGlyph.get(p.getId());
            } else {
                targetGlyph = arc.getTarget() instanceof Glyph && ((Glyph)arc.getTarget()).getClazz().equals("terminal") ? (Glyph)terminalId2Submap.get(((Glyph)arc.getTarget()).getId()) : (Glyph)arc.getTarget();
            }
            this.arcToTarget.put(arc.getId(), targetGlyph);
            if (this.processToArcs.containsKey(sourceGlyph.getId())) {
                this.processToArcs.get(sourceGlyph.getId()).add(arc);
                isConnectedToProcess = true;
            }
            if (this.processToArcs.containsKey(targetGlyph.getId())) {
                this.processToArcs.get(targetGlyph.getId()).add(arc);
                isConnectedToProcess = true;
            }
            if (this.glyphToArc.containsKey(sourceGlyph.getId())) {
                this.glyphToArc.get(sourceGlyph.getId()).add(arc);
            }
            if (this.glyphToArc.containsKey(targetGlyph.getId())) {
                this.glyphToArc.get(targetGlyph.getId()).add(arc);
            }
            if (isConnectedToProcess || SBGNUtils.isLogicGate(sourceGlyph) || SBGNUtils.isLogicGate(targetGlyph)) continue;
            this.orphanArcs.add(arc);
        }
    }

    public AbstractMap.SimpleEntry<Link, Link> baseLinkProcessingStep1(ReactantWrapper reactantW, Glyph glyph, Arc arc, Point2D.Float absAssocPoint, boolean isReactant, ReactionFeatures options) {
        List<Point2D.Float> reactantPoints0 = SBGNML2CD.applyCorrection(SBGNUtils.getPoints(arc), (float)this.mapBounds.getX(), (float)this.mapBounds.getY());
        if (options.isReversible() && isReactant) {
            Collections.reverse(reactantPoints0);
        }
        Link reactantLink0 = new Link(reactantPoints0);
        Rectangle2D.Float baseRect0 = SBGNUtils.getRectangleFromGlyph(glyph);
        baseRect0.setRect(baseRect0.getX() - this.mapBounds.getX(), baseRect0.getY() - this.mapBounds.getY(), baseRect0.getWidth(), baseRect0.getHeight());
        AnchorPoint startAnchor0 = isReactant ? SBGNML2CD.inferAnchorPoint(reactantLink0.getStart(), reactantW, baseRect0) : SBGNML2CD.inferAnchorPoint(reactantLink0.getEnd(), reactantW, baseRect0);
        reactantW.setAnchorPoint(startAnchor0);
        Point2D.Float finalPoint = SBGNML2CD.getFinalpoint(reactantW.getAnchorPoint(), reactantW, baseRect0);
        List<Point2D.Float> editpoints0 = reactantLink0.getEditPoints();
        if (!options.isReversible && isReactant) {
            Collections.reverse(editpoints0);
        }
        AffineTransform transform = options.isLogicGateReaction ? GeometryUtils.getTransformsToLocalCoords(finalPoint, absAssocPoint) : GeometryUtils.getTransformsToLocalCoords(absAssocPoint, finalPoint);
        List<Point2D.Float> localEditPoints0 = GeometryUtils.convertPoints(editpoints0, transform);
        ArrayList<Point2D.Float> finalAndLocalPoints = new ArrayList<Point2D.Float>();
        finalAndLocalPoints.add(new Point2D.Float());
        finalAndLocalPoints.addAll(localEditPoints0);
        finalAndLocalPoints.add(finalPoint);
        return new AbstractMap.SimpleEntry<Link, Link>(new Link(finalAndLocalPoints), reactantLink0);
    }

    public AbstractMap.SimpleEntry<Point2D.Float, Point2D.Float> getAssocDissocPoints(List<ReactantWrapper> reactants, Glyph processGlyph, Point2D.Float processCoords, Arc arc, boolean isAssociation) {
        Point2D.Float absAssocPoint = null;
        if (processGlyph.getPort().size() > 0) {
            Port oppositePort = isAssociation ? (Port)arc.getSource() : (Port)arc.getTarget();
            Port consumptionPort = null;
            for (Port p : processGlyph.getPort()) {
                if (p == oppositePort) continue;
                consumptionPort = p;
                break;
            }
            absAssocPoint = new Point2D.Float(consumptionPort.getX() - (float)this.mapBounds.getX(), consumptionPort.getY() - (float)this.mapBounds.getY());
        } else {
            absAssocPoint = new Point2D.Float((float)(processCoords.getX() - this.mapBounds.getX()), (float)(processCoords.getY() - this.mapBounds.getY()));
        }
        Point2D.Float localAssocPoint = GeometryUtils.convertPoints(Collections.singletonList(absAssocPoint), GeometryUtils.getTransformsToLocalCoords(reactants.get(0).getCenterPoint(), reactants.get(1).getCenterPoint(), reactants.get(2).getCenterPoint())).get(0);
        return new AbstractMap.SimpleEntry<Point2D.Float, Point2D.Float>(absAssocPoint, localAssocPoint);
    }

    public Line2D.Float getProcessLine(Link link, Point2D assocPoint, ReactionFeatures options) {
        if (link.getEditPoints().size() > 0) {
            if (options.isAssociation()) {
                return new Line2D.Float(assocPoint, link.getEditPoints().get(0));
            }
            return new Line2D.Float(link.getEditPoints().get(0), assocPoint);
        }
        if (options.isAssociation()) {
            return new Line2D.Float(assocPoint, link.getEnd());
        }
        return new Line2D.Float(link.getStart(), assocPoint);
    }

    public LineWrapper buildLineWrapperWithProcess(java.util.Map<String, List<Point2D.Float>> arcIds2LocalEditPoints, String processGLyphId, Point2D.Float localAssocPoint) {
        ArrayList<String> arcsIds = new ArrayList<String>();
        ArrayList<List<Point2D.Float>> editPointsList = new ArrayList<List<Point2D.Float>>();
        ArrayList<Integer> segmentCountList = new ArrayList<Integer>();
        int totalSegmentCount = 1;
        int processSegmentIndex = 0;
        boolean isBranchReactionType = localAssocPoint != null;
        boolean isFirstEntry = true;
        for (Map.Entry<String, List<Point2D.Float>> entry : arcIds2LocalEditPoints.entrySet()) {
            arcsIds.add(entry.getKey());
            editPointsList.add(entry.getValue());
            segmentCountList.add(entry.getValue().size() + 1);
            totalSegmentCount += entry.getValue().size();
            if (!isFirstEntry) continue;
            isFirstEntry = false;
            processSegmentIndex = entry.getValue().size();
        }
        ConnectScheme connectScheme = isBranchReactionType ? this.getBranchConnectScheme(segmentCountList) : this.getSimpleConnectScheme(totalSegmentCount, processSegmentIndex);
        String lineColor = "ff000000";
        float lineWidth = 1.0f;
        if (this.mapHasStyle) {
            boolean areAllStyleTheSame = true;
            StyleInfo arcStyle1 = this.styleMap.get(arcsIds.get(0));
            for (int i = 1; i < arcsIds.size(); ++i) {
                Iterator arcStyle2 = this.styleMap.get(arcsIds.get(i));
                if (arcStyle1.getLineWidth() == ((StyleInfo)((Object)arcStyle2)).getLineWidth() && arcStyle1.getLineColor().equals(((StyleInfo)((Object)arcStyle2)).getLineColor())) continue;
                areAllStyleTheSame = false;
                break;
            }
            StyleInfo processGlyphStyle = this.styleMap.get(processGLyphId);
            if (arcStyle1.getLineWidth() != processGlyphStyle.getLineWidth() || !arcStyle1.getLineColor().equals(processGlyphStyle.getLineColor())) {
                areAllStyleTheSame = false;
            }
            if (areAllStyleTheSame) {
                lineWidth = arcStyle1.getLineWidth();
                lineColor = arcStyle1.getLineColor();
            }
        }
        Line line = new Line();
        line.setWidth(BigDecimal.valueOf(lineWidth));
        line.setColor(lineColor);
        ArrayList<String> editPointString = new ArrayList<String>();
        ArrayList<Point2D.Float> mergedList = new ArrayList<Point2D.Float>();
        for (List list : editPointsList) {
            mergedList.addAll(list);
        }
        if (isBranchReactionType) {
            mergedList.add(localAssocPoint);
        }
        for (Point2D.Float float_ : mergedList) {
            editPointString.add(float_.getX() + "," + float_.getY());
        }
        LineWrapper lineWrapper = new LineWrapper(connectScheme, editPointString, line);
        if (isBranchReactionType) {
            lineWrapper.setNum0((Integer)segmentCountList.get(0) - 1);
            lineWrapper.setNum1((Integer)segmentCountList.get(1) - 1);
            lineWrapper.setNum2((Integer)segmentCountList.get(2) - 1);
            lineWrapper.settShapeIndex(0);
        }
        return lineWrapper;
    }

    public LineWrapper buildLineWrapper(String arcId, List<Point2D.Float> localEditPoints, Point2D.Float additionalPoint) {
        String lineColor = "ff000000";
        float lineWidth = 1.0f;
        if (this.mapHasStyle) {
            StyleInfo styleInfo = this.styleMap.get(arcId);
            lineWidth = styleInfo.getLineWidth();
            lineColor = styleInfo.getLineColor();
        }
        int segmentCount = localEditPoints.size() + 1;
        ConnectScheme connectScheme = this.getSimpleConnectScheme(segmentCount, -1);
        LineType2 line = new LineType2();
        line.setWidth(BigDecimal.valueOf(lineWidth));
        line.setColor(lineColor);
        line.setType("Straight");
        ArrayList<String> editPointString = new ArrayList<String>();
        for (Point2D.Float p : localEditPoints) {
            editPointString.add(p.getX() + "," + p.getY());
        }
        if (additionalPoint != null) {
            editPointString.add(additionalPoint.getX() + "," + additionalPoint.getY());
        }
        return new LineWrapper(connectScheme, editPointString, line);
    }

    public static AnchorPoint inferAnchorPoint(Point2D.Float p, ReactantWrapper reactantW, Rectangle2D.Float rect) {
        SpeciesWrapper speciesW = reactantW.getAliasW().getSpeciesW();
        CdShape baseProductShape = ReactantModel.getCdShape(speciesW.getCdClass(), speciesW.getType());
        AnchorPoint a = GeometryUtils.getNearestAnchorPoint(p, rect, baseProductShape);
        return a;
    }

    public static int inferProcessAnchorPoint(Point2D.Float p, Process process2) {
        double minDist = Double.MAX_VALUE;
        int result = -1;
        for (int i = 2; i < 8; ++i) {
            Point2D.Float anchorCoord = process2.getAbsoluteAnchorCoords(i);
            double distance = p.distance(anchorCoord);
            if (!(distance < minDist)) continue;
            minDist = distance;
            result = i;
        }
        return result;
    }

    public static Point2D.Float getFinalpoint(AnchorPoint a, ReactantWrapper reactantW, Rectangle2D.Float r) {
        SpeciesWrapper speciesW = reactantW.getAliasW().getSpeciesW();
        CdShape baseProductShape = ReactantModel.getCdShape(speciesW.getCdClass(), speciesW.getType());
        return GeometryUtils.getAbsoluteAnchorPoint(baseProductShape, r, a);
    }

    public static List<Point2D.Float> applyCorrection(List<Point2D.Float> points, float xdiff, float ydiff) {
        for (Point2D.Float p : points) {
            p.setLocation(p.getX() - (double)xdiff, p.getY() - (double)ydiff);
        }
        return points;
    }

    public void setNotes(INotesFeature notesFeature, SBGNBase sbgnEntity) {
        if (sbgnEntity.getNotes() != null && sbgnEntity.getNotes().getAny().size() > 0) {
            Element notes = sbgnEntity.getNotes().getAny().get(0);
            notesFeature.setNotes(notes);
        }
    }

    public void setAnnotations(IAnnotationsFeature annotationsFeature, SBGNBase sbgnEntity) {
        if (sbgnEntity.getExtension() != null) {
            for (Element e : sbgnEntity.getExtension().getAny()) {
                if (!e.getTagName().equals("annotation")) continue;
                Element rdf = SBGNUtils.sanitizeRdfURNs((Element)e.getElementsByTagName("rdf:RDF").item(0));
                annotationsFeature.setAnnotations(rdf);
            }
        }
    }

    @Override
    public GeneralModel convert(GeneralModel generalModel) throws ConversionException, ReadModelException {
        SBGNSBFCModel sbgnModel = (SBGNSBFCModel)generalModel;
        return new CellDesignerSBFCModel(this.toCD(sbgnModel.getModel()));
    }

    @Override
    public String getResultExtension() {
        return null;
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public String getHtmlDescription() {
        return null;
    }

    class ReactionFeatures {
        private boolean isReversible;
        private boolean isBranch;
        private boolean isAssociation;
        private boolean isLogicGateReaction;

        public ReactionFeatures(boolean isReversible, boolean isBranch, boolean isAssociation) {
            this.isReversible = isReversible;
            this.isBranch = isBranch;
            this.isAssociation = isAssociation;
            this.isLogicGateReaction = false;
        }

        public ReactionFeatures(boolean isReversible, boolean isBranch, boolean isAssociation, boolean isLogicGateReaction) {
            this.isReversible = isReversible;
            this.isBranch = isBranch;
            this.isAssociation = isAssociation;
            this.isLogicGateReaction = isLogicGateReaction;
        }

        public boolean isReversible() {
            return this.isReversible;
        }

        public boolean isAssociation() {
            return this.isBranch && this.isAssociation;
        }

        public boolean isDissociation() {
            return this.isBranch && !this.isAssociation;
        }

        public boolean isReactionSimple() {
            return !this.isBranch;
        }

        public boolean isLogicGateReaction() {
            return this.isLogicGateReaction;
        }
    }
}

