/*
 * Decompiled with CFR 0.152.
 */
package fr.curie.cd2sbgnml;

import fr.curie.cd2sbgnml.CD2SBGNML;
import fr.curie.cd2sbgnml.CellDesignerSBFCModel;
import fr.curie.cd2sbgnml.SBGNML2CD;
import fr.curie.cd2sbgnml.SBGNSBFCModel;
import fr.curie.cd2sbgnml.xmlcdwrappers.Utils;
import java.io.File;
import java.io.IOException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.util.ValidationEventCollector;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.sbfc.converter.exceptions.ConversionException;
import org.sbfc.converter.exceptions.ReadModelException;
import org.sbfc.converter.exceptions.WriteModelException;
import org.sbgn.SbgnUtil;
import org.sbml.sbml.level2.version4.Sbml;
import org.xml.sax.SAXException;

public class Main {
    public static void main(String[] args) {
        System.out.println("test");
        String inputFile = "samples/reaction.xml";
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = null;
        try {
            schema = sf.newSchema(new File("schema/CellDesigner.xsd"));
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{Sbml.class});
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            unmarshaller.setSchema(schema);
            unmarshaller.setEventHandler((ValidationEventHandler)new ValidationEventCollector());
            Sbml sbml = (Sbml)unmarshaller.unmarshal(new File(inputFile));
        }
        catch (JAXBException | SAXException e) {
            e.printStackTrace();
        }
        CellDesignerSBFCModel cdModel = new CellDesignerSBFCModel();
        try {
            cdModel.setModelFromFile(inputFile);
        }
        catch (ReadModelException e) {
            e.printStackTrace();
        }
        try {
            CD2SBGNML cd2SBGNML = new CD2SBGNML();
            SBGNSBFCModel sbgnModel = (SBGNSBFCModel)cd2SBGNML.convert(cdModel);
            sbgnModel.modelToFile("samples/out.sbgnml");
        }
        catch (ConversionException | ReadModelException | WriteModelException e) {
            e.printStackTrace();
        }
        System.out.println("VALIDATION");
        try {
            SbgnUtil.isValid(new File("samples/out.sbgnml"));
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("CONVERT BACK TO CD");
        SBGNSBFCModel sbgnModel = new SBGNSBFCModel();
        try {
            sbgnModel.setModelFromFile("samples/out.sbgnml");
        }
        catch (ReadModelException e) {
            e.printStackTrace();
        }
        try {
            CellDesignerSBFCModel backCdModel = (CellDesignerSBFCModel)new SBGNML2CD().convert(sbgnModel);
            System.out.println(backCdModel.getSbml());
            File file = new File("samples/newCD.xml");
            Marshaller marshaller = JAXBContext.newInstance((Class[])new Class[]{Sbml.class}).createMarshaller();
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.setProperty("com.sun.xml.bind.namespacePrefixMapper", (Object)new Utils.DefaultNamespacePrefixMapper());
            marshaller.marshal((Object)backCdModel.getSbml(), file);
        }
        catch (ConversionException e) {
            e.printStackTrace();
        }
        catch (ReadModelException e) {
            e.printStackTrace();
        }
        catch (PropertyException e) {
            e.printStackTrace();
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        System.out.println("VALIDATION of CellDesigner final output");
        sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        schema = null;
        try {
            schema = sf.newSchema(new File("schema/CellDesigner.xsd"));
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{Sbml.class});
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            unmarshaller.setSchema(schema);
            unmarshaller.setEventHandler((ValidationEventHandler)new ValidationEventCollector());
            Sbml sbml = (Sbml)unmarshaller.unmarshal(new File("samples/newCD.xml"));
        }
        catch (JAXBException | SAXException e) {
            e.printStackTrace();
        }
    }
}

