/*
 * Decompiled with CFR 0.152.
 */
package fr.curie.cd2sbgnml;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import fr.curie.cd2sbgnml.CD2SBGNML;
import fr.curie.cd2sbgnml.CellDesignerSBFCModel;
import fr.curie.cd2sbgnml.SBGNSBFCModel;
import java.io.File;
import java.io.IOException;
import javax.xml.bind.JAXBException;
import org.sbfc.converter.exceptions.ConversionException;
import org.sbfc.converter.exceptions.ReadModelException;
import org.sbfc.converter.exceptions.WriteModelException;
import org.sbgn.SbgnUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class Cd2SbgnmlScript {
    @Parameter(names={"-i", "--input"}, required=true)
    private String inputFileName;
    @Parameter(names={"-o", "--output"}, required=true)
    private String outputFileName;

    public static void main(String[] args) {
        Logger logger = LoggerFactory.getLogger(Cd2SbgnmlScript.class);
        Cd2SbgnmlScript app = new Cd2SbgnmlScript();
        JCommander.newBuilder().addObject(app).build().parse(args);
        Cd2SbgnmlScript.convert(app.inputFileName, app.outputFileName);
    }

    public static void convert(String inputFileName, String outputFileName) {
        CD2SBGNML toSBGNConverter = new CD2SBGNML();
        long start = System.currentTimeMillis();
        CellDesignerSBFCModel cdModel = new CellDesignerSBFCModel();
        try {
            cdModel.setModelFromFile(inputFileName);
        }
        catch (ReadModelException e) {
            e.printStackTrace();
        }
        try {
            SBGNSBFCModel sbgnModel = (SBGNSBFCModel)toSBGNConverter.convert(cdModel);
            sbgnModel.modelToFile(outputFileName);
        }
        catch (ConversionException | ReadModelException | WriteModelException e) {
            e.printStackTrace();
        }
        long elapsedTimeMillis = System.currentTimeMillis() - start;
        System.out.println((float)elapsedTimeMillis / 1000.0f + " seconds");
        try {
            SbgnUtil.isValid(new File(outputFileName));
        }
        catch (IOException | JAXBException | SAXException e) {
            e.printStackTrace();
        }
    }
}

