/*
 * Decompiled with CFR 0.152.
 */
package fr.curie.cd2sbgnml;

import fr.curie.cd2sbgnml.CellDesignerSBFCModel;
import fr.curie.cd2sbgnml.SBGNSBFCModel;
import fr.curie.cd2sbgnml.graphics.CdShape;
import fr.curie.cd2sbgnml.graphics.GeometryUtils;
import fr.curie.cd2sbgnml.graphics.Link;
import fr.curie.cd2sbgnml.model.GenericReactionElement;
import fr.curie.cd2sbgnml.model.GenericReactionModel;
import fr.curie.cd2sbgnml.model.LinkModel;
import fr.curie.cd2sbgnml.model.LogicGate;
import fr.curie.cd2sbgnml.model.Process;
import fr.curie.cd2sbgnml.model.ReactantModel;
import fr.curie.cd2sbgnml.model.ReactionModelFactory;
import fr.curie.cd2sbgnml.model.ReactionNodeModel;
import fr.curie.cd2sbgnml.xmlcdwrappers.AliasWrapper;
import fr.curie.cd2sbgnml.xmlcdwrappers.ModelWrapper;
import fr.curie.cd2sbgnml.xmlcdwrappers.ReactantWrapper;
import fr.curie.cd2sbgnml.xmlcdwrappers.ReactionWrapper;
import fr.curie.cd2sbgnml.xmlcdwrappers.ResidueWrapper;
import fr.curie.cd2sbgnml.xmlcdwrappers.SpeciesWrapper;
import fr.curie.cd2sbgnml.xmlcdwrappers.StyleInfo;
import fr.curie.cd2sbgnml.xmlcdwrappers.TextWrapper;
import fr.curie.cd2sbgnml.xmlcdwrappers.Utils;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.sbfc.converter.GeneralConverter;
import org.sbfc.converter.exceptions.ConversionException;
import org.sbfc.converter.exceptions.ReadModelException;
import org.sbfc.converter.models.GeneralModel;
import org.sbgn.Language;
import org.sbgn.bindings.Arc;
import org.sbgn.bindings.Bbox;
import org.sbgn.bindings.Glyph;
import org.sbgn.bindings.Label;
import org.sbgn.bindings.Map;
import org.sbgn.bindings.Port;
import org.sbgn.bindings.SBGNBase;
import org.sbgn.bindings.Sbgn;
import org.sbml._2001.ns.celldesigner.Bounds;
import org.sbml._2001.ns.celldesigner.CompartmentAlias;
import org.sbml._2001.ns.celldesigner.ModelDisplay;
import org.sbml._2001.ns.celldesigner.Point;
import org.sbml.sbml.level2.version4.Compartment;
import org.sbml.sbml.level2.version4.Sbml;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CD2SBGNML
extends GeneralConverter {
    final Logger logger = LoggerFactory.getLogger(CD2SBGNML.class);
    List<Glyph> glyphList;
    HashMap<String, Glyph> glyphMap;
    List<StyleInfo> styleInfoList;
    HashMap<String, Port> portMap;

    public Sbgn toSbgn(Sbml sbml) {
        Sbgn sbgn = new Sbgn();
        Map map = new Map();
        sbgn.setMap(map);
        map.setLanguage(Language.PD.toString());
        ModelWrapper modelW = ModelWrapper.create(sbml);
        if (modelW.getModel().getNotes() != null) {
            map.setNotes(this.getSBGNNotes(Utils.getNotes(modelW.getModel().getNotes())));
        }
        map.setExtension(this.getSBGNAnnotation(Utils.getRDFAnnotations(modelW.getModel().getAnnotation().getAny()), "mapID"));
        this.logger.debug("number of species " + modelW.getListOfSpecies().size());
        this.logger.debug("number of included species " + modelW.getListOfIncludedSpecies().size());
        this.logger.debug("number of compartments " + modelW.getListOfCompartments().size());
        this.logger.debug("compartment aliases count: " + modelW.getListOfCompartmentAliases().size());
        this.glyphList = new ArrayList<Glyph>();
        this.glyphMap = new HashMap();
        this.styleInfoList = new ArrayList<StyleInfo>();
        this.portMap = new HashMap();
        for (Compartment compartment : modelW.getListOfCompartments()) {
            this.processCompartment(compartment, modelW, map);
        }
        for (SpeciesWrapper speciesW : modelW.getListOfSpeciesWrapper()) {
            this.processSpecies(speciesW, modelW, map);
        }
        for (ReactionWrapper reactionW : modelW.getListOfReactionWrapper()) {
            GenericReactionModel genericReactionModel = ReactionModelFactory.create(reactionW);
            this.logger.debug(reactionW.getId() + " " + reactionW.getReactantList().size());
            String processId = null;
            if (reactionW.hasProcess()) {
                Iterator<LinkModel> process2 = genericReactionModel.getProcess();
                Point2D.Float processCoord = ((GenericReactionElement)((Object)process2)).getGlyph().getCenter();
                Glyph processGlyph = new Glyph();
                processGlyph.setClazz(Process.getSbgnClass(genericReactionModel.getCdReactionType().toString()));
                processId = ((GenericReactionElement)((Object)process2)).getId();
                processGlyph.setId(processId);
                String processCompartmentId = null;
                boolean sameCompartmentForAllReactants = true;
                ArrayList<ReactantWrapper> combinedBaseWrapper = new ArrayList<ReactantWrapper>(reactionW.getBaseReactants());
                combinedBaseWrapper.addAll(reactionW.getBaseProducts());
                for (ReactantWrapper reactantW : combinedBaseWrapper) {
                    String reactantCompId = reactantW.getAliasW().getSpeciesW().getCompartment();
                    if (processCompartmentId == null) {
                        processCompartmentId = reactantCompId;
                        continue;
                    }
                    if (processCompartmentId.equals(reactantCompId)) continue;
                    sameCompartmentForAllReactants = false;
                    break;
                }
                this.logger.debug("Final process compartment is: " + processCompartmentId);
                if (sameCompartmentForAllReactants && !processCompartmentId.equals("default")) {
                    processGlyph.setCompartmentRef(this.glyphMap.get(processCompartmentId));
                }
                Bbox processBbox = new Bbox();
                processBbox.setX((float)((Point2D)processCoord).getX() - ((ReactionNodeModel)((Object)process2)).getSize() / 2.0f);
                processBbox.setY((float)((Point2D)processCoord).getY() - ((ReactionNodeModel)((Object)process2)).getSize() / 2.0f);
                processBbox.setH(((ReactionNodeModel)((Object)process2)).getSize());
                processBbox.setW(((ReactionNodeModel)((Object)process2)).getSize());
                processGlyph.setBbox(processBbox);
                processGlyph.setNotes(this.getSBGNNotes(reactionW.getNotes()));
                processGlyph.setExtension(this.getSBGNAnnotation(reactionW.getAnnotations(), processId));
                Port p1 = new Port();
                String p1Id = processId + "_p1";
                p1.setId(p1Id);
                p1.setX((float)((ReactionNodeModel)((Object)process2)).getPortIn().getX());
                p1.setY((float)((ReactionNodeModel)((Object)process2)).getPortIn().getY());
                processGlyph.getPort().add(p1);
                this.portMap.put(p1Id, p1);
                Port p2 = new Port();
                String p2Id = processId + "_p2";
                p2.setId(p2Id);
                p2.setX((float)((ReactionNodeModel)((Object)process2)).getPortOut().getX());
                p2.setY((float)((ReactionNodeModel)((Object)process2)).getPortOut().getY());
                processGlyph.getPort().add(p2);
                this.portMap.put(p2Id, p2);
                processGlyph.setOrientation(((ReactionNodeModel)((Object)process2)).getOrientation().name().toLowerCase());
                this.glyphList.add(processGlyph);
                this.glyphMap.put(processId, processGlyph);
                this.styleInfoList.add(genericReactionModel.getProcess().getStyleInfo());
                map.getGlyph().add(processGlyph);
            }
            for (ReactionNodeModel nodeModel : genericReactionModel.getReactionNodeModels()) {
                if (!(nodeModel instanceof LogicGate)) continue;
                LogicGate logicGate = (LogicGate)nodeModel;
                Point2D.Float logicCoord = logicGate.getGlyph().getCenter();
                Glyph logicGlyph = new Glyph();
                logicGlyph.setClazz(LogicGate.getSbgnClass(logicGate.getType()));
                String logicId = logicGate.getId();
                logicGlyph.setId(logicId);
                Bbox logicBbox = new Bbox();
                logicBbox.setX((float)((Point2D)logicCoord).getX() - logicGate.getSize() / 2.0f);
                logicBbox.setY((float)((Point2D)logicCoord).getY() - logicGate.getSize() / 2.0f);
                logicBbox.setH(logicGate.getSize());
                logicBbox.setW(logicGate.getSize());
                logicGlyph.setBbox(logicBbox);
                ArrayList<Glyph> connectedGLyphs = new ArrayList<Glyph>();
                for (LinkModel lm : genericReactionModel.getLinkModels()) {
                    String modifierId;
                    if (lm.getEnd().getId().equals(logicGate.getId())) {
                        modifierId = lm.getStart().getId();
                        connectedGLyphs.add(this.glyphMap.get(modifierId));
                        continue;
                    }
                    if (!lm.getStart().getId().equals(logicGate.getId())) continue;
                    modifierId = lm.getEnd().getId();
                    connectedGLyphs.add(this.glyphMap.get(modifierId));
                }
                String logicCompartmentId = null;
                boolean sameCompartmentForAllReactants = true;
                Glyph compartmentGlyph = null;
                for (Glyph g : connectedGLyphs) {
                    String glyphCompartmentId = g.getCompartmentRef() == null ? "default" : ((Glyph)g.getCompartmentRef()).getId();
                    if (logicCompartmentId == null) {
                        logicCompartmentId = glyphCompartmentId;
                        compartmentGlyph = (Glyph)g.getCompartmentRef();
                        continue;
                    }
                    if (logicCompartmentId.equals(glyphCompartmentId)) continue;
                    sameCompartmentForAllReactants = false;
                    break;
                }
                this.logger.debug("Final logic compartment is: " + logicCompartmentId);
                if (sameCompartmentForAllReactants && !logicCompartmentId.equals("default")) {
                    logicGlyph.setCompartmentRef(compartmentGlyph);
                }
                Port p1 = new Port();
                String p1Id = logicId + "_p1";
                p1.setId(p1Id);
                p1.setX((float)logicGate.getPortIn().getX());
                p1.setY((float)logicGate.getPortIn().getY());
                logicGlyph.getPort().add(p1);
                this.portMap.put(p1Id, p1);
                Port p2 = new Port();
                String p2Id = logicId + "_p2";
                p2.setId(p2Id);
                p2.setX((float)logicGate.getPortOut().getX());
                p2.setY((float)logicGate.getPortOut().getY());
                logicGlyph.getPort().add(p2);
                this.portMap.put(p2Id, p2);
                logicGlyph.setOrientation(logicGate.getOrientation().name().toLowerCase());
                this.glyphList.add(logicGlyph);
                this.glyphMap.put(logicId, logicGlyph);
                this.styleInfoList.add(logicGate.getStyleInfo());
                map.getGlyph().add(logicGlyph);
            }
            for (LinkModel ln : genericReactionModel.getLinkModels()) {
                this.styleInfoList.add(ln.getStyleInfo());
                map.getArc().add(this.getArc(ln));
            }
        }
        for (TextWrapper textW : modelW.getListofTextWrapper()) {
            if (!textW.isVisible()) continue;
            Glyph textGlyph = new Glyph();
            Bbox textBbox = new Bbox();
            textBbox.setX((float)textW.getBbox().getX());
            textBbox.setY((float)textW.getBbox().getY());
            textBbox.setW((float)textW.getBbox().getWidth());
            textBbox.setH((float)textW.getBbox().getHeight());
            textGlyph.setBbox(textBbox);
            Label textLabel = new Label();
            textLabel.setText(textW.getText());
            textGlyph.setLabel(textLabel);
            textGlyph.setClazz("annotation");
            textGlyph.setId("text_" + UUID.randomUUID());
            Glyph.Callout callout = new Glyph.Callout();
            org.sbgn.bindings.Point calloutPoint = new org.sbgn.bindings.Point();
            calloutPoint.setX((float)textW.getRefPoint().getX());
            calloutPoint.setY((float)textW.getRefPoint().getY());
            callout.setPoint(calloutPoint);
            textGlyph.setCallout(callout);
            map.getGlyph().add(textGlyph);
        }
        SBGNBase.Extension ext = new SBGNBase.Extension();
        ext.getAny().add(this.getAllStyles(this.styleInfoList, sbml));
        map.setExtension(ext);
        return sbgn;
    }

    public void processCompartment(Compartment compartment, ModelWrapper modelW, Map map) {
        if (!compartment.getId().equals("default")) {
            for (CompartmentAlias alias : modelW.getCompartmentAliasFor(compartment.getId())) {
                Bounds cdBounds = alias.getBounds();
                Point cdPoint = alias.getPoint();
                Glyph compGlyph = new Glyph();
                compGlyph.setClazz("compartment");
                String compartmentId = compartment.getId() + "_" + alias.getId();
                compGlyph.setId(compartmentId);
                if (!compartment.getOutside().equals("default")) {
                    compGlyph.setCompartmentRef(this.glyphMap.get(compartment.getOutside()));
                }
                Label compLabel = new Label();
                compLabel.setText(Utils.interpretToUTF8(compartment.getName()));
                if (alias.getNamePoint() != null) {
                    Bbox labelBbox = new Bbox();
                    labelBbox.setX(alias.getNamePoint().getX().floatValue());
                    labelBbox.setY(alias.getNamePoint().getY().floatValue());
                    labelBbox.setH(10.0f);
                    labelBbox.setW(GeometryUtils.getLengthForString(compartment.getName()));
                    compLabel.setBbox(labelBbox);
                }
                compGlyph.setLabel(compLabel);
                Bbox compBbox = new Bbox();
                if (cdBounds == null) {
                    float pointX = cdPoint.getX().floatValue();
                    float pointY = cdPoint.getY().floatValue();
                    ModelDisplay display = modelW.getModel().getAnnotation().getExtension().getModelDisplay();
                    float mapSizeX = display.getSizeX();
                    float mapSizeY = display.getSizeY();
                    Rectangle2D.Float bbox = GeometryUtils.getCompartmentBbox(alias.getClazz(), pointX, pointY, alias.getDoubleLine().getThickness().floatValue(), mapSizeX, mapSizeY);
                    compBbox.setX((float)bbox.getX());
                    compBbox.setY((float)bbox.getY());
                    compBbox.setW((float)bbox.getWidth());
                    compBbox.setH((float)bbox.getHeight());
                } else {
                    compBbox.setX(cdBounds.getX().floatValue());
                    compBbox.setY(cdBounds.getY().floatValue());
                    compBbox.setH(cdBounds.getH().floatValue());
                    compBbox.setW(cdBounds.getW().floatValue());
                }
                compGlyph.setBbox(compBbox);
                compGlyph.setNotes(this.getSBGNNotes(Utils.getNotes(compartment.getNotes())));
                compGlyph.setExtension(this.getSBGNAnnotation(Utils.getRDFAnnotations(compartment.getAnnotation().getAny()), compartmentId));
                this.glyphList.add(compGlyph);
                this.glyphMap.put(compartment.getId(), compGlyph);
                this.styleInfoList.add(new StyleInfo(alias, compartmentId));
                map.getGlyph().add(compGlyph);
            }
        }
    }

    public Glyph processSpeciesAlias(SpeciesWrapper species, AliasWrapper alias, ModelWrapper modelW, boolean isClone) {
        Glyph glyph = this.getGlyph(alias, isClone);
        if (species.getReferenceNotes() != null) {
            if (glyph.getNotes() != null) {
                glyph.getNotes().getAny().set(0, Utils.mergeHtmls(glyph.getNotes().getAny().get(0), species.getReferenceNotes()));
                this.logger.debug("MULTIPLE NOTES " + glyph.getNotes().getAny());
            } else {
                glyph.setNotes(this.getSBGNNotes(species.getReferenceNotes()));
            }
        }
        if (species.isComplex()) {
            if (modelW.getIncludedAliasWrapperFor(alias.getId()) == null) {
                this.logger.warn("Empty complex for species " + species.getId() + " alias: " + alias.getId() + " name: " + species.getName());
            } else {
                for (AliasWrapper includedAlias : modelW.getIncludedAliasWrapperFor(alias.getId())) {
                    SpeciesWrapper includedSpecies = modelW.getSpeciesWrapperFor(includedAlias.getSpeciesId());
                    Glyph includedGlyph = this.processSpeciesAlias(includedSpecies, includedAlias, modelW, isClone);
                    glyph.getGlyph().add(includedGlyph);
                    this.glyphList.add(includedGlyph);
                    this.glyphMap.put(includedGlyph.getId(), includedGlyph);
                    this.styleInfoList.add(includedAlias.getStyleInfo());
                }
            }
        }
        return glyph;
    }

    public void processSpecies(SpeciesWrapper species, ModelWrapper modelW, Map map) {
        boolean isClone = false;
        if (species.getAliases().size() > 1) {
            isClone = true;
        }
        for (AliasWrapper alias : species.getAliases()) {
            if (species.isIncludedSpecies()) continue;
            Glyph glyph = this.processSpeciesAlias(species, alias, modelW, isClone);
            this.glyphList.add(glyph);
            this.glyphMap.put(glyph.getId(), glyph);
            this.styleInfoList.add(alias.getStyleInfo());
            map.getGlyph().add(glyph);
        }
    }

    public Glyph getGlyph(AliasWrapper aliasW, boolean isClone) {
        Glyph rnaUnitOfInfo;
        Glyph receptorUnitOfInfo;
        String id = aliasW.getSpeciesW().getId() + "_" + aliasW.getId();
        SpeciesWrapper species = aliasW.getSpeciesW();
        Rectangle2D.Float bboxRect = (Rectangle2D.Float)aliasW.getBounds();
        Glyph glyph = new Glyph();
        glyph.setId(id);
        if (!species.isIncludedSpecies() && !species.getCompartment().equals("default")) {
            glyph.setCompartmentRef(this.glyphMap.get(species.getCompartment()));
        }
        Label label = new Label();
        label.setText(Utils.interpretToUTF8(species.getName()));
        glyph.setLabel(label);
        if (isClone) {
            glyph.setClone(new Glyph.Clone());
        }
        Bbox bbox = new Bbox();
        bbox.setX((float)bboxRect.getX());
        bbox.setY((float)bboxRect.getY());
        bbox.setH((float)bboxRect.getHeight());
        bbox.setW((float)bboxRect.getWidth());
        glyph.setBbox(bbox);
        if (species.getStructuralState() != null) {
            Glyph statevar = this.getStateVariable("", species.getStructuralState(), bboxRect, 90.0f);
            glyph.getGlyph().add(statevar);
        }
        if (aliasW.getInfo() != null) {
            Glyph unitOfInfo = this.getUnitOfInfo(aliasW.getInfo().getSbgnText(), bboxRect, -GeometryUtils.unsignedRadianToSignedDegree(aliasW.getInfo().angle));
            glyph.getGlyph().add(unitOfInfo);
        }
        String sbgnClass = ReactantModel.getSbgnClass(species.getCdClass());
        if (species.getMultimer() > 1) {
            sbgnClass = sbgnClass + " multimer";
            if (aliasW.getInfo() == null || !aliasW.getInfo().prefix.equals("N")) {
                float angle = 90.0f;
                if (species.getStructuralState() != null) {
                    angle = -90.0f;
                }
                Glyph unitOfInfoMultimer = this.getUnitOfInfo("N:" + species.getMultimer(), bboxRect, angle);
                glyph.getGlyph().add(unitOfInfoMultimer);
            }
        }
        for (ResidueWrapper residueW : species.getResidues()) {
            Glyph residue = this.getStateVariableFromResidueWrapper(residueW, bboxRect);
            glyph.getGlyph().add(residue);
        }
        if (species.getType() == SpeciesWrapper.ReferenceType.RECEPTOR) {
            receptorUnitOfInfo = this.getUnitOfInfo("receptor", bboxRect, 90.0f);
            glyph.getGlyph().add(receptorUnitOfInfo);
        } else if (species.getType() == SpeciesWrapper.ReferenceType.ION_CHANNEL) {
            receptorUnitOfInfo = this.getUnitOfInfo("ion channel", bboxRect, 90.0f);
            glyph.getGlyph().add(receptorUnitOfInfo);
            Glyph activeStateVar = aliasW.isActive() ? this.getStateVariable("", "open", bboxRect, -90.0f) : this.getStateVariable("", "closed", bboxRect, -90.0f);
            glyph.getGlyph().add(activeStateVar);
        } else if (species.getType() == SpeciesWrapper.ReferenceType.TRUNCATED) {
            receptorUnitOfInfo = this.getUnitOfInfo("truncated", bboxRect, 90.0f);
            glyph.getGlyph().add(receptorUnitOfInfo);
        } else if (species.getType() == SpeciesWrapper.ReferenceType.RNA) {
            rnaUnitOfInfo = this.getUnitOfInfo("RNA", bboxRect, 90.0f);
            glyph.getGlyph().add(rnaUnitOfInfo);
        } else if (species.getType() == SpeciesWrapper.ReferenceType.ANTISENSE_RNA) {
            rnaUnitOfInfo = this.getUnitOfInfo("asRNA", bboxRect, 90.0f);
            glyph.getGlyph().add(rnaUnitOfInfo);
        } else if (species.getCdClass().equals("DRUG")) {
            Glyph drugUnitOfInfo = this.getUnitOfInfo("drug", bboxRect, 90.0f);
            glyph.getGlyph().add(drugUnitOfInfo);
        }
        glyph.setNotes(this.getSBGNNotes(species.getNotes()));
        glyph.setExtension(this.getSBGNAnnotation(species.getAnnotations(), id));
        glyph.setClazz(sbgnClass);
        return glyph;
    }

    public Glyph getStateVariable(String prefix, String value, Rectangle2D.Float parentBbox, float angle) {
        Glyph unitOfInfo = new Glyph();
        Glyph.State state = new Glyph.State();
        state.setValue(value);
        state.setVariable(prefix);
        unitOfInfo.setState(state);
        Rectangle2D.Float infoRect = GeometryUtils.getAuxUnitBboxFromAngle(parentBbox, prefix + ":" + value, angle);
        Bbox infoBbox = new Bbox();
        infoBbox.setX((float)infoRect.getX());
        infoBbox.setY((float)infoRect.getY());
        infoBbox.setW((float)infoRect.getWidth());
        infoBbox.setH((float)infoRect.getHeight());
        unitOfInfo.setBbox(infoBbox);
        unitOfInfo.setClazz("state variable");
        unitOfInfo.setId("_" + UUID.randomUUID());
        return unitOfInfo;
    }

    public Glyph getStateVariableFromResidueWrapper(ResidueWrapper residueW, Rectangle2D.Float parentBbox) {
        Glyph unitOfInfo = new Glyph();
        String prefix = residueW.name;
        String value = ResidueWrapper.getShortState(residueW.state);
        Glyph.State state = new Glyph.State();
        state.setValue(value);
        state.setVariable(prefix);
        unitOfInfo.setState(state);
        Rectangle2D.Float infoRect = residueW.useAngle ? GeometryUtils.getAuxUnitBboxFromAngle(parentBbox, prefix + ":" + value, GeometryUtils.unsignedRadianToSignedDegree(residueW.angle)) : GeometryUtils.getAuxUnitBboxFromRelativeTopRatio(parentBbox, prefix + ":" + value, residueW.relativePos);
        Bbox infoBbox = new Bbox();
        infoBbox.setX((float)infoRect.getX());
        infoBbox.setY((float)infoRect.getY());
        infoBbox.setW((float)infoRect.getWidth());
        infoBbox.setH((float)infoRect.getHeight());
        unitOfInfo.setBbox(infoBbox);
        unitOfInfo.setClazz("state variable");
        unitOfInfo.setId("_" + UUID.randomUUID());
        return unitOfInfo;
    }

    public Glyph getUnitOfInfo(String text, Rectangle2D.Float parentBbox, float angle) {
        Glyph unitOfInfo = new Glyph();
        Label infoLabel = new Label();
        infoLabel.setText(Utils.interpretToUTF8(text));
        unitOfInfo.setLabel(infoLabel);
        Rectangle2D.Float infoRect = GeometryUtils.getAuxUnitBboxFromAngle(parentBbox, text, angle);
        Bbox infoBbox = new Bbox();
        infoBbox.setX((float)infoRect.getX());
        infoBbox.setY((float)infoRect.getY());
        infoBbox.setW((float)infoRect.getWidth());
        infoBbox.setH((float)infoRect.getHeight());
        unitOfInfo.setBbox(infoBbox);
        unitOfInfo.setClazz("unit of information");
        unitOfInfo.setId("_" + UUID.randomUUID());
        return unitOfInfo;
    }

    public Arc getArc(LinkModel linkM) {
        SBGNBase target;
        SBGNBase source;
        String portNumber;
        if (!this.glyphMap.containsKey(linkM.getStart().getId())) {
            this.logger.error("No source for link: " + linkM.getId() + " missing glyph " + linkM.getStart().getId());
        }
        if (!this.glyphMap.containsKey(linkM.getEnd().getId())) {
            this.logger.error("No target for link: " + linkM.getId() + " missing glyph " + linkM.getEnd().getId());
        }
        GenericReactionElement genericSource = linkM.getStart();
        GenericReactionElement genericTarget = linkM.getEnd();
        Link link = linkM.getLink();
        String clazz = linkM.getSbgnClass();
        Arc arc1 = new Arc();
        if (genericSource instanceof ReactionNodeModel) {
            portNumber = "p2";
            if (linkM.isReversed()) {
                portNumber = "p1";
            }
            source = this.portMap.get(genericSource.getId() + "_" + portNumber);
        } else {
            if (genericSource instanceof ReactantModel && genericSource.getGlyph().getCdShape() == CdShape.PHENOTYPE) {
                this.logger.warn("Arc with id: " + linkM.getId() + " is coming from phenotype glyph " + genericSource.getId() + ". Outgoing arcs are forbidden for phenotypes in SBGN, but are kept here.");
            }
            source = this.glyphMap.get(genericSource.getId());
        }
        if (genericTarget instanceof ReactionNodeModel && (clazz.equals("production") || clazz.equals("consumption") || clazz.equals("logic arc"))) {
            portNumber = "p1";
            if (linkM.isReversed()) {
                portNumber = "p2";
            }
            target = this.portMap.get(genericTarget.getId() + "_" + portNumber);
        } else {
            target = this.glyphMap.get(genericTarget.getId());
        }
        arc1.setSource(source);
        arc1.setTarget(target);
        arc1.setClazz(clazz);
        arc1.setId(linkM.getId());
        Point2D.Float startPoint = link.getStart();
        Point2D.Float endPoint = link.getEnd();
        Arc.Start s1 = new Arc.Start();
        s1.setX((float)((Point2D)startPoint).getX());
        s1.setY((float)((Point2D)startPoint).getY());
        arc1.setStart(s1);
        for (int i = 0; i < link.getEditPoints().size(); ++i) {
            Point2D p = link.getEditPoints().get(i);
            Arc.Next next = new Arc.Next();
            next.setX((float)p.getX());
            next.setY((float)p.getY());
            arc1.getNext().add(next);
        }
        Arc.End e1 = new Arc.End();
        e1.setX((float)((Point2D)endPoint).getX());
        e1.setY((float)((Point2D)endPoint).getY());
        arc1.setEnd(e1);
        return arc1;
    }

    public Element getAllStyles(List<StyleInfo> styleInfoList, Sbml sbmldoc) {
        Document baseDoc = null;
        try {
            baseDoc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        java.util.Map<String, String> colorMap = StyleInfo.getMapOfColorDefinitions(styleInfoList);
        Element renderInformation = baseDoc.createElement("renderInformation");
        renderInformation.setAttribute("xmlns", "http://www.sbml.org/sbml/level3/version1/render/version1");
        renderInformation.setAttribute("id", "renderInformation");
        renderInformation.setAttribute("programName", "cd2sbgnml");
        renderInformation.setAttribute("programVersion", "0.1");
        renderInformation.setAttribute("backgroundColor", "#ffffff");
        Element listofcolors = baseDoc.createElement("listOfColorDefinitions");
        renderInformation.appendChild(listofcolors);
        for (String color : colorMap.keySet()) {
            Element colorDef = baseDoc.createElement("colorDefinition");
            colorDef.setAttribute("id", colorMap.get(color));
            String alpha = color.substring(0, 2);
            color = "#" + color.substring(2) + alpha;
            colorDef.setAttribute("value", color);
            listofcolors.appendChild(colorDef);
        }
        Element listofstyles = baseDoc.createElement("listOfStyles");
        renderInformation.appendChild(listofstyles);
        HashMap<String, StyleInfo> styleMap = new HashMap<String, StyleInfo>();
        HashMap idListMap = new HashMap();
        for (StyleInfo sinfo : styleInfoList) {
            if (!styleMap.containsKey(sinfo.getId())) {
                styleMap.put(sinfo.getId(), sinfo);
                ArrayList<String> idList = new ArrayList<String>();
                idList.add(sinfo.getRefId());
                idListMap.put(sinfo.getId(), idList);
                continue;
            }
            ((List)idListMap.get(sinfo.getId())).add(sinfo.getRefId());
        }
        for (String styleId : styleMap.keySet()) {
            StyleInfo sinfo = (StyleInfo)styleMap.get(styleId);
            Element styleE = baseDoc.createElement("style");
            styleE.setAttribute("id", styleId);
            styleE.setAttribute("idList", ((List)idListMap.get(styleId)).stream().collect(Collectors.joining(" ")));
            Element g = baseDoc.createElement("g");
            g.setAttribute("fontSize", String.valueOf(sinfo.getFontSize()));
            g.setAttribute("stroke", colorMap.get(sinfo.getLineColor()));
            g.setAttribute("strokeWidth", String.valueOf(sinfo.getLineWidth()));
            g.setAttribute("fill", colorMap.get(sinfo.getBgColor()));
            styleE.appendChild(g);
            listofstyles.appendChild(styleE);
        }
        return renderInformation;
    }

    public SBGNBase.Notes getSBGNNotes(Element notes) {
        SBGNBase.Notes newNotes = new SBGNBase.Notes();
        if (notes != null) {
            newNotes.getAny().add(notes);
            return newNotes;
        }
        return null;
    }

    public SBGNBase.Extension getSBGNAnnotation(Element rdf, String refId) {
        if (rdf == null) {
            return null;
        }
        Element description = (Element)rdf.getElementsByTagName("rdf:Description").item(0);
        description.setAttribute("rdf:about", "#" + refId);
        SBGNBase.Extension newExt = new SBGNBase.Extension();
        Element annotationElement = rdf.getOwnerDocument().createElement("annotation");
        annotationElement.appendChild(rdf.cloneNode(true));
        newExt.getAny().add(annotationElement);
        return newExt;
    }

    @Override
    public GeneralModel convert(GeneralModel generalModel) throws ConversionException, ReadModelException {
        CellDesignerSBFCModel cdModel = (CellDesignerSBFCModel)generalModel;
        return new SBGNSBFCModel(this.toSbgn(cdModel.getSbml()));
    }

    @Override
    public String getResultExtension() {
        return null;
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public String getHtmlDescription() {
        return null;
    }
}

