```{eval-rst}
:html_theme.sidebar_secondary.remove: true
```

# ogstools Documentation

```{toctree}
---
hidden:
---
User Guide <user-guide/index>
Examples <examples/index>
API reference <reference/index>
Development <development/index>
Release notes <releases/index>
```

`ogstools` is a collection of Python tools aimed at evolving into a modeling toolchain around [OpenGeoSys](https://www.opengeosys.org), a finite element solver for coupled thermo-hydro-chemo-mechanical problems in the subsurface.

In this project we’ll collect existing pre and postprocessing scripts for OpenGeoSys at first. Over time we’ll develop an entire toolchain out of that collection. Currently we are at the stage of code collection.

**Date:** {sub-ref}`today` **Version:** {sub-ref}`version`

**Useful links:** [Source repository](https://gitlab.opengeosys.org/ogs/tools/ogstools) | [Issues](https://gitlab.opengeosys.org/ogs/tools/ogstools/-/issues) | [OpenGeoSys Website](https://www.opengeosys.org) | [OpenGeoSys Forum](https://discourse.opengeosys.org)

::::{grid} 1 2 2 2
:gutter: 4

:::{grid-item-card} User guide
:text-align: center

Get an overview over the key concepts of `ogstools` and the included tools.

---

```{button-ref} user-guide/index
:ref-type: doc
:color: primary
:click-parent:
:expand:
To the User guide
```

:::

:::{grid-item-card} Examples
:text-align: center

Examples of ogstools usage, especially in combination with other tools or even
complete modeling workflows.

---

```{button-ref} examples/index
:ref-type: doc
:color: primary
:click-parent:
:expand:
To the Examples section
```

:::

:::{grid-item-card} API reference
:text-align: center

The reference guide contains a detailed description of the ogstools API.
It describes which methods are available, how they work and which parameters can be used.

---

```{button-ref} reference/index
:ref-type: doc
:color: primary
:click-parent:
:expand:
To the API reference
```

:::

:::{grid-item-card} Devleloper guide
:text-align: center

Learn how to setup a development environment and how contribute your code to
help improving the OpenGeoSys tools ecosystem.

---

```{button-ref} development/index
:ref-type: doc
:color: primary
:click-parent:
:expand:
To the Developer guide
```

:::

::::
