import tkinter as tk

# https://stackoverflow.com/questions/4055267/tkinter-mouse-drag-a-window-without-borders-eg-overridedirect1
class FloatingWindow(tk.Toplevel):
	def __init__(self, *args, **kwargs):
		tk.Toplevel.__init__(self, *args, **kwargs)
		self.overrideredirect(True)
		self.bind("<ButtonPress-1>", self.start_move)
		self.bind("<ButtonRelease-1>", self.stop_move)
		self.bind("<B1-Motion>", self.do_move)

	def start_move(self, event):
		self.x = event.x
		self.y = event.y

	def stop_move(self, event):
		self.x = None
		self.y = None

	def do_move(self, event):
		deltax = event.x - self.x
		deltay = event.y - self.y
		x = self.winfo_x() + deltax
		y = self.winfo_y() + deltay
		self.geometry(f"+{x}+{y}")
