# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['pommesdispatch', 'pommesdispatch.model', 'pommesdispatch.model_funcs']

package_data = \
{'': ['*']}

install_requires = \
['numpy', 'oemof.solph==0.4.4', 'pandas', 'pyyaml']

entry_points = \
{'console_scripts': ['run_pommes_dispatch = '
                     'pommesdispatch.cli:run_pommes_dispatch']}

setup_kwargs = {
    'name': 'pommesdispatch',
    'version': '0.1.0',
    'description': 'A bottom-up fundamental power market model for the German electricity sector',
    'long_description': '![PyPI](https://img.shields.io/pypi/v/pommesdispatch)\n![PyPI - Python Version](https://img.shields.io/pypi/pyversions/pommesdispatch)\n![Documentation Status](https://readthedocs.org/projects/pommesdispatch/badge/?version=latest)\n![PyPI - License](https://img.shields.io/pypi/l/pommesdispatch)\n\n# pommesdispatch\n\n**A bottom-up fundamental power market model for the German electricity sector**\n\nThis is the **dispatch variant** of the fundamental power market model *POMMES* (**PO**wer **M**arket **M**odel of **E**nergy and re**S**ources).\nPlease navigate to the section of interest to find out more.\n\n## Contents\n* [Introduction](#introduction)\n* [Documentation](#documentation)\n* [Installation](#installation)\n    * [Setting up pommesdispatch](#setting-up-pommesdispatch)\n    * [Installing a solver](#installing-a-solver)\n* [Contributing](#contributing)\n* [Citing](#citing)\n* [License](#license)\n\n## Introduction\n*POMMES* itself is a cosmos consisting of a **dispatch model** (stored in this repository and described here), a **data preparation routine** and an **investment model** for the German wholesale power market. The model was originally developed by a group of researchers and students at the [chair of Energy and Resources Management of TU Berlin](https://www.er.tu-berlin.de/menue/home/) and is now maintained by a group of alumni and open for other contributions.\n\nIf you are interested in the data preparation routines used or investment modeling, please find more information here:\n- [pommesdata](https://github.com/pommes-public/pommesdata): A full-featured transparent data preparation routine from raw data to POMMES model inputs\n- pommesinvest: A multi-period integrated investment and dispatch model for the German power sector (upcoming).\n\n### Purpose and model characterization\nThe **dispatch variant** of the power market model *POMMES* `pommesdispatch` enables the user to simulate the **dispatch of backup power plants, storages as well as demand response units for the Federal Republic of Germany** for an arbitrary year or timeframe between 2017 and 2030. The dispatch of renewable power plants is exogeneously determined by normalized infeed time series and capacity values. The models\' overall goal is to minimize power system costs occuring from wholesale markets whereby no network constraints are considered except for the existing bidding zone configuration used for modeling electricity exchange. Thus, the model purpose is to simulate **dispatch decisions** and the resulting **day-ahed market prices**. A brief categorization of the model is given in the following table. An extensive categorization can be found in the [model documentation]().\n\n| **criterion** | **manifestation** |\n| ---- | ---- |\n| Purpose | - simulation of power plant dispatch and day-ahead prices for DE (scenario analysis) |\n| Spatial coverage | - Germany (DE-LU) + electrical neighbours (NTC approach) |\n| Time horizon | - usually 1 year in hourly resolution |\n| Technologies | - conventional power plants, storages, demand response (optimized)<br> - renewable generators (fixed)<br> - demand: exogenous time series |\n| Data sources | - input data not shipped out, but can be obtained from [pommesdata](https://github.com/pommes-public/pommesdata); OPSD, BNetzA, ENTSO-E, others |\n| Implementation | - graph representation & linear optimization: [oemof.solph](https://github.com/oemof/oemof-solph) / [pyomo](https://github.com/Pyomo/pyomo) <br> - data management: python / .csv |\n\n### Mathematical and technical implementation\nThe models\' underlying mathematical method is a **linear programming** approach, seeking to minimize overall \npower system costs under constraints such as satisfying power demand at all times and not violating power generation \ncapacity or storage limits. Thus, binary variables such as units\' status, startups and shutdowns are not accounted for.\n\nThe model builds on the framework **[oemof.solph](https://github.com/oemof/oemof-solph)** which allows modeling\nenergy systems in a graph-based representation with the underlying mathematical constraints and objective function \nterms implemented in **[pyomo](https://pyomo.readthedocs.io/en/stable/)**. Some of the required oemof.solph featuresm - such as demand response modeling - have been provided by the *POMMES* main developers which are also active in the \noemof community. Users not familiar with oemof.solph may find further information in the \n[oemof.solph documentation](https://oemof-solph.readthedocs.io/en/latest/readme.html).\n\n## Documentation\nAn extensive **[documentation of pommesdispatch](https://pommesdispatch.readthedocs.io/)** can be found on readthedocs. It contains a user\'s guide, a model categorization, some energy economic and technical background information, a complete model formulation as well as documentation of the model functions and classes. \n\n## Installation\nTo set up `pommesdispatch`, set up a virtual environment (e.g. using conda) or add the required packages to your python installation. Additionally, you have to install a solver in order to solve the mathematical optimization problem.\n\n### Setting up pommesdispatch\n`pommesdispatch` is hosted on [PyPI](https://pypi.org/project/pommesdispatch/). \nTo install it, please use the following command\n```\npip install pommesdispatch\n```\n\nIf you want to contribute as a developer, you fist have to\n[fork](https://docs.github.com/en/get-started/quickstart/fork-a-repo>)\nit and then clone the repository, in order to copy the files locally by typing\n```\ngit clone https://github.com/your-github-username/pommesdispatch.git\n```\nAfter cloning the repository, you have to install the required dependencies.\nMake sure you have conda installed as a package manager.\nIf not, you can download it [here](https://www.anaconda.com/).\nOpen a command shell and navigate to the folder\nwhere you copied the environment to.\n\nUse the following command to install dependencies\n```\nconda env create -f environment.yml\n```\nActivate your environment by typing\n```\nconda activate pommes_dispatch\n```\n\n### Installing a solver\nIn order to solve a `pommesdispatch` model instance, you need a solver installed. Please see [oemof.solph\'s information on solvers](https://github.com/oemof/oemof-solph#installing-a-solver). As a default, gurobi is used for `pommesdispatch` models. It is a commercial solver, but provides academic licenses, though, if this applies to you. Elsewhise, we recommend to use CBC as the solver oemof recommends. To test your solver and oemof.solph installation, again see information from [oemof.solph](https://github.com/oemof/oemof-solph#installation-test).\n\n## Contributing\nEvery kind of contribution or feedback is warmly welcome.<br>\nWe use the [GitHub issue management](https://github.com/pommes-public/pommesdispatch/issues) as well as \n[pull requests](https://github.com/pommes-public/pommesdispatch/pulls) for collaboration. We try to stick to the PEP8 coding standards.\n\nThe following people have contributed in the following manner to `pommesdispatch`:\n\n| Name | Contribution | Status |\n| ---- | ---- | ---- |\n| Johannes Kochems | major development & conceptualization<br>conceptualization, core functionality (esp. dispatch, power prices, demand response, rolling horizon modeling), architecture, publishing process | coordinator & maintainer,<br>developer & corresponding author |\n| Yannick Werner | major development & conceptualization<br>conceptualization, core functionality (esp. exchange, RES, CHP modeling), interface to pommesdata  | developer & corresponding author |\n| Johannes Giehl | development<br>early-stage core functionality | developer |\n| Benjamin Grosse | development<br>support for conceptualization, early-stage contributions at the interface to pommesdata | developer |\n| Sophie Westphal | development<br>early-stage contributions at the interface to pommesdata | former developer (student assistant) |\n| Flora von Mikulicz-Radecki | testing<br>early-stage comprehensive testing | former tester (student assistant) |\n| Carla Spiller | development<br>early-stage rolling horizon and cross-border exchange integration | former developer (student assistant) |\n| Fabian Büllesbach | development<br>early-stage rolling horizon implementation | former developer (master\'s student) |\n| Timona Ghosh | development<br>early-stage cross-border exchange implementation | former developer (master\'s student) |\n| Paul Verwiebe | support<br>support of early-stage core functionality development | former supporter (research associate) |\n| Leticia Encinas Rosa | support<br>support of early-stage core functionality development | former supporter (research associate) |\n| Joachim Müller-Kirchenbauer | support & conceptualization<br>early-stage conceptualization, funding | supporter (university professor) |\n\n*Note: Not every single contribution is reflected in the current version of\n`pommesdispatch`. This is especially true for those marked as early-stage \ncontributions that may have been extended, altered or sometimes discarded. \nNonetheless, all people listed have made valuable contributions. The ones\ndiscarded might be re-integrated at some point in time.\nDedicated contributions to `pommesdata` and `pommesinvest` are not included\nin the list, but listed individually for these projects.*\n\n## Citing\nA publication using and introducing `pommesdispatch` is currently in preparation.\n\nIf you are using `pommesdispatch` for your own analyses, we recommend citing as:<br>\n*Kochems, J.; Werner, Y.; Giehl, J.; Grosse, B. et al. (2021): pommesdispatch. A bottom-up fundamental power market model for the German electricity sector. https://github.com/pommes-public/pommesdispatch, accessed YYYY-MM-DD.*\n\nWe furthermore recommend naming the version tag or the commit hash used for the sake of transparency and reproducibility.\n\nAlso see the *CITATION.cff* file for citation information.\n\n## License\nThis software is licensed under MIT License.\n\nCopyright 2021 pommes developer group\n\nPermission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:\n\nThe above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.\n\nTHE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.\n',
    'author': 'Johannes Kochems',
    'author_email': 'jokochems@web.de',
    'maintainer': 'Johannes Kochems',
    'maintainer_email': 'jokochems@web.de',
    'url': 'https://github.com/pommes-public/pommesdispatch/',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
