"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegTesting = void 0;
const origins = require("@aws-cdk/aws-cloudfront-origins");
const cdk = require("@aws-cdk/core");
const _1 = require("./");
const extensions = require("./extensions");
class IntegTesting {
    constructor() {
        const app = new cdk.App();
        const stack = new cdk.Stack(app, 'demo-stack');
        // prepare the `modify resonse header` extension
        // const modifyRespHeader = new extensions.ModifyResponseHeader(stack, 'ModifyResp');
        // prepare the `anti-hotlinking` extension
        // const antiHotlinking = new extensions.AntiHotlinking(stack, 'AntiHotlink', {
        //   referer: [
        //     'example.com',
        //     'exa?ple.*',
        //   ],
        // });
        // prepare the security headers extension
        const securityHeaders = new extensions.SecurtyHeaders(stack, 'SecurityHeaders');
        const mulOrgIpRetry = new extensions.MultipleOriginIpRetry(stack, 'MulOrgIpRetry', {
            originIp: ['1.2.3.4'],
            originProtocol: 'https',
        });
        // create the cloudfront distribution with extension(s)
        new _1.Distribution(stack, 'dist', {
            defaultBehavior: {
                origin: new origins.HttpOrigin('aws.amazon.com'),
                edgeLambdas: [
                    // modifyRespHeader,
                    // viewer request
                    //antiHotlinking,
                    // origin response
                    securityHeaders,
                    mulOrgIpRetry,
                ],
            },
        });
        this.stack = [stack];
    }
}
exports.IntegTesting = IntegTesting;
new IntegTesting();
//# sourceMappingURL=data:application/json;base64,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