"use strict";
var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SimpleLambdaEdge = exports.RedirectByGeolocation = exports.AccessOriginByGeolocation = exports.CustomErrorPage = exports.DefaultDirIndex = exports.Custom = exports.MultipleOriginIpRetry = exports.SecurtyHeaders = exports.AntiHotlinking = exports.ModifyResponseHeader = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const cf = require("@aws-cdk/aws-cloudfront");
const lambda = require("@aws-cdk/aws-lambda");
const aws_lambda_nodejs_1 = require("@aws-cdk/aws-lambda-nodejs");
const cdk = require("@aws-cdk/core");
const _1 = require("./");
/**
 * The directory for all extensions lambda assets
 */
const EXTENSION_ASSETS_PATH = path.join(__dirname, '../lambda-assets/extensions');
;
/**
 * The modify response header extension.
 *
 * @see https://console.aws.amazon.com/lambda/home#/create/app?applicationId=arn:aws:serverlessrepo:us-east-1:418289889111:applications/modify-response-header
 * @stability stable
 */
class ModifyResponseHeader extends _1.ServerlessApp {
    /**
     * @stability stable
     */
    constructor(scope, id) {
        super(scope, id, {
            applicationId: 'arn:aws:serverlessrepo:us-east-1:418289889111:applications/modify-response-header',
            semanticVersion: '1.0.0',
        });
        const stack = cdk.Stack.of(scope);
        this.functionArn = this.resource.getAtt('Outputs.ModifyResponseHeaderFunctionARN').toString();
        this.functionVersion = bumpFunctionVersion(stack, id, this.functionArn);
        this.eventType = cf.LambdaEdgeEventType.ORIGIN_RESPONSE;
    }
}
exports.ModifyResponseHeader = ModifyResponseHeader;
_a = JSII_RTTI_SYMBOL_1;
ModifyResponseHeader[_a] = { fqn: "cdk-cloudfront-plus.ModifyResponseHeader", version: "0.1.33" };
/**
 * The Anti-Hotlinking extension.
 *
 * @see https://console.aws.amazon.com/lambda/home#/create/app?applicationId=arn:aws:serverlessrepo:us-east-1:418289889111:applications/anti-hotlinking
 * @stability stable
 */
class AntiHotlinking extends _1.ServerlessApp {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        super(scope, id, {
            applicationId: 'arn:aws:serverlessrepo:us-east-1:418289889111:applications/anti-hotlinking',
            semanticVersion: '1.2.5',
            parameters: {
                RefererList: props.referer.join(','),
            },
        });
        const stack = cdk.Stack.of(scope);
        this.functionArn = this.resource.getAtt('Outputs.AntiHotlinking').toString();
        this.functionVersion = bumpFunctionVersion(stack, id, this.functionArn);
        this.eventType = cf.LambdaEdgeEventType.VIEWER_REQUEST;
    }
}
exports.AntiHotlinking = AntiHotlinking;
_b = JSII_RTTI_SYMBOL_1;
AntiHotlinking[_b] = { fqn: "cdk-cloudfront-plus.AntiHotlinking", version: "0.1.33" };
/**
 * Security Headers extension.
 *
 * @see https://aws.amazon.com/tw/blogs/networking-and-content-delivery/adding-http-security-headers-using-lambdaedge-and-amazon-cloudfront/
 * @stability stable
 */
class SecurtyHeaders extends _1.ServerlessApp {
    /**
     * @stability stable
     */
    constructor(scope, id) {
        super(scope, id, {
            applicationId: 'arn:aws:serverlessrepo:us-east-1:418289889111:applications/add-security-headers',
            semanticVersion: '1.0.0',
        });
        const stack = cdk.Stack.of(scope);
        this.functionArn = this.resource.getAtt('Outputs.AddSecurityHeaderFunction').toString();
        this.functionVersion = bumpFunctionVersion(stack, id, this.functionArn);
        this.eventType = cf.LambdaEdgeEventType.ORIGIN_RESPONSE;
    }
}
exports.SecurtyHeaders = SecurtyHeaders;
_c = JSII_RTTI_SYMBOL_1;
SecurtyHeaders[_c] = { fqn: "cdk-cloudfront-plus.SecurtyHeaders", version: "0.1.33" };
/**
 * Multiple Origin IP Retry extension.
 *
 * @see https://github.com/awslabs/aws-cloudfront-extensions/tree/main/edge/nodejs/multiple-origin-IP-retry
 * @stability stable
 */
class MultipleOriginIpRetry extends _1.ServerlessApp {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        super(scope, id, {
            applicationId: 'arn:aws:serverlessrepo:us-east-1:418289889111:applications/multiple-origin-IP-retry',
            semanticVersion: '1.0.1',
            parameters: {
                OriginIPList: props.originIp.join(';'),
                OriginProtocol: props.originProtocol,
            },
        });
        const stack = cdk.Stack.of(scope);
        this.functionArn = this.resource.getAtt('Outputs.MultipleOriginIPRetry').toString();
        this.functionVersion = bumpFunctionVersion(stack, id, this.functionArn);
        this.eventType = cf.LambdaEdgeEventType.ORIGIN_REQUEST;
    }
}
exports.MultipleOriginIpRetry = MultipleOriginIpRetry;
_d = JSII_RTTI_SYMBOL_1;
MultipleOriginIpRetry[_d] = { fqn: "cdk-cloudfront-plus.MultipleOriginIpRetry", version: "0.1.33" };
/**
 * Custom extension sample.
 *
 * @stability stable
 */
class Custom extends cdk.NestedStack {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _l, _m, _o, _p, _q, _r;
        super(scope, id, props);
        this.props = props;
        const func = (_l = props === null || props === void 0 ? void 0 : props.func) !== null && _l !== void 0 ? _l : new lambda.Function(this, 'CustomFunc', {
            code: (_m = props === null || props === void 0 ? void 0 : props.code) !== null && _m !== void 0 ? _m : lambda.Code.fromAsset(path.join(__dirname, '../lambda/function')),
            runtime: (_o = props === null || props === void 0 ? void 0 : props.runtime) !== null && _o !== void 0 ? _o : lambda.Runtime.PYTHON_3_8,
            handler: (_p = props === null || props === void 0 ? void 0 : props.handler) !== null && _p !== void 0 ? _p : 'index.lambda_handler',
            timeout: (_q = props === null || props === void 0 ? void 0 : props.timeout) !== null && _q !== void 0 ? _q : cdk.Duration.seconds(5),
        });
        this.functionArn = func.functionArn;
        this.functionVersion = func.currentVersion;
        this.eventType = (_r = props === null || props === void 0 ? void 0 : props.eventType) !== null && _r !== void 0 ? _r : cf.LambdaEdgeEventType.ORIGIN_RESPONSE;
        this._addDescription();
        this._outputSolutionId();
    }
    _addDescription() {
        this.templateOptions.description = `(${this.props.solutionId}) ${this.props.templateDescription}`;
    }
    _outputSolutionId() {
        if (this.props.solutionId) {
            new cdk.CfnOutput(this, 'SolutionId', {
                value: this.props.solutionId,
                description: 'Solution ID',
            });
        }
    }
}
exports.Custom = Custom;
_e = JSII_RTTI_SYMBOL_1;
Custom[_e] = { fqn: "cdk-cloudfront-plus.Custom", version: "0.1.33" };
/**
 * Generate a lambda function version from the given function ARN
 * @param scope
 * @param id
 * @param functionArn The lambda function ARN
 * @returns lambda.Version
 */
function bumpFunctionVersion(scope, id, functionArn) {
    return new lambda.Version(scope, `LambdaVersion${id}`, {
        lambda: lambda.Function.fromFunctionArn(scope, `FuncArn${id}`, functionArn),
    });
}
/**
 * Default Directory Indexes in Amazon S3-backed Amazon CloudFront Origins.
 *
 * use case - see https://aws.amazon.com/tw/blogs/compute/implementing-default-directory-indexes-in-amazon-s3-backed-amazon-cloudfront-origins-using-lambdaedge/
 *
 * @stability stable
 */
class DefaultDirIndex extends Custom {
    /**
     * @stability stable
     */
    constructor(scope, id) {
        const func = new aws_lambda_nodejs_1.NodejsFunction(scope, 'DefaultDirIndexFunc', {
            entry: `${EXTENSION_ASSETS_PATH}/cf-default-dir-index/index.ts`,
            // L@E does not support NODE14 so use NODE12 instead.
            runtime: lambda.Runtime.NODEJS_12_X,
        });
        super(scope, id, {
            func,
            eventType: cf.LambdaEdgeEventType.ORIGIN_REQUEST,
            solutionId: 'SO8134',
            templateDescription: 'Cloudfront extension with AWS CDK - Default Directory Index for Amazon S3 Origin.',
        });
        this.lambdaFunction = this.functionVersion;
    }
}
exports.DefaultDirIndex = DefaultDirIndex;
_f = JSII_RTTI_SYMBOL_1;
DefaultDirIndex[_f] = { fqn: "cdk-cloudfront-plus.DefaultDirIndex", version: "0.1.33" };
;
/**
 * Display customized error pages, or mask 4XX error pages, based on where the error originated.
 *
 * use case - see https://aws.amazon.com/blogs/networking-and-content-delivery/customize-403-error-pages-from-amazon-cloudfront-origin-with-lambdaedge/
 *
 * @stability stable
 */
class CustomErrorPage extends Custom {
    /**
     * @stability stable
     */
    constructor(scope, id) {
        super(scope, id, {
            runtime: lambda.Runtime.PYTHON_3_7,
            handler: 'index.handler',
            code: lambda.AssetCode.fromAsset(`${EXTENSION_ASSETS_PATH}/cf-custom-error-page`),
            eventType: cf.LambdaEdgeEventType.ORIGIN_RESPONSE,
            solutionId: 'SO8136',
            templateDescription: 'Cloudfront extension with AWS CDK - Custom Error Page',
        });
        this.lambdaFunction = this.functionVersion;
    }
}
exports.CustomErrorPage = CustomErrorPage;
_g = JSII_RTTI_SYMBOL_1;
CustomErrorPage[_g] = { fqn: "cdk-cloudfront-plus.CustomErrorPage", version: "0.1.33" };
;
/**
 * (SO8118)Access Origin by Geolocation.
 *
 * @stability stable
 */
class AccessOriginByGeolocation extends Custom {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        const func = new aws_lambda_nodejs_1.NodejsFunction(scope, 'AccessOriginByGeolocationFunc', {
            entry: `${EXTENSION_ASSETS_PATH}/cf-access-origin-by-geolocation/index.ts`,
            // L@E does not support NODE14 so use NODE12 instead.
            runtime: lambda.Runtime.NODEJS_12_X,
            bundling: {
                define: {
                    'process.env.COUNTRY_CODE_TABLE': jsonStringifiedBundlingDefinition(props.countryTable),
                },
            },
        });
        super(scope, id, {
            func,
            eventType: cf.LambdaEdgeEventType.ORIGIN_REQUEST,
            solutionId: 'S08118',
            templateDescription: 'Cloudfront extension with AWS CDK - Access Origin by Geolocation',
        });
    }
}
exports.AccessOriginByGeolocation = AccessOriginByGeolocation;
_h = JSII_RTTI_SYMBOL_1;
AccessOriginByGeolocation[_h] = { fqn: "cdk-cloudfront-plus.AccessOriginByGeolocation", version: "0.1.33" };
;
/**
 * Forward request to the nearest PoP as per geolocation.
 *
 * @stability stable
 */
class RedirectByGeolocation extends Custom {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        const func = new aws_lambda_nodejs_1.NodejsFunction(scope, 'RedirectByGeolocationFunc', {
            entry: `${EXTENSION_ASSETS_PATH}/cf-redirect-by-geolocation/index.ts`,
            // L@E does not support NODE14 so use NODE12 instead.
            runtime: lambda.Runtime.NODEJS_12_X,
            bundling: {
                define: {
                    'process.env.COUNTRY_CODE_TABLE': jsonStringifiedBundlingDefinition(props.countryTable),
                },
            },
        });
        super(scope, id, {
            func,
            eventType: cf.LambdaEdgeEventType.ORIGIN_REQUEST,
            solutionId: 'SO8135',
            templateDescription: 'Cloudfront extension with AWS CDK - Redirect by Geolocation',
        });
    }
}
exports.RedirectByGeolocation = RedirectByGeolocation;
_j = JSII_RTTI_SYMBOL_1;
RedirectByGeolocation[_j] = { fqn: "cdk-cloudfront-plus.RedirectByGeolocation", version: "0.1.33" };
/**
 * Simple content generation.
 *
 * @see https://github.com/awslabs/aws-cloudfront-extensions/tree/main/edge/nodejs/simple-lambda-edge
 * @stability stable
 */
class SimpleLambdaEdge extends Custom {
    /**
     * @stability stable
     */
    constructor(scope, id) {
        const func = new aws_lambda_nodejs_1.NodejsFunction(scope, 'SimpleLambdaEdgeFunc', {
            entry: `${EXTENSION_ASSETS_PATH}/simple-lambda-edge/index.ts`,
            // L@E does not support NODE14 so use NODE12 instead.
            runtime: lambda.Runtime.NODEJS_12_X,
        });
        super(scope, id, {
            func,
            eventType: cf.LambdaEdgeEventType.VIEWER_REQUEST,
            solutionId: '',
            templateDescription: 'Cloudfront extension with AWS CDK - Simple Lambda Edge.',
        });
    }
}
exports.SimpleLambdaEdge = SimpleLambdaEdge;
_k = JSII_RTTI_SYMBOL_1;
SimpleLambdaEdge[_k] = { fqn: "cdk-cloudfront-plus.SimpleLambdaEdge", version: "0.1.33" };
;
function jsonStringifiedBundlingDefinition(value) {
    return JSON.stringify(value)
        .replace(/"/g, '\\"')
        .replace(/,/g, '\\,');
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZXh0ZW5zaW9ucy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9leHRlbnNpb25zLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUEsNkJBQTZCO0FBQzdCLDhDQUE4QztBQUM5Qyw4Q0FBOEM7QUFDOUMsa0VBQTREO0FBQzVELHFDQUFxQztBQUNyQyx5QkFBbUM7QUFFbkM7O0dBRUc7QUFDSCxNQUFNLHFCQUFxQixHQUFHLElBQUksQ0FBQyxJQUFJLENBQUMsU0FBUyxFQUFFLDZCQUE2QixDQUFDLENBQUM7QUFrQmpGLENBQUM7Ozs7Ozs7QUFPRixNQUFhLG9CQUFxQixTQUFRLGdCQUFhOzs7O0lBSXJELFlBQVksS0FBb0IsRUFBRSxFQUFVO1FBQzFDLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFO1lBQ2YsYUFBYSxFQUFFLG1GQUFtRjtZQUNsRyxlQUFlLEVBQUUsT0FBTztTQUN6QixDQUFDLENBQUM7UUFDSCxNQUFNLEtBQUssR0FBRyxHQUFHLENBQUMsS0FBSyxDQUFDLEVBQUUsQ0FBQyxLQUFLLENBQUMsQ0FBQztRQUNsQyxJQUFJLENBQUMsV0FBVyxHQUFHLElBQUksQ0FBQyxRQUFRLENBQUMsTUFBTSxDQUFDLHlDQUF5QyxDQUFDLENBQUMsUUFBUSxFQUFFLENBQUM7UUFDOUYsSUFBSSxDQUFDLGVBQWUsR0FBRyxtQkFBbUIsQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFLElBQUksQ0FBQyxXQUFXLENBQUMsQ0FBQztRQUN4RSxJQUFJLENBQUMsU0FBUyxHQUFHLEVBQUUsQ0FBQyxtQkFBbUIsQ0FBQyxlQUFlLENBQUM7SUFDMUQsQ0FBQzs7QUFiSCxvREFjQzs7Ozs7Ozs7O0FBaUJELE1BQWEsY0FBZSxTQUFRLGdCQUFhOzs7O0lBSS9DLFlBQVksS0FBb0IsRUFBRSxFQUFVLEVBQUUsS0FBMEI7UUFDdEUsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUU7WUFDZixhQUFhLEVBQUUsNEVBQTRFO1lBQzNGLGVBQWUsRUFBRSxPQUFPO1lBQ3hCLFVBQVUsRUFBRTtnQkFDVixXQUFXLEVBQUUsS0FBSyxDQUFDLE9BQU8sQ0FBQyxJQUFJLENBQUMsR0FBRyxDQUFDO2FBQ3JDO1NBQ0YsQ0FBQyxDQUFDO1FBQ0gsTUFBTSxLQUFLLEdBQUcsR0FBRyxDQUFDLEtBQUssQ0FBQyxFQUFFLENBQUMsS0FBSyxDQUFDLENBQUM7UUFDbEMsSUFBSSxDQUFDLFdBQVcsR0FBRyxJQUFJLENBQUMsUUFBUSxDQUFDLE1BQU0sQ0FBQyx3QkFBd0IsQ0FBQyxDQUFDLFFBQVEsRUFBRSxDQUFDO1FBQzdFLElBQUksQ0FBQyxlQUFlLEdBQUcsbUJBQW1CLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRSxJQUFJLENBQUMsV0FBVyxDQUFDLENBQUM7UUFDeEUsSUFBSSxDQUFDLFNBQVMsR0FBRyxFQUFFLENBQUMsbUJBQW1CLENBQUMsY0FBYyxDQUFDO0lBQ3pELENBQUM7O0FBaEJILHdDQWlCQzs7Ozs7Ozs7O0FBT0QsTUFBYSxjQUFlLFNBQVEsZ0JBQWE7Ozs7SUFJL0MsWUFBWSxLQUFvQixFQUFFLEVBQVU7UUFDMUMsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUU7WUFDZixhQUFhLEVBQUUsaUZBQWlGO1lBQ2hHLGVBQWUsRUFBRSxPQUFPO1NBQ3pCLENBQUMsQ0FBQztRQUNILE1BQU0sS0FBSyxHQUFHLEdBQUcsQ0FBQyxLQUFLLENBQUMsRUFBRSxDQUFDLEtBQUssQ0FBQyxDQUFDO1FBQ2xDLElBQUksQ0FBQyxXQUFXLEdBQUcsSUFBSSxDQUFDLFFBQVEsQ0FBQyxNQUFNLENBQUMsbUNBQW1DLENBQUMsQ0FBQyxRQUFRLEVBQUUsQ0FBQztRQUN4RixJQUFJLENBQUMsZUFBZSxHQUFHLG1CQUFtQixDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUUsSUFBSSxDQUFDLFdBQVcsQ0FBQyxDQUFDO1FBQ3hFLElBQUksQ0FBQyxTQUFTLEdBQUcsRUFBRSxDQUFDLG1CQUFtQixDQUFDLGVBQWUsQ0FBQztJQUMxRCxDQUFDOztBQWJILHdDQWNDOzs7Ozs7Ozs7QUF3QkQsTUFBYSxxQkFBc0IsU0FBUSxnQkFBYTs7OztJQUl0RCxZQUFZLEtBQW9CLEVBQUUsRUFBVSxFQUFFLEtBQWlDO1FBQzdFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFO1lBQ2YsYUFBYSxFQUFFLHFGQUFxRjtZQUNwRyxlQUFlLEVBQUUsT0FBTztZQUN4QixVQUFVLEVBQUU7Z0JBQ1YsWUFBWSxFQUFFLEtBQUssQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLEdBQUcsQ0FBQztnQkFDdEMsY0FBYyxFQUFFLEtBQUssQ0FBQyxjQUFjO2FBQ3JDO1NBQ0YsQ0FBQyxDQUFDO1FBQ0gsTUFBTSxLQUFLLEdBQUcsR0FBRyxDQUFDLEtBQUssQ0FBQyxFQUFFLENBQUMsS0FBSyxDQUFDLENBQUM7UUFDbEMsSUFBSSxDQUFDLFdBQVcsR0FBRyxJQUFJLENBQUMsUUFBUSxDQUFDLE1BQU0sQ0FBQywrQkFBK0IsQ0FBQyxDQUFDLFFBQVEsRUFBRSxDQUFDO1FBQ3BGLElBQUksQ0FBQyxlQUFlLEdBQUcsbUJBQW1CLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRSxJQUFJLENBQUMsV0FBVyxDQUFDLENBQUM7UUFDeEUsSUFBSSxDQUFDLFNBQVMsR0FBRyxFQUFFLENBQUMsbUJBQW1CLENBQUMsY0FBYyxDQUFDO0lBQ3pELENBQUM7O0FBakJILHNEQWtCQzs7Ozs7Ozs7QUF1RkQsTUFBYSxNQUFPLFNBQVEsR0FBRyxDQUFDLFdBQVc7Ozs7SUFLekMsWUFBWSxLQUFvQixFQUFFLEVBQVUsRUFBRSxLQUFrQjs7UUFDOUQsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUUsS0FBSyxDQUFDLENBQUM7UUFFeEIsSUFBSSxDQUFDLEtBQUssR0FBRyxLQUFLLENBQUM7UUFFbkIsTUFBTSxJQUFJLFNBQUcsS0FBSyxhQUFMLEtBQUssdUJBQUwsS0FBSyxDQUFFLElBQUksbUNBQUksSUFBSSxNQUFNLENBQUMsUUFBUSxDQUFDLElBQUksRUFBRSxZQUFZLEVBQUU7WUFDbEUsSUFBSSxRQUFFLEtBQUssYUFBTCxLQUFLLHVCQUFMLEtBQUssQ0FBRSxJQUFJLG1DQUFJLE1BQU0sQ0FBQyxJQUFJLENBQUMsU0FBUyxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsU0FBUyxFQUFFLG9CQUFvQixDQUFDLENBQUM7WUFDdEYsT0FBTyxRQUFFLEtBQUssYUFBTCxLQUFLLHVCQUFMLEtBQUssQ0FBRSxPQUFPLG1DQUFJLE1BQU0sQ0FBQyxPQUFPLENBQUMsVUFBVTtZQUNwRCxPQUFPLFFBQUUsS0FBSyxhQUFMLEtBQUssdUJBQUwsS0FBSyxDQUFFLE9BQU8sbUNBQUksc0JBQXNCO1lBQ2pELE9BQU8sUUFBRSxLQUFLLGFBQUwsS0FBSyx1QkFBTCxLQUFLLENBQUUsT0FBTyxtQ0FBSSxHQUFHLENBQUMsUUFBUSxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUM7U0FDbkQsQ0FBQyxDQUFDO1FBQ0gsSUFBSSxDQUFDLFdBQVcsR0FBRyxJQUFJLENBQUMsV0FBVyxDQUFDO1FBQ3BDLElBQUksQ0FBQyxlQUFlLEdBQUcsSUFBSSxDQUFDLGNBQWMsQ0FBQztRQUMzQyxJQUFJLENBQUMsU0FBUyxTQUFHLEtBQUssYUFBTCxLQUFLLHVCQUFMLEtBQUssQ0FBRSxTQUFTLG1DQUFJLEVBQUUsQ0FBQyxtQkFBbUIsQ0FBQyxlQUFlLENBQUM7UUFDNUUsSUFBSSxDQUFDLGVBQWUsRUFBRSxDQUFDO1FBQ3ZCLElBQUksQ0FBQyxpQkFBaUIsRUFBRSxDQUFDO0lBQzNCLENBQUM7SUFDTyxlQUFlO1FBQ3JCLElBQUksQ0FBQyxlQUFlLENBQUMsV0FBVyxHQUFHLElBQUksSUFBSSxDQUFDLEtBQUssQ0FBQyxVQUFVLEtBQUssSUFBSSxDQUFDLEtBQUssQ0FBQyxtQkFBbUIsRUFBRSxDQUFDO0lBQ3BHLENBQUM7SUFDTyxpQkFBaUI7UUFDdkIsSUFBSSxJQUFJLENBQUMsS0FBSyxDQUFDLFVBQVUsRUFBRTtZQUN6QixJQUFJLEdBQUcsQ0FBQyxTQUFTLENBQUMsSUFBSSxFQUFFLFlBQVksRUFBRTtnQkFDcEMsS0FBSyxFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsVUFBVTtnQkFDNUIsV0FBVyxFQUFFLGFBQWE7YUFDM0IsQ0FBQyxDQUFDO1NBQ0o7SUFDSCxDQUFDOztBQWhDSCx3QkFpQ0M7OztBQUVEOzs7Ozs7R0FNRztBQUNILFNBQVMsbUJBQW1CLENBQUMsS0FBb0IsRUFBRSxFQUFVLEVBQUUsV0FBbUI7SUFDaEYsT0FBTyxJQUFJLE1BQU0sQ0FBQyxPQUFPLENBQUMsS0FBSyxFQUFFLGdCQUFnQixFQUFFLEVBQUUsRUFBRTtRQUNyRCxNQUFNLEVBQUUsTUFBTSxDQUFDLFFBQVEsQ0FBQyxlQUFlLENBQUMsS0FBSyxFQUFFLFVBQVUsRUFBRSxFQUFFLEVBQUUsV0FBVyxDQUFDO0tBQzVFLENBQUMsQ0FBQztBQUNMLENBQUM7Ozs7Ozs7O0FBT0QsTUFBYSxlQUFnQixTQUFRLE1BQU07Ozs7SUFFekMsWUFBWSxLQUFvQixFQUFFLEVBQVU7UUFDMUMsTUFBTSxJQUFJLEdBQUcsSUFBSSxrQ0FBYyxDQUFDLEtBQUssRUFBRSxxQkFBcUIsRUFBRTtZQUM1RCxLQUFLLEVBQUUsR0FBRyxxQkFBcUIsZ0NBQWdDO1lBQy9ELHFEQUFxRDtZQUNyRCxPQUFPLEVBQUUsTUFBTSxDQUFDLE9BQU8sQ0FBQyxXQUFXO1NBQ3BDLENBQUMsQ0FBQztRQUNILEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFO1lBQ2YsSUFBSTtZQUNKLFNBQVMsRUFBRSxFQUFFLENBQUMsbUJBQW1CLENBQUMsY0FBYztZQUNoRCxVQUFVLEVBQUUsUUFBUTtZQUNwQixtQkFBbUIsRUFBRSxtRkFBbUY7U0FDekcsQ0FBQyxDQUFDO1FBQ0gsSUFBSSxDQUFDLGNBQWMsR0FBRyxJQUFJLENBQUMsZUFBZSxDQUFDO0lBQzdDLENBQUM7O0FBZkgsMENBZ0JDOzs7QUFBQSxDQUFDOzs7Ozs7OztBQU9GLE1BQWEsZUFBZ0IsU0FBUSxNQUFNOzs7O0lBRXpDLFlBQVksS0FBb0IsRUFBRSxFQUFVO1FBRTFDLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFO1lBQ2YsT0FBTyxFQUFFLE1BQU0sQ0FBQyxPQUFPLENBQUMsVUFBVTtZQUNsQyxPQUFPLEVBQUUsZUFBZTtZQUN4QixJQUFJLEVBQUUsTUFBTSxDQUFDLFNBQVMsQ0FBQyxTQUFTLENBQUMsR0FBRyxxQkFBcUIsdUJBQXVCLENBQUM7WUFDakYsU0FBUyxFQUFFLEVBQUUsQ0FBQyxtQkFBbUIsQ0FBQyxlQUFlO1lBQ2pELFVBQVUsRUFBRSxRQUFRO1lBQ3BCLG1CQUFtQixFQUFFLHVEQUF1RDtTQUM3RSxDQUFDLENBQUM7UUFDSCxJQUFJLENBQUMsY0FBYyxHQUFHLElBQUksQ0FBQyxlQUFlLENBQUM7SUFDN0MsQ0FBQzs7QUFiSCwwQ0FjQzs7O0FBQUEsQ0FBQzs7Ozs7O0FBYUYsTUFBYSx5QkFBMEIsU0FBUSxNQUFNOzs7O0lBQ25ELFlBQVksS0FBb0IsRUFBRSxFQUFVLEVBQUUsS0FBcUM7UUFDakYsTUFBTSxJQUFJLEdBQUcsSUFBSSxrQ0FBYyxDQUFDLEtBQUssRUFBRSwrQkFBK0IsRUFBRTtZQUN0RSxLQUFLLEVBQUUsR0FBRyxxQkFBcUIsMkNBQTJDO1lBQzFFLHFEQUFxRDtZQUNyRCxPQUFPLEVBQUUsTUFBTSxDQUFDLE9BQU8sQ0FBQyxXQUFXO1lBQ25DLFFBQVEsRUFBRTtnQkFDUixNQUFNLEVBQUU7b0JBQ04sZ0NBQWdDLEVBQUUsaUNBQWlDLENBQUMsS0FBSyxDQUFDLFlBQVksQ0FBQztpQkFDeEY7YUFDRjtTQUNGLENBQUMsQ0FBQztRQUNILEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFO1lBQ2YsSUFBSTtZQUNKLFNBQVMsRUFBRSxFQUFFLENBQUMsbUJBQW1CLENBQUMsY0FBYztZQUNoRCxVQUFVLEVBQUUsUUFBUTtZQUNwQixtQkFBbUIsRUFBRSxrRUFBa0U7U0FDeEYsQ0FBQyxDQUFDO0lBQ0wsQ0FBQzs7QUFsQkgsOERBbUJDOzs7QUFBQSxDQUFDOzs7Ozs7QUFhRixNQUFhLHFCQUFzQixTQUFRLE1BQU07Ozs7SUFDL0MsWUFBWSxLQUFvQixFQUFFLEVBQVUsRUFBRSxLQUFpQztRQUM3RSxNQUFNLElBQUksR0FBRyxJQUFJLGtDQUFjLENBQUMsS0FBSyxFQUFFLDJCQUEyQixFQUFFO1lBQ2xFLEtBQUssRUFBRSxHQUFHLHFCQUFxQixzQ0FBc0M7WUFDckUscURBQXFEO1lBQ3JELE9BQU8sRUFBRSxNQUFNLENBQUMsT0FBTyxDQUFDLFdBQVc7WUFDbkMsUUFBUSxFQUFFO2dCQUNSLE1BQU0sRUFBRTtvQkFDTixnQ0FBZ0MsRUFBRSxpQ0FBaUMsQ0FBQyxLQUFLLENBQUMsWUFBWSxDQUFDO2lCQUN4RjthQUNGO1NBQ0YsQ0FBQyxDQUFDO1FBQ0gsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUU7WUFDZixJQUFJO1lBQ0osU0FBUyxFQUFFLEVBQUUsQ0FBQyxtQkFBbUIsQ0FBQyxjQUFjO1lBQ2hELFVBQVUsRUFBRSxRQUFRO1lBQ3BCLG1CQUFtQixFQUFFLDZEQUE2RDtTQUNuRixDQUFDLENBQUM7SUFDTCxDQUFDOztBQWxCSCxzREFtQkM7Ozs7Ozs7OztBQU1ELE1BQWEsZ0JBQWlCLFNBQVEsTUFBTTs7OztJQUMxQyxZQUFZLEtBQW9CLEVBQUUsRUFBVTtRQUMxQyxNQUFNLElBQUksR0FBRyxJQUFJLGtDQUFjLENBQUMsS0FBSyxFQUFFLHNCQUFzQixFQUFFO1lBQzdELEtBQUssRUFBRSxHQUFHLHFCQUFxQiw4QkFBOEI7WUFDN0QscURBQXFEO1lBQ3JELE9BQU8sRUFBRSxNQUFNLENBQUMsT0FBTyxDQUFDLFdBQVc7U0FDcEMsQ0FBQyxDQUFDO1FBQ0gsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUU7WUFDZixJQUFJO1lBQ0osU0FBUyxFQUFFLEVBQUUsQ0FBQyxtQkFBbUIsQ0FBQyxjQUFjO1lBQ2hELFVBQVUsRUFBRSxFQUFFO1lBQ2QsbUJBQW1CLEVBQUUseURBQXlEO1NBQy9FLENBQUMsQ0FBQztJQUNMLENBQUM7O0FBYkgsNENBY0M7OztBQUFBLENBQUM7QUFFRixTQUFTLGlDQUFpQyxDQUFDLEtBQVU7SUFDbkQsT0FBTyxJQUFJLENBQUMsU0FBUyxDQUFDLEtBQUssQ0FBQztTQUN6QixPQUFPLENBQUMsSUFBSSxFQUFFLEtBQUssQ0FBQztTQUNwQixPQUFPLENBQUMsSUFBSSxFQUFFLEtBQUssQ0FBQyxDQUFDO0FBQzFCLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBwYXRoIGZyb20gJ3BhdGgnO1xuaW1wb3J0ICogYXMgY2YgZnJvbSAnQGF3cy1jZGsvYXdzLWNsb3VkZnJvbnQnO1xuaW1wb3J0ICogYXMgbGFtYmRhIGZyb20gJ0Bhd3MtY2RrL2F3cy1sYW1iZGEnO1xuaW1wb3J0IHsgTm9kZWpzRnVuY3Rpb24gfSBmcm9tICdAYXdzLWNkay9hd3MtbGFtYmRhLW5vZGVqcyc7XG5pbXBvcnQgKiBhcyBjZGsgZnJvbSAnQGF3cy1jZGsvY29yZSc7XG5pbXBvcnQgeyBTZXJ2ZXJsZXNzQXBwIH0gZnJvbSAnLi8nO1xuXG4vKipcbiAqIFRoZSBkaXJlY3RvcnkgZm9yIGFsbCBleHRlbnNpb25zIGxhbWJkYSBhc3NldHNcbiAqL1xuY29uc3QgRVhURU5TSU9OX0FTU0VUU19QQVRIID0gcGF0aC5qb2luKF9fZGlybmFtZSwgJy4uL2xhbWJkYS1hc3NldHMvZXh0ZW5zaW9ucycpO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgaW50ZXJmYWNlIElFeHRlbnNpb25zIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgZnVuY3Rpb25Bcm46IHN0cmluZztcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBmdW5jdGlvblZlcnNpb246IGxhbWJkYS5WZXJzaW9uO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgZXZlbnRUeXBlOiBjZi5MYW1iZGFFZGdlRXZlbnRUeXBlO1xufTtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgY2xhc3MgTW9kaWZ5UmVzcG9uc2VIZWFkZXIgZXh0ZW5kcyBTZXJ2ZXJsZXNzQXBwIGltcGxlbWVudHMgSUV4dGVuc2lvbnMge1xuICByZWFkb25seSBmdW5jdGlvbkFybjogc3RyaW5nO1xuICByZWFkb25seSBmdW5jdGlvblZlcnNpb246IGxhbWJkYS5WZXJzaW9uO1xuICByZWFkb25seSBldmVudFR5cGU6IGNmLkxhbWJkYUVkZ2VFdmVudFR5cGU7XG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBjZGsuQ29uc3RydWN0LCBpZDogc3RyaW5nKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkLCB7XG4gICAgICBhcHBsaWNhdGlvbklkOiAnYXJuOmF3czpzZXJ2ZXJsZXNzcmVwbzp1cy1lYXN0LTE6NDE4Mjg5ODg5MTExOmFwcGxpY2F0aW9ucy9tb2RpZnktcmVzcG9uc2UtaGVhZGVyJyxcbiAgICAgIHNlbWFudGljVmVyc2lvbjogJzEuMC4wJyxcbiAgICB9KTtcbiAgICBjb25zdCBzdGFjayA9IGNkay5TdGFjay5vZihzY29wZSk7XG4gICAgdGhpcy5mdW5jdGlvbkFybiA9IHRoaXMucmVzb3VyY2UuZ2V0QXR0KCdPdXRwdXRzLk1vZGlmeVJlc3BvbnNlSGVhZGVyRnVuY3Rpb25BUk4nKS50b1N0cmluZygpO1xuICAgIHRoaXMuZnVuY3Rpb25WZXJzaW9uID0gYnVtcEZ1bmN0aW9uVmVyc2lvbihzdGFjaywgaWQsIHRoaXMuZnVuY3Rpb25Bcm4pO1xuICAgIHRoaXMuZXZlbnRUeXBlID0gY2YuTGFtYmRhRWRnZUV2ZW50VHlwZS5PUklHSU5fUkVTUE9OU0U7XG4gIH1cbn1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBpbnRlcmZhY2UgQW50aUhvdGxpbmtpbmdQcm9wcyB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHJlZmVyZXI6IHN0cmluZ1tdO1xufVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBjbGFzcyBBbnRpSG90bGlua2luZyBleHRlbmRzIFNlcnZlcmxlc3NBcHAgaW1wbGVtZW50cyBJRXh0ZW5zaW9ucyB7XG4gIHJlYWRvbmx5IGZ1bmN0aW9uQXJuOiBzdHJpbmc7XG4gIHJlYWRvbmx5IGZ1bmN0aW9uVmVyc2lvbjogbGFtYmRhLlZlcnNpb247XG4gIHJlYWRvbmx5IGV2ZW50VHlwZTogY2YuTGFtYmRhRWRnZUV2ZW50VHlwZTtcbiAgY29uc3RydWN0b3Ioc2NvcGU6IGNkay5Db25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBBbnRpSG90bGlua2luZ1Byb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkLCB7XG4gICAgICBhcHBsaWNhdGlvbklkOiAnYXJuOmF3czpzZXJ2ZXJsZXNzcmVwbzp1cy1lYXN0LTE6NDE4Mjg5ODg5MTExOmFwcGxpY2F0aW9ucy9hbnRpLWhvdGxpbmtpbmcnLFxuICAgICAgc2VtYW50aWNWZXJzaW9uOiAnMS4yLjUnLFxuICAgICAgcGFyYW1ldGVyczoge1xuICAgICAgICBSZWZlcmVyTGlzdDogcHJvcHMucmVmZXJlci5qb2luKCcsJyksXG4gICAgICB9LFxuICAgIH0pO1xuICAgIGNvbnN0IHN0YWNrID0gY2RrLlN0YWNrLm9mKHNjb3BlKTtcbiAgICB0aGlzLmZ1bmN0aW9uQXJuID0gdGhpcy5yZXNvdXJjZS5nZXRBdHQoJ091dHB1dHMuQW50aUhvdGxpbmtpbmcnKS50b1N0cmluZygpO1xuICAgIHRoaXMuZnVuY3Rpb25WZXJzaW9uID0gYnVtcEZ1bmN0aW9uVmVyc2lvbihzdGFjaywgaWQsIHRoaXMuZnVuY3Rpb25Bcm4pO1xuICAgIHRoaXMuZXZlbnRUeXBlID0gY2YuTGFtYmRhRWRnZUV2ZW50VHlwZS5WSUVXRVJfUkVRVUVTVDtcbiAgfVxufVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgY2xhc3MgU2VjdXJ0eUhlYWRlcnMgZXh0ZW5kcyBTZXJ2ZXJsZXNzQXBwIGltcGxlbWVudHMgSUV4dGVuc2lvbnMge1xuICByZWFkb25seSBmdW5jdGlvbkFybjogc3RyaW5nO1xuICByZWFkb25seSBmdW5jdGlvblZlcnNpb246IGxhbWJkYS5WZXJzaW9uO1xuICByZWFkb25seSBldmVudFR5cGU6IGNmLkxhbWJkYUVkZ2VFdmVudFR5cGU7XG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBjZGsuQ29uc3RydWN0LCBpZDogc3RyaW5nKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkLCB7XG4gICAgICBhcHBsaWNhdGlvbklkOiAnYXJuOmF3czpzZXJ2ZXJsZXNzcmVwbzp1cy1lYXN0LTE6NDE4Mjg5ODg5MTExOmFwcGxpY2F0aW9ucy9hZGQtc2VjdXJpdHktaGVhZGVycycsXG4gICAgICBzZW1hbnRpY1ZlcnNpb246ICcxLjAuMCcsXG4gICAgfSk7XG4gICAgY29uc3Qgc3RhY2sgPSBjZGsuU3RhY2sub2Yoc2NvcGUpO1xuICAgIHRoaXMuZnVuY3Rpb25Bcm4gPSB0aGlzLnJlc291cmNlLmdldEF0dCgnT3V0cHV0cy5BZGRTZWN1cml0eUhlYWRlckZ1bmN0aW9uJykudG9TdHJpbmcoKTtcbiAgICB0aGlzLmZ1bmN0aW9uVmVyc2lvbiA9IGJ1bXBGdW5jdGlvblZlcnNpb24oc3RhY2ssIGlkLCB0aGlzLmZ1bmN0aW9uQXJuKTtcbiAgICB0aGlzLmV2ZW50VHlwZSA9IGNmLkxhbWJkYUVkZ2VFdmVudFR5cGUuT1JJR0lOX1JFU1BPTlNFO1xuICB9XG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGludGVyZmFjZSBNdWx0aXBsZU9yaWdpbklwUmV0cnlQcm9wcyB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgb3JpZ2luSXA6IHN0cmluZ1tdO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgb3JpZ2luUHJvdG9jb2w6IHN0cmluZztcbn1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBjbGFzcyBNdWx0aXBsZU9yaWdpbklwUmV0cnkgZXh0ZW5kcyBTZXJ2ZXJsZXNzQXBwIGltcGxlbWVudHMgSUV4dGVuc2lvbnMge1xuICByZWFkb25seSBmdW5jdGlvbkFybjogc3RyaW5nO1xuICByZWFkb25seSBmdW5jdGlvblZlcnNpb246IGxhbWJkYS5WZXJzaW9uO1xuICByZWFkb25seSBldmVudFR5cGU6IGNmLkxhbWJkYUVkZ2VFdmVudFR5cGU7XG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBjZGsuQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogTXVsdGlwbGVPcmlnaW5JcFJldHJ5UHJvcHMpIHtcbiAgICBzdXBlcihzY29wZSwgaWQsIHtcbiAgICAgIGFwcGxpY2F0aW9uSWQ6ICdhcm46YXdzOnNlcnZlcmxlc3NyZXBvOnVzLWVhc3QtMTo0MTgyODk4ODkxMTE6YXBwbGljYXRpb25zL211bHRpcGxlLW9yaWdpbi1JUC1yZXRyeScsXG4gICAgICBzZW1hbnRpY1ZlcnNpb246ICcxLjAuMScsXG4gICAgICBwYXJhbWV0ZXJzOiB7XG4gICAgICAgIE9yaWdpbklQTGlzdDogcHJvcHMub3JpZ2luSXAuam9pbignOycpLFxuICAgICAgICBPcmlnaW5Qcm90b2NvbDogcHJvcHMub3JpZ2luUHJvdG9jb2wsXG4gICAgICB9LFxuICAgIH0pO1xuICAgIGNvbnN0IHN0YWNrID0gY2RrLlN0YWNrLm9mKHNjb3BlKTtcbiAgICB0aGlzLmZ1bmN0aW9uQXJuID0gdGhpcy5yZXNvdXJjZS5nZXRBdHQoJ091dHB1dHMuTXVsdGlwbGVPcmlnaW5JUFJldHJ5JykudG9TdHJpbmcoKTtcbiAgICB0aGlzLmZ1bmN0aW9uVmVyc2lvbiA9IGJ1bXBGdW5jdGlvblZlcnNpb24oc3RhY2ssIGlkLCB0aGlzLmZ1bmN0aW9uQXJuKTtcbiAgICB0aGlzLmV2ZW50VHlwZSA9IGNmLkxhbWJkYUVkZ2VFdmVudFR5cGUuT1JJR0lOX1JFUVVFU1Q7XG4gIH1cbn1cblxuZXhwb3J0IGludGVyZmFjZSBDdXN0b21Qcm9wcyB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgZnVuYz86IGxhbWJkYS5GdW5jdGlvbjtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGNvZGU/OiBsYW1iZGEuQXNzZXRDb2RlO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBydW50aW1lPzogbGFtYmRhLlJ1bnRpbWU7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgaGFuZGxlcj86IHN0cmluZztcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHRpbWVvdXQ/OiBjZGsuRHVyYXRpb247XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBldmVudFR5cGU/OiBjZi5MYW1iZGFFZGdlRXZlbnRUeXBlO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHNvbHV0aW9uSWQ/OiBzdHJpbmc7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgdGVtcGxhdGVEZXNjcmlwdGlvbj86IHN0cmluZztcbn1cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBjbGFzcyBDdXN0b20gZXh0ZW5kcyBjZGsuTmVzdGVkU3RhY2sgaW1wbGVtZW50cyBJRXh0ZW5zaW9ucyB7XG4gIHJlYWRvbmx5IGZ1bmN0aW9uQXJuOiBzdHJpbmc7XG4gIHJlYWRvbmx5IGZ1bmN0aW9uVmVyc2lvbjogbGFtYmRhLlZlcnNpb247XG4gIHJlYWRvbmx5IGV2ZW50VHlwZTogY2YuTGFtYmRhRWRnZUV2ZW50VHlwZTtcbiAgcmVhZG9ubHkgcHJvcHM6IEN1c3RvbVByb3BzO1xuICBjb25zdHJ1Y3RvcihzY29wZTogY2RrLkNvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IEN1c3RvbVByb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkLCBwcm9wcyk7XG5cbiAgICB0aGlzLnByb3BzID0gcHJvcHM7XG5cbiAgICBjb25zdCBmdW5jID0gcHJvcHM/LmZ1bmMgPz8gbmV3IGxhbWJkYS5GdW5jdGlvbih0aGlzLCAnQ3VzdG9tRnVuYycsIHtcbiAgICAgIGNvZGU6IHByb3BzPy5jb2RlID8/IGxhbWJkYS5Db2RlLmZyb21Bc3NldChwYXRoLmpvaW4oX19kaXJuYW1lLCAnLi4vbGFtYmRhL2Z1bmN0aW9uJykpLFxuICAgICAgcnVudGltZTogcHJvcHM/LnJ1bnRpbWUgPz8gbGFtYmRhLlJ1bnRpbWUuUFlUSE9OXzNfOCxcbiAgICAgIGhhbmRsZXI6IHByb3BzPy5oYW5kbGVyID8/ICdpbmRleC5sYW1iZGFfaGFuZGxlcicsXG4gICAgICB0aW1lb3V0OiBwcm9wcz8udGltZW91dCA/PyBjZGsuRHVyYXRpb24uc2Vjb25kcyg1KSxcbiAgICB9KTtcbiAgICB0aGlzLmZ1bmN0aW9uQXJuID0gZnVuYy5mdW5jdGlvbkFybjtcbiAgICB0aGlzLmZ1bmN0aW9uVmVyc2lvbiA9IGZ1bmMuY3VycmVudFZlcnNpb247XG4gICAgdGhpcy5ldmVudFR5cGUgPSBwcm9wcz8uZXZlbnRUeXBlID8/IGNmLkxhbWJkYUVkZ2VFdmVudFR5cGUuT1JJR0lOX1JFU1BPTlNFO1xuICAgIHRoaXMuX2FkZERlc2NyaXB0aW9uKCk7XG4gICAgdGhpcy5fb3V0cHV0U29sdXRpb25JZCgpO1xuICB9XG4gIHByaXZhdGUgX2FkZERlc2NyaXB0aW9uKCkge1xuICAgIHRoaXMudGVtcGxhdGVPcHRpb25zLmRlc2NyaXB0aW9uID0gYCgke3RoaXMucHJvcHMuc29sdXRpb25JZH0pICR7dGhpcy5wcm9wcy50ZW1wbGF0ZURlc2NyaXB0aW9ufWA7XG4gIH1cbiAgcHJpdmF0ZSBfb3V0cHV0U29sdXRpb25JZCgpIHtcbiAgICBpZiAodGhpcy5wcm9wcy5zb2x1dGlvbklkKSB7XG4gICAgICBuZXcgY2RrLkNmbk91dHB1dCh0aGlzLCAnU29sdXRpb25JZCcsIHtcbiAgICAgICAgdmFsdWU6IHRoaXMucHJvcHMuc29sdXRpb25JZCxcbiAgICAgICAgZGVzY3JpcHRpb246ICdTb2x1dGlvbiBJRCcsXG4gICAgICB9KTtcbiAgICB9XG4gIH1cbn1cblxuLyoqXG4gKiBHZW5lcmF0ZSBhIGxhbWJkYSBmdW5jdGlvbiB2ZXJzaW9uIGZyb20gdGhlIGdpdmVuIGZ1bmN0aW9uIEFSTlxuICogQHBhcmFtIHNjb3BlXG4gKiBAcGFyYW0gaWRcbiAqIEBwYXJhbSBmdW5jdGlvbkFybiBUaGUgbGFtYmRhIGZ1bmN0aW9uIEFSTlxuICogQHJldHVybnMgbGFtYmRhLlZlcnNpb25cbiAqL1xuZnVuY3Rpb24gYnVtcEZ1bmN0aW9uVmVyc2lvbihzY29wZTogY2RrLkNvbnN0cnVjdCwgaWQ6IHN0cmluZywgZnVuY3Rpb25Bcm46IHN0cmluZyk6IGxhbWJkYS5WZXJzaW9uIHtcbiAgcmV0dXJuIG5ldyBsYW1iZGEuVmVyc2lvbihzY29wZSwgYExhbWJkYVZlcnNpb24ke2lkfWAsIHtcbiAgICBsYW1iZGE6IGxhbWJkYS5GdW5jdGlvbi5mcm9tRnVuY3Rpb25Bcm4oc2NvcGUsIGBGdW5jQXJuJHtpZH1gLCBmdW5jdGlvbkFybiksXG4gIH0pO1xufVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgY2xhc3MgRGVmYXVsdERpckluZGV4IGV4dGVuZHMgQ3VzdG9tIHtcbiAgcmVhZG9ubHkgbGFtYmRhRnVuY3Rpb246IGxhbWJkYS5WZXJzaW9uO1xuICBjb25zdHJ1Y3RvcihzY29wZTogY2RrLkNvbnN0cnVjdCwgaWQ6IHN0cmluZykge1xuICAgIGNvbnN0IGZ1bmMgPSBuZXcgTm9kZWpzRnVuY3Rpb24oc2NvcGUsICdEZWZhdWx0RGlySW5kZXhGdW5jJywge1xuICAgICAgZW50cnk6IGAke0VYVEVOU0lPTl9BU1NFVFNfUEFUSH0vY2YtZGVmYXVsdC1kaXItaW5kZXgvaW5kZXgudHNgLFxuICAgICAgLy8gTEBFIGRvZXMgbm90IHN1cHBvcnQgTk9ERTE0IHNvIHVzZSBOT0RFMTIgaW5zdGVhZC5cbiAgICAgIHJ1bnRpbWU6IGxhbWJkYS5SdW50aW1lLk5PREVKU18xMl9YLFxuICAgIH0pO1xuICAgIHN1cGVyKHNjb3BlLCBpZCwge1xuICAgICAgZnVuYyxcbiAgICAgIGV2ZW50VHlwZTogY2YuTGFtYmRhRWRnZUV2ZW50VHlwZS5PUklHSU5fUkVRVUVTVCxcbiAgICAgIHNvbHV0aW9uSWQ6ICdTTzgxMzQnLFxuICAgICAgdGVtcGxhdGVEZXNjcmlwdGlvbjogJ0Nsb3VkZnJvbnQgZXh0ZW5zaW9uIHdpdGggQVdTIENESyAtIERlZmF1bHQgRGlyZWN0b3J5IEluZGV4IGZvciBBbWF6b24gUzMgT3JpZ2luLicsXG4gICAgfSk7XG4gICAgdGhpcy5sYW1iZGFGdW5jdGlvbiA9IHRoaXMuZnVuY3Rpb25WZXJzaW9uO1xuICB9XG59O1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgY2xhc3MgQ3VzdG9tRXJyb3JQYWdlIGV4dGVuZHMgQ3VzdG9tIHtcbiAgcmVhZG9ubHkgbGFtYmRhRnVuY3Rpb246IGxhbWJkYS5WZXJzaW9uO1xuICBjb25zdHJ1Y3RvcihzY29wZTogY2RrLkNvbnN0cnVjdCwgaWQ6IHN0cmluZykge1xuXG4gICAgc3VwZXIoc2NvcGUsIGlkLCB7XG4gICAgICBydW50aW1lOiBsYW1iZGEuUnVudGltZS5QWVRIT05fM183LFxuICAgICAgaGFuZGxlcjogJ2luZGV4LmhhbmRsZXInLFxuICAgICAgY29kZTogbGFtYmRhLkFzc2V0Q29kZS5mcm9tQXNzZXQoYCR7RVhURU5TSU9OX0FTU0VUU19QQVRIfS9jZi1jdXN0b20tZXJyb3ItcGFnZWApLFxuICAgICAgZXZlbnRUeXBlOiBjZi5MYW1iZGFFZGdlRXZlbnRUeXBlLk9SSUdJTl9SRVNQT05TRSxcbiAgICAgIHNvbHV0aW9uSWQ6ICdTTzgxMzYnLFxuICAgICAgdGVtcGxhdGVEZXNjcmlwdGlvbjogJ0Nsb3VkZnJvbnQgZXh0ZW5zaW9uIHdpdGggQVdTIENESyAtIEN1c3RvbSBFcnJvciBQYWdlJyxcbiAgICB9KTtcbiAgICB0aGlzLmxhbWJkYUZ1bmN0aW9uID0gdGhpcy5mdW5jdGlvblZlcnNpb247XG4gIH1cbn07XG5cbmV4cG9ydCBpbnRlcmZhY2UgQWNjZXNzT3JpZ2luQnlHZW9sb2NhdGlvblByb3BzIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgY291bnRyeVRhYmxlOiB7IFtjb2RlOiBzdHJpbmddOiBzdHJpbmcgfTtcbn1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBjbGFzcyBBY2Nlc3NPcmlnaW5CeUdlb2xvY2F0aW9uIGV4dGVuZHMgQ3VzdG9tIHtcbiAgY29uc3RydWN0b3Ioc2NvcGU6IGNkay5Db25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBBY2Nlc3NPcmlnaW5CeUdlb2xvY2F0aW9uUHJvcHMpIHtcbiAgICBjb25zdCBmdW5jID0gbmV3IE5vZGVqc0Z1bmN0aW9uKHNjb3BlLCAnQWNjZXNzT3JpZ2luQnlHZW9sb2NhdGlvbkZ1bmMnLCB7XG4gICAgICBlbnRyeTogYCR7RVhURU5TSU9OX0FTU0VUU19QQVRIfS9jZi1hY2Nlc3Mtb3JpZ2luLWJ5LWdlb2xvY2F0aW9uL2luZGV4LnRzYCxcbiAgICAgIC8vIExARSBkb2VzIG5vdCBzdXBwb3J0IE5PREUxNCBzbyB1c2UgTk9ERTEyIGluc3RlYWQuXG4gICAgICBydW50aW1lOiBsYW1iZGEuUnVudGltZS5OT0RFSlNfMTJfWCxcbiAgICAgIGJ1bmRsaW5nOiB7XG4gICAgICAgIGRlZmluZToge1xuICAgICAgICAgICdwcm9jZXNzLmVudi5DT1VOVFJZX0NPREVfVEFCTEUnOiBqc29uU3RyaW5naWZpZWRCdW5kbGluZ0RlZmluaXRpb24ocHJvcHMuY291bnRyeVRhYmxlKSxcbiAgICAgICAgfSxcbiAgICAgIH0sXG4gICAgfSk7XG4gICAgc3VwZXIoc2NvcGUsIGlkLCB7XG4gICAgICBmdW5jLFxuICAgICAgZXZlbnRUeXBlOiBjZi5MYW1iZGFFZGdlRXZlbnRUeXBlLk9SSUdJTl9SRVFVRVNULFxuICAgICAgc29sdXRpb25JZDogJ1MwODExOCcsXG4gICAgICB0ZW1wbGF0ZURlc2NyaXB0aW9uOiAnQ2xvdWRmcm9udCBleHRlbnNpb24gd2l0aCBBV1MgQ0RLIC0gQWNjZXNzIE9yaWdpbiBieSBHZW9sb2NhdGlvbicsXG4gICAgfSk7XG4gIH1cbn07XG5cbmV4cG9ydCBpbnRlcmZhY2UgUmVkaXJlY3RCeUdlb2xvY2F0aW9uUHJvcHMge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBjb3VudHJ5VGFibGU6IHsgW2NvZGU6IHN0cmluZ106IHN0cmluZyB9O1xufVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGNsYXNzIFJlZGlyZWN0QnlHZW9sb2NhdGlvbiBleHRlbmRzIEN1c3RvbSB7XG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBjZGsuQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogUmVkaXJlY3RCeUdlb2xvY2F0aW9uUHJvcHMpIHtcbiAgICBjb25zdCBmdW5jID0gbmV3IE5vZGVqc0Z1bmN0aW9uKHNjb3BlLCAnUmVkaXJlY3RCeUdlb2xvY2F0aW9uRnVuYycsIHtcbiAgICAgIGVudHJ5OiBgJHtFWFRFTlNJT05fQVNTRVRTX1BBVEh9L2NmLXJlZGlyZWN0LWJ5LWdlb2xvY2F0aW9uL2luZGV4LnRzYCxcbiAgICAgIC8vIExARSBkb2VzIG5vdCBzdXBwb3J0IE5PREUxNCBzbyB1c2UgTk9ERTEyIGluc3RlYWQuXG4gICAgICBydW50aW1lOiBsYW1iZGEuUnVudGltZS5OT0RFSlNfMTJfWCxcbiAgICAgIGJ1bmRsaW5nOiB7XG4gICAgICAgIGRlZmluZToge1xuICAgICAgICAgICdwcm9jZXNzLmVudi5DT1VOVFJZX0NPREVfVEFCTEUnOiBqc29uU3RyaW5naWZpZWRCdW5kbGluZ0RlZmluaXRpb24ocHJvcHMuY291bnRyeVRhYmxlKSxcbiAgICAgICAgfSxcbiAgICAgIH0sXG4gICAgfSk7XG4gICAgc3VwZXIoc2NvcGUsIGlkLCB7XG4gICAgICBmdW5jLFxuICAgICAgZXZlbnRUeXBlOiBjZi5MYW1iZGFFZGdlRXZlbnRUeXBlLk9SSUdJTl9SRVFVRVNULFxuICAgICAgc29sdXRpb25JZDogJ1NPODEzNScsXG4gICAgICB0ZW1wbGF0ZURlc2NyaXB0aW9uOiAnQ2xvdWRmcm9udCBleHRlbnNpb24gd2l0aCBBV1MgQ0RLIC0gUmVkaXJlY3QgYnkgR2VvbG9jYXRpb24nLFxuICAgIH0pO1xuICB9XG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGNsYXNzIFNpbXBsZUxhbWJkYUVkZ2UgZXh0ZW5kcyBDdXN0b20ge1xuICBjb25zdHJ1Y3RvcihzY29wZTogY2RrLkNvbnN0cnVjdCwgaWQ6IHN0cmluZykge1xuICAgIGNvbnN0IGZ1bmMgPSBuZXcgTm9kZWpzRnVuY3Rpb24oc2NvcGUsICdTaW1wbGVMYW1iZGFFZGdlRnVuYycsIHtcbiAgICAgIGVudHJ5OiBgJHtFWFRFTlNJT05fQVNTRVRTX1BBVEh9L3NpbXBsZS1sYW1iZGEtZWRnZS9pbmRleC50c2AsXG4gICAgICAvLyBMQEUgZG9lcyBub3Qgc3VwcG9ydCBOT0RFMTQgc28gdXNlIE5PREUxMiBpbnN0ZWFkLlxuICAgICAgcnVudGltZTogbGFtYmRhLlJ1bnRpbWUuTk9ERUpTXzEyX1gsXG4gICAgfSk7XG4gICAgc3VwZXIoc2NvcGUsIGlkLCB7XG4gICAgICBmdW5jLFxuICAgICAgZXZlbnRUeXBlOiBjZi5MYW1iZGFFZGdlRXZlbnRUeXBlLlZJRVdFUl9SRVFVRVNULFxuICAgICAgc29sdXRpb25JZDogJycsXG4gICAgICB0ZW1wbGF0ZURlc2NyaXB0aW9uOiAnQ2xvdWRmcm9udCBleHRlbnNpb24gd2l0aCBBV1MgQ0RLIC0gU2ltcGxlIExhbWJkYSBFZGdlLicsXG4gICAgfSk7XG4gIH1cbn07XG5cbmZ1bmN0aW9uIGpzb25TdHJpbmdpZmllZEJ1bmRsaW5nRGVmaW5pdGlvbih2YWx1ZTogYW55KTogc3RyaW5nIHtcbiAgcmV0dXJuIEpTT04uc3RyaW5naWZ5KHZhbHVlKVxuICAgIC5yZXBsYWNlKC9cIi9nLCAnXFxcXFwiJylcbiAgICAucmVwbGFjZSgvLC9nLCAnXFxcXCwnKTtcbn1cbiJdfQ==