# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['wm_ssh']

package_data = \
{'': ['*']}

install_requires = \
['click>=8.0.3,<9.0.0', 'requests>=2.27.1,<3.0.0']

entry_points = \
{'console_scripts': ['wm-ssh = wm_ssh.cli:wm_ssh']}

setup_kwargs = {
    'name': 'wm-ssh',
    'version': '0.3.0',
    'description': 'Wikimedia ssh wrapper to expand host names',
    'long_description': '# wm-ssh\n\nSsh wrapper to expand wikimedia hostnames.\n\nCurrently it will try several sources, heavily using caches:\n* Known working entries\n* Known hosts file (https://config-master.wikimedia.org/known_hosts.ecdsa)\n* Netbox (https://netbox.wikimedia.org)\n* Openstack Browser (https://openstack-browser.toolforge.org)\n\n# Installation\n## pip\n\nJust `pip install wm-ssh`, that should bring in a new binary, wm-ssh.\n\n## Configuration\nYou can change the default settings by creating a configuration file, and passing the path using\n`--config-file` or using the default `~/.config/wm-ssh/config.json`.\n\nYou can se an example of the loaded configuration running:\n```\nwm-ssh -v --print-config\n```\n\n### Known hosts url\nThis is a url with an ssh `known hosts` formatted file (see man for sshd(8) for the format), the\ndefault one will use wikimedia bare metal hosts and non-cloud VMs.\n\n### Openstack browser\nUrl to the openstack browser toolforge tool, with the list of all the VMs, the default will use\nthe current available one.\n\n\n### Netbox\nNOTE: The netbox feature needs you to have a token for netbox.wikimedia.org, see:\n    https://netbox.wikimedia.org/user/api-tokens/\n\nYou can either configure the netbox cli and set just the path to the config file (the default is\n`~/.config/netbox/config.json`), or you can set the netbox token and url directly  in the wm-ssh\nconfig like (`~/.config/wm-ssh/config.json`):\n```\n{\n    "netbox_config": {\n        "netbox_url": "https://netbox.wikimedia.org/api",\n        "api_token": "myapitokenwouldgohere"\n    }\n}\n```\n\n## Running from code\n\nNote that this mode will require some tweaks in the auto-completing for it to work.\n\nClone the code:\n```\ngit clone git@github.com:david-caro/wm-ssh.git\n```\n\nInstall dependencies with poetry:\n```\npoetry install\n```\n\nRun with poetry:\n```\npoetry run wm-ssh <MYHOST>\n```\n\n\n# Bash completion\n\nYou can use the `utils/wm-ssh.complete` file (source it from your bashrc for example) to achieve bash completion features,\nthough they only work with wmcs openstack instances and known hosts.\n\nFor example, add in your `~/.bashrc` file:\n```\nsource /path/to/git/repo/utirs/wm-ssh.complete\n```\n\nAfter that, it will autocomplete host names from the caches:\n```\n08:04 PM ~/Work/repos/per_user/david-caro/wm-ssh  (main|✚ 2)\ndcaro@vulcanus$ wm-ssh an<tab><tab>\n\nDisplay all 127 possibilities? (y or n)<y>\n\nan-airflow1001.eqiad.wmnet                       an-presto1004.eqiad.wmnet                        an-worker1101.eqiad.wmnet\nan-airflow1002.eqiad.wmnet                       an-presto1005.eqiad.wmnet                        an-worker1102.eqiad.wmnet\nan-airflow1003.eqiad.wmnet                       an-test-client1001.eqiad.wmnet                   an-worker1103.eqiad.wmnet\nanalytics1058.eqiad.wmnet                        an-test-coord1001.eqiad.wmnet                    an-worker1104.eqiad.wmnet\nanalytics1059.eqiad.wmnet                        an-test-coord1002.eqiad.wmnet                    an-worker1105.eqiad.wmnet\nanalytics1060.eqiad.wmnet                        an-test-druid1001.eqiad.wmnet                    an-worker1106.eqiad.wmnet\nanalytics1061.eqiad.wmnet                        an-test-master1001.eqiad.wmnet                   an-worker1107.eqiad.wmnet\nanalytics1062.eqiad.wmnet                        an-test-master1002.eqiad.wmnet                   an-worker1108.eqiad.wmnet\nanalytics1063.eqiad.wmnet                        an-test-presto1001.eqiad.wmnet                   an-worker1109.eqiad.wmnet\nanalytics1064.eqiad.wmnet                        an-test-ui1001.eqiad.wmnet                       an-worker1110.eqiad.wmnet\nanalytics1065.eqiad.wmnet                        an-test-worker1001.eqiad.wmnet                   an-worker1111.eqiad.wmnet\nanalytics1066.eqiad.wmnet                        an-test-worker1002.eqiad.wmnet                   an-worker1112.eqiad.wmnet\nanalytics1067.eqiad.wmnet                        an-test-worker1003.eqiad.wmnet                   an-worker1113.eqiad.wmnet\nanalytics1068.eqiad.wmnet                        an-tool1005.eqiad.wmnet                          an-worker1114.eqiad.wmnet\nanalytics1069.eqiad.wmnet                        an-tool1007.eqiad.wmnet                          an-worker1115.eqiad.wmnet\nanalytics1070.eqiad.wmnet                        an-tool1008.eqiad.wmnet                          an-worker1116.eqiad.wmnet\nanalytics1071.eqiad.wmnet                        an-tool1009.eqiad.wmnet                          an-worker1117.eqiad.wmnet\nanalytics1072.eqiad.wmnet                        an-tool1010.eqiad.wmnet                          an-worker1118.eqiad.wmnet\nanalytics1073.eqiad.wmnet                        an-tool1011.eqiad.wmnet                          an-worker1119.eqiad.wmnet\nanalytics1074.eqiad.wmnet                        an-web1001.eqiad.wmnet                           an-worker1120.eqiad.wmnet\nanalytics1075.eqiad.wmnet                        an-worker1078.eqiad.wmnet                        an-worker1121.eqiad.wmnet\nanalytics1076.eqiad.wmnet                        an-worker1079.eqiad.wmnet                        an-worker1122.eqiad.wmnet\nanalytics1077.eqiad.wmnet                        an-worker1080.eqiad.wmnet                        an-worker1123.eqiad.wmnet\nan-conf1001.eqiad.wmnet                          an-worker1081.eqiad.wmnet                        an-worker1124.eqiad.wmnet\nan-conf1002.eqiad.wmnet                          an-worker1082.eqiad.wmnet                        an-worker1125.eqiad.wmnet\nan-conf1003.eqiad.wmnet                          an-worker1083.eqiad.wmnet                        an-worker1126.eqiad.wmnet\nan-coord1001.eqiad.wmnet                         an-worker1084.eqiad.wmnet                        an-worker1127.eqiad.wmnet\nan-coord1002.eqiad.wmnet                         an-worker1085.eqiad.wmnet                        an-worker1128.eqiad.wmnet\nan-db1001.eqiad.wmnet                            an-worker1086.eqiad.wmnet                        an-worker1129.eqiad.wmnet\nan-db1002.eqiad.wmnet                            an-worker1087.eqiad.wmnet                        an-worker1130.eqiad.wmnet\nan-db-backup-1.analytics.eqiad1.wikimedia.cloud  an-worker1088.eqiad.wmnet                        an-worker1131.eqiad.wmnet\nandrewtest2.trove.eqiad1.wikimedia.cloud         an-worker1089.eqiad.wmnet                        an-worker1132.eqiad.wmnet\nan-druid1001.eqiad.wmnet                         an-worker1090.eqiad.wmnet                        an-worker1133.eqiad.wmnet\nan-druid1002.eqiad.wmnet                         an-worker1091.eqiad.wmnet                        an-worker1134.eqiad.wmnet\nan-druid1003.eqiad.wmnet                         an-worker1092.eqiad.wmnet                        an-worker1135.eqiad.wmnet\nan-druid1004.eqiad.wmnet                         an-worker1093.eqiad.wmnet                        an-worker1136.eqiad.wmnet\nan-druid1005.eqiad.wmnet                         an-worker1094.eqiad.wmnet                        an-worker1137.eqiad.wmnet\nan-launcher1002.eqiad.wmnet                      an-worker1095.eqiad.wmnet                        an-worker1138.eqiad.wmnet\nan-master1001.eqiad.wmnet                        an-worker1096.eqiad.wmnet                        an-worker1139.eqiad.wmnet\nan-master1002.eqiad.wmnet                        an-worker1097.eqiad.wmnet                        an-worker1140.eqiad.wmnet\nan-presto1001.eqiad.wmnet                        an-worker1098.eqiad.wmnet                        an-worker1141.eqiad.wmnet\nan-presto1002.eqiad.wmnet                        an-worker1099.eqiad.wmnet\nan-presto1003.eqiad.wmnet                        an-worker1100.eqiad.wmnet\n\n08:04 PM ~/Work/repos/per_user/david-caro/wm-ssh  (main|✚ 2)\ndcaro@vulcanus$ wm-ssh an\n```\n\n',
    'author': 'David Caro',
    'author_email': 'me@dcaro.es',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/david-caro/wm-ssh',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
