# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/21_minimum.ipynb (unless otherwise specified).

__all__ = ['now', 'Link']

# Cell
from .config import Config
from datetime import datetime
from uuid import uuid4
from inspect import getargspec
from copy import deepcopy

# Cell
def now():return datetime.now().timestamp()

class Link:
    is_link_identifier = True
    data = Config()
    inputs = Config()
    verbose = 0
    def __init__(self,func):
        self.ensure_funcs()
        func_name = func.__name__
        self.func_name = func_name
        self.funcs_[func_name] = func
        self.func = self.funcs_[func_name]
        self.register_args()

    def __repr__(self,):
        return f"[Link Function]:{self.func}"

    def ensure_funcs(self,):
        if hasattr(self,"funcs_")==False:
            self.__class__.funcs_ = Config()

    def ensure_uuid(self,uuid:str)->str:
        """
        Make sure there's uuid,
        if not create on
        """
        if uuid == False:
            uuid = str(uuid4())
            self.data[uuid] = Config()
            self.inputs[uuid] = Config()
            return uuid
        else:
            return uuid

    def check_callback(self,v,uuid):

        if hasattr(v,"is_link_identifier")==False:
            # this is not a callback function
            return v

        elif v.func_name in self.data[uuid]:
            # found calculated result of the function
            # read the cached result
            if self.verbose>0:
                print(f"[{self.func_name}] using cache:\t{v.func_name}")
            return self.data[uuid].get(v.func_name)

        else:
            # calculated result of function v not found,
            # execuate the calculation
            if self.verbose>0:
                print(f"[{self.func_name}] execute callback:\t{v.func_name}")
            result = v.unit_call(uuid)()
            return result

    @staticmethod
    def value_only(dict_:Config)->Config:
        """
        filter out the value that requires callback
        """
        return Config((k,v) for k,v in dict_.items() if hasattr(v,"is_link_identifier")==False)

    @staticmethod
    def callback_only(dict_:Config)->Config:
        """
        filter out the value that does not require callback
        """
        return Config((k,v) for k,v in dict_.items() if hasattr(v,"is_link_identifier")==True)

    def get_cached(self,uuid:str)->Config:
        """
        Get the cached data
        """
        this_data = self.data[uuid]
        return Config((k,this_data.get(k)) for k in self.all_argname \
                          if k in this_data)

    def unit_call(self,uuid = False):
        uuid = self.ensure_uuid(uuid)

        def called(*args,**kwargs):
            # record inputs
            kwargs0 = deepcopy(self.kwargs_default)
            kwargs0.update(kwargs)

            # save inputs
            self.inputs[uuid].update(Config({self.func_name:Config(args = args,
                                                                   kwargs = kwargs0)}))
            # save data
            self.data[uuid].update(self.value_only(kwargs0))

            # check the cache for all args
            cached = self.get_cached(uuid)
            kwargs0.update(cached)

            # check the callback trigger
            args0 = list(self.check_callback(a,uuid) for a in args)
            kwargs0 = dict((k,self.check_callback(v,uuid)) for k,v in kwargs0.items())

            # redundant keywords
            if (len(args0)>0) and len(self.arg_spec.args)>=len(args0):
                manual_args = self.arg_spec.args[:len(args0)]
                for k in manual_args:
                    if k in kwargs0:
                        del kwargs0[k]
                if len(args0)>len(manual_args):
                    # TODO: continue development
                    for arg in args0[-len(manual_args):]:
                        pass

            # run function
            if self.verbose > 1:
                print(f"[{self.func_name}] final args {args0}")
                print(f"[{self.func_name}] final kwargs {kwargs0}")
            rt = self.func(*args0,**kwargs0)

            # save outputs
            if hasattr(rt,'items'):
                self.data[uuid].update(rt)
            self.data[uuid].update({self.func_name:rt})

            return rt
        return called

    def __call__(self,*args,**kwargs,):
        return self.unit_call()(*args,**kwargs)

    def register_args(self)->None:
        """
        Register all the arguements
        """
        arg_spec = getfullargspec(self.func)
        self.arg_spec = arg_spec

        # gather all the default **keyword** arguments
        kwargs_default = dict()
        if arg_spec.defaults != None:
            kwargs_default.update(dict(zip(arg_spec.args[::-1],arg_spec.defaults[::-1])))
        if arg_spec.kwonlydefaults != None:
            kwargs_default.update(dict(zip(arg_spec.kwonlyargs[::-1],arg_spec.kwonlydefaults[::-1])))
        self.kwargs_default = kwargs_default

        # gather all the arg,kwarg name
        self.all_argname = []
        if len(arg_spec.args)>0:
            self.all_argname+=arg_spec.args
        if len(arg_spec.kwonlyargs)>0:
            self.all_argname+=arg_spec.kwonlyargs