# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/51_widgets.ipynb (unless otherwise specified).

__all__ = ['image_to_base64', 'data_url', 'image_dom', 'view_images']

# Cell
import base64
from io import BytesIO
from PIL import Image

# Cell
def image_to_base64(
    img: Image
) -> str:
    """
    Transform PIL Image to base64 for API
    Return:
        - base64 encoded image bytes
    """
    img = img.convert('RGB')
    output_buffer = BytesIO()
    img.save(output_buffer, format='JPEG')
    byte_data = output_buffer.getvalue()
    base64_str = base64.b64encode(byte_data)
    return base64_str.decode()

def data_url(
    img: Image
) -> str:
    """
    Return:
        - data url string,
            can be used as the src value of <img>
    """
    return f"data:image/jpg;base64,{image_to_base64(img)}"

# Cell
def image_dom(
    img: Image,
    **kwargs
):
    """
    Create <img> tag with src='data:...'
        with PIL.Image object
    return forgebox.html.DOM
    """
    from ..html import DOM

    img_dom = DOM("","img",dict(
        src=data_url(img),
    ))
    kwargs.update({"style": "padding:3px"})
    div_dom = DOM("","div",kwargs)
    div_dom.append(img_dom)
    return div_dom

def view_images(
    *images,
    num_per_row=4,
):
    """
    Create <div> wraping up images
    view_images(
        img1, img2, img3,
        img4, img5, img6,
        img7)()
    """
    from ..html import DOM
    frame = DOM("","div",{"class":"row"})
    assert num_per_row in [1, 2, 3, 4, 6, 12],\
        "num_per_row should be in [1, 2, 3, 4, 6, 12]"
    col = 12//num_per_row

    for img in images:
        frame.append(image_dom(img,**{"class": f"col-sm-{col}"}))
    return frame