import type { Context, ScheduledEvent } from 'aws-lambda';
import * as AWS from 'aws-sdk';
/**
 * Obtains the TLS certificate used by the HTTPS endpoint designated by the
 * `HTTPS_ENDPOINT` environment variable, checks how many validity days remain
 * for this endpoint, and produces a CloudWatch metric under the namespace
 * designated by `METRIC_NAMESPACE`, named as specified by `METRIC_NAME`.
 *
 * If the certificate is past expiration, the metric will be trimmed to `0`
 * instead of turning into negative values.
 */
export declare function handler(_event: ScheduledEvent, _context: Context): Promise<{
    $response: AWS.Response<{}, AWS.AWSError>;
}>;
