import { IAlarm, IMetric, MetricOptions } from '@aws-cdk/aws-cloudwatch';
import { RetentionDays } from '@aws-cdk/aws-logs';
import { IBucket } from '@aws-cdk/aws-s3';
import { IQueue } from '@aws-cdk/aws-sqs';
import { Construct } from '@aws-cdk/core';
import { Monitoring } from '../../monitoring';
export interface DiscoveryProps {
    /**
     * The monitoring handler to register alarms with.
     */
    readonly monitoring: Monitoring;
    /**
     * The queue to post package updated messages to
     */
    readonly queue: IQueue;
    /**
     * How long should execution logs be retained?
     *
     * @default RetentionDays.TEN_YEARS
     */
    readonly logRetention?: RetentionDays;
}
/**
 * This discovery function periodically scans the CouchDB replica of npmjs.com
 * to discover newly published packages that are relevant for indexing in the
 * Construct Hub, then notifies the ingestion function about those.
 */
export declare class Discovery extends Construct {
    /**
     * The S3 bucket in which the discovery function stages npm packages.
     */
    readonly bucket: IBucket;
    /**
     * Alarms if the discovery function does not complete successfully.
     */
    readonly alarmErrors: IAlarm;
    /**
     * Alarms if the discovery function does not run as expected.
     */
    readonly alarmNoInvocations: IAlarm;
    private readonly timeout;
    constructor(scope: Construct, id: string, props: DiscoveryProps);
    /**
     * The average time it took to process a changes batch.
     */
    metricBatchProcessingTime(opts?: MetricOptions): IMetric;
    /**
     * The total count of changes that were processed.
     */
    metricChangeCount(opts?: MetricOptions): IMetric;
    /**
     * The age of the oldest package version that was processed.
     */
    metricPackageVersionAge(opts?: MetricOptions): IMetric;
    /**
     * The total count of package versions that were inspected.
     */
    metricPackageVersionCount(opts?: MetricOptions): IMetric;
    /**
     * The total count of package versions that were deemed relevant.
     */
    metricRelevantPackageVersions(opts?: MetricOptions): IMetric;
    /**
     * The amount of time that was remaining when the lambda returned in order to
     * avoid hitting a timeout.
     */
    metricRemainingTime(opts?: MetricOptions): IMetric;
    /**
     * The total count of staging failures.
     */
    metricStagingFailureCount(opts?: MetricOptions): IMetric;
    /**
     * The average time it took to stage a package to S3.
     */
    metricStagingTime(opts?: MetricOptions): IMetric;
    /**
     * The amount of changes that were not processed due to having an invalid
     * format.
     */
    metricUnprocessableEntity(opts?: MetricOptions): IMetric;
}
