import { IAlarm } from '@aws-cdk/aws-cloudwatch';
import { RetentionDays } from '@aws-cdk/aws-logs';
import { Bucket } from '@aws-cdk/aws-s3';
import { Construct } from '@aws-cdk/core';
import { Monitoring } from '../../monitoring';
export interface CatalogBuilderProps {
    /**
     * The package store bucket.
     */
    readonly bucket: Bucket;
    /**
     * The monitoring handler to register alarms with.
     */
    readonly monitoring: Monitoring;
    /**
     * How long should execution logs be retained?
     *
     * @default RetentionDays.TEN_YEARS
     */
    readonly logRetention?: RetentionDays;
}
/**
 * Builds or re-builds the `catalog.json` object in the designated bucket.
 */
export declare class CatalogBuilder extends Construct {
    /**
     * Alarms when the dead-letter-queue associated with the catalog builder
     * function is not empty, meaning the catalog builder failed to run and
     * requires operator attention.
     */
    readonly alarmDeadLetterQueueNotEmpty: IAlarm;
    constructor(scope: Construct, id: string, props: CatalogBuilderProps);
}
