"""
    These are the sub-commands for a top level object added to the CLI group in 'cli.py'.
    The commands and options are implemented here and the logic behind them resides in the corresponding behavior file.
"""

import behavior
import click
import pyke

@click.group(help='Experience related commands.')
def experience():
  pass

@click.command('ls', help="List the experiences related to the selected profile.")
@click.option('--profile', '-p', help=pyke.helptxt.PROFILE, callback=pyke.select_profile, autocompletion=pyke.auth.get_profile_names)
@click.option('--format', '-f', default='{id} {label} {name} {createdAt}', help='The --format option takes the column name of the returned table wrapped in \
{} and returns only that column. It is not compatible with --json flag.')
@pyke.list_options
def list(**kwargs):
  behavior.ExperienceBehavior(**kwargs).list()

@click.command('export', help='Exports an experience as a JSON file')
@click.option('--profile', '-p', help=pyke.helptxt.PROFILE, callback=pyke.select_profile, autocompletion=pyke.auth.get_profile_names)
@click.option('--label', '-l', help='The label of the experience being exported. This is the experience "Name" in the UI.')
@click.option('--name', '-n', default='', help='The autogenerated name (aka namespace) of the experience being exported. This is not the experience "Name" in the UI.')
@click.option('--export-file', '-path', help='The location to save the export file. Not supported if --json is specified.')
@click.option('--json', is_flag=True, help='Return raw json from the platform')
def export(**kwargs):
  behavior.ExperienceBehavior(**kwargs).export()

@click.command('import', help='Imports an experience via a JSON file')
@click.option('--profile', '-p', help=pyke.helptxt.PROFILE, callback=pyke.select_profile, autocompletion=pyke.auth.get_profile_names)
@click.option('--label', '-l', prompt=True, help='The label for the new experience. This aligns with "Name" in the UI.')
@click.option('--description', '-d', help='The description for the new experience')
@click.option('--device-type', '-dt', prompt=True, type=click.Choice(['mobile', 'tablet', 'web']), default='mobile', help='The preview device the experience is displayed on in the studio.')
@click.option('--collection', '-cn', help='The id or the name of the collection where the new Experience will be placed.')
@click.option('--activation-code', '-ac', prompt=True, help='The activation code for the new experience')
@click.option('--template', '-t', is_flag=True, help='Indicates the new experience should be a template')
@click.option('--redirect-url', '-ru', default='', help='The redirect url for the new experience')
@click.option('--import-file', '-path', prompt=True, help='The location of the experience file to import')
@click.option('--json', is_flag=True, help='Return raw json from the platform')
def import_(**kwargs):
  behavior.ExperienceBehavior(**kwargs).import_()

@click.command('add', help="Create a new Experience within a selected profile")
@click.option('--profile', '-p', help=pyke.helptxt.PROFILE, callback=pyke.select_profile, autocompletion=pyke.auth.get_profile_names)
@click.option('--name', '-n', prompt=True, type=str, help='Name of the new Experience.')
@click.option('--description', '-d', help='Description of new Experience.')
@click.option('--collection', '-cn', help='The id or the name of the collection where the new Experience will be placed.')
@click.option('--activation-code', '-ac', prompt=True, help='The code used to activate the Experience.')
@click.option('--device-type', '-dt', prompt=True, type=click.Choice(['mobile', 'tablet', 'web']), default='mobile', help='The preview device the experience is displayed on in the studio."')
@click.option('--redirect-url', '-ru', help='A valid webaddress that the Experience will redirect.')
@click.option('--json', is_flag=True, help='Return raw json from the platform')
def create(**kwargs):
  behavior.ExperienceBehavior(**kwargs).create()

experience.add_command(list)
experience.add_command(export)
experience.add_command(import_)
experience.add_command(create)
