import setuptools
from setuptools import setup, find_packages
from codecs import open
from os import path

here = path.abspath(path.dirname(__file__))

# Get the long description from the README file
with open(path.join(here, 'README.md'), encoding='utf-8') as f:
    long_description = f.read()

setup(
    name='subx',

    # Updated via travisd: https://travis-ci.org/guettli/subx
    # See .travis.yml
    version='2020.43.0',

    description='subx: Datastructure SubprocessResult',
    long_description=long_description,
    long_description_content_type='text/markdown',

    url='https://github.com/guettli/subx/',

    author='Thomas Guettler',
    author_email='info.subx@thomas-guettler.de',

    license='Apache Software License 2.0',

    # See https://pypi.python.org/pypi?%3Aaction=list_classifiers
    classifiers=[
        # How mature is this project? Common values are
        #   3 - Alpha
        #   4 - Beta
        #   5 - Production/Stable
        'Development Status :: 5 - Production/Stable',

        # Indicate who your project is intended for
        'Intended Audience :: Information Technology',

        # Pick your license as you wish (should match "license" above)
        'License :: OSI Approved :: Apache Software License',

        'Programming Language :: Python :: 3',
    ],

    packages=setuptools.find_packages(),

    python_requires='>=3.7',
)
