"use strict";
var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GlobalDataIngestion = exports.OAuth2AuthorizationCodeGrant = exports.SimpleLambdaEdge = exports.RedirectByGeolocation = exports.AccessOriginByGeolocation = exports.CustomErrorPage = exports.DefaultDirIndex = exports.ConvertQueryString = exports.NormalizeQueryString = exports.MultipleOriginIpRetry = exports.SecurtyHeaders = exports.AntiHotlinking = exports.HTTP302FromOrigin = exports.ModifyResponseHeader = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const cf = require("@aws-cdk/aws-cloudfront");
const iam = require("@aws-cdk/aws-iam");
const lambda = require("@aws-cdk/aws-lambda");
const aws_lambda_nodejs_1 = require("@aws-cdk/aws-lambda-nodejs");
const cdk = require("@aws-cdk/core");
const _1 = require("./");
const custom_1 = require("./custom");
/**
 * The directory for all extensions lambda assets
 */
const EXTENSION_ASSETS_PATH = path.join(__dirname, '../lambda-assets/extensions');
;
/**
 * The modify response header extension.
 *
 * @see https://console.aws.amazon.com/lambda/home#/create/app?applicationId=arn:aws:serverlessrepo:us-east-1:418289889111:applications/modify-response-header
 * @stability stable
 */
class ModifyResponseHeader extends _1.ServerlessApp {
    /**
     * @stability stable
     */
    constructor(scope, id) {
        super(scope, id, {
            applicationId: 'arn:aws:serverlessrepo:us-east-1:418289889111:applications/modify-response-header',
            semanticVersion: '1.0.0',
        });
        const stack = cdk.Stack.of(scope);
        this.functionArn = this.resource.getAtt('Outputs.ModifyResponseHeaderFunctionARN').toString();
        this.functionVersion = bumpFunctionVersion(stack, id, this.functionArn);
        this.eventType = cf.LambdaEdgeEventType.ORIGIN_RESPONSE;
    }
}
exports.ModifyResponseHeader = ModifyResponseHeader;
_a = JSII_RTTI_SYMBOL_1;
ModifyResponseHeader[_a] = { fqn: "cdk-cloudfront-plus.ModifyResponseHeader", version: "0.3.161" };
// export class HTTP302FromOrigin extends ServerlessApp implements IExtensions {
//   readonly functionArn: string;
//   readonly functionVersion: lambda.Version;
//   readonly eventType: cf.LambdaEdgeEventType;
//   readonly lambdaFunction: lambda.Version;
//   constructor(scope: cdk.Construct, id: string) {
//     super(scope, id, {
//       applicationId: 'arn:aws:serverlessrepo:us-east-1:418289889111:applications/http302-from-origin',
//       semanticVersion: '1.0.2',
//     });
//     const stack = cdk.Stack.of(scope);
//     this.functionArn = this.resource.getAtt('Outputs.Http302Function').toString();
//     this.functionVersion = bumpFunctionVersion(stack, id, this.functionArn);
//     this.lambdaFunction = this.functionVersion;
//     this.eventType = cf.LambdaEdgeEventType.ORIGIN_RESPONSE;
//   }
// };
/**
 * The HTTP[302] from origin extension.
 *
 * @see https://console.aws.amazon.com/lambda/home#/create/app?applicationId=arn:aws:serverlessrepo:us-east-1:418289889111:applications/http302-from-origin
 * @stability stable
 */
class HTTP302FromOrigin extends custom_1.Custom {
    /**
     * @stability stable
     */
    constructor(scope, id) {
        const func = new aws_lambda_nodejs_1.NodejsFunction(scope, 'HTTP302FromOriginFunc', {
            entry: `${EXTENSION_ASSETS_PATH}/cf-http302-from-origin/index.ts`,
            runtime: lambda.Runtime.NODEJS_14_X,
        });
        super(scope, id, {
            func,
            eventType: cf.LambdaEdgeEventType.ORIGIN_RESPONSE,
            solutionId: 'SO8103',
            templateDescription: 'Cloudfront extension with AWS CDK - HTTP 302 from Origin',
        });
        this.lambdaFunction = this.functionVersion;
    }
}
exports.HTTP302FromOrigin = HTTP302FromOrigin;
_b = JSII_RTTI_SYMBOL_1;
HTTP302FromOrigin[_b] = { fqn: "cdk-cloudfront-plus.HTTP302FromOrigin", version: "0.3.161" };
;
/**
 * The Anti-Hotlinking extension.
 *
 * @see https://console.aws.amazon.com/lambda/home#/create/app?applicationId=arn:aws:serverlessrepo:us-east-1:418289889111:applications/anti-hotlinking
 * @stability stable
 */
class AntiHotlinking extends _1.ServerlessApp {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        super(scope, id, {
            applicationId: 'arn:aws:serverlessrepo:us-east-1:418289889111:applications/anti-hotlinking',
            semanticVersion: '1.2.5',
            parameters: {
                RefererList: props.referer.join(','),
            },
        });
        const stack = cdk.Stack.of(scope);
        this.functionArn = this.resource.getAtt('Outputs.AntiHotlinking').toString();
        this.functionVersion = bumpFunctionVersion(stack, id, this.functionArn);
        this.eventType = cf.LambdaEdgeEventType.VIEWER_REQUEST;
    }
}
exports.AntiHotlinking = AntiHotlinking;
_c = JSII_RTTI_SYMBOL_1;
AntiHotlinking[_c] = { fqn: "cdk-cloudfront-plus.AntiHotlinking", version: "0.3.161" };
/**
 * Security Headers extension.
 *
 * @see https://aws.amazon.com/tw/blogs/networking-and-content-delivery/adding-http-security-headers-using-lambdaedge-and-amazon-cloudfront/
 * @stability stable
 */
class SecurtyHeaders extends _1.ServerlessApp {
    /**
     * @stability stable
     */
    constructor(scope, id) {
        super(scope, id, {
            applicationId: 'arn:aws:serverlessrepo:us-east-1:418289889111:applications/add-security-headers',
            semanticVersion: '1.0.0',
        });
        const stack = cdk.Stack.of(scope);
        this.functionArn = this.resource.getAtt('Outputs.AddSecurityHeaderFunction').toString();
        this.functionVersion = bumpFunctionVersion(stack, id, this.functionArn);
        this.eventType = cf.LambdaEdgeEventType.ORIGIN_RESPONSE;
    }
}
exports.SecurtyHeaders = SecurtyHeaders;
_d = JSII_RTTI_SYMBOL_1;
SecurtyHeaders[_d] = { fqn: "cdk-cloudfront-plus.SecurtyHeaders", version: "0.3.161" };
/**
 * Multiple Origin IP Retry extension.
 *
 * @see https://github.com/awslabs/aws-cloudfront-extensions/tree/main/edge/nodejs/multiple-origin-IP-retry
 * @stability stable
 */
class MultipleOriginIpRetry extends _1.ServerlessApp {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        super(scope, id, {
            applicationId: 'arn:aws:serverlessrepo:us-east-1:418289889111:applications/multiple-origin-IP-retry',
            semanticVersion: '1.0.1',
            parameters: {
                OriginIPList: props.originIp.join(';'),
                OriginProtocol: props.originProtocol,
            },
        });
        const stack = cdk.Stack.of(scope);
        this.functionArn = this.resource.getAtt('Outputs.MultipleOriginIPRetry').toString();
        this.functionVersion = bumpFunctionVersion(stack, id, this.functionArn);
        this.eventType = cf.LambdaEdgeEventType.ORIGIN_REQUEST;
    }
}
exports.MultipleOriginIpRetry = MultipleOriginIpRetry;
_e = JSII_RTTI_SYMBOL_1;
MultipleOriginIpRetry[_e] = { fqn: "cdk-cloudfront-plus.MultipleOriginIpRetry", version: "0.3.161" };
/**
 * Normalize Query String extension.
 *
 * @see https://github.com/awslabs/aws-cloudfront-extensions/tree/main/edge/nodejs/normalize-query-string
 * @stability stable
 */
class NormalizeQueryString extends _1.ServerlessApp {
    /**
     * @stability stable
     */
    constructor(scope, id) {
        super(scope, id, {
            applicationId: 'arn:aws:serverlessrepo:us-east-1:418289889111:applications/normalize-query-string',
            semanticVersion: '1.0.1',
        });
        const stack = cdk.Stack.of(scope);
        this.functionArn = this.resource.getAtt('Outputs.NormalizeQueryStringFunction').toString();
        this.functionVersion = bumpFunctionVersion(stack, id, this.functionArn);
        this.eventType = cf.LambdaEdgeEventType.VIEWER_REQUEST;
    }
}
exports.NormalizeQueryString = NormalizeQueryString;
_f = JSII_RTTI_SYMBOL_1;
NormalizeQueryString[_f] = { fqn: "cdk-cloudfront-plus.NormalizeQueryString", version: "0.3.161" };
/**
 * Generate a lambda function version from the given function ARN
 * @param scope
 * @param id
 * @param functionArn The lambda function ARN
 * @returns lambda.Version
 */
function bumpFunctionVersion(scope, id, functionArn) {
    return new lambda.Version(scope, `LambdaVersion${id}`, {
        lambda: lambda.Function.fromFunctionArn(scope, `FuncArn${id}`, functionArn),
    });
}
/**
 * Convert a query string to key-value pairs and add them into header.
 *
 * @see https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/lambda-examples.html#lambda-examples-header-based-on-query-string
 * @stability stable
 */
class ConvertQueryString extends custom_1.Custom {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        const func = new aws_lambda_nodejs_1.NodejsFunction(scope, 'ConvertQueryStringFunc', {
            entry: `${EXTENSION_ASSETS_PATH}/cf-convert-query-string/index.ts`,
            handler: 'lambdaHandler',
            runtime: lambda.Runtime.NODEJS_14_X,
            bundling: {
                define: {
                    NEEDED_KEYS: JSON.stringify(props.args),
                },
            },
        });
        super(scope, id, {
            func,
            eventType: cf.LambdaEdgeEventType.ORIGIN_REQUEST,
            solutionId: 'SO8113',
            templateDescription: 'Cloudfront extension with AWS CDK - Convert Query String.',
        });
        this.lambdaFunction = this.functionVersion;
    }
}
exports.ConvertQueryString = ConvertQueryString;
_g = JSII_RTTI_SYMBOL_1;
ConvertQueryString[_g] = { fqn: "cdk-cloudfront-plus.ConvertQueryString", version: "0.3.161" };
/**
 * Default Directory Indexes in Amazon S3-backed Amazon CloudFront Origins.
 *
 * use case - see https://aws.amazon.com/tw/blogs/compute/implementing-default-directory-indexes-in-amazon-s3-backed-amazon-cloudfront-origins-using-lambdaedge/
 *
 * @stability stable
 */
class DefaultDirIndex extends custom_1.Custom {
    /**
     * @stability stable
     */
    constructor(scope, id) {
        const func = new aws_lambda_nodejs_1.NodejsFunction(scope, 'DefaultDirIndexFunc', {
            entry: `${EXTENSION_ASSETS_PATH}/cf-default-dir-index/index.ts`,
            runtime: lambda.Runtime.NODEJS_14_X,
        });
        super(scope, id, {
            func,
            eventType: cf.LambdaEdgeEventType.ORIGIN_REQUEST,
            solutionId: 'SO8134',
            templateDescription: 'Cloudfront extension with AWS CDK - Default Directory Index for Amazon S3 Origin.',
        });
        this.lambdaFunction = this.functionVersion;
    }
}
exports.DefaultDirIndex = DefaultDirIndex;
_h = JSII_RTTI_SYMBOL_1;
DefaultDirIndex[_h] = { fqn: "cdk-cloudfront-plus.DefaultDirIndex", version: "0.3.161" };
;
/**
 * Display customized error pages, or mask 4XX error pages, based on where the error originated.
 *
 * use case - see https://aws.amazon.com/blogs/networking-and-content-delivery/customize-403-error-pages-from-amazon-cloudfront-origin-with-lambdaedge/
 *
 * @stability stable
 */
class CustomErrorPage extends custom_1.Custom {
    /**
     * @stability stable
     */
    constructor(scope, id) {
        const func = new aws_lambda_nodejs_1.NodejsFunction(scope, 'CustomErrorPageFunc', {
            entry: `${EXTENSION_ASSETS_PATH}/cf-custom-error-page/index.ts`,
            runtime: lambda.Runtime.NODEJS_14_X,
        });
        super(scope, id, {
            func,
            eventType: cf.LambdaEdgeEventType.ORIGIN_RESPONSE,
            solutionId: 'SO8136',
            templateDescription: 'Cloudfront extension with AWS CDK - Custom Error Page',
        });
        this.lambdaFunction = this.functionVersion;
    }
}
exports.CustomErrorPage = CustomErrorPage;
_j = JSII_RTTI_SYMBOL_1;
CustomErrorPage[_j] = { fqn: "cdk-cloudfront-plus.CustomErrorPage", version: "0.3.161" };
;
/**
 * (SO8118)Access Origin by Geolocation.
 *
 * @stability stable
 */
class AccessOriginByGeolocation extends custom_1.Custom {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        const func = new aws_lambda_nodejs_1.NodejsFunction(scope, 'AccessOriginByGeolocationFunc', {
            entry: `${EXTENSION_ASSETS_PATH}/cf-access-origin-by-geolocation/index.ts`,
            runtime: lambda.Runtime.NODEJS_14_X,
            bundling: {
                define: {
                    'process.env.COUNTRY_CODE_TABLE': JSON.stringify(props.countryTable),
                },
            },
        });
        super(scope, id, {
            func,
            eventType: cf.LambdaEdgeEventType.ORIGIN_REQUEST,
            solutionId: 'S08118',
            templateDescription: 'Cloudfront extension with AWS CDK - Access Origin by Geolocation',
        });
    }
}
exports.AccessOriginByGeolocation = AccessOriginByGeolocation;
_k = JSII_RTTI_SYMBOL_1;
AccessOriginByGeolocation[_k] = { fqn: "cdk-cloudfront-plus.AccessOriginByGeolocation", version: "0.3.161" };
;
/**
 * Forward request to the nearest PoP as per geolocation.
 *
 * @stability stable
 */
class RedirectByGeolocation extends custom_1.Custom {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        const func = new aws_lambda_nodejs_1.NodejsFunction(scope, 'RedirectByGeolocationFunc', {
            entry: `${EXTENSION_ASSETS_PATH}/cf-redirect-by-geolocation/index.ts`,
            runtime: lambda.Runtime.NODEJS_14_X,
            bundling: {
                define: {
                    'process.env.COUNTRY_CODE_TABLE': JSON.stringify(props.countryTable),
                },
            },
        });
        super(scope, id, {
            func,
            eventType: cf.LambdaEdgeEventType.ORIGIN_REQUEST,
            solutionId: 'SO8135',
            templateDescription: 'Cloudfront extension with AWS CDK - Redirect by Geolocation',
        });
    }
}
exports.RedirectByGeolocation = RedirectByGeolocation;
_l = JSII_RTTI_SYMBOL_1;
RedirectByGeolocation[_l] = { fqn: "cdk-cloudfront-plus.RedirectByGeolocation", version: "0.3.161" };
/**
 * Simple content generation.
 *
 * @see https://github.com/awslabs/aws-cloudfront-extensions/tree/main/edge/nodejs/simple-lambda-edge
 * @stability stable
 */
class SimpleLambdaEdge extends custom_1.Custom {
    /**
     * @stability stable
     */
    constructor(scope, id) {
        const func = new aws_lambda_nodejs_1.NodejsFunction(scope, 'SimpleLambdaEdgeFunc', {
            entry: `${EXTENSION_ASSETS_PATH}/simple-lambda-edge/index.ts`,
            runtime: lambda.Runtime.NODEJS_14_X,
        });
        super(scope, id, {
            func,
            eventType: cf.LambdaEdgeEventType.VIEWER_REQUEST,
            solutionId: '',
            templateDescription: 'Cloudfront extension with AWS CDK - Simple Lambda Edge.',
        });
    }
}
exports.SimpleLambdaEdge = SimpleLambdaEdge;
_m = JSII_RTTI_SYMBOL_1;
SimpleLambdaEdge[_m] = { fqn: "cdk-cloudfront-plus.SimpleLambdaEdge", version: "0.3.161" };
;
/**
 * OAuth2 Authentication - Authorization Code Grant.
 *
 * @stability stable
 */
class OAuth2AuthorizationCodeGrant extends custom_1.Custom {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        const func = new aws_lambda_nodejs_1.NodejsFunction(scope, 'OAuth2AuthorizationCodeGrantFunc', {
            entry: `${EXTENSION_ASSETS_PATH}/cf-authentication-by-oauth2/index.ts`,
            runtime: lambda.Runtime.NODEJS_14_X,
            bundling: {
                define: {
                    'process.env.CLIENT_DOMAIN': JSON.stringify(props.clientDomain),
                    'process.env.CLIENT_ID': JSON.stringify(props.clientId),
                    'process.env.CLIENT_SECRET': JSON.stringify(props.clientSecret),
                    'process.env.CLIENT_PUBLIC_KEY': JSON.stringify(props.clientPublicKey),
                    'process.env.AUTHORIZE_URL': JSON.stringify(props.authorizeUrl),
                    'process.env.AUTHORIZE_PARAMS': JSON.stringify(props.authorizeParams),
                    'process.env.AUTHORIZE_REDIRECTURI_SHOULD_MATCH': JSON.stringify(props.authorizeRedirecturiShouldMatch),
                    'process.env.CALLBACK_PATH': JSON.stringify(props.callbackPath),
                    'process.env.JWT_ARGORITHM': JSON.stringify(props.jwtArgorithm),
                    'process.env.JWT_TOKEN_PATH': JSON.stringify(props.jwtTokenPath),
                    'process.env.DEBUG_ENABLE': JSON.stringify(props.debugEnable),
                },
            },
        });
        super(scope, id, {
            func,
            eventType: cf.LambdaEdgeEventType.VIEWER_REQUEST,
            solutionId: 'SO8131',
            templateDescription: 'Cloudfront extension with AWS CDK - OAuth2 Authentication - Authorization Code Grant.',
        });
        this.lambdaFunction = this.functionVersion;
    }
}
exports.OAuth2AuthorizationCodeGrant = OAuth2AuthorizationCodeGrant;
_o = JSII_RTTI_SYMBOL_1;
OAuth2AuthorizationCodeGrant[_o] = { fqn: "cdk-cloudfront-plus.OAuth2AuthorizationCodeGrant", version: "0.3.161" };
;
;
/**
 * Ingest data to Kinesis Firehose by nearest cloudfront edge.
 *
 * @see https://aws.amazon.com/blogs/networking-and-content-delivery/global-data-ingestion-with-amazon-cloudfront-and-lambdaedge/
 * @stability stable
 */
class GlobalDataIngestion extends custom_1.Custom {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _q;
        const func = new aws_lambda_nodejs_1.NodejsFunction(scope, 'GlobalDataIngestionFunc', {
            entry: `${EXTENSION_ASSETS_PATH}/cf-global-data-ingestion/index.ts`,
            runtime: lambda.Runtime.NODEJS_14_X,
            bundling: {
                define: {
                    'process.env.DELIVERY_STREAM_NAME': JSON.stringify(props.firehoseStreamName),
                },
            },
        });
        (_q = func.role) === null || _q === void 0 ? void 0 : _q.addManagedPolicy(iam.ManagedPolicy.fromAwsManagedPolicyName('AmazonKinesisFirehoseFullAccess'));
        super(scope, id, {
            func,
            eventType: cf.LambdaEdgeEventType.VIEWER_REQUEST,
            includeBody: true,
            solutionId: 'SO8133',
            templateDescription: 'Cloudfront extension with AWS CDK - Global Data Ingestion',
        });
        this.lambdaFunction = this.functionVersion;
    }
}
exports.GlobalDataIngestion = GlobalDataIngestion;
_p = JSII_RTTI_SYMBOL_1;
GlobalDataIngestion[_p] = { fqn: "cdk-cloudfront-plus.GlobalDataIngestion", version: "0.3.161" };
//# sourceMappingURL=data:application/json;base64,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