import * as codepipeline from "../../aws-codepipeline";
import { Stage } from "../../core";
import * as cxapi from "../../cx-api";
import { Construct } from 'constructs';
import { AssetType } from './actions';
import { Construct as CoreConstruct } from "../../core";
/**
 * (experimental) Construction properties for a CdkStage.
 *
 * @experimental
 */
export interface CdkStageProps {
    /**
     * (experimental) Name of the stage that should be created.
     *
     * @experimental
     */
    readonly stageName: string;
    /**
     * (experimental) The underlying Pipeline Stage associated with thisCdkStage.
     *
     * @experimental
     */
    readonly pipelineStage: codepipeline.IStage;
    /**
     * (experimental) The CodePipeline Artifact with the Cloud Assembly.
     *
     * @experimental
     */
    readonly cloudAssemblyArtifact: codepipeline.Artifact;
    /**
     * (experimental) Features the Stage needs from its environment.
     *
     * @experimental
     */
    readonly host: IStageHost;
}
/**
 * (experimental) Stage in a CdkPipeline.
 *
 * You don't need to instantiate this class directly. Use
 * `cdkPipeline.addStage()` instead.
 *
 * @experimental
 */
export declare class CdkStage extends CoreConstruct {
    private _nextSequentialRunOrder;
    private _manualApprovalCounter;
    private readonly pipelineStage;
    private readonly cloudAssemblyArtifact;
    private readonly stacksToDeploy;
    private readonly stageName;
    private readonly host;
    private _prepared;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: CdkStageProps);
    /**
     * (experimental) Add all stacks in the application Stage to this stage.
     *
     * The application construct should subclass `Stage` and can contain any
     * number of `Stacks` inside it that may have dependency relationships
     * on one another.
     *
     * All stacks in the application will be deployed in the appropriate order,
     * and all assets found in the application will be added to the asset
     * publishing stage.
     *
     * @experimental
     */
    addApplication(appStage: Stage, options?: AddStageOptions): void;
    /**
     * (experimental) Add a deployment action based on a stack artifact.
     *
     * @experimental
     */
    addStackArtifactDeployment(stackArtifact: cxapi.CloudFormationStackArtifact, options?: AddStackOptions): void;
    /**
     * (experimental) Add a manual approval action.
     *
     * If you need more flexibility than what this method offers,
     * use `addAction` with a `ManualApprovalAction`.
     *
     * @experimental
     */
    addManualApprovalAction(options?: AddManualApprovalOptions): void;
    /**
     * (experimental) Add one or more CodePipeline Actions.
     *
     * You need to make sure it is created with the right runOrder. Call `nextSequentialRunOrder()`
     * for every action to get actions to execute in sequence.
     *
     * @experimental
     */
    addActions(...actions: codepipeline.IAction[]): void;
    /**
     * (experimental) Return the runOrder number necessary to run the next Action in sequence with the rest.
     *
     * FIXME: This is here because Actions are immutable and can't be reordered
     * after creation, nor is there a way to specify relative priorities, which
     * is a limitation that we should take away in the base library.
     *
     * @experimental
     */
    nextSequentialRunOrder(count?: number): number;
    /**
     * (experimental) Whether this Stage contains an action to deploy the given stack, identified by its artifact ID.
     *
     * @experimental
     */
    deploysStack(artifactId: string): boolean;
    /**
     * Actually add all the DeployStack actions to the stage.
     *
     * We do this late because before we can render the actual DeployActions,
     * we need to know whether or not we need to capture the stack outputs.
     *
     * FIXME: This is here because Actions are immutable and can't be reordered
     * after creation, nor is there a way to specify relative priorities, which
     * is a limitation that we should take away in the base library.
     */
    private prepareStage;
    /**
     * Advance the runorder counter so that the next sequential number is higher than the given one
     */
    private advanceRunOrderPast;
    /**
     * Simplify the stack name by removing the `Stage-` prefix if it exists.
     */
    private simplifyStackName;
    /**
     * Make sure all assets depended on by this stack are published in this pipeline
     *
     * Taking care to exclude the stack template itself -- it is being published
     * as an asset because the CLI needs to know the asset publishing role when
     * pushing the template to S3, but in the case of CodePipeline we always
     * reference the template from the artifact bucket.
     *
     * (NOTE: this is only true for top-level stacks, not nested stacks. Nested
     * Stack templates are always published as assets).
     */
    private publishAssetDependencies;
}
/**
 * (experimental) Additional options for adding a stack deployment.
 *
 * @experimental
 */
export interface AddStackOptions {
    /**
     * (experimental) Base runorder.
     *
     * @default - Next sequential runorder
     * @experimental
     */
    readonly runOrder?: number;
    /**
     * (experimental) Base runorder.
     *
     * @default - runOrder + 1
     * @experimental
     */
    readonly executeRunOrder?: number;
}
/**
 * (experimental) A single output of a Stack.
 *
 * @experimental
 */
export declare class StackOutput {
    /**
     * (experimental) The artifact and file the output is stored in.
     *
     * @experimental
     */
    readonly artifactFile: codepipeline.ArtifactPath;
    /**
     * (experimental) The name of the output in the JSON object in the file.
     *
     * @experimental
     */
    readonly outputName: string;
    /**
     * (experimental) Build a StackOutput from a known artifact and an output name.
     *
     * @experimental
     */
    constructor(artifactFile: codepipeline.ArtifactPath, outputName: string);
}
/**
 * (experimental) Features that the Stage needs from its environment.
 *
 * @experimental
 */
export interface IStageHost {
    /**
     * (experimental) Make sure all the assets from the given manifest are published.
     *
     * @experimental
     */
    publishAsset(command: AssetPublishingCommand): void;
    /**
     * (experimental) Return the Artifact the given stack has to emit its outputs into, if any.
     *
     * @experimental
     */
    stackOutputArtifact(stackArtifactId: string): codepipeline.Artifact | undefined;
}
/**
 * (experimental) Instructions to publish certain assets.
 *
 * @experimental
 */
export interface AssetPublishingCommand {
    /**
     * (experimental) Asset manifest path.
     *
     * @experimental
     */
    readonly assetManifestPath: string;
    /**
     * (experimental) Asset identifier.
     *
     * @experimental
     */
    readonly assetId: string;
    /**
     * (experimental) Asset selector to pass to `cdk-assets`.
     *
     * @experimental
     */
    readonly assetSelector: string;
    /**
     * (experimental) Type of asset to publish.
     *
     * @experimental
     */
    readonly assetType: AssetType;
}
/**
 * (experimental) Options for adding an application stage to a pipeline.
 *
 * @experimental
 */
export interface AddStageOptions {
    /**
     * (experimental) Add manual approvals before executing change sets.
     *
     * This gives humans the opportunity to confirm the change set looks alright
     * before deploying it.
     *
     * @default false
     * @experimental
     */
    readonly manualApprovals?: boolean;
}
/**
 * (experimental) Options for addManualApproval.
 *
 * @experimental
 */
export interface AddManualApprovalOptions {
    /**
     * (experimental) The name of the manual approval action.
     *
     * @default 'ManualApproval' with a rolling counter
     * @experimental
     */
    readonly actionName?: string;
    /**
     * (experimental) The runOrder for this action.
     *
     * @default - The next sequential runOrder
     * @experimental
     */
    readonly runOrder?: number;
}
