"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.cloudAssemblyBuildSpecDir = exports.embeddedAsmPath = exports.assemblyBuilderOf = exports.appOf = void 0;
/**
 * Get access to construct internals that we need but got removed from the Stages PR.
 */
const path = require("path");
const core_1 = require("../../../core"); // Automatically re-written from '@aws-cdk/core'
const constructs_1 = require("constructs");
function appOf(construct) {
    const root = constructs_1.Node.of(construct).root;
    if (!core_1.App.isApp(root)) {
        throw new Error(`Construct must be created under an App, but is not: ${constructs_1.Node.of(construct).path}`);
    }
    return root;
}
exports.appOf = appOf;
function assemblyBuilderOf(stage) {
    return stage._assemblyBuilder;
}
exports.assemblyBuilderOf = assemblyBuilderOf;
/**
 * Return the relative path from the app assembly to the scope's (nested) assembly
 */
function embeddedAsmPath(scope) {
    var _a;
    const appAsmRoot = assemblyBuilderOf(appOf(scope)).outdir;
    const stage = (_a = core_1.Stage.of(scope)) !== null && _a !== void 0 ? _a : appOf(scope);
    const stageAsmRoot = assemblyBuilderOf(stage).outdir;
    return path.relative(appAsmRoot, stageAsmRoot) || '.';
}
exports.embeddedAsmPath = embeddedAsmPath;
/**
 * Determine the directory where the cloud assembly will be written, for use in a BuildSpec
 */
function cloudAssemblyBuildSpecDir(scope) {
    return assemblyBuilderOf(appOf(scope)).outdir;
}
exports.cloudAssemblyBuildSpecDir = cloudAssemblyBuildSpecDir;
//# sourceMappingURL=data:application/json;base64,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