import * as codepipeline from "../../../aws-codepipeline";
import * as events from "../../../aws-events";
import * as iam from "../../../aws-iam";
import * as cxapi from "../../../cx-api";
import { Construct } from 'constructs';
import { Construct as CoreConstruct } from "../../../core";
/**
 * (experimental) Customization options for a DeployCdkStackAction.
 *
 * @experimental
 */
export interface DeployCdkStackActionOptions {
    /**
     * (experimental) Base name of the action.
     *
     * @default stackName
     * @experimental
     */
    readonly baseActionName?: string;
    /**
     * (experimental) The CodePipeline artifact that holds the Cloud Assembly.
     *
     * @experimental
     */
    readonly cloudAssemblyInput: codepipeline.Artifact;
    /**
     * (experimental) Run order for the Prepare action.
     *
     * @default 1
     * @experimental
     */
    readonly prepareRunOrder?: number;
    /**
     * (experimental) Run order for the Execute action.
     *
     * @default - prepareRunOrder + 1
     * @experimental
     */
    readonly executeRunOrder?: number;
    /**
     * (experimental) Artifact to write Stack Outputs to.
     *
     * @default - No outputs
     * @experimental
     */
    readonly output?: codepipeline.Artifact;
    /**
     * (experimental) Filename in output to write Stack outputs to.
     *
     * @default - Required when 'output' is set
     * @experimental
     */
    readonly outputFileName?: string;
    /**
     * (experimental) Name of the change set to create and deploy.
     *
     * @default 'PipelineChange'
     * @experimental
     */
    readonly changeSetName?: string;
}
/**
 * (experimental) Properties for a DeployCdkStackAction.
 *
 * @experimental
 */
export interface DeployCdkStackActionProps extends DeployCdkStackActionOptions {
    /**
     * (experimental) Relative path of template in the input artifact.
     *
     * @experimental
     */
    readonly templatePath: string;
    /**
     * (experimental) Role for the action to assume.
     *
     * This controls the account to deploy into
     *
     * @experimental
     */
    readonly actionRole: iam.IRole;
    /**
     * (experimental) The name of the stack that should be created/updated.
     *
     * @experimental
     */
    readonly stackName: string;
    /**
     * (experimental) Role to execute CloudFormation under.
     *
     * @default - Execute CloudFormation using the action role
     * @experimental
     */
    readonly cloudFormationExecutionRole?: iam.IRole;
    /**
     * (experimental) Region to deploy into.
     *
     * @default - Same region as pipeline
     * @experimental
     */
    readonly region?: string;
    /**
     * (experimental) Artifact ID for the stack deployed here.
     *
     * Used for pipeline order checking.
     *
     * @default - Order will not be checked
     * @experimental
     */
    readonly stackArtifactId?: string;
    /**
     * (experimental) Artifact ID for the stacks this stack depends on.
     *
     * Used for pipeline order checking.
     *
     * @default - No dependencies
     * @experimental
     */
    readonly dependencyStackArtifactIds?: string[];
    /**
     * (experimental) Template configuration path relative to the input artifact.
     *
     * @default - No template configuration
     * @experimental
     */
    readonly templateConfigurationPath?: string;
}
/**
 * (experimental) Options for the 'fromStackArtifact' operation.
 *
 * @experimental
 */
export interface CdkStackActionFromArtifactOptions extends DeployCdkStackActionOptions {
    /**
     * (experimental) The name of the stack that should be created/updated.
     *
     * @default - Same as stack artifact
     * @experimental
     */
    readonly stackName?: string;
}
/**
 * (experimental) Action to deploy a CDK Stack.
 *
 * Adds two CodePipeline Actions to the pipeline: one to create a ChangeSet
 * and one to execute it.
 *
 * You do not need to instantiate this action yourself -- it will automatically
 * be added by the pipeline when you add stack artifacts or entire stages.
 *
 * @experimental
 */
export declare class DeployCdkStackAction implements codepipeline.IAction {
    /**
     * (experimental) Construct a DeployCdkStackAction from a Stack artifact.
     *
     * @experimental
     */
    static fromStackArtifact(scope: Construct, artifact: cxapi.CloudFormationStackArtifact, options: CdkStackActionFromArtifactOptions): DeployCdkStackAction;
    /**
     * (experimental) The runorder for the prepare action.
     *
     * @experimental
     */
    readonly prepareRunOrder: number;
    /**
     * (experimental) The runorder for the execute action.
     *
     * @experimental
     */
    readonly executeRunOrder: number;
    /**
     * (experimental) Name of the deployed stack.
     *
     * @experimental
     */
    readonly stackName: string;
    /**
     * (experimental) Artifact id of the artifact this action was based on.
     *
     * @experimental
     */
    readonly stackArtifactId?: string;
    /**
     * (experimental) Artifact ids of the artifact this stack artifact depends on.
     *
     * @experimental
     */
    readonly dependencyStackArtifactIds: string[];
    private readonly prepareChangeSetAction;
    private readonly executeChangeSetAction;
    /**
     * @experimental
     */
    constructor(props: DeployCdkStackActionProps);
    /**
     * (experimental) Exists to implement IAction.
     *
     * @experimental
     */
    bind(scope: CoreConstruct, stage: codepipeline.IStage, options: codepipeline.ActionBindOptions): codepipeline.ActionConfig;
    /**
     * (experimental) Exists to implement IAction.
     *
     * @experimental
     */
    onStateChange(name: string, target?: events.IRuleTarget, options?: events.RuleProps): events.Rule;
    /**
     * (experimental) Exists to implement IAction.
     *
     * @experimental
     */
    get actionProperties(): codepipeline.ActionProperties;
}
/**
 * (experimental) Options for CdkDeployAction.fromStackArtifact.
 *
 * @experimental
 */
export interface FromStackArtifactOptions {
    /**
     * (experimental) The CodePipeline artifact that holds the Cloud Assembly.
     *
     * @experimental
     */
    readonly cloudAssemblyInput: codepipeline.Artifact;
    /**
     * (experimental) Run order for the 2 actions that will be created.
     *
     * @default 1
     * @experimental
     */
    readonly prepareRunOrder?: number;
    /**
     * (experimental) Run order for the Execute action.
     *
     * @default - prepareRunOrder + 1
     * @experimental
     */
    readonly executeRunOrder?: number;
    /**
     * (experimental) Artifact to write Stack Outputs to.
     *
     * @default - No outputs
     * @experimental
     */
    readonly output?: codepipeline.Artifact;
    /**
     * (experimental) Filename in output to write Stack outputs to.
     *
     * @default - Required when 'output' is set
     * @experimental
     */
    readonly outputFileName?: string;
}
