"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EnvironmentPlaceholders = void 0;
/**
 * (experimental) Placeholders which can be used manifests.
 *
 * These can occur both in the Asset Manifest as well as the general
 * Cloud Assembly manifest.
 *
 * @experimental
 */
class EnvironmentPlaceholders {
    /**
     * (experimental) Replace the environment placeholders in all strings found in a complex object.
     *
     * Duplicated between cdk-assets and aws-cdk CLI because we don't have a good single place to put it
     * (they're nominally independent tools).
     *
     * @experimental
     */
    static replace(object, values) {
        return this.recurse(object, value => {
            value = replaceAll(value, EnvironmentPlaceholders.CURRENT_REGION, values.region);
            value = replaceAll(value, EnvironmentPlaceholders.CURRENT_ACCOUNT, values.accountId);
            value = replaceAll(value, EnvironmentPlaceholders.CURRENT_PARTITION, values.partition);
            return value;
        });
    }
    /**
     * (experimental) Like 'replace', but asynchronous.
     *
     * @experimental
     */
    static async replaceAsync(object, provider) {
        let needRegion = false;
        let needAccountId = false;
        let needPartition = false;
        this.recurse(object, value => {
            if (value.indexOf(EnvironmentPlaceholders.CURRENT_REGION) > 1) {
                needRegion = true;
            }
            if (value.indexOf(EnvironmentPlaceholders.CURRENT_ACCOUNT) > 1) {
                needAccountId = true;
            }
            if (value.indexOf(EnvironmentPlaceholders.CURRENT_PARTITION) > 1) {
                needPartition = true;
            }
            return value;
        });
        const region = needRegion ? await provider.region() : undefined;
        const accountId = needAccountId ? await provider.accountId() : undefined;
        const partition = needPartition ? await provider.partition() : undefined;
        return this.recurse(object, value => {
            value = replaceAll(value, EnvironmentPlaceholders.CURRENT_REGION, region !== null && region !== void 0 ? region : 'WONTHAPPEN');
            value = replaceAll(value, EnvironmentPlaceholders.CURRENT_ACCOUNT, accountId !== null && accountId !== void 0 ? accountId : 'WONTHAPPEN');
            value = replaceAll(value, EnvironmentPlaceholders.CURRENT_PARTITION, partition !== null && partition !== void 0 ? partition : 'WONTHAPPEN');
            return value;
        });
    }
    static recurse(value, cb) {
        if (typeof value === 'string') {
            return cb(value);
        }
        if (typeof value !== 'object' || value === null) {
            return value;
        }
        if (Array.isArray(value)) {
            return value.map(x => this.recurse(x, cb));
        }
        const ret = {};
        for (const [key, inner] of Object.entries(value)) {
            ret[key] = this.recurse(inner, cb);
        }
        return ret;
    }
}
exports.EnvironmentPlaceholders = EnvironmentPlaceholders;
/**
 * (experimental) Insert this into the destination fields to be replaced with the current region.
 *
 * @experimental
 */
EnvironmentPlaceholders.CURRENT_REGION = '${AWS::Region}';
/**
 * (experimental) Insert this into the destination fields to be replaced with the current account.
 *
 * @experimental
 */
EnvironmentPlaceholders.CURRENT_ACCOUNT = '${AWS::AccountId}';
/**
 * (experimental) Insert this into the destination fields to be replaced with the current partition.
 *
 * @experimental
 */
EnvironmentPlaceholders.CURRENT_PARTITION = '${AWS::Partition}';
/**
 * A "replace-all" function that doesn't require us escaping a literal string to a regex
 */
function replaceAll(s, search, replace) {
    return s.split(search).join(replace);
}
//# sourceMappingURL=data:application/json;base64,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